/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.idea.intentions.SimplifyBooleanWithConstantsIntention;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/SimplifyComparisonFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "value", "", "(Lorg/jetbrains/kotlin/psi/KtExpression;Z)V", "getValue", "()Z", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "idea"})
public final class SimplifyComparisonFix
extends KotlinQuickFixAction<KtExpression> {
    private final boolean value;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return "Simplify " + (KtExpression)this.getElement() + " to '" + this.value + '\'';
    }

    @NotNull
    public String getText() {
        return "Simplify comparison";
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtExpression ktExpression = (KtExpression)this.getElement();
        if (ktExpression == null) {
            return;
        }
        KtExpression element3 = ktExpression;
        PsiElement parent2 = element3.getParent();
        KtExpression replacement = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null).createExpression("" + this.value);
        element3.replace((PsiElement)replacement);
        PsiElement $receiver$iv = parent2;
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtBinaryExpression.class, (boolean)false);
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression booleanExpression = ktBinaryExpression;
        SimplifyBooleanWithConstantsIntention simplifyIntention = new SimplifyBooleanWithConstantsIntention();
        if (simplifyIntention.isApplicableTo(booleanExpression)) {
            simplifyIntention.applyTo(booleanExpression, editor);
        }
    }

    public final boolean getValue() {
        return this.value;
    }

    public SimplifyComparisonFix(@NotNull KtExpression element3, boolean value2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        super((PsiElement)element3);
        this.value = value2;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/SimplifyComparisonFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (!(psiElement2 instanceof KtExpression)) {
                psiElement2 = null;
            }
            KtExpression ktExpression = (KtExpression)psiElement2;
            if (ktExpression == null) {
                return null;
            }
            KtExpression expression2 = ktExpression;
            Diagnostic diagnostic2 = diagnostic;
            if (!(diagnostic2 instanceof DiagnosticWithParameters2)) {
                diagnostic2 = null;
            }
            DiagnosticWithParameters2 diagnosticWithParameters2 = (DiagnosticWithParameters2)diagnostic2;
            Object object = diagnosticWithParameters2 != null ? diagnosticWithParameters2.getB() : null;
            if (!(object instanceof Boolean)) {
                object = null;
            }
            Boolean bl = (Boolean)object;
            if (bl == null) {
                return null;
            }
            boolean value2 = bl;
            return new SimplifyComparisonFix(expression2, value2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

