/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.cutPaste;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.refactoring.BaseRefactoringIntentionAction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.conversion.copy.RangeUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.cutPaste.MoveDeclarationsProcessor;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J!\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0096\u0002J \u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/cutPaste/MoveDeclarationsIntentionAction;", "Lcom/intellij/refactoring/BaseRefactoringIntentionAction;", "Lcom/intellij/codeInspection/HintAction;", "processor", "Lorg/jetbrains/kotlin/idea/refactoring/cutPaste/MoveDeclarationsProcessor;", "bounds", "Lcom/intellij/openapi/editor/RangeMarker;", "modificationCount", "", "(Lorg/jetbrains/kotlin/idea/refactoring/cutPaste/MoveDeclarationsProcessor;Lcom/intellij/openapi/editor/RangeMarker;J)V", "isSingleDeclaration", "", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "showHint", "startInWriteAction", "idea"})
public final class MoveDeclarationsIntentionAction
extends BaseRefactoringIntentionAction
implements HintAction {
    private final boolean isSingleDeclaration;
    private final MoveDeclarationsProcessor processor;
    private final RangeMarker bounds;
    private final long modificationCount;

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getText() {
        return "Update usages to reflect declaration" + (this.isSingleDeclaration ? "s" : "") + " move";
    }

    @NotNull
    public String getFamilyName() {
        return "Update usages on declarations cut/paste";
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return PsiModificationTracker.SERVICE.getInstance((Project)this.processor.getProject()).getModificationCount() == this.modificationCount;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        this.processor.performRefactoring();
    }

    public boolean showHint(@NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        TextRange textRange = RangeUtilsKt.getRange(this.bounds);
        if (textRange == null) {
            return false;
        }
        TextRange range = textRange;
        if (editor.getCaretModel().getOffset() != range.getEndOffset()) {
            return false;
        }
        if (PsiModificationTracker.SERVICE.getInstance((Project)this.processor.getProject()).getModificationCount() != this.modificationCount) {
            return false;
        }
        String hintText = "" + this.getText() + "? " + KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
        HintManager.getInstance().showQuestionHint(editor, hintText, range.getEndOffset(), range.getEndOffset(), new QuestionAction(this){
            final /* synthetic */ MoveDeclarationsIntentionAction this$0;

            public final boolean execute() {
                MoveDeclarationsIntentionAction.access$getProcessor$p(this.this$0).performRefactoring();
                return true;
            }
            {
                this.this$0 = moveDeclarationsIntentionAction;
            }
        });
        return true;
    }

    public MoveDeclarationsIntentionAction(@NotNull MoveDeclarationsProcessor processor2, @NotNull RangeMarker bounds, long modificationCount) {
        Intrinsics.checkParameterIsNotNull((Object)processor2, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        this.processor = processor2;
        this.bounds = bounds;
        this.modificationCount = modificationCount;
        this.isSingleDeclaration = this.processor.getPastedDeclarations().size() == 1;
    }

    @NotNull
    public static final /* synthetic */ MoveDeclarationsProcessor access$getProcessor$p(MoveDeclarationsIntentionAction $this) {
        return $this.processor;
    }
}

