/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInliner.UsageReplacementStrategy;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.CallableBuilderKt;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineCallableProcessor;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineFunctionDialog;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u000f\u001a\u00020\u000bH\u0014J\b\u0010\u0010\u001a\u00020\u000bH\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0015H\u0014J\b\u0010\u0017\u001a\u00020\u0015H\u0014J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0015H\u0014J\b\u0010\u0019\u001a\u00020\u0015H\u0014J\b\u0010\u001a\u001a\u00020\u000bH\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineFunctionDialog;", "Lcom/intellij/refactoring/inline/InlineOptionsDialog;", "project", "Lcom/intellij/openapi/project/Project;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "reference", "Lorg/jetbrains/kotlin/idea/references/KtSimpleNameReference;", "replacementStrategy", "Lorg/jetbrains/kotlin/idea/codeInliner/UsageReplacementStrategy;", "allowInlineThisOnly", "", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lorg/jetbrains/kotlin/idea/references/KtSimpleNameReference;Lorg/jetbrains/kotlin/idea/codeInliner/UsageReplacementStrategy;Z)V", "occurrencesNumber", "", "allowInlineAll", "canInlineThisOnly", "doAction", "", "doHelpAction", "getBorderTitle", "", "getInlineAllText", "getInlineThisText", "getKeepTheDeclarationText", "getNameLabelText", "isInlineThis", "idea"})
public final class KotlinInlineFunctionDialog
extends InlineOptionsDialog {
    private int occurrencesNumber;
    private final KtNamedFunction function;
    private final KtSimpleNameReference reference;
    private final UsageReplacementStrategy replacementStrategy;
    private final boolean allowInlineThisOnly;

    protected boolean allowInlineAll() {
        return true;
    }

    @NotNull
    protected String getNameLabelText() {
        Object object;
        StringBuilder stringBuilder;
        String occurrencesString;
        block3: {
            block2: {
                occurrencesString = this.occurrencesNumber > -1 ? " - " + this.occurrencesNumber + " occurrence" + (this.occurrencesNumber == 1 ? "" : "s") : "";
                stringBuilder = new StringBuilder().append("").append(this.function.getNameAsSafeName()).append(CollectionsKt.joinToString$default((Iterable)this.function.getValueParameters(), null, (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)getNameLabelText.functionText.1.INSTANCE, (int)25, null));
                object = CallableBuilderKt.getReturnTypeReference(this.function);
                if (object == null) break block2;
                KtTypeReference ktTypeReference = object;
                StringBuilder stringBuilder2 = stringBuilder;
                KtTypeReference it = ktTypeReference;
                String string = ": " + it.getText();
                stringBuilder = stringBuilder2;
                object = string;
                if (object != null) break block3;
            }
            object = "";
        }
        String functionText2 = stringBuilder.append(object).toString();
        return "Function " + functionText2 + ' ' + occurrencesString;
    }

    @NotNull
    protected String getBorderTitle() {
        return "Inline";
    }

    @NotNull
    protected String getInlineThisText() {
        return "Inline this only and keep the function";
    }

    @NotNull
    protected String getInlineAllText() {
        return this.function.isWritable() ? "Inline all and remove the function" : "All invocations in project";
    }

    @Nullable
    protected String getKeepTheDeclarationText() {
        return this.function.isWritable() ? "Inline all and keep the function" : super.getKeepTheDeclarationText();
    }

    public void doAction() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        this.invokeRefactoring(new KotlinInlineCallableProcessor(project, this.replacementStrategy, this.function, this.reference, this.isInlineThisOnly() || this.allowInlineThisOnly, !this.isInlineThisOnly() && !this.isKeepTheDeclaration() && !this.allowInlineThisOnly, null, 64, null));
        JavaRefactoringSettings settings2 = JavaRefactoringSettings.getInstance();
        if (this.myRbInlineThisOnly.isEnabled() && this.myRbInlineAll.isEnabled()) {
            settings2.INLINE_METHOD_THIS = this.isInlineThisOnly();
        }
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.function instanceof KtConstructor ? "refactoring.inlineConstructor" : "refactoring.inlineMethod");
    }

    protected boolean canInlineThisOnly() {
        return this.allowInlineThisOnly;
    }

    protected boolean isInlineThis() {
        return JavaRefactoringSettings.getInstance().INLINE_METHOD_THIS;
    }

    public KotlinInlineFunctionDialog(@NotNull Project project, @NotNull KtNamedFunction function2, @Nullable KtSimpleNameReference reference2, @NotNull UsageReplacementStrategy replacementStrategy, boolean allowInlineThisOnly) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)replacementStrategy, (String)"replacementStrategy");
        super(project, true, (PsiElement)function2);
        this.function = function2;
        this.reference = reference2;
        this.replacementStrategy = replacementStrategy;
        this.allowInlineThisOnly = allowInlineThisOnly;
        this.occurrencesNumber = KotlinInlineFunctionDialog.access$initOccurrencesNumber$s759928653(this.function);
        this.myInvokedOnReference = this.reference != null;
        this.setTitle("Inline function");
        this.init();
    }

    public static final /* synthetic */ int access$initOccurrencesNumber$s759928653(PsiNameIdentifierOwner p0) {
        return InlineOptionsDialog.initOccurrencesNumber((PsiNameIdentifierOwner)p0);
    }
}

