/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.introduceVariable;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.ui.PositionTracker;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SpecifyTypeExplicitlyIntention;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.types.KotlinType;

public class KotlinInplaceVariableIntroducer<D extends KtCallableDeclaration>
extends InplaceVariableIntroducer<KtExpression> {
    private static final Key<KotlinInplaceVariableIntroducer> ACTIVE_INTRODUCER = Key.create((String)"ACTIVE_INTRODUCER");
    public static final String TYPE_REFERENCE_VARIABLE_NAME = "TypeReferenceVariable";
    public static final String PRIMARY_VARIABLE_NAME = "PrimaryVariable";
    private static final Function0<Boolean> TRUE = new Function0<Boolean>(){

        public Boolean invoke() {
            return true;
        }
    };
    private static final Pass<JComponent> DO_NOTHING = new Pass<JComponent>(){

        public void pass(JComponent component) {
        }
    };
    private final boolean myReplaceOccurrence;
    protected D myDeclaration;
    private final boolean isVar;
    private final boolean myDoNotChangeVar;
    @Nullable
    private final KotlinType myExprType;
    private final boolean noTypeInference;
    private final List<ControlWrapper> panelControls = new ArrayList<ControlWrapper>();
    private JPanel contentPanel;

    public KotlinInplaceVariableIntroducer(PsiNamedElement elementToRename, Editor editor, Project project, String title, KtExpression[] occurrences, @Nullable KtExpression expr2, boolean replaceOccurrence, D declaration2, boolean isVar, boolean doNotChangeVar, @Nullable KotlinType exprType, boolean noTypeInference) {
        super(elementToRename, editor, project, title, (PsiElement[])occurrences, (PsiElement)expr2);
        this.myReplaceOccurrence = replaceOccurrence;
        this.myDeclaration = declaration2;
        this.isVar = isVar;
        this.myDoNotChangeVar = doNotChangeVar;
        this.myExprType = exprType;
        this.noTypeInference = noTypeInference;
        String advertisementActionId = this.getAdvertisementActionId();
        if (advertisementActionId != null) {
            this.showDialogAdvertisement(advertisementActionId);
        }
    }

    @Nullable
    protected String getAdvertisementActionId() {
        return null;
    }

    @NotNull
    private JPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel(new GridBagLayout());
            this.contentPanel.setBorder(null);
        }
        JPanel jPanel = this.contentPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/KotlinInplaceVariableIntroducer", "getContentPanel"));
        }
        return jPanel;
    }

    protected final void addPanelControl(@NotNull ControlWrapper panelControl) {
        if (panelControl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panelControl", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/KotlinInplaceVariableIntroducer", "addPanelControl"));
        }
        this.panelControls.add(panelControl);
    }

    protected final void addPanelControl(@Nullable Function0<JComponent> initializer2) {
        if (initializer2 != null) {
            this.addPanelControl(new ControlWrapper(initializer2));
        }
    }

    protected void initPanelControls() {
        this.addPanelControl(this.getCreateVarCheckBox());
        this.addPanelControl(this.getCreateExplicitTypeCheckBox());
    }

    protected final void updatePanelControls() {
        JPanel panel = this.getContentPanel();
        panel.removeAll();
        int count = 1;
        for (ControlWrapper panelControl : this.panelControls) {
            if (!panelControl.isAvailable()) continue;
            panelControl.initialize();
            panel.add((Component)panelControl.getComponent(), new GridBagConstraints(0, count, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
            ++count;
        }
        panel.add((Component)Box.createVerticalBox(), new GridBagConstraints(0, count, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Nullable
    protected final JComponent getComponent() {
        this.panelControls.clear();
        this.initPanelControls();
        this.updatePanelControls();
        return this.getContentPanel();
    }

    @Nullable
    protected final Function0<JComponent> getCreateExplicitTypeCheckBox() {
        if (this.myExprType == null || this.noTypeInference) {
            return null;
        }
        return new Function0<JComponent>(){

            public JComponent invoke() {
                NonFocusableCheckBox exprTypeCheckbox = new NonFocusableCheckBox("Specify type explicitly");
                exprTypeCheckbox.setSelected(false);
                exprTypeCheckbox.setMnemonic('t');
                exprTypeCheckbox.addActionListener(new ActionListener((JCheckBox)exprTypeCheckbox){
                    final /* synthetic */ JCheckBox val$exprTypeCheckbox;
                    {
                        this.val$exprTypeCheckbox = jCheckBox;
                    }

                    @Override
                    public void actionPerformed(@NotNull ActionEvent e) {
                        if (e == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/KotlinInplaceVariableIntroducer$3$1", "actionPerformed"));
                        }
                        KotlinInplaceVariableIntroducer.this.runWriteActionAndRestartRefactoring(new Runnable(){

                            @Override
                            public void run() {
                                if (val$exprTypeCheckbox.isSelected()) {
                                    String renderedType = IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.renderType(KotlinInplaceVariableIntroducer.this.myExprType);
                                    KotlinInplaceVariableIntroducer.this.myDeclaration.setTypeReference(new KtPsiFactory(KotlinInplaceVariableIntroducer.this.myProject).createType(renderedType));
                                } else {
                                    KotlinInplaceVariableIntroducer.this.myDeclaration.setTypeReference(null);
                                }
                            }
                        });
                    }
                });
                return exprTypeCheckbox;
            }
        };
    }

    @Nullable
    protected final Function0<JComponent> getCreateVarCheckBox() {
        if (this.myDoNotChangeVar) {
            return null;
        }
        return new Function0<JComponent>(){

            public JComponent invoke() {
                NonFocusableCheckBox varCheckbox = new NonFocusableCheckBox("Declare with var");
                varCheckbox.setSelected(KotlinInplaceVariableIntroducer.this.isVar);
                varCheckbox.setMnemonic('v');
                varCheckbox.addActionListener(new ActionListener((JCheckBox)varCheckbox){
                    final /* synthetic */ JCheckBox val$varCheckbox;
                    {
                        this.val$varCheckbox = jCheckBox;
                    }

                    @Override
                    public void actionPerformed(@NotNull ActionEvent e) {
                        if (e == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/KotlinInplaceVariableIntroducer$4$1", "actionPerformed"));
                        }
                        new WriteCommandAction(KotlinInplaceVariableIntroducer.this.myProject, KotlinInplaceVariableIntroducer.this.getCommandName(), KotlinInplaceVariableIntroducer.this.getCommandName(), new PsiFile[0]){

                            protected void run(@NotNull Result result2) throws Throwable {
                                if (result2 == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/KotlinInplaceVariableIntroducer$4$1$1", "run"));
                                }
                                PsiDocumentManager.getInstance((Project)KotlinInplaceVariableIntroducer.this.myProject).commitDocument(KotlinInplaceVariableIntroducer.this.myEditor.getDocument());
                                KtPsiFactory psiFactory = new KtPsiFactory(KotlinInplaceVariableIntroducer.this.myProject);
                                PsiElement keyword = val$varCheckbox.isSelected() ? psiFactory.createVarKeyword() : psiFactory.createValKeyword();
                                PsiElement valOrVar = KotlinInplaceVariableIntroducer.this.myDeclaration instanceof KtProperty ? ((KtProperty)KotlinInplaceVariableIntroducer.this.myDeclaration).getValOrVarKeyword() : ((KtParameter)KotlinInplaceVariableIntroducer.this.myDeclaration).getValOrVarKeyword();
                                valOrVar.replace(keyword);
                            }
                        }.execute();
                    }
                });
                return varCheckbox;
            }
        };
    }

    protected final void runWriteActionAndRestartRefactoring(final Runnable runnable) {
        final Ref greedyToRight = new Ref();
        new WriteCommandAction(this.myProject, this.getCommandName(), this.getCommandName(), new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/KotlinInplaceVariableIntroducer$5", "run"));
                }
                PsiDocumentManager.getInstance((Project)KotlinInplaceVariableIntroducer.this.myProject).commitDocument(KotlinInplaceVariableIntroducer.this.myEditor.getDocument());
                ASTNode identifier2 = KotlinInplaceVariableIntroducer.this.myDeclaration.getNode().findChildByType((IElementType)KtTokens.IDENTIFIER);
                if (identifier2 != null) {
                    RangeHighlighter[] highlighters;
                    TextRange range = identifier2.getTextRange();
                    for (RangeHighlighter highlighter : highlighters = KotlinInplaceVariableIntroducer.this.myEditor.getMarkupModel().getAllHighlighters()) {
                        if (highlighter.getStartOffset() != range.getStartOffset() || highlighter.getEndOffset() != range.getEndOffset()) continue;
                        greedyToRight.set((Object)highlighter.isGreedyToRight());
                        highlighter.setGreedyToRight(false);
                    }
                }
                runnable.run();
                TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)InjectedLanguageUtil.getTopLevelEditor((Editor)KotlinInplaceVariableIntroducer.this.myEditor));
                if (templateState != null) {
                    KotlinInplaceVariableIntroducer.this.myEditor.putUserData(InplaceRefactoring.INTRODUCE_RESTART, (Object)true);
                    templateState.cancelTemplate();
                }
            }
        }.execute();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                ASTNode identifier2 = KotlinInplaceVariableIntroducer.this.myDeclaration.getNode().findChildByType((IElementType)KtTokens.IDENTIFIER);
                if (identifier2 != null) {
                    RangeHighlighter[] highlighters;
                    TextRange range = identifier2.getTextRange();
                    for (RangeHighlighter highlighter : highlighters = KotlinInplaceVariableIntroducer.this.myEditor.getMarkupModel().getAllHighlighters()) {
                        if (highlighter.getStartOffset() != range.getStartOffset() || highlighter.getEndOffset() != range.getEndOffset()) continue;
                        highlighter.setGreedyToRight(((Boolean)greedyToRight.get()).booleanValue());
                    }
                }
            }
        });
        if (this.myEditor.getUserData(INTRODUCE_RESTART) == Boolean.TRUE) {
            this.myInitialName = this.myDeclaration.getName();
            this.performInplaceRefactoring(this.getSuggestionsForNextRun());
        }
    }

    private LinkedHashSet<String> getSuggestionsForNextRun() {
        LinkedHashSet<String> nameSuggestions2;
        String currentName = this.myDeclaration.getName();
        if (this.myNameSuggestions.contains(currentName)) {
            nameSuggestions2 = this.myNameSuggestions;
        } else {
            nameSuggestions2 = new LinkedHashSet<String>();
            nameSuggestions2.add(currentName);
            nameSuggestions2.addAll(this.myNameSuggestions);
        }
        return nameSuggestions2;
    }

    protected void revalidate() {
        this.getContentPanel().revalidate();
        if (this.myTarget != null) {
            this.myBalloon.revalidate((PositionTracker)new PositionTracker.Static(this.myTarget));
        }
    }

    protected void addTypeReferenceVariable(TemplateBuilderImpl builder) {
        KtTypeReference typeReference = this.myDeclaration.getTypeReference();
        Expression expression2 = SpecifyTypeExplicitlyIntention.Companion.createTypeExpressionForTemplate(this.myExprType, (KtElement)this.myDeclaration);
        if (typeReference != null && expression2 != null) {
            builder.replaceElement((PsiElement)typeReference, TYPE_REFERENCE_VARIABLE_NAME, expression2, false);
        }
    }

    protected void addAdditionalVariables(TemplateBuilderImpl builder) {
        this.addTypeReferenceVariable(builder);
    }

    protected boolean buildTemplateAndStart(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages, PsiElement scope2, PsiFile containingFile) {
        this.myEditor.putUserData(INTRODUCE_RESTART, (Object)false);
        this.myEditor.getCaretModel().moveToOffset(this.getNameIdentifier().getTextOffset());
        boolean result2 = super.buildTemplateAndStart(refs, stringUsages, scope2, containingFile);
        TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)InjectedLanguageUtil.getTopLevelEditor((Editor)this.myEditor));
        if (templateState != null && this.myDeclaration.getTypeReference() != null) {
            templateState.addTemplateStateListener((TemplateEditingListener)SpecifyTypeExplicitlyIntention.Companion.createTypeReferencePostprocessor((KtCallableDeclaration)this.myDeclaration));
        }
        return result2;
    }

    protected Collection<PsiReference> collectRefs(SearchScope referencesSearchScope) {
        return CollectionsKt.map((Iterable)ArraysKt.filterIsInstance((Object[])this.getOccurrences(), KtSimpleNameExpression.class), (Function1)new Function1<KtSimpleNameExpression, PsiReference>(){

            public PsiReference invoke(KtSimpleNameExpression expression2) {
                return ReferenceUtilKt.getMainReference(expression2);
            }
        });
    }

    public boolean performInplaceRefactoring(LinkedHashSet<String> nameSuggestions2) {
        if (super.performInplaceRefactoring(nameSuggestions2)) {
            this.myEditor.putUserData(ACTIVE_INTRODUCER, (Object)this);
            return true;
        }
        return false;
    }

    public void finish(boolean success) {
        super.finish(success);
        this.myEditor.putUserData(ACTIVE_INTRODUCER, null);
    }

    protected void moveOffsetAfter(boolean success) {
        if (!this.myReplaceOccurrence || this.myExprMarker == null) {
            this.myEditor.getCaretModel().moveToOffset(this.myDeclaration.getTextRange().getEndOffset());
        } else {
            int startOffset = this.myExprMarker.getStartOffset();
            PsiFile file2 = this.myDeclaration.getContainingFile();
            PsiElement elementAt = file2.findElementAt(startOffset);
            if (elementAt != null) {
                this.myEditor.getCaretModel().moveToOffset(elementAt.getTextRange().getEndOffset());
            } else {
                this.myEditor.getCaretModel().moveToOffset(this.myExprMarker.getEndOffset());
            }
        }
    }

    public void stopIntroduce() {
        final TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)this.myEditor);
        if (templateState != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    templateState.gotoEnd(true);
                }
            };
            CommandProcessor.getInstance().executeCommand(this.myProject, runnable, this.getCommandName(), (Object)this.getCommandName());
        }
    }

    @Nullable
    public static KotlinInplaceVariableIntroducer getActiveInstance(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/KotlinInplaceVariableIntroducer", "getActiveInstance"));
        }
        return (KotlinInplaceVariableIntroducer)((Object)editor.getUserData(ACTIVE_INTRODUCER));
    }

    protected static final class ControlWrapper {
        @NotNull
        private final Function0<JComponent> factory;
        @NotNull
        private final Function0<Boolean> condition;
        @NotNull
        private final Pass<JComponent> initializer;
        private JComponent component;

        public ControlWrapper(@NotNull Function0<JComponent> factory2, @NotNull Function0<Boolean> condition2, @NotNull Pass<JComponent> initializer2) {
            if (factory2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/KotlinInplaceVariableIntroducer$ControlWrapper", "<init>"));
            }
            if (condition2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/KotlinInplaceVariableIntroducer$ControlWrapper", "<init>"));
            }
            if (initializer2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/KotlinInplaceVariableIntroducer$ControlWrapper", "<init>"));
            }
            this.factory = factory2;
            this.condition = condition2;
            this.initializer = initializer2;
        }

        public ControlWrapper(@NotNull Function0<JComponent> factory2) {
            if (factory2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/KotlinInplaceVariableIntroducer$ControlWrapper", "<init>"));
            }
            this(factory2, (Function0<Boolean>)TRUE, (Pass<JComponent>)DO_NOTHING);
        }

        public boolean isAvailable() {
            return (Boolean)this.condition.invoke();
        }

        public void initialize() {
            this.initializer.pass((Object)this.getComponent());
        }

        @NotNull
        public JComponent getComponent() {
            if (this.component == null) {
                this.component = (JComponent)this.factory.invoke();
            }
            JComponent jComponent = this.component;
            if (jComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/KotlinInplaceVariableIntroducer$ControlWrapper", "getComponent"));
            }
            return jComponent;
        }
    }
}

