/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.ideaExtensions;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.JavaResolutionUtils;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.synthetic.JavaSyntheticPropertiesScope;
import org.jetbrains.kotlin.synthetic.JavaSyntheticPropertiesScopeKt;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinPropertyAccessorsReferenceSearcher;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/MethodReferencesSearch$SearchParameters;", "()V", "processQuery", "", "queryParameters", "consumer", "Lcom/intellij/util/Processor;", "propertyName", "", "method", "Lcom/intellij/psi/PsiMethod;", "idea"})
public final class KotlinPropertyAccessorsReferenceSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer2) {
        Intrinsics.checkParameterIsNotNull((Object)queryParameters, (String)"queryParameters");
        Intrinsics.checkParameterIsNotNull(consumer2, (String)"consumer");
        PsiMethod method = queryParameters.getMethod();
        SearchScope onlyKotlinFiles = SearchUtilKt.restrictToKotlinSources(queryParameters.getEffectiveSearchScope());
        if (Intrinsics.areEqual((Object)onlyKotlinFiles, (Object)GlobalSearchScope.EMPTY_SCOPE)) {
            return;
        }
        PsiMethod psiMethod2 = method;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod2, (String)"method");
        String string = this.propertyName(psiMethod2);
        if (string == null) {
            return;
        }
        String propertyName = string;
        SearchRequestCollector searchRequestCollector = queryParameters.getOptimizer();
        if (searchRequestCollector == null) {
            Intrinsics.throwNpe();
        }
        searchRequestCollector.searchWord(propertyName, onlyKotlinFiles, (short)1, true, (PsiElement)method);
    }

    private final String propertyName(PsiMethod method) {
        PsiNamedElement unwrapped = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)method);
        if (unwrapped instanceof KtProperty) {
            return unwrapped.getName();
        }
        String string = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
        if (!JavaSyntheticPropertiesScopeKt.canBePropertyAccessor(string)) {
            return null;
        }
        FunctionDescriptor functionDescriptor2 = JavaResolutionUtils.getJavaMethodDescriptor$default(method, null, 1, null);
        if (functionDescriptor2 == null) {
            return null;
        }
        FunctionDescriptor functionDescriptor3 = functionDescriptor2;
        JavaSyntheticPropertiesScope syntheticExtensionsScope = new JavaSyntheticPropertiesScope(new LockBasedStorageManager(), LookupTracker.DO_NOTHING.INSTANCE);
        SyntheticJavaPropertyDescriptor syntheticJavaPropertyDescriptor = SyntheticJavaPropertyDescriptor.Companion.findByGetterOrSetter(functionDescriptor3, syntheticExtensionsScope);
        if (syntheticJavaPropertyDescriptor == null) {
            return null;
        }
        SyntheticJavaPropertyDescriptor property2 = syntheticJavaPropertyDescriptor;
        return property2.getName().asString();
    }

    public KotlinPropertyAccessorsReferenceSearcher() {
        super(true);
    }
}

