/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.spring.generate;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.actions.generate.GenerateSpringBeanDependenciesUtil;
import com.intellij.spring.model.actions.generate.SpringBeanClassMember;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.editor.BatchTemplateRunner;
import org.jetbrains.kotlin.idea.spring.SpringUtilsKt;
import org.jetbrains.kotlin.idea.spring.generate.GenerateAutowiredDependenciesUtilsKt;
import org.jetbrains.kotlin.idea.spring.generate.GenerateAutowiredDependenciesUtilsKt$addCreatePropertyTemplate$;
import org.jetbrains.kotlin.idea.spring.generate.GenerateDependenciesUtilsKt;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\u001a3\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0002\u0010\n\u001a(\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a=\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\r2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0012\u001a\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u00142\u0006\u0010\f\u001a\u00020\r\u001a\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a8\u0006\u0017"}, d2={"addCreatePropertyTemplate", "Lorg/jetbrains/kotlin/idea/editor/BatchTemplateRunner;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "candidateBean", "Lcom/intellij/spring/model/SpringBeanPointer;", "Lcom/intellij/spring/model/CommonSpringBean;", "candidateBeanClasses", "", "Lcom/intellij/psi/PsiClass;", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lcom/intellij/spring/model/SpringBeanPointer;[Lcom/intellij/psi/PsiClass;)Lorg/jetbrains/kotlin/idea/editor/BatchTemplateRunner;", "createAutowiredDependency", "klass", "Lorg/jetbrains/kotlin/asJava/classes/KtLightClass;", "model", "Lcom/intellij/spring/CommonSpringModel;", "createAutowiredProperty", "currentBeanClass", "(Lorg/jetbrains/kotlin/asJava/classes/KtLightClass;Lcom/intellij/spring/model/SpringBeanPointer;[Lcom/intellij/psi/PsiClass;Lcom/intellij/spring/CommonSpringModel;)Lorg/jetbrains/kotlin/psi/KtProperty;", "generateAutowiredDependenciesFor", "", "getQualifierName", "", "kotlin-ultimate"})
public final class GenerateAutowiredDependenciesUtilsKt {
    private static final String getQualifierName(@NotNull SpringBeanPointer<CommonSpringBean> $receiver) {
        SpringQualifier springQualifier = $receiver.getSpringBean().getSpringQualifier();
        String value2 = springQualifier != null ? springQualifier.getQualifierValue() : null;
        CharSequence charSequence = value2;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? $receiver.getName() : value2;
    }

    private static final KtProperty createAutowiredProperty(KtLightClass currentBeanClass, SpringBeanPointer<CommonSpringBean> candidateBean, PsiClass[] candidateBeanClasses, CommonSpringModel model) {
        try {
            CharSequence charSequence;
            KtProperty ktProperty;
            String string;
            KtClassOrObject ktClassOrObject = (KtClassOrObject)currentBeanClass.getKotlinOrigin();
            if (ktClassOrObject == null) {
                return null;
            }
            KtClassOrObject ktBeanClass = ktClassOrObject;
            String qualifierName = GenerateAutowiredDependenciesUtilsKt.getQualifierName(candidateBean);
            PsiClass candidateBeanClass = (PsiClass)ArraysKt.first((Object[])candidateBeanClasses);
            String beanName = candidateBean.getName();
            if (beanName != null && KotlinNameSuggester.INSTANCE.isIdentifier(beanName)) {
                string = beanName;
            } else {
                string = candidateBeanClass.getName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
            }
            String name2 = string;
            Project project = currentBeanClass.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"currentBeanClass.project");
            KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
            KtProperty $receiver = ktProperty = psiFactory.createProperty("lateinit var " + StringsKt.decapitalize((String)name2) + ": " + GenerateDependenciesUtilsKt.getDefaultTypeText(candidateBeanClass));
            $receiver.addAnnotationEntry(psiFactory.createAnnotationEntry("@org.springframework.beans.factory.annotation.Autowired"));
            SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)candidateBeanClass).withInheritors().effectiveBeanTypes();
            if (SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters).size() > 1 && !((charSequence = (CharSequence)qualifierName) == null || StringsKt.isBlank((CharSequence)charSequence))) {
                StringBuilder stringBuilder = new StringBuilder().append("@org.springframework.beans.factory.annotation.Qualifier(\"");
                String string2 = qualifierName;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                String annotationText = stringBuilder.append(StringUtil.escapeStringCharacters((String)string2)).append("\")").toString();
                $receiver.addAnnotationEntry(psiFactory.createAnnotationEntry(annotationText));
            }
            KtProperty prototype2 = ktProperty;
            KtClassOrObject this_$iv = ktBeanClass;
            KtClassBody body$iv = KtClassOrObjectKt.getOrCreateBody(this_$iv);
            PsiElement psiElement2 = body$iv.getRBrace();
            if (psiElement2 == null && (psiElement2 = body$iv.getLastChild()) == null) {
                Intrinsics.throwNpe();
            }
            PsiElement anchor$iv = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement2, (Class[])new Class[]{PsiWhiteSpace.class});
            PsiElement psiElement3 = body$iv.addAfter(prototype2, anchor$iv);
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
            }
            $receiver = ktProperty = (KtProperty)psiElement3;
            ShortenReferences.process$default(ShortenReferences.DEFAULT, $receiver, null, 2, null);
            return ktProperty;
        }
        catch (IncorrectOperationException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    private static final BatchTemplateRunner addCreatePropertyTemplate(KtProperty property2, SpringBeanPointer<CommonSpringBean> candidateBean, PsiClass[] candidateBeanClasses) {
        BatchTemplateRunner batchTemplateRunner;
        Project project = property2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"property.project");
        BatchTemplateRunner $receiver = batchTemplateRunner = new BatchTemplateRunner(project);
        SmartPsiElementPointer<PsiElement> propertyPointer = PsiUtilsKt.createSmartPointer((PsiElement)property2);
        $receiver.addTemplateFactory(property2, (Function0<? extends Template>)((Function0)new Function0<Template>(propertyPointer, property2, candidateBeanClasses, candidateBean){
            final /* synthetic */ SmartPsiElementPointer $propertyPointer;
            final /* synthetic */ KtProperty $property$inlined;
            final /* synthetic */ PsiClass[] $candidateBeanClasses$inlined;
            final /* synthetic */ SpringBeanPointer $candidateBean$inlined;
            {
                this.$propertyPointer = smartPsiElementPointer;
                this.$property$inlined = ktProperty;
                this.$candidateBeanClasses$inlined = psiClassArray;
                this.$candidateBean$inlined = springBeanPointer;
                super(0);
            }

            @Nullable
            public final Template invoke() {
                KtProperty ktProperty = (KtProperty)this.$propertyPointer.getElement();
                if (ktProperty == null) {
                    return null;
                }
                KtProperty currentProperty = ktProperty;
                TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)currentProperty);
                KtProperty ktProperty2 = currentProperty;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktProperty2, (String)"currentProperty");
                GenerateDependenciesUtilsKt.appendVariableTemplate(builder, ktProperty2, this.$candidateBeanClasses$inlined, (Function0<? extends Collection<String>>)((Function0)new Function0<Collection<? extends String>>(this, currentProperty){
                    final /* synthetic */ addCreatePropertyTemplate$$inlined$apply$lambda$1 this$0;
                    final /* synthetic */ KtProperty $currentProperty;
                    {
                        this.this$0 = var1_1;
                        this.$currentProperty = ktProperty;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final Collection<String> invoke() {
                        void var3_3;
                        void $receiver$iv$iv;
                        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(this.$currentProperty);
                        if (ktClassOrObject == null) {
                            Intrinsics.throwNpe();
                        }
                        Iterable $receiver$iv = ktClassOrObject.getDeclarations();
                        Iterable iterable = $receiver$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        void $receiver$iv$iv$iv = $receiver$iv$iv;
                        for (T element$iv$iv$iv : $receiver$iv$iv$iv) {
                            String string;
                            String string2;
                            T element$iv$iv = element$iv$iv$iv;
                            KtDeclaration it = (KtDeclaration)element$iv$iv;
                            if (Intrinsics.areEqual((Object)it, (Object)this.$currentProperty) ^ true) {
                                KtDeclaration ktDeclaration = it;
                                if (!(ktDeclaration instanceof KtProperty)) {
                                    ktDeclaration = null;
                                }
                                KtProperty ktProperty = (KtProperty)ktDeclaration;
                                string2 = ktProperty != null ? ktProperty.getName() : null;
                            } else {
                                string2 = null;
                            }
                            if (string2 == null) continue;
                            String it$iv$iv = string = string2;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        List existingNames = (List)var3_3;
                        SpringBeanPointer springBeanPointer = this.this$0.$candidateBean$inlined;
                        KtProperty ktProperty = this.$currentProperty;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktProperty, (String)"currentProperty");
                        return GenerateDependenciesUtilsKt.getSuggestedNames((SpringBeanPointer<CommonSpringBean>)springBeanPointer, ktProperty, existingNames, (Function1<? super CallableDescriptor, ? extends KotlinType>)((Function1)addCreatePropertyTemplate.1.1.INSTANCE));
                    }
                }));
                return builder.buildInlineTemplate();
            }
        }));
        return batchTemplateRunner;
    }

    private static final BatchTemplateRunner createAutowiredDependency(KtLightClass klass2, SpringBeanPointer<CommonSpringBean> candidateBean, CommonSpringModel model) {
        Object[] $receiver$iv = SpringUtilsKt.effectiveBeanClasses(candidateBean);
        Object[] objectArray = $receiver$iv;
        if (objectArray.length == 0) {
            return null;
        }
        PsiClass[] candidateBeanClasses = (PsiClass[])$receiver$iv;
        if (!GenerateSpringBeanDependenciesUtil.ensureFileWritable((PsiClass)klass2)) {
            return null;
        }
        return (BatchTemplateRunner)ApplicationManager.getApplication().runWriteAction(new Computable<T>(klass2, candidateBean, candidateBeanClasses, model){
            final /* synthetic */ KtLightClass $klass$inlined;
            final /* synthetic */ SpringBeanPointer $candidateBean$inlined;
            final /* synthetic */ PsiClass[] $candidateBeanClasses$inlined;
            final /* synthetic */ CommonSpringModel $model$inlined;
            {
                this.$klass$inlined = ktLightClass;
                this.$candidateBean$inlined = springBeanPointer;
                this.$candidateBeanClasses$inlined = psiClassArray;
                this.$model$inlined = commonSpringModel;
            }

            public final T compute() {
                BatchTemplateRunner batchTemplateRunner;
                KtProperty ktProperty = GenerateAutowiredDependenciesUtilsKt.access$createAutowiredProperty(this.$klass$inlined, this.$candidateBean$inlined, this.$candidateBeanClasses$inlined, this.$model$inlined);
                if (ktProperty != null) {
                    KtProperty ktProperty2;
                    KtProperty property2 = ktProperty2 = ktProperty;
                    batchTemplateRunner = GenerateAutowiredDependenciesUtilsKt.access$addCreatePropertyTemplate(property2, this.$candidateBean$inlined, this.$candidateBeanClasses$inlined);
                } else {
                    batchTemplateRunner = null;
                }
                return (T)batchTemplateRunner;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<BatchTemplateRunner> generateAutowiredDependenciesFor(@NotNull KtLightClass klass2) {
        List list2;
        Iterator iterator2;
        Function1<SpringBeanPointer<CommonSpringBean>, Boolean> predicate$iv;
        void $receiver$iv$iv;
        Function1<SpringBeanPointer<CommonSpringBean>, Boolean> destination$iv$iv;
        Object $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
        CommonSpringModel model = SpringModelUtils.getInstance().getPsiClassSpringModel((PsiClass)klass2);
        Set candidates2 = GenerateSpringBeanDependenciesUtil.getAutowiredBeanCandidates((CommonSpringModel)model, (Condition)generateAutowiredDependenciesFor.candidates.1.INSTANCE);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Comparator $receiver$iv$iv2;
            Function1<SpringBeanPointer<CommonSpringBean>, Boolean> function1 = $receiver$iv = (Function1<SpringBeanPointer<CommonSpringBean>, Boolean>)candidates2;
            destination$iv$iv = (Function1<SpringBeanPointer<CommonSpringBean>, Boolean>)new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                SpringBeanClassMember springBeanClassMember = (SpringBeanClassMember)item$iv$iv;
                Function1<SpringBeanPointer<CommonSpringBean>, Boolean> function12 = destination$iv$iv;
                SpringBeanPointer springBeanPointer = it.getSpringBean();
                function12.add(springBeanPointer);
            }
            $receiver$iv = (List)destination$iv$iv;
            predicate$iv = GenerateDependenciesUtilsKt.getBeanFilter(klass2.getProject());
            destination$iv$iv = $receiver$iv;
            Collection destination$iv$iv2 = new ArrayList();
            iterator2 = $receiver$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                if (!((Boolean)predicate$iv.invoke(element$iv$iv)).booleanValue()) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv2;
            predicate$iv = $receiver$iv;
            $receiver$iv$iv2 = new Comparator<T>(){

                public final int compare(T a, T b) {
                    SpringBeanPointer it = (SpringBeanPointer)a;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (SpringBeanPointer)b;
                    Comparable comparable2 = comparable;
                    String string = it.getName();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            };
            list2 = CollectionsKt.sortedWith(predicate$iv, (Comparator)$receiver$iv$iv2);
        } else {
            List list3 = GenerateSpringBeanDependenciesUtil.chooseDependentBeans((Set)candidates2, (Project)klass2.getProject(), (boolean)true);
            list2 = list3;
            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"GenerateSpringBeanDepend\u2026tes, klass.project, true)");
        }
        List dependencies2 = list2;
        predicate$iv = $receiver$iv = (Iterable)dependencies2;
        destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            BatchTemplateRunner batchTemplateRunner;
            SpringBeanPointer it;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            SpringBeanPointer springBeanPointer = it = (SpringBeanPointer)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)springBeanPointer, (String)"it");
            CommonSpringModel commonSpringModel = model;
            Intrinsics.checkExpressionValueIsNotNull((Object)commonSpringModel, (String)"model");
            if (GenerateAutowiredDependenciesUtilsKt.createAutowiredDependency(klass2, (SpringBeanPointer<CommonSpringBean>)springBeanPointer, commonSpringModel) == null) continue;
            BatchTemplateRunner it$iv$iv = batchTemplateRunner;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final /* synthetic */ KtProperty access$createAutowiredProperty(@NotNull KtLightClass currentBeanClass, @NotNull SpringBeanPointer candidateBean, @NotNull PsiClass[] candidateBeanClasses, @NotNull CommonSpringModel model) {
        return GenerateAutowiredDependenciesUtilsKt.createAutowiredProperty(currentBeanClass, (SpringBeanPointer<CommonSpringBean>)candidateBean, candidateBeanClasses, model);
    }

    @NotNull
    public static final /* synthetic */ BatchTemplateRunner access$addCreatePropertyTemplate(@NotNull KtProperty property2, @NotNull SpringBeanPointer candidateBean, @NotNull PsiClass[] candidateBeanClasses) {
        return GenerateAutowiredDependenciesUtilsKt.addCreatePropertyTemplate(property2, (SpringBeanPointer<CommonSpringBean>)candidateBean, candidateBeanClasses);
    }
}

