/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.common.Symbol;

public class JsName
extends HasMetadata
implements Symbol {
    @NotNull
    private final String ident;
    private final boolean temporary;

    JsName(@NotNull String ident, boolean temporary) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "org/jetbrains/kotlin/js/backend/ast/JsName", "<init>"));
        }
        this.ident = ident;
        this.temporary = temporary;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    @NotNull
    public String getIdent() {
        String string = this.ident;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsName", "getIdent"));
        }
        return string;
    }

    @NotNull
    public JsNameRef makeRef() {
        JsNameRef jsNameRef = new JsNameRef(this);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsName", "makeRef"));
        }
        return jsNameRef;
    }

    public String toString() {
        return this.ident;
    }
}

