/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinClassStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.Utils;
import org.jetbrains.kotlin.resolve.lazy.ResolveSessionUtils;

public class KtClassElementType
extends KtStubElementType<KotlinClassStub, KtClass> {
    public KtClassElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/psi/stubs/elements/KtClassElementType", "<init>"));
        }
        super(debugName, KtClass.class, KotlinClassStub.class);
    }

    @Override
    @NotNull
    public KtClass createPsi(@NotNull KotlinClassStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/stubs/elements/KtClassElementType", "createPsi"));
        }
        KtClass ktClass2 = !stub.isEnumEntry() ? new KtClass(stub) : new KtEnumEntry(stub);
        if (ktClass2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/stubs/elements/KtClassElementType", "createPsi"));
        }
        return ktClass2;
    }

    @Override
    @NotNull
    public KtClass createPsiFromAst(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/stubs/elements/KtClassElementType", "createPsiFromAst"));
        }
        KtClass ktClass2 = node.getElementType() != KtStubElementTypes.ENUM_ENTRY ? new KtClass(node) : new KtEnumEntry(node);
        if (ktClass2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/stubs/elements/KtClassElementType", "createPsiFromAst"));
        }
        return ktClass2;
    }

    public KotlinClassStub createStub(@NotNull KtClass psi2, StubElement parentStub) {
        if (psi2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/kotlin/psi/stubs/elements/KtClassElementType", "createStub"));
        }
        FqName fqName2 = ResolveSessionUtils.safeFqNameForLazyResolve(psi2);
        boolean isEnumEntry = psi2 instanceof KtEnumEntry;
        List<String> superNames = KtPsiUtilKt.getSuperNames(psi2);
        return new KotlinClassStubImpl(KtClassElementType.getStubType(isEnumEntry), (StubElement<? extends PsiElement>)parentStub, StringRef.fromString((String)(fqName2 != null ? fqName2.asString() : null)), StringRef.fromString((String)psi2.getName()), Utils.INSTANCE.wrapStrings(superNames), psi2.isInterface(), isEnumEntry, psi2.isLocal(), psi2.isTopLevel());
    }

    public void serialize(@NotNull KotlinClassStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/stubs/elements/KtClassElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/psi/stubs/elements/KtClassElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        FqName fqName2 = stub.getFqName();
        dataStream.writeName(fqName2 == null ? null : fqName2.asString());
        dataStream.writeBoolean(stub.isInterface());
        dataStream.writeBoolean(stub.isEnumEntry());
        dataStream.writeBoolean(stub.isLocal());
        dataStream.writeBoolean(stub.isTopLevel());
        List<String> superNames = stub.getSuperNames();
        dataStream.writeVarInt(superNames.size());
        for (String name2 : superNames) {
            dataStream.writeName(name2);
        }
    }

    @NotNull
    public KotlinClassStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/psi/stubs/elements/KtClassElementType", "deserialize"));
        }
        StringRef name2 = dataStream.readName();
        StringRef qualifiedName2 = dataStream.readName();
        boolean isTrait = dataStream.readBoolean();
        boolean isEnumEntry = dataStream.readBoolean();
        boolean isLocal = dataStream.readBoolean();
        boolean isTopLevel = dataStream.readBoolean();
        int superCount = dataStream.readVarInt();
        StringRef[] superNames = StringRef.createArray((int)superCount);
        for (int i = 0; i < superCount; ++i) {
            superNames[i] = dataStream.readName();
        }
        KotlinClassStubImpl kotlinClassStubImpl = new KotlinClassStubImpl(KtClassElementType.getStubType(isEnumEntry), (StubElement<? extends PsiElement>)parentStub, qualifiedName2, name2, superNames, isTrait, isEnumEntry, isLocal, isTopLevel);
        if (kotlinClassStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/stubs/elements/KtClassElementType", "deserialize"));
        }
        return kotlinClassStubImpl;
    }

    @Override
    public void indexStub(@NotNull KotlinClassStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/stubs/elements/KtClassElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/kotlin/psi/stubs/elements/KtClassElementType", "indexStub"));
        }
        StubIndexService.getInstance().indexClass(stub, sink);
    }

    public static KtClassElementType getStubType(boolean isEnumEntry) {
        return isEnumEntry ? KtStubElementTypes.ENUM_ENTRY : KtStubElementTypes.CLASS;
    }
}

