/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ExplicitSmartCasts;
import org.jetbrains.kotlin.resolve.calls.smartcasts.IdentifierInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ImplicitSmartCasts;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SingleSmartCast;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastResult;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007H\u0002J,\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J.\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\n\u001a\u00020\u000bJ\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager;", "", "()V", "getSmartCastSubType", "Lorg/jetbrains/kotlin/types/KotlinType;", "receiverParameterType", "smartCastTypes", "", "getSmartCastVariants", "", "receiverToCast", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "containingDeclarationOrModule", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "getSmartCastVariantsExcludingReceiver", "isSubTypeBySmartCastIgnoringNullability", "", "receiverArgument", "Companion", "frontend"})
public final class SmartCastManager {
    public static final Companion Companion = new Companion(null);

    private final List<KotlinType> getSmartCastVariants(ReceiverValue receiverToCast, ResolutionContext<?> context) {
        BindingContext bindingContext2 = context.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"context.trace.bindingContext");
        DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"context.dataFlowInfo");
        return this.getSmartCastVariants(receiverToCast, bindingContext2, declarationDescriptor, dataFlowInfo);
    }

    @NotNull
    public final List<KotlinType> getSmartCastVariants(@NotNull ReceiverValue receiverToCast, @NotNull BindingContext bindingContext2, @NotNull DeclarationDescriptor containingDeclarationOrModule, @NotNull DataFlowInfo dataFlowInfo) {
        Intrinsics.checkParameterIsNotNull((Object)receiverToCast, (String)"receiverToCast");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)containingDeclarationOrModule, (String)"containingDeclarationOrModule");
        Intrinsics.checkParameterIsNotNull((Object)dataFlowInfo, (String)"dataFlowInfo");
        Collection<KotlinType> variants = this.getSmartCastVariantsExcludingReceiver(bindingContext2, containingDeclarationOrModule, dataFlowInfo, receiverToCast);
        ArrayList<KotlinType> result2 = new ArrayList<KotlinType>(variants.size() + 1);
        result2.add(receiverToCast.getType());
        result2.addAll(variants);
        return result2;
    }

    @NotNull
    public final Collection<KotlinType> getSmartCastVariantsExcludingReceiver(@NotNull ResolutionContext<?> context, @NotNull ReceiverValue receiverToCast) {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)receiverToCast, (String)"receiverToCast");
        BindingContext bindingContext2 = context.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"context.trace.bindingContext");
        DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"context.dataFlowInfo");
        return this.getSmartCastVariantsExcludingReceiver(bindingContext2, declarationDescriptor, dataFlowInfo, receiverToCast);
    }

    private final Collection<KotlinType> getSmartCastVariantsExcludingReceiver(BindingContext bindingContext2, DeclarationDescriptor containingDeclarationOrModule, DataFlowInfo dataFlowInfo, ReceiverValue receiverToCast) {
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiverToCast, bindingContext2, containingDeclarationOrModule);
        return dataFlowInfo.getCollectedTypes(dataFlowValue);
    }

    public final boolean isSubTypeBySmartCastIgnoringNullability(@NotNull ReceiverValue receiverArgument, @NotNull KotlinType receiverParameterType, @NotNull ResolutionContext<?> context) {
        Intrinsics.checkParameterIsNotNull((Object)receiverArgument, (String)"receiverArgument");
        Intrinsics.checkParameterIsNotNull((Object)receiverParameterType, (String)"receiverParameterType");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        List<KotlinType> smartCastTypes = this.getSmartCastVariants(receiverArgument, context);
        KotlinType kotlinType = TypeUtils.makeNullable(receiverParameterType);
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"TypeUtils.makeNullable(receiverParameterType)");
        return this.getSmartCastSubType(kotlinType, (Collection<? extends KotlinType>)smartCastTypes) != null;
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinType getSmartCastSubType(KotlinType receiverParameterType, Collection<? extends KotlinType> smartCastTypes) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = smartCastTypes;
        void var5_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KotlinType it = (KotlinType)element$iv$iv;
            if (!ArgumentTypeResolver.isSubtypeOfForArgumentType(it, receiverParameterType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List subTypes = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        if (subTypes.isEmpty()) {
            return null;
        }
        KotlinType intersection = TypeIntersector.intersectTypes(KotlinTypeChecker.DEFAULT, subTypes);
        if (intersection == null || !intersection.getConstructor().isDenotable()) {
            return receiverParameterType;
        }
        return intersection;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JV\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000bJ@\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000bJ:\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager$Companion;", "", "()V", "checkAndRecordPossibleCast", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastResult;", "dataFlowValue", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "additionalPredicate", "Lkotlin/Function1;", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "call", "Lorg/jetbrains/kotlin/psi/Call;", "recordExpressionType", "recordCastOrError", "", "type", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "frontend"})
    public static final class Companion {
        private final void recordCastOrError(KtExpression expression2, KotlinType type2, BindingTrace trace, DataFlowValue dataFlowValue, Call call2, boolean recordExpressionType) {
            block10: {
                block7: {
                    ExplicitSmartCasts explicitSmartCasts;
                    KtExpression ktExpression;
                    WritableSlice<KtExpression, ExplicitSmartCasts> writableSlice;
                    BindingTrace bindingTrace;
                    block9: {
                        SingleSmartCast newSmartCast;
                        block8: {
                            KotlinType oldType;
                            if (KotlinBuiltIns.isNullableNothing(type2)) {
                                return;
                            }
                            if (!dataFlowValue.isStable()) break block7;
                            ExplicitSmartCasts oldSmartCasts = (ExplicitSmartCasts)trace.get(BindingContext.SMARTCAST, expression2);
                            newSmartCast = new SingleSmartCast(call2, type2);
                            if (oldSmartCasts != null && (oldType = oldSmartCasts.type(call2)) != null && Intrinsics.areEqual((Object)oldType, (Object)type2) ^ true) {
                                throw (Throwable)((Object)new AssertionError((Object)("Rewriting key " + call2 + " for smart cast on " + expression2.getText())));
                            }
                            bindingTrace = trace;
                            writableSlice = BindingContext.SMARTCAST;
                            ktExpression = expression2;
                            explicitSmartCasts = oldSmartCasts;
                            if (explicitSmartCasts == null) break block8;
                            ExplicitSmartCasts explicitSmartCasts2 = explicitSmartCasts;
                            KtExpression ktExpression2 = ktExpression;
                            WritableSlice<KtExpression, ExplicitSmartCasts> writableSlice2 = writableSlice;
                            BindingTrace bindingTrace2 = bindingTrace;
                            ExplicitSmartCasts it = explicitSmartCasts2;
                            ExplicitSmartCasts explicitSmartCasts3 = it.plus(newSmartCast);
                            bindingTrace = bindingTrace2;
                            writableSlice = writableSlice2;
                            ktExpression = ktExpression2;
                            explicitSmartCasts = explicitSmartCasts3;
                            if (explicitSmartCasts != null) break block9;
                        }
                        explicitSmartCasts = newSmartCast;
                    }
                    bindingTrace.record(writableSlice, ktExpression, explicitSmartCasts);
                    if (recordExpressionType) {
                        trace.recordType(expression2, type2);
                    }
                    break block10;
                }
                trace.report(Errors.SMARTCAST_IMPOSSIBLE.on((KtExpression)((PsiElement)expression2), type2, expression2.getText(), dataFlowValue.getKind().getDescription()));
            }
        }

        @Nullable
        public final SmartCastResult checkAndRecordPossibleCast(@NotNull DataFlowValue dataFlowValue, @NotNull KotlinType expectedType2, @Nullable KtExpression expression2, @NotNull ResolutionContext<?> c, @Nullable Call call2, boolean recordExpressionType) {
            Intrinsics.checkParameterIsNotNull((Object)dataFlowValue, (String)"dataFlowValue");
            Intrinsics.checkParameterIsNotNull((Object)expectedType2, (String)"expectedType");
            Intrinsics.checkParameterIsNotNull(c, (String)"c");
            return this.checkAndRecordPossibleCast(dataFlowValue, expectedType2, null, expression2, c, call2, recordExpressionType);
        }

        @Nullable
        public final SmartCastResult checkAndRecordPossibleCast(@NotNull DataFlowValue dataFlowValue, @NotNull KotlinType expectedType2, @Nullable Function1<? super KotlinType, Boolean> additionalPredicate, @Nullable KtExpression expression2, @NotNull ResolutionContext<?> c, @Nullable Call call2, boolean recordExpressionType) {
            Intrinsics.checkParameterIsNotNull((Object)dataFlowValue, (String)"dataFlowValue");
            Intrinsics.checkParameterIsNotNull((Object)expectedType2, (String)"expectedType");
            Intrinsics.checkParameterIsNotNull(c, (String)"c");
            Call call3 = call2;
            KtExpression calleeExpression2 = call3 != null ? call3.getCalleeExpression() : null;
            for (KotlinType possibleType : c.dataFlowInfo.getCollectedTypes(dataFlowValue)) {
                block10: {
                    ImplicitSmartCasts implicitSmartCasts;
                    KtExpression ktExpression;
                    WritableSlice<KtExpression, ImplicitSmartCasts> writableSlice;
                    BindingTrace bindingTrace;
                    block12: {
                        ImplicitSmartCasts newSmartCasts;
                        block11: {
                            KotlinType oldType;
                            ReceiverValue receiver;
                            block9: {
                                if (!ArgumentTypeResolver.isSubtypeOfForArgumentType(possibleType, expectedType2) || additionalPredicate != null && !((Boolean)additionalPredicate.invoke((Object)possibleType)).booleanValue()) continue;
                                if (expression2 == null) break block9;
                                BindingTrace bindingTrace2 = c.trace;
                                Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace2, (String)"c.trace");
                                this.recordCastOrError(expression2, possibleType, bindingTrace2, dataFlowValue, call2, recordExpressionType);
                                break block10;
                            }
                            if (calleeExpression2 == null || !dataFlowValue.isStable()) break block10;
                            IdentifierInfo identifierInfo = dataFlowValue.getIdentifierInfo();
                            if (!(identifierInfo instanceof IdentifierInfo.Receiver)) {
                                identifierInfo = null;
                            }
                            IdentifierInfo.Receiver receiver2 = (IdentifierInfo.Receiver)identifierInfo;
                            ReceiverValue receiverValue = receiver = receiver2 != null ? receiver2.getValue() : null;
                            if (!(receiver instanceof ImplicitReceiver)) break block10;
                            ImplicitSmartCasts oldSmartCasts = (ImplicitSmartCasts)c.trace.get(BindingContext.IMPLICIT_RECEIVER_SMARTCAST, calleeExpression2);
                            newSmartCasts = new ImplicitSmartCasts((ImplicitReceiver)receiver, possibleType);
                            if (oldSmartCasts != null && (oldType = oldSmartCasts.getReceiverTypes().get(receiver)) != null && Intrinsics.areEqual((Object)oldType, (Object)possibleType) ^ true) {
                                throw (Throwable)((Object)new AssertionError((Object)("Rewriting key " + receiver + " for implicit smart cast on " + calleeExpression2.getText() + ": " + "was " + oldType + ", now " + possibleType)));
                            }
                            bindingTrace = c.trace;
                            writableSlice = BindingContext.IMPLICIT_RECEIVER_SMARTCAST;
                            ktExpression = calleeExpression2;
                            implicitSmartCasts = oldSmartCasts;
                            if (implicitSmartCasts == null) break block11;
                            ImplicitSmartCasts implicitSmartCasts2 = implicitSmartCasts;
                            KtExpression ktExpression2 = ktExpression;
                            WritableSlice<KtExpression, ImplicitSmartCasts> writableSlice2 = writableSlice;
                            BindingTrace bindingTrace3 = bindingTrace;
                            ImplicitSmartCasts it = implicitSmartCasts2;
                            ImplicitSmartCasts implicitSmartCasts3 = it.plus(newSmartCasts);
                            bindingTrace = bindingTrace3;
                            writableSlice = writableSlice2;
                            ktExpression = ktExpression2;
                            implicitSmartCasts = implicitSmartCasts3;
                            if (implicitSmartCasts != null) break block12;
                        }
                        implicitSmartCasts = newSmartCasts;
                    }
                    bindingTrace.record(writableSlice, ktExpression, implicitSmartCasts);
                }
                return new SmartCastResult(possibleType, dataFlowValue.isStable());
            }
            if (!c.dataFlowInfo.getCollectedNullability(dataFlowValue).canBeNull() && !expectedType2.isMarkedNullable()) {
                boolean immanentlyNotNull = !dataFlowValue.getImmanentNullability().canBeNull();
                KotlinType nullableExpectedType = TypeUtils.makeNullable(expectedType2);
                if (ArgumentTypeResolver.isSubtypeOfForArgumentType(dataFlowValue.getType(), nullableExpectedType) && (additionalPredicate == null || ((Boolean)additionalPredicate.invoke((Object)dataFlowValue.getType())).booleanValue())) {
                    if (!immanentlyNotNull && expression2 != null) {
                        KotlinType kotlinType = dataFlowValue.getType();
                        BindingTrace bindingTrace = c.trace;
                        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"c.trace");
                        this.recordCastOrError(expression2, kotlinType, bindingTrace, dataFlowValue, call2, recordExpressionType);
                    }
                    return new SmartCastResult(dataFlowValue.getType(), immanentlyNotNull || dataFlowValue.isStable());
                }
                KotlinType kotlinType = nullableExpectedType;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"nullableExpectedType");
                return this.checkAndRecordPossibleCast(dataFlowValue, kotlinType, expression2, c, call2, recordExpressionType);
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

