/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ \u0010\t\u001a\u00020\n2\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u0007\u001a\u00020&J\u000e\u0010'\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020)J\u001c\u0010*\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000eJ\u000e\u0010-\u001a\u00020.2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010/\u001a\u0002002\u0006\u0010\u0007\u001a\u00020+J\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u0002042\u0006\u0010\u0007\u001a\u000205J\u000e\u00106\u001a\u0002072\u0006\u0010\u0007\u001a\u00020#J\u001a\u00108\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b*\u0006\u0012\u0002\b\u00030\u000bH\u0002J\f\u00109\u001a\u00020\u000e*\u00020:H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/ConstantValueFactory;", "", "builtins", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "createAnnotationValue", "Lorg/jetbrains/kotlin/resolve/constants/AnnotationValue;", "value", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "createArrayValue", "Lorg/jetbrains/kotlin/resolve/constants/ArrayValue;", "", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "createBooleanValue", "Lorg/jetbrains/kotlin/resolve/constants/BooleanValue;", "", "createByteValue", "Lorg/jetbrains/kotlin/resolve/constants/ByteValue;", "", "createCharValue", "Lorg/jetbrains/kotlin/resolve/constants/CharValue;", "", "createConstantValue", "createDoubleValue", "Lorg/jetbrains/kotlin/resolve/constants/DoubleValue;", "", "createEnumValue", "Lorg/jetbrains/kotlin/resolve/constants/EnumValue;", "enumEntryClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "createErrorValue", "Lorg/jetbrains/kotlin/resolve/constants/ErrorValue;", "message", "", "createFloatValue", "Lorg/jetbrains/kotlin/resolve/constants/FloatValue;", "", "createIntValue", "Lorg/jetbrains/kotlin/resolve/constants/IntValue;", "", "createIntegerConstantValue", "", "expectedType", "createKClassValue", "Lorg/jetbrains/kotlin/resolve/constants/KClassValue;", "createLongValue", "Lorg/jetbrains/kotlin/resolve/constants/LongValue;", "createNullValue", "Lorg/jetbrains/kotlin/resolve/constants/NullValue;", "createShortValue", "Lorg/jetbrains/kotlin/resolve/constants/ShortValue;", "", "createStringValue", "Lorg/jetbrains/kotlin/resolve/constants/StringValue;", "arrayToList", "arrayType", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "descriptors"})
public final class ConstantValueFactory {
    private final KotlinBuiltIns builtins;

    @NotNull
    public final LongValue createLongValue(long value2) {
        return new LongValue(value2, this.builtins);
    }

    @NotNull
    public final IntValue createIntValue(int value2) {
        return new IntValue(value2, this.builtins);
    }

    @NotNull
    public final ErrorValue createErrorValue(@NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        return ErrorValue.Companion.create(message2);
    }

    @NotNull
    public final ShortValue createShortValue(short value2) {
        return new ShortValue(value2, this.builtins);
    }

    @NotNull
    public final ByteValue createByteValue(byte value2) {
        return new ByteValue(value2, this.builtins);
    }

    @NotNull
    public final DoubleValue createDoubleValue(double value2) {
        return new DoubleValue(value2, this.builtins);
    }

    @NotNull
    public final FloatValue createFloatValue(float value2) {
        return new FloatValue(value2, this.builtins);
    }

    @NotNull
    public final BooleanValue createBooleanValue(boolean value2) {
        return new BooleanValue(value2, this.builtins);
    }

    @NotNull
    public final CharValue createCharValue(char value2) {
        return new CharValue(value2, this.builtins);
    }

    @NotNull
    public final StringValue createStringValue(@NotNull String value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        return new StringValue(value2, this.builtins);
    }

    @NotNull
    public final NullValue createNullValue() {
        return new NullValue(this.builtins);
    }

    @NotNull
    public final EnumValue createEnumValue(@NotNull ClassDescriptor enumEntryClass) {
        Intrinsics.checkParameterIsNotNull((Object)enumEntryClass, (String)"enumEntryClass");
        return new EnumValue(enumEntryClass);
    }

    @NotNull
    public final ArrayValue createArrayValue(@NotNull List<? extends ConstantValue<?>> value2, @NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(value2, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        return new ArrayValue(value2, type2, this.builtins);
    }

    @NotNull
    public final AnnotationValue createAnnotationValue(@NotNull AnnotationDescriptor value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        return new AnnotationValue(value2);
    }

    @NotNull
    public final KClassValue createKClassValue(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        return new KClassValue(type2);
    }

    @Nullable
    public final ConstantValue<?> createConstantValue(@Nullable Object value2) {
        Object object = value2;
        return object instanceof Byte ? (ConstantValue)this.createByteValue(((Number)value2).byteValue()) : (object instanceof Short ? (ConstantValue)this.createShortValue(((Number)value2).shortValue()) : (object instanceof Integer ? (ConstantValue)this.createIntValue(((Number)value2).intValue()) : (object instanceof Long ? (ConstantValue)this.createLongValue(((Number)value2).longValue()) : (object instanceof Character ? (ConstantValue)this.createCharValue(((Character)value2).charValue()) : (object instanceof Float ? (ConstantValue)this.createFloatValue(((Number)value2).floatValue()) : (object instanceof Double ? (ConstantValue)this.createDoubleValue(((Number)value2).doubleValue()) : (object instanceof Boolean ? (ConstantValue)this.createBooleanValue((Boolean)value2) : (object instanceof String ? (ConstantValue)this.createStringValue((String)value2) : (object instanceof byte[] ? (ConstantValue)this.createArrayValue(this.arrayToList(ArraysKt.toList((byte[])((byte[])value2))), this.arrayType(PrimitiveType.BYTE)) : (object instanceof short[] ? (ConstantValue)this.createArrayValue(this.arrayToList(ArraysKt.toList((short[])((short[])value2))), this.arrayType(PrimitiveType.SHORT)) : (object instanceof int[] ? (ConstantValue)this.createArrayValue(this.arrayToList(ArraysKt.toList((int[])((int[])value2))), this.arrayType(PrimitiveType.INT)) : (object instanceof long[] ? (ConstantValue)this.createArrayValue(this.arrayToList(ArraysKt.toList((long[])((long[])value2))), this.arrayType(PrimitiveType.LONG)) : (object instanceof char[] ? (ConstantValue)this.createArrayValue(this.arrayToList(ArraysKt.toList((char[])((char[])value2))), this.arrayType(PrimitiveType.CHAR)) : (object instanceof float[] ? (ConstantValue)this.createArrayValue(this.arrayToList(ArraysKt.toList((float[])((float[])value2))), this.arrayType(PrimitiveType.FLOAT)) : (object instanceof double[] ? (ConstantValue)this.createArrayValue(this.arrayToList(ArraysKt.toList((double[])((double[])value2))), this.arrayType(PrimitiveType.DOUBLE)) : (object instanceof boolean[] ? (ConstantValue)this.createArrayValue(this.arrayToList(ArraysKt.toList((boolean[])((boolean[])value2))), this.arrayType(PrimitiveType.BOOLEAN)) : (object == null ? (ConstantValue)this.createNullValue() : null)))))))))))))))));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ConstantValue<?>> arrayToList(@NotNull List<?> $receiver) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.toList((Iterable)$receiver);
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            ConstantValue<?> constantValue;
            Object element$iv$iv = element$iv$iv$iv;
            Object it = element$iv$iv;
            if (this.createConstantValue(it) == null) continue;
            ConstantValue<?> it$iv$iv = constantValue;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final KotlinType arrayType(@NotNull PrimitiveType $receiver) {
        SimpleType simpleType2 = this.builtins.getPrimitiveArrayKotlinType($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"builtins.getPrimitiveArrayKotlinType(this)");
        return simpleType2;
    }

    @Nullable
    public final ConstantValue<?> createIntegerConstantValue(long value2, @NotNull KotlinType expectedType2) {
        Intrinsics.checkParameterIsNotNull((Object)expectedType2, (String)"expectedType");
        KotlinType notNullExpected = TypeUtils.makeNotNullable(expectedType2);
        return KotlinBuiltIns.isLong(notNullExpected) ? (ConstantValue)this.createLongValue(value2) : (KotlinBuiltIns.isInt(notNullExpected) && value2 == (long)((int)value2) ? (ConstantValue)this.createIntValue((int)value2) : (KotlinBuiltIns.isShort(notNullExpected) && value2 == (long)((short)value2) ? (ConstantValue)this.createShortValue((short)value2) : (KotlinBuiltIns.isByte(notNullExpected) && value2 == (long)((byte)value2) ? (ConstantValue)this.createByteValue((byte)value2) : (KotlinBuiltIns.isChar(notNullExpected) ? (ConstantValue)this.createIntValue((int)value2) : null))));
    }

    public ConstantValueFactory(@NotNull KotlinBuiltIns builtins) {
        Intrinsics.checkParameterIsNotNull((Object)builtins, (String)"builtins");
        this.builtins = builtins;
    }
}

