/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.wizard;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.PsiPropertiesProvider;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.compiler.AlienFormFileException;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.LwComponent;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import com.intellij.uiDesigner.wizard.BeanProperty;
import com.intellij.uiDesigner.wizard.FormProperty;
import com.intellij.uiDesigner.wizard.FormProperty2BeanProperty;
import com.intellij.uiDesigner.wizard.WizardData;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class Generator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.wizard.Generator");

    private Generator() {
    }

    public static FormProperty[] exposeForm(Project project, VirtualFile formFile, LwRootContainer[] rootContainer) throws MyException {
        LwRootContainer _rootContainer;
        Module module = ModuleUtil.findModuleForFile((VirtualFile)formFile, (Project)project);
        LOG.assertTrue(module != null);
        PsiPropertiesProvider propertiesProvider = new PsiPropertiesProvider(module);
        Document doc = FileDocumentManager.getInstance().getDocument(formFile);
        try {
            _rootContainer = Utils.getRootContainer((String)doc.getText(), (PropertiesProvider)propertiesProvider);
        }
        catch (AlienFormFileException e) {
            throw new MyException(e.getMessage());
        }
        catch (Exception e) {
            throw new MyException(UIDesignerBundle.message("error.cannot.process.form.file", e));
        }
        rootContainer[0] = _rootContainer;
        final String classToBind = _rootContainer.getClassToBind();
        if (classToBind == null) {
            throw new MyException(UIDesignerBundle.message("error.form.is.not.bound.to.a.class", new Object[0]));
        }
        final PsiClass boundClass = FormEditingUtil.findClassToBind(module, classToBind);
        if (boundClass == null) {
            throw new MyException(UIDesignerBundle.message("error.bound.class.does.not.exist", classToBind));
        }
        final ArrayList result = new ArrayList();
        final MyException[] exception = new MyException[1];
        FormEditingUtil.iterate((IComponent)_rootContainer, new FormEditingUtil.ComponentVisitor<LwComponent>(){

            @Override
            public boolean visit(LwComponent component) {
                String binding = component.getBinding();
                if (binding == null) {
                    return true;
                }
                PsiField[] fields = boundClass.getFields();
                PsiField field = null;
                for (int i = fields.length - 1; i >= 0; --i) {
                    if (!binding.equals(fields[i].getName())) continue;
                    field = fields[i];
                    break;
                }
                if (field == null) {
                    exception[0] = new MyException(UIDesignerBundle.message("error.field.not.found.in.class", binding, classToBind));
                    return false;
                }
                PsiClass fieldClass = Generator.getClassByType(field.getType());
                if (fieldClass == null) {
                    exception[0] = new MyException(UIDesignerBundle.message("error.invalid.binding.field.type", binding, classToBind));
                    return false;
                }
                if (Generator.instanceOf(fieldClass, JTextComponent.class.getName())) {
                    result.add(new FormProperty(component, "getText", "setText", String.class.getName()));
                } else if (Generator.instanceOf(fieldClass, JCheckBox.class.getName())) {
                    result.add(new FormProperty(component, "isSelected", "setSelected", Boolean.TYPE.getName()));
                }
                return true;
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
        return result.toArray(new FormProperty[result.size()]);
    }

    private static PsiClass getClassByType(PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        return ((PsiClassType)type).resolve();
    }

    private static boolean instanceOf(PsiClass jComponentClass, String baseClassName) {
        for (PsiClass c = jComponentClass; c != null; c = c.getSuperClass()) {
            if (!baseClassName.equals(c.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public static void generateDataBindingMethods(WizardData data) throws MyException {
        FormProperty2BeanProperty[] bindings;
        if (data.myBindToNewBean) {
            data.myBeanClass = Generator.createBeanClass(data);
        } else if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)data.myBeanClass.getProject(), (PsiElement)data.myBeanClass)) {
            return;
        }
        HashMap<String, String> binding2beanGetter = new HashMap<String, String>();
        HashMap<String, String> binding2beanSetter = new HashMap<String, String>();
        for (FormProperty2BeanProperty form2bean : bindings = data.myBindings) {
            if (form2bean == null || form2bean.myBeanProperty == null) continue;
            String setterName = PropertyUtil.suggestSetterName((String)form2bean.myBeanProperty.myName);
            PsiMethod[] methodsByName = data.myBeanClass.findMethodsByName(setterName, true);
            if (methodsByName.length < 1) {
                LOG.assertTrue(!data.myBindToNewBean);
                if (!data.myBeanClass.isWritable()) {
                    throw new MyException("Cannot add property to non writable class " + data.myBeanClass.getQualifiedName());
                }
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer methodsBuffer = new StringBuffer();
                Project project = data.myBeanClass.getProject();
                CodeStyleManager formatter = CodeStyleManager.getInstance((Project)project);
                JavaCodeStyleManager styler = JavaCodeStyleManager.getInstance((Project)project);
                Generator.generateProperty(styler, form2bean.myBeanProperty.myName, form2bean.myBeanProperty.myType, stringBuffer, methodsBuffer);
                try {
                    PsiClass fakeClass = JavaPsiFacade.getInstance((Project)data.myBeanClass.getProject()).getElementFactory().createClassFromText(stringBuffer.toString() + methodsBuffer.toString(), null);
                    PsiField[] fields = fakeClass.getFields();
                    PsiElement result = data.myBeanClass.add((PsiElement)fields[0]);
                    styler.shortenClassReferences(result);
                    formatter.reformat(result);
                    PsiMethod[] methods = fakeClass.getMethods();
                    PsiElement result2 = data.myBeanClass.add((PsiElement)methods[0]);
                    styler.shortenClassReferences(result2);
                    formatter.reformat(result2);
                    PsiElement result3 = data.myBeanClass.add((PsiElement)methods[1]);
                    styler.shortenClassReferences(result3);
                    formatter.reformat(result3);
                }
                catch (IncorrectOperationException e) {
                    throw new MyException(e.getMessage());
                }
            }
            PsiMethod propertySetter = PropertyUtil.findPropertySetter((PsiClass)data.myBeanClass, (String)form2bean.myBeanProperty.myName, (boolean)false, (boolean)true);
            PsiMethod propertyGetter = PropertyUtil.findPropertyGetter((PsiClass)data.myBeanClass, (String)form2bean.myBeanProperty.myName, (boolean)false, (boolean)true);
            if (propertyGetter == null || propertySetter == null) continue;
            String string = form2bean.myFormProperty.getLwComponent().getBinding();
            binding2beanGetter.put(string, propertyGetter.getName());
            binding2beanSetter.put(string, propertySetter.getName());
        }
        String dataBeanClassName = data.myBeanClass.getQualifiedName();
        LwRootContainer[] rootContainer = new LwRootContainer[1];
        FormProperty[] formProperties = Generator.exposeForm(data.myProject, data.myFormFile, rootContainer);
        StringBuffer getDataBody = new StringBuffer();
        StringBuffer setDataBody = new StringBuffer();
        StringBuffer isModifiedBody = new StringBuffer();
        for (FormProperty formProperty : formProperties) {
            String binding = formProperty.getLwComponent().getBinding();
            if (!binding2beanGetter.containsKey(binding)) continue;
            getDataBody.append("data.");
            getDataBody.append((String)binding2beanSetter.get(binding));
            getDataBody.append("(");
            getDataBody.append(binding);
            getDataBody.append(".");
            getDataBody.append(formProperty.getComponentPropertyGetterName());
            getDataBody.append("());\n");
            setDataBody.append(binding);
            setDataBody.append(".");
            setDataBody.append(formProperty.getComponentPropertySetterName());
            setDataBody.append("(data.");
            setDataBody.append((String)binding2beanGetter.get(binding));
            setDataBody.append("());\n");
            String propertyClassName = formProperty.getComponentPropertyClassName();
            if ("boolean".equals(propertyClassName)) {
                isModifiedBody.append("if (");
                isModifiedBody.append(binding);
                isModifiedBody.append(".");
                isModifiedBody.append(formProperty.getComponentPropertyGetterName());
                isModifiedBody.append("()");
                isModifiedBody.append("!= ");
                isModifiedBody.append("data.");
                isModifiedBody.append((String)binding2beanGetter.get(binding));
                isModifiedBody.append("()");
                isModifiedBody.append(") return true;\n");
                continue;
            }
            isModifiedBody.append("if (");
            isModifiedBody.append(binding);
            isModifiedBody.append(".");
            isModifiedBody.append(formProperty.getComponentPropertyGetterName());
            isModifiedBody.append("()");
            isModifiedBody.append("!= null ? ");
            isModifiedBody.append("!");
            isModifiedBody.append(binding);
            isModifiedBody.append(".");
            isModifiedBody.append(formProperty.getComponentPropertyGetterName());
            isModifiedBody.append("()");
            isModifiedBody.append(".equals(");
            isModifiedBody.append("data.");
            isModifiedBody.append((String)binding2beanGetter.get(binding));
            isModifiedBody.append("()");
            isModifiedBody.append(") : ");
            isModifiedBody.append("data.");
            isModifiedBody.append((String)binding2beanGetter.get(binding));
            isModifiedBody.append("()");
            isModifiedBody.append("!= null");
            isModifiedBody.append(") return true;\n");
        }
        isModifiedBody.append("return false;\n");
        String string = "public void setData(" + dataBeanClassName + " data){\n" + setDataBody.toString() + "}\n\npublic void getData(" + dataBeanClassName + " data){\n" + getDataBody.toString() + "}\n\npublic boolean isModified(" + dataBeanClassName + " data){\n" + isModifiedBody.toString() + "}\n";
        Module module = ModuleUtil.findModuleForFile((VirtualFile)data.myFormFile, (Project)data.myProject);
        LOG.assertTrue(module != null);
        PsiClass boundClass = FormEditingUtil.findClassToBind(module, rootContainer[0].getClassToBind());
        LOG.assertTrue(boundClass != null);
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)module.getProject(), (PsiElement)boundClass)) {
            return;
        }
        try {
            PsiClass fakeClass = JavaPsiFacade.getInstance((Project)data.myProject).getElementFactory().createClassFromText(string, null);
            PsiMethod methodSetData = fakeClass.getMethods()[0];
            PsiMethod methodGetData = fakeClass.getMethods()[1];
            PsiMethod methodIsModified = fakeClass.getMethods()[2];
            PsiMethod existing1 = boundClass.findMethodBySignature(methodSetData, false);
            PsiMethod existing2 = boundClass.findMethodBySignature(methodGetData, false);
            PsiMethod existing3 = boundClass.findMethodBySignature(methodIsModified, false);
            if (existing1 != null) {
                existing1.delete();
            }
            if (existing2 != null) {
                existing2.delete();
            }
            if (existing3 != null) {
                existing3.delete();
            }
            CodeStyleManager formatter = CodeStyleManager.getInstance((Project)module.getProject());
            JavaCodeStyleManager styler = JavaCodeStyleManager.getInstance((Project)module.getProject());
            PsiElement setData = boundClass.add((PsiElement)methodSetData);
            styler.shortenClassReferences(setData);
            formatter.reformat(setData);
            PsiElement getData = boundClass.add((PsiElement)methodGetData);
            styler.shortenClassReferences(getData);
            formatter.reformat(getData);
            if (data.myGenerateIsModified) {
                PsiElement isModified = boundClass.add((PsiElement)methodIsModified);
                styler.shortenClassReferences(isModified);
                formatter.reformat(isModified);
            }
            OpenFileDescriptor descriptor = new OpenFileDescriptor(setData.getProject(), setData.getContainingFile().getVirtualFile(), setData.getTextOffset());
            FileEditorManager.getInstance((Project)data.myProject).openTextEditor(descriptor, true);
        }
        catch (IncorrectOperationException e) {
            throw new MyException(e.getMessage());
        }
    }

    @NotNull
    private static PsiClass createBeanClass(WizardData wizardData) throws MyException {
        PsiClass psiClass;
        PsiDirectory[] directories;
        PsiManager psiManager = PsiManager.getInstance((Project)wizardData.myProject);
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)wizardData.myProject);
        ProjectFileIndex fileIndex = projectRootManager.getFileIndex();
        VirtualFile sourceRoot = fileIndex.getSourceRootForFile(wizardData.myFormFile);
        if (sourceRoot == null) {
            throw new MyException(UIDesignerBundle.message("error.form.file.is.not.in.source.root", new Object[0]));
        }
        PsiDirectory rootDirectory = psiManager.findDirectory(sourceRoot);
        LOG.assertTrue(rootDirectory != null);
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage(wizardData.myPackageName);
        if (aPackage == null) {
            throw new MyException(UIDesignerBundle.message("error.package.does.not.exist", wizardData.myPackageName));
        }
        PsiDirectory targetDir = null;
        for (PsiDirectory psiDirectory : directories = aPackage.getDirectories()) {
            if (!PsiTreeUtil.isAncestor((PsiElement)rootDirectory, (PsiElement)psiDirectory, (boolean)false)) continue;
            targetDir = psiDirectory;
            break;
        }
        if (targetDir == null) {
            throw new MyException(UIDesignerBundle.message("error.cannot.find.package", wizardData.myPackageName));
        }
        String body = "public class " + wizardData.myShortClassName + "{\npublic " + wizardData.myShortClassName + "(){}\n}";
        try {
            FormProperty2BeanProperty[] bindings;
            PsiFile sourceFile = PsiFileFactory.getInstance((Project)psiManager.getProject()).createFileFromText(wizardData.myShortClassName + ".java", body);
            sourceFile = (PsiFile)targetDir.add((PsiElement)sourceFile);
            PsiClass beanClass = ((PsiJavaFile)sourceFile).getClasses()[0];
            ArrayList<String> properties = new ArrayList<String>();
            HashMap<String, String> property2fqClassName = new HashMap<String, String>();
            for (FormProperty2BeanProperty binding : bindings = wizardData.myBindings) {
                if (binding == null || binding.myBeanProperty == null) continue;
                properties.add(binding.myBeanProperty.myName);
                String propertyClassName = binding.myFormProperty.getComponentPropertyClassName();
                property2fqClassName.put(binding.myBeanProperty.myName, propertyClassName);
            }
            Generator.generateBean(beanClass, ArrayUtil.toStringArray(properties), property2fqClassName);
            psiClass = beanClass;
        }
        catch (IncorrectOperationException e) {
            throw new MyException(e.getMessage());
        }
        if (psiClass == null) {
            Generator.$$$reportNull$$$0(0);
        }
        return psiClass;
    }

    private static void generateBean(PsiClass aClass, String[] properties, HashMap<String, String> property2fqClassName) throws MyException {
        StringBuffer membersBuffer = new StringBuffer();
        StringBuffer methodsBuffer = new StringBuffer();
        CodeStyleManager formatter = CodeStyleManager.getInstance((Project)aClass.getProject());
        JavaCodeStyleManager styler = JavaCodeStyleManager.getInstance((Project)aClass.getProject());
        for (String property : properties) {
            LOG.assertTrue(property != null);
            String type = property2fqClassName.get(property);
            LOG.assertTrue(type != null);
            Generator.generateProperty(styler, property, type, membersBuffer, methodsBuffer);
        }
        try {
            PsiMethod[] methods;
            PsiField[] fields;
            PsiClass fakeClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createClassFromText(membersBuffer.toString() + methodsBuffer.toString(), null);
            for (PsiField field : fields = fakeClass.getFields()) {
                aClass.add((PsiElement)field);
            }
            for (PsiMethod method : methods = fakeClass.getMethods()) {
                aClass.add((PsiElement)method);
            }
            styler.shortenClassReferences((PsiElement)aClass);
            formatter.reformat((PsiElement)aClass);
        }
        catch (IncorrectOperationException e) {
            throw new MyException(e.getMessage());
        }
    }

    private static void generateProperty(JavaCodeStyleManager codeStyleManager, String property, String type, @NonNls StringBuffer membersBuffer, @NonNls StringBuffer methodsBuffer) {
        String field = codeStyleManager.suggestVariableName((VariableKind)VariableKind.FIELD, (String)property, null, null).names[0];
        membersBuffer.append("private ");
        membersBuffer.append(type);
        membersBuffer.append(" ");
        membersBuffer.append(field);
        membersBuffer.append(";\n");
        methodsBuffer.append("public ");
        methodsBuffer.append(type);
        methodsBuffer.append(" ");
        methodsBuffer.append(Generator.suggestGetterName(property, type));
        methodsBuffer.append("(){\n");
        methodsBuffer.append("return ");
        methodsBuffer.append(field);
        methodsBuffer.append(";}\n");
        String parameterName = codeStyleManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, (String)property, null, null).names[0];
        methodsBuffer.append("public void ");
        methodsBuffer.append(PropertyUtil.suggestSetterName((String)property));
        methodsBuffer.append("(final ");
        methodsBuffer.append(type);
        methodsBuffer.append(" ");
        methodsBuffer.append(parameterName);
        methodsBuffer.append("){\n");
        if (parameterName.equals(field)) {
            methodsBuffer.append("this.");
        }
        methodsBuffer.append(field);
        methodsBuffer.append("=");
        methodsBuffer.append(parameterName);
        methodsBuffer.append(";}\n");
    }

    private static String suggestGetterName(String propertyName, String propertyType) {
        return PropertyUtil.suggestGetterName((String)propertyName, (PsiType)("boolean".equals(propertyType) ? PsiType.BOOLEAN : null));
    }

    public static void prepareWizardData(WizardData data, PsiClass boundClass) throws MyException {
        PsiElement[] children;
        PsiMethod[] allGetDataMethods = boundClass.findMethodsByName("getData", false);
        PsiMethod[] allSetDataMethods = boundClass.findMethodsByName("setData", false);
        PsiMethod setDataMethod = null;
        PsiClass beanClass = null;
        block0: for (int i = 0; i < allGetDataMethods.length; ++i) {
            PsiClass _getParameterClass;
            PsiParameter[] _getMethodParameters;
            PsiMethod _getMethod = allGetDataMethods[i];
            if (!PsiType.VOID.equals((Object)_getMethod.getReturnType()) || (_getMethodParameters = _getMethod.getParameterList().getParameters()).length != 1 || (_getParameterClass = Generator.getClassByType(_getMethodParameters[0].getType())) == null) continue;
            for (PsiMethod _setMethod : allSetDataMethods) {
                PsiClass _setParameterClass;
                PsiParameter[] _setMethodParameters;
                if (!PsiType.VOID.equals((Object)_setMethod.getReturnType()) || (_setMethodParameters = _setMethod.getParameterList().getParameters()).length != 1 || (_setParameterClass = Generator.getClassByType(_setMethodParameters[0].getType())) != _getParameterClass) continue;
                setDataMethod = _setMethod;
                beanClass = _getParameterClass;
                break block0;
            }
        }
        if (beanClass == null) {
            return;
        }
        data.myBindToNewBean = false;
        data.myBeanClass = beanClass;
        PsiCodeBlock body = setDataMethod.getBody();
        if (body == null) {
            return;
        }
        for (PsiElement child : children = body.getChildren()) {
            PsiMethod barMethod;
            PsiMethodCallExpression callExpression2;
            PsiElement psiElement;
            PsiExpression[] expressions;
            PsiExpressionList argumentList;
            PsiReferenceParameterList parameterList;
            PsiExpression expression;
            if (!(child instanceof PsiExpressionStatement) || !((expression = ((PsiExpressionStatement)child).getExpression()) instanceof PsiMethodCallExpression)) continue;
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)expression;
            int index = -1;
            PsiElement psiElement2 = Generator.getObjectForWhichMethodWasCalled(callExpression);
            if (!(psiElement2 instanceof PsiField) || ((PsiField)psiElement2).getContainingClass() != boundClass) continue;
            PsiField bindingField = (PsiField)psiElement2;
            FormProperty2BeanProperty[] bindings = data.myBindings;
            for (int j = 0; j < bindings.length; ++j) {
                FormProperty2BeanProperty binding = bindings[j];
                if (!bindingField.getName().equals(binding.myFormProperty.getLwComponent().getBinding())) continue;
                index = j;
                break;
            }
            if (index == -1 || (parameterList = callExpression.getMethodExpression().getParameterList()) == null || (argumentList = callExpression.getArgumentList()) == null || (expressions = argumentList.getExpressions()) == null || expressions.length != 1 || !(expressions[0] instanceof PsiMethodCallExpression) || !((psiElement = Generator.getObjectForWhichMethodWasCalled(callExpression2 = (PsiMethodCallExpression)expressions[0])) instanceof PsiParameter) || (barMethod = (PsiMethod)callExpression2.getMethodExpression().resolve()) == null || !PropertyUtil.isSimplePropertyGetter((PsiMethod)barMethod)) continue;
            String propertyName = PropertyUtil.getPropertyName((PsiMethod)barMethod);
            String typeName = barMethod.getReturnType().getCanonicalText();
            if (!"boolean".equals(typeName) && !"java.lang.String".equals(typeName)) continue;
            data.myBindings[index].myBeanProperty = new BeanProperty(propertyName, typeName);
        }
    }

    private static PsiElement getObjectForWhichMethodWasCalled(PsiMethodCallExpression callExpression) {
        PsiExpression qualifierExpression = callExpression.getMethodExpression().getQualifierExpression();
        if (!(qualifierExpression instanceof PsiReferenceExpression)) {
            return null;
        }
        return ((PsiReferenceExpression)qualifierExpression).resolve();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/wizard/Generator", "createBeanClass"));
    }

    public static final class MyException
    extends Exception {
        public MyException(String message) {
            super(message);
        }
    }
}

