/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.struts.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ActionUtil {
    private ActionUtil() {
    }

    static boolean matchesPath(@NotNull @NonNls String actionPath, @NotNull @NonNls String checkPath) {
        int bangIdx;
        String strippedCheckPath;
        if (actionPath == null) {
            ActionUtil.$$$reportNull$$$0(0);
        }
        if (checkPath == null) {
            ActionUtil.$$$reportNull$$$0(1);
        }
        String string = strippedCheckPath = (bangIdx = checkPath.indexOf(33)) == -1 ? checkPath : checkPath.substring(0, bangIdx);
        if (actionPath.indexOf(42) == -1) {
            return Comparing.equal((String)strippedCheckPath, (String)actionPath);
        }
        try {
            return Pattern.matches(StringUtil.replace((String)actionPath, (String)"*", (String)"[^/]*"), strippedCheckPath);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    static List<PsiMethod> findActionMethods(@NotNull PsiClass actionClass, @Nullable String methodName) {
        PsiMethod[] methods;
        Module module;
        if (actionClass == null) {
            ActionUtil.$$$reportNull$$$0(2);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)actionClass)) == null) {
            return Collections.emptyList();
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
        PsiClassType stringType = PsiType.getJavaLangString((PsiManager)actionClass.getManager(), (GlobalSearchScope)scope);
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)actionClass.getProject()).getElementFactory();
        PsiClassType resultType = psiElementFactory.createTypeByFQClassName("com.opensymphony.xwork2.Result", scope);
        boolean searchForMethod = methodName != null;
        SmartList actionMethods = new SmartList();
        for (PsiMethod psiMethod : methods = searchForMethod ? actionClass.findMethodsByName(methodName, true) : actionClass.getAllMethods()) {
            PsiType type;
            String psiMethodName;
            PsiModifierList modifiers;
            if (psiMethod.isConstructor() || !(modifiers = psiMethod.getModifierList()).hasModifierProperty("public") || modifiers.hasModifierProperty("static") || modifiers.hasModifierProperty("abstract") || psiMethod.getParameterList().getParametersCount() != 0 || Comparing.equal((String)(psiMethodName = psiMethod.getName()), (String)"toString") || PropertyUtil.isSimplePropertyGetter((PsiMethod)psiMethod) && actionClass.findFieldByName(PropertyUtil.getPropertyName((PsiMethod)psiMethod), true) != null || (type = psiMethod.getReturnType()) == null || !(type instanceof PsiClassType) || !type.equals(stringType) && !type.equals(resultType)) continue;
            if (searchForMethod) {
                return Collections.singletonList(psiMethod);
            }
            Condition nameCondition = method -> psiMethodName.equals(method.getName());
            if (ContainerUtil.exists((Iterable)actionMethods, (Condition)nameCondition)) continue;
            actionMethods.add(psiMethod);
        }
        return actionMethods;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/struts2/dom/struts/impl/ActionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "matchesPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findActionMethods";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

