/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.facet.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.struts2.facet.StrutsFacetConfiguration;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrutsFileSet
implements Disposable {
    private final String id;
    private String name;
    private boolean autodetected;
    private boolean removed;
    private final List<VirtualFilePointer> files;
    @NonNls
    private static final String ID_PREFIX = "s2fileset";
    private static final Function<StrutsFileSet, String> FILESET_NAME_FUNCTION = strutsFileSet -> strutsFileSet.getName();
    private static final Function<StrutsFileSet, String> FILESET_ID_FUNCTION = strutsFileSet -> strutsFileSet.getId();

    public StrutsFileSet(@NotNull @NonNls String id, @NotNull @NonNls String name, @NotNull StrutsFacetConfiguration parent) {
        if (id == null) {
            StrutsFileSet.$$$reportNull$$$0(0);
        }
        if (name == null) {
            StrutsFileSet.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            StrutsFileSet.$$$reportNull$$$0(2);
        }
        this.files = new SmartList();
        this.id = id;
        this.name = name;
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public StrutsFileSet(@NotNull StrutsFileSet original) {
        if (original == null) {
            StrutsFileSet.$$$reportNull$$$0(3);
        }
        this.files = new SmartList();
        this.id = original.id;
        this.name = original.name;
        this.files.addAll(original.files);
        this.autodetected = original.autodetected;
        this.removed = original.removed;
    }

    public static String getUniqueId(Set<StrutsFileSet> list) {
        return UniqueNameGenerator.generateUniqueName((String)ID_PREFIX, (Collection)ContainerUtil.map2List(list, FILESET_ID_FUNCTION));
    }

    public static String getUniqueName(String prefix, Set<StrutsFileSet> list) {
        return UniqueNameGenerator.generateUniqueName((String)(prefix + " "), (Collection)ContainerUtil.map2List(list, FILESET_NAME_FUNCTION));
    }

    public boolean isNew() {
        return false;
    }

    @NotNull
    public String getId() {
        String string = this.id;
        if (string == null) {
            StrutsFileSet.$$$reportNull$$$0(4);
        }
        return string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            StrutsFileSet.$$$reportNull$$$0(5);
        }
        this.name = name;
    }

    public boolean isAutodetected() {
        return this.autodetected;
    }

    public void setAutodetected(boolean autodetected) {
        this.autodetected = autodetected;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    @NotNull
    public List<VirtualFilePointer> getFiles() {
        List<VirtualFilePointer> list = this.files;
        if (list == null) {
            StrutsFileSet.$$$reportNull$$$0(6);
        }
        return list;
    }

    public void addFile(VirtualFile file) {
        this.addFile(file.getUrl());
    }

    public void addFile(@NonNls String url) {
        if (!StringUtil.isEmptyOrSpaces((String)url)) {
            VirtualFilePointer filePointer = VirtualFilePointerManager.getInstance().create(url, (Disposable)this, null);
            this.files.add(filePointer);
        }
    }

    public void removeFile(VirtualFilePointer file) {
        this.files.remove(file);
    }

    public boolean hasFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        for (VirtualFilePointer pointer : this.files) {
            VirtualFile virtualFile = pointer.getFile();
            if (virtualFile == null || !file.equals(virtualFile)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object another) {
        if (another instanceof StrutsFileSet) {
            StrutsFileSet obj = (StrutsFileSet)another;
            return Comparing.equal((String)obj.getId(), (String)this.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/struts2/facet/ui/StrutsFileSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/struts2/facet/ui/StrutsFileSet";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

