/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.references;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodQuickFix;
import com.intellij.codeInsight.daemon.quickFix.CreateFieldOrPropertyFix;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.ws.WSBundle;
import com.intellij.ws.inspections.fixes.RemoveElementFix;
import com.intellij.ws.references.WSReference;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropOrderReference
extends WSReference<PsiLiteralExpression> {
    private PsiLiteralExpression myLiteralExpression;

    public PropOrderReference(PsiLiteralExpression psiElement) {
        super((PsiElement)psiElement, true);
        this.myLiteralExpression = psiElement;
    }

    public PsiLiteralExpression getElement() {
        return this.myLiteralExpression;
    }

    @Nullable
    public PsiElement resolve() {
        PsiClass clazz = this.findClass();
        if (clazz != null) {
            String name = this.getCanonicalText();
            if (PropOrderReference.hasFieldAccessorType(clazz)) {
                return clazz.findFieldByName(name, false);
            }
            return PropertyUtil.findPropertyGetter((PsiClass)clazz, (String)name, (boolean)false, (boolean)true);
        }
        return null;
    }

    private static boolean hasFieldAccessorType(PsiClass clazz) {
        String value;
        PsiNameValuePair[] attributes;
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)clazz, (String[])new String[]{"javax.xml.bind.annotation.XmlAccessorType"});
        if (annotation != null && (attributes = annotation.getParameterList().getAttributes()).length == 1 && (value = attributes[0].getText()) != null) {
            return value.contains("FIELD");
        }
        return false;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        Object value = this.myLiteralExpression.getValue();
        String string = PropOrderReference.hasFieldAccessorType(this.findClass()) ? WSBundle.message("field.doesnt.exist", value) : WSBundle.message("property.doesnt.exist", value);
        if (string == null) {
            PropOrderReference.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    private PsiClass findClass() {
        PsiElement clazz;
        PsiElement element;
        PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PsiAnnotation.class);
        if (annotation != null && (element = annotation.getParent()) instanceof PsiModifierList && (clazz = element.getParent()) instanceof PsiClass) {
            return (PsiClass)clazz;
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        PsiClass clazz = this.findClass();
        if (clazz == null) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                PropOrderReference.$$$reportNull$$$0(1);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        ArrayList<LookupElementBuilder> lookups = new ArrayList<LookupElementBuilder>();
        List<String> existent = this.getExistingProperties();
        if (PropOrderReference.hasFieldAccessorType(clazz)) {
            for (PsiField field : clazz.getFields()) {
                String name = field.getName();
                if (existent.contains(name)) continue;
                lookups.add(LookupElementBuilder.create((String)name).withIcon(PlatformIcons.FIELD_ICON).bold());
            }
        } else {
            ArrayList properties = new ArrayList(PropertyUtil.getAllProperties((PsiClass)clazz, (boolean)false, (boolean)true).keySet());
            properties.removeAll(existent);
            for (String property : properties) {
                lookups.add(LookupElementBuilder.create((String)property).withIcon(PlatformIcons.METHOD_ICON).bold());
            }
        }
        Object[] objectArray = lookups.toArray(new LookupElementBuilder[lookups.size()]);
        if (objectArray == null) {
            PropOrderReference.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    @NotNull
    private List<String> getExistingProperties() {
        ArrayList<String> list = new ArrayList<String>();
        PsiElement parent = this.myLiteralExpression.getParent();
        if (parent instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers;
            for (PsiAnnotationMemberValue initializer : initializers = ((PsiArrayInitializerMemberValue)parent).getInitializers()) {
                Object value;
                PsiElement element = initializer.getOriginalElement();
                if (!(element instanceof PsiLiteralExpression) || !((value = ((PsiLiteralExpression)element).getValue()) instanceof String)) continue;
                list.add(value.toString());
            }
        }
        ArrayList<String> arrayList = list;
        if (arrayList == null) {
            PropOrderReference.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        Project project = this.myLiteralExpression.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        String name = PropertyUtil.getPropertyName((String)newElementName);
        name = name == null ? newElementName : name;
        PsiExpression newElement = factory.createExpressionFromText("\"" + name + "\"", null);
        this.myLiteralExpression = (PsiLiteralExpression)this.myLiteralExpression.replace((PsiElement)newElement);
        return this.myLiteralExpression;
    }

    public boolean isReferenceTo(PsiElement element) {
        Object value;
        PsiClass psiClass = this.findClass();
        if (element instanceof BeanPropertyElement) {
            element = ((BeanPropertyElement)element).getMethod();
        }
        if (element instanceof PsiMember && ((PsiMember)element).getContainingClass() == psiClass && psiClass != null && (value = this.myLiteralExpression.getValue()) instanceof String) {
            if (PropOrderReference.hasFieldAccessorType(psiClass)) {
                return element instanceof PsiField && psiClass.findFieldByName((String)value, false) != null;
            }
            return element instanceof PsiMethod && value.equals(PropertyUtil.getPropertyName((PsiMethod)((PsiMethod)element)));
        }
        return false;
    }

    public LocalQuickFix[] getQuickFixes() {
        PsiElement parent;
        Object fix;
        PsiClass psiClass;
        ArrayList<Object> fixes = new ArrayList<Object>();
        Object value = this.myLiteralExpression.getValue();
        if (value instanceof String && (psiClass = this.findClass()) != null && (fix = PropOrderReference.hasFieldAccessorType(psiClass) ? new CreateFieldOrPropertyFix(psiClass, (String)value, (PsiType)PsiType.getJavaLangString((PsiManager)psiClass.getManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)psiClass.getProject())), PropertyMemberType.FIELD, PsiAnnotation.EMPTY_ARRAY) : CreateMethodQuickFix.createFix((PsiClass)psiClass, (String)("public java.lang.String get" + StringUtil.capitalize((String)((String)value)) + "()"), (String)"return null;")) != null) {
            fixes.add(fix);
        }
        fixes.add(new RemoveElementFix((PsiElement)((parent = this.myLiteralExpression.getParent()) instanceof PsiNameValuePair ? parent : this.myLiteralExpression), WSBundle.message("remove", new Object[0])));
        return fixes.toArray(new LocalQuickFix[fixes.size()]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ws/references/PropOrderReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingProperties";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

