/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.JavaDuplicatesPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.VariableData;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.ExtractedParameter;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.refactoring.util.duplicates.VariableReturnValue;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

class JavaDuplicatesExtractMethodProcessor
extends ExtractMethodProcessor {
    private static final Logger LOG = Logger.getInstance(JavaDuplicatesExtractMethodProcessor.class);

    public JavaDuplicatesExtractMethodProcessor(PsiElement[] elements) {
        super(elements[0].getProject(), null, elements, null, JavaDuplicatesPresentation.REFACTORING_NAME, "", "refactoring.extractMethod");
    }

    public void applyFrom(JavaDuplicatesExtractMethodProcessor processor, Map<PsiVariable, PsiVariable> copyToThisVariables) {
        this.myMethodName = processor.myMethodName;
        this.myStatic = processor.myStatic;
        this.myIsChainedConstructor = processor.myIsChainedConstructor;
        this.myMethodVisibility = processor.myMethodVisibility;
        this.myReturnType = processor.myReturnType;
        this.myVariableDatum = new VariableData[processor.myVariableDatum.length];
        for (int i = 0; i < this.myVariableDatum.length; ++i) {
            VariableData copyData = processor.myVariableDatum[i];
            PsiVariable thisVariable = copyToThisVariables.get(copyData.variable);
            if (thisVariable == null) {
                this.myVariableDatum[i] = copyData;
                continue;
            }
            this.myVariableDatum[i] = new VariableData(thisVariable, copyData.type);
            this.myVariableDatum[i].name = copyData.name;
            this.myVariableDatum[i].originalName = copyData.originalName;
            this.myVariableDatum[i].passAsParameter = copyData.passAsParameter;
        }
    }

    public void applyDefaults(@NotNull String methodName, @PsiModifier.ModifierConstant @NotNull String visibility) {
        PsiType returnType;
        if (methodName == null) {
            JavaDuplicatesExtractMethodProcessor.$$$reportNull$$$0(0);
        }
        if (visibility == null) {
            JavaDuplicatesExtractMethodProcessor.$$$reportNull$$$0(1);
        }
        this.myMethodName = methodName;
        this.myVariableDatum = this.getInputVariables().getInputVariables().toArray(new VariableData[0]);
        this.myMethodVisibility = visibility;
        this.myArtificialOutputVariable = PsiType.VOID.equals((Object)this.myReturnType) ? this.getArtificialOutputVariable() : null;
        PsiType psiType = returnType = this.myArtificialOutputVariable != null ? this.myArtificialOutputVariable.getType() : this.myReturnType;
        if (returnType != null) {
            this.myReturnType = returnType;
        }
    }

    public void doExtract() {
        super.chooseAnchor();
        super.doExtract();
    }

    void updateStaticModifier(List<Match> matches) {
        if (!this.isStatic() && this.isCanBeStatic()) {
            for (Match match : matches) {
                if (this.isInSameFile(match) && this.isInSameClass(match)) continue;
                PsiUtil.setModifierProperty((PsiModifierListOwner)this.myExtractedMethod, (String)"static", (boolean)true);
                this.myStatic = true;
                break;
            }
        }
    }

    public void putExtractedParameters(Map<PsiLocalVariable, ExtractedParameter> extractedParameters) {
        for (Map.Entry<PsiLocalVariable, ExtractedParameter> entry : extractedParameters.entrySet()) {
            this.myInputVariables.foldExtractedParameter((PsiVariable)entry.getKey(), (PsiExpression)entry.getValue().myPatternUsages.get(0));
        }
    }

    public boolean prepare(boolean showErrorHint) {
        this.setShowErrorDialogs(false);
        try {
            if (super.prepare()) {
                return true;
            }
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{JavaDuplicatesPresentation.REFACTORING_NAME}));
            LOG.info(message);
            if (showErrorHint) {
                CommonRefactoringUtil.showErrorHint((Project)this.myProject, null, (String)message, (String)JavaDuplicatesPresentation.REFACTORING_NAME, (String)"refactoring.extractMethod");
            }
            return false;
        }
        catch (PrepareFailedException e) {
            LOG.info((Throwable)e);
            if (showErrorHint) {
                CommonRefactoringUtil.showErrorHint((Project)this.myProject, null, (String)e.getMessage(), (String)JavaDuplicatesPresentation.REFACTORING_NAME, (String)"refactoring.extractMethod");
            }
            return false;
        }
    }

    public PsiElement processMatch(Match match) throws IncorrectOperationException {
        PsiMethodCallExpression callExpression;
        boolean inSameFile = this.isInSameFile(match);
        if (!inSameFile) {
            this.relaxMethodVisibility(match);
        }
        boolean inSameClass = this.isInSameClass(match);
        PsiElement element = super.processMatch(match);
        if (!(inSameFile && inSameClass || (callExpression = this.getMatchMethodCallExpression(element)) == null)) {
            return this.updateCallQualifier(callExpression);
        }
        return element;
    }

    @NotNull
    private PsiElement updateCallQualifier(PsiMethodCallExpression callExpression) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        PsiClass psiClass = this.myExtractedMethod.getContainingClass();
        LOG.assertTrue(psiClass != null, (Object)"myExtractedMethod.getContainingClass");
        PsiReferenceExpression newQualifier = factory.createReferenceExpression(psiClass);
        callExpression.getMethodExpression().setQualifierExpression((PsiExpression)newQualifier);
        PsiElement psiElement = JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)callExpression);
        if (psiElement == null) {
            JavaDuplicatesExtractMethodProcessor.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public DuplicatesFinder createDuplicatesFinder() {
        VariableReturnValue returnValue = this.myOutputVariables.length == 1 ? new VariableReturnValue(this.myOutputVariables[0]) : null;
        DuplicatesFinder duplicatesFinder = new DuplicatesFinder(this.myElements, this.myInputVariables, (ReturnValue)returnValue, Collections.emptyList(), true);
        if (duplicatesFinder == null) {
            JavaDuplicatesExtractMethodProcessor.$$$reportNull$$$0(3);
        }
        return duplicatesFinder;
    }

    private void relaxMethodVisibility(Match match) {
        if (this.isInSamePackage(match)) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)this.myExtractedMethod, (String)"private", (boolean)false);
        } else {
            PsiUtil.setModifierProperty((PsiModifierListOwner)this.myExtractedMethod, (String)"public", (boolean)true);
        }
    }

    private boolean isInSameFile(Match match) {
        return this.myExtractedMethod.getContainingFile() == match.getMatchStart().getContainingFile();
    }

    private boolean isInSamePackage(Match match) {
        PsiFile psiFile = this.myExtractedMethod.getContainingFile();
        PsiFile matchFile = match.getMatchStart().getContainingFile();
        return psiFile instanceof PsiJavaFile && matchFile instanceof PsiJavaFile && Objects.equals(((PsiJavaFile)psiFile).getPackageName(), ((PsiJavaFile)matchFile).getPackageName());
    }

    private boolean isInSameClass(Match match) {
        PsiClass matchClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)match.getMatchStart(), PsiClass.class);
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.myExtractedMethod, PsiClass.class);
        return psiClass != null && matchClass != null && PsiTreeUtil.isAncestor((PsiElement)psiClass, (PsiElement)matchClass, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/JavaDuplicatesExtractMethodProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/JavaDuplicatesExtractMethodProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "updateCallQualifier";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDuplicatesFinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyDefaults";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

