/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.JavaDuplicatesExtractMethodProcessor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.introduceParameter.IntroduceParameterHandler;
import com.intellij.refactoring.util.VariableData;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.ExtractedParameter;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class JavaDuplicatesMatcher {
    private static final Logger LOG = Logger.getInstance(JavaDuplicatesMatcher.class);
    private final PsiElement[] myPattern;
    private final List<PsiElement[]> myCandidates;
    private List<Match> myMatches;

    public JavaDuplicatesMatcher(PsiElement[] pattern, List<PsiElement[]> candidates) {
        this.myPattern = pattern;
        this.myCandidates = candidates;
    }

    boolean compare() {
        if (this.myPattern.length == 0 || !(this.myPattern[0] instanceof PsiStatement)) {
            return false;
        }
        JavaDuplicatesExtractMethodProcessor processor = new JavaDuplicatesExtractMethodProcessor(this.myPattern);
        if (!processor.prepare(false)) {
            return false;
        }
        Set codeFragments = ((StreamEx)StreamEx.of(this.myCandidates).filter(elements -> ((PsiElement[])elements).length != 0)).map(elements -> ControlFlowUtil.findCodeFragment((PsiElement)elements[0])).toSet();
        DuplicatesFinder duplicatesFinder = processor.createDuplicatesFinder();
        this.myMatches = new ArrayList<Match>();
        for (PsiElement codeFragment : codeFragments) {
            List matches = duplicatesFinder.findDuplicates(codeFragment);
            this.myMatches.addAll(matches);
        }
        PsiFile patternFile = this.myPattern[0].getContainingFile();
        Module patternModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)patternFile);
        this.myMatches.removeIf(match -> {
            PsiFile matchFile = match.getMatchStart().getContainingFile();
            if (matchFile == patternFile) {
                return false;
            }
            if (patternModule != ModuleUtilCore.findModuleForPsiElement((PsiElement)matchFile)) {
                return true;
            }
            return !processor.isCanBeStatic();
        });
        this.myMatches = ExtractedParameter.getCompatibleMatches(this.myMatches, (PsiElement[])this.myPattern);
        return !this.myMatches.isEmpty();
    }

    void extract() {
        Project project = this.myPattern[0].getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiElement[] elementsInCopy = IntroduceParameterHandler.getElementsInCopy((Project)project, (PsiFile)this.myPattern[0].getContainingFile(), (PsiElement[])this.myPattern);
        PsiCodeBlock blockInCopy = JavaDuplicatesMatcher.wrapWithCodeBlock(elementsInCopy, factory);
        LOG.assertTrue((elementsInCopy = blockInCopy.getChildren()).length > 2, (Object)"block length is too small");
        elementsInCopy = Arrays.copyOfRange(elementsInCopy, 1, elementsInCopy.length - 1);
        Map<PsiVariable, PsiVariable> copyToPatternVariablesMapping = this.collectVariablesMapping(this.myPattern, elementsInCopy);
        JavaDuplicatesExtractMethodProcessor patternProcessor = new JavaDuplicatesExtractMethodProcessor(this.myPattern);
        if (!patternProcessor.prepare(true)) {
            return;
        }
        Map<PsiLocalVariable, ExtractedParameter> parameterDeclarations = this.createParameterDeclarations(elementsInCopy, blockInCopy, patternProcessor.getInputVariables(), patternProcessor.getOutputVariables(), project);
        JavaDuplicatesExtractMethodProcessor copyProcessor = new JavaDuplicatesExtractMethodProcessor(elementsInCopy);
        if (!copyProcessor.prepare(true)) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            copyProcessor.applyDefaults("newMethod", "private");
        } else if (!copyProcessor.showDialog()) {
            return;
        }
        patternProcessor.applyFrom(copyProcessor, copyToPatternVariablesMapping);
        patternProcessor.putExtractedParameters(parameterDeclarations);
        WriteAction.run(() -> {
            for (Map.Entry entry : parameterDeclarations.entrySet()) {
                PsiLocalVariable localVariable = (PsiLocalVariable)entry.getKey();
                List usages = ((ExtractedParameter)entry.getValue()).myPatternUsages;
                for (PsiReferenceExpression usage : usages) {
                    String name = localVariable.getName();
                    LOG.assertTrue(name != null, (Object)"replace local variable name");
                    usage.replace((PsiElement)factory.createExpressionFromText(name, (PsiElement)usage));
                }
            }
            patternProcessor.doExtract();
            patternProcessor.updateStaticModifier(this.myMatches);
            THashMap patternToParameter = new THashMap();
            for (Map.Entry entry : parameterDeclarations.entrySet()) {
                patternToParameter.put(((ExtractedParameter)entry.getValue()).myPatternVariable, entry.getKey());
            }
            for (Match match : this.myMatches) {
                List matchedParameters = match.getExtractedParameters();
                if (matchedParameters != null) {
                    for (ExtractedParameter matchedParameter : matchedParameters) {
                        PsiLocalVariable localVariable = (PsiLocalVariable)patternToParameter.get(matchedParameter.myPatternVariable);
                        LOG.assertTrue(localVariable != null, (Object)"match local variable");
                        boolean ok = match.putParameter((Pair)Pair.createNonNull((Object)localVariable, (Object)matchedParameter.myType), (PsiElement)matchedParameter.myCandidateUsage);
                        LOG.assertTrue(ok, (Object)"put matched parameter");
                    }
                }
                patternProcessor.processMatch(match);
            }
        });
    }

    private Map<PsiVariable, PsiVariable> collectVariablesMapping(@NotNull PsiElement[] pattern, @NotNull PsiElement[] copy) {
        if (pattern == null) {
            JavaDuplicatesMatcher.$$$reportNull$$$0(0);
        }
        if (copy == null) {
            JavaDuplicatesMatcher.$$$reportNull$$$0(1);
        }
        THashMap mapping = new THashMap();
        this.collectVariablesMapping(pattern, copy, (Map<PsiVariable, PsiVariable>)mapping);
        return mapping;
    }

    private void collectVariablesMapping(@NotNull PsiElement[] pattern, @NotNull PsiElement[] copy, @NotNull Map<PsiVariable, PsiVariable> mapping) {
        if (pattern == null) {
            JavaDuplicatesMatcher.$$$reportNull$$$0(2);
        }
        if (copy == null) {
            JavaDuplicatesMatcher.$$$reportNull$$$0(3);
        }
        if (mapping == null) {
            JavaDuplicatesMatcher.$$$reportNull$$$0(4);
        }
        pattern = JavaDuplicatesMatcher.skipWhitespacesAndComments(pattern);
        LOG.assertTrue((copy = JavaDuplicatesMatcher.skipWhitespacesAndComments(copy)).length == pattern.length, (Object)"copy length");
        for (int i = 0; i < pattern.length; ++i) {
            this.collectVariablesMapping(pattern[i], copy[i], mapping);
        }
    }

    private void collectVariablesMapping(PsiElement pattern, PsiElement copy, @NotNull Map<PsiVariable, PsiVariable> mapping) {
        PsiElement resolvedCopy;
        PsiElement resolvedPattern;
        if (mapping == null) {
            JavaDuplicatesMatcher.$$$reportNull$$$0(5);
        }
        if (pattern == copy) {
            return;
        }
        LOG.assertTrue(pattern != null && copy != null, (Object)"null in collectVariablesMapping");
        if (pattern instanceof PsiVariable && copy instanceof PsiVariable) {
            mapping.put((PsiVariable)copy, (PsiVariable)pattern);
        } else if (pattern instanceof PsiReferenceExpression && copy instanceof PsiReferenceExpression && (resolvedPattern = ((PsiReferenceExpression)pattern).resolve()) != (resolvedCopy = ((PsiReferenceExpression)copy).resolve()) && resolvedPattern instanceof PsiVariable && resolvedCopy instanceof PsiVariable) {
            mapping.put((PsiVariable)resolvedCopy, (PsiVariable)resolvedPattern);
        }
        this.collectVariablesMapping(pattern.getChildren(), copy.getChildren(), mapping);
    }

    @NotNull
    private Map<PsiLocalVariable, ExtractedParameter> createParameterDeclarations(PsiElement[] elementsInCopy, PsiCodeBlock blockInCopy, InputVariables inputVariables, PsiVariable[] outputVariables, Project project) {
        List parameters = this.myMatches.get(0).getExtractedParameters();
        THashMap parameterDeclarations = new THashMap();
        if (parameters != null && !parameters.isEmpty()) {
            UniqueNameGenerator generator = JavaDuplicatesMatcher.getParameterNameGenerator(elementsInCopy[0], inputVariables, outputVariables);
            THashMap parameterNames = new THashMap();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            for (ExtractedParameter parameter : parameters) {
                PsiReferenceExpression patternUsage = (PsiReferenceExpression)parameter.myPatternUsages.get(0);
                LOG.assertTrue(patternUsage != null, (Object)"patternUsageReferenceElement");
                String usageText = patternUsage.getQualifiedName();
                PsiExpression exprInCopy = factory.createExpressionFromText(usageText, (PsiElement)blockInCopy);
                SuggestedNameInfo info = JavaCodeStyleManager.getInstance((Project)project).suggestVariableName(VariableKind.PARAMETER, null, exprInCopy, null);
                String parameterName = generator.generateUniqueName(info.names.length > 0 ? info.names[0] : "p");
                String declarationText = parameter.myType.getCanonicalText() + " " + parameterName + " = " + usageText + ";";
                PsiDeclarationStatement paramDeclaration = (PsiDeclarationStatement)factory.createStatementFromText(declarationText, (PsiElement)blockInCopy);
                paramDeclaration = (PsiDeclarationStatement)blockInCopy.addBefore((PsiElement)paramDeclaration, elementsInCopy[0]);
                PsiLocalVariable localVariable = (PsiLocalVariable)paramDeclaration.getDeclaredElements()[0];
                parameterDeclarations.put(localVariable, parameter);
                parameterNames.put(parameter.myPatternVariable, parameterName);
            }
            this.replaceUsages(elementsInCopy, (Map<PsiVariable, String>)parameterNames, factory);
        }
        THashMap tHashMap = parameterDeclarations;
        if (tHashMap == null) {
            JavaDuplicatesMatcher.$$$reportNull$$$0(6);
        }
        return tHashMap;
    }

    @NotNull
    private static PsiCodeBlock wrapWithCodeBlock(PsiElement[] elements, PsiElementFactory factory) {
        PsiElement parent = elements[0].getParent();
        PsiBlockStatement statement = (PsiBlockStatement)factory.createStatementFromText("{}", parent);
        statement.getCodeBlock().addRange(elements[0], elements[elements.length - 1]);
        statement = (PsiBlockStatement)parent.addBefore((PsiElement)statement, elements[0]);
        parent.deleteChildRange(elements[0], elements[elements.length - 1]);
        PsiCodeBlock psiCodeBlock = statement.getCodeBlock();
        if (psiCodeBlock == null) {
            JavaDuplicatesMatcher.$$$reportNull$$$0(7);
        }
        return psiCodeBlock;
    }

    private void replaceUsages(PsiElement[] elements, Map<PsiVariable, String> parameterNames, PsiElementFactory factory) {
        THashMap usagesToReplace = new THashMap();
        JavaDuplicatesMatcher.collectUsages(elements, this.myPattern, parameterNames, (Map<PsiExpression, String>)usagesToReplace);
        for (Map.Entry entry : usagesToReplace.entrySet()) {
            PsiExpression expression = (PsiExpression)entry.getKey();
            String name = (String)entry.getValue();
            PsiExpression replacement = factory.createExpressionFromText(name, (PsiElement)expression);
            expression.replace((PsiElement)replacement);
        }
    }

    private static void collectUsages(PsiElement[] elements, PsiElement[] pattern, Map<PsiVariable, String> parameterNames, Map<PsiExpression, String> usagesToReplace) {
        LOG.assertTrue((elements = JavaDuplicatesMatcher.skipWhitespacesAndComments(elements)).length == (pattern = JavaDuplicatesMatcher.skipWhitespacesAndComments(pattern)).length, (Object)"length in collectUsages");
        for (int i = 0; i < elements.length; ++i) {
            JavaDuplicatesMatcher.collectUsages(elements[i], pattern[i], parameterNames, usagesToReplace);
        }
    }

    private static void collectUsages(PsiElement element, PsiElement pattern, Map<PsiVariable, String> parameterNames, Map<PsiExpression, String> usagesToReplace) {
        String name;
        PsiElement resolvedPattern;
        PsiReference patternReference;
        if (element instanceof PsiReferenceExpression && pattern instanceof PsiReferenceExpression && (patternReference = pattern.getReference()) != null && (resolvedPattern = patternReference.resolve()) instanceof PsiVariable && (name = parameterNames.get((PsiVariable)resolvedPattern)) != null) {
            usagesToReplace.put((PsiExpression)element, name);
            return;
        }
        JavaDuplicatesMatcher.collectUsages(element.getChildren(), pattern.getChildren(), parameterNames, usagesToReplace);
    }

    private static UniqueNameGenerator getParameterNameGenerator(PsiElement patternElement, InputVariables inputVariables, PsiVariable[] outputVariables) {
        UniqueNameGenerator uniqueNameGenerator = new UniqueNameGenerator();
        for (VariableData data : inputVariables.getInputVariables()) {
            String name;
            if (data.variable == null || (name = data.variable.getName()) == null) continue;
            uniqueNameGenerator.addExistingName(name);
        }
        for (PsiVariable variable : outputVariables) {
            String name = variable.getName();
            if (name == null) continue;
            uniqueNameGenerator.addExistingName(name);
        }
        PsiElement superParent = PsiTreeUtil.getParentOfType((PsiElement)patternElement, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class});
        if (superParent != null) {
            ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)superParent)).filter(element -> element instanceof PsiVariable)).forEach(element -> {
                String name = ((PsiVariable)element).getName();
                if (name != null) {
                    uniqueNameGenerator.addExistingName(name);
                }
            });
        }
        return uniqueNameGenerator;
    }

    @NotNull
    private static PsiElement[] skipWhitespacesAndComments(@NotNull PsiElement[] pattern) {
        if (pattern == null) {
            JavaDuplicatesMatcher.$$$reportNull$$$0(8);
        }
        if (pattern.length == 0) {
            if (pattern == null) {
                JavaDuplicatesMatcher.$$$reportNull$$$0(9);
            }
            return pattern;
        }
        PsiElement[] psiElementArray = ContainerUtil.filter((Object[])pattern, e -> !(e instanceof PsiWhiteSpace) && !(e instanceof PsiComment)).toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            JavaDuplicatesMatcher.$$$reportNull$$$0(10);
        }
        return psiElementArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/JavaDuplicatesMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/JavaDuplicatesMatcher";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterDeclarations";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithCodeBlock";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "skipWhitespacesAndComments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectVariablesMapping";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespacesAndComments";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

