/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.predicates;

import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatchResultImpl;
import com.intellij.structuralsearch.impl.matcher.MatchUtils;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.plugin.util.SmartPsiPointer;

public final class ReferencePredicate
extends MatchPredicate {
    private final String myName;

    public ReferencePredicate(String name) {
        this.myName = name;
    }

    @Override
    public boolean match(PsiElement match, int start, int end, MatchContext context) {
        PsiElement target = MatchUtils.getReferencedElement(match = StructuralSearchUtil.getParentIfIdentifier(match));
        if (target != null) {
            StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(target);
            assert (profile != null);
            String image = profile.getText(target, 0, -1);
            context.getResult().addSon(new MatchResultImpl(this.myName, image, new SmartPsiPointer(target), true));
        }
        return true;
    }
}

