/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace.impl;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptSupport;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementInfoImpl;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReplacementBuilder {
    private final String replacement;
    private final List<ParameterInfo> parameterizations = new ArrayList<ParameterInfo>();
    private final Map<String, ScriptSupport> replacementVarsMap;
    private final ReplaceOptions options;
    private final Project myProject;

    ReplacementBuilder(Project project, ReplaceOptions options) {
        StructuralSearchProfile profile;
        this.myProject = project;
        this.replacementVarsMap = new HashMap<String, ScriptSupport>();
        this.options = options;
        String _replacement = options.getReplacement();
        FileType fileType = options.getMatchOptions().getFileType();
        Template template = TemplateManager.getInstance((Project)project).createTemplate("", "", _replacement);
        int segmentsCount = template.getSegmentsCount();
        this.replacement = template.getTemplateText();
        for (int i = 0; i < segmentsCount; ++i) {
            int pos;
            int offset = template.getSegmentOffset(i);
            String name = template.getSegmentName(i);
            ParameterInfo info = new ParameterInfo();
            info.setStartIndex(offset);
            info.setName(name);
            info.setReplacementVariable(options.getVariableDefinition(name) != null);
            for (pos = offset - 1; pos >= 0 && pos < this.replacement.length() && Character.isWhitespace(this.replacement.charAt(pos)); --pos) {
            }
            if (pos >= 0) {
                if (this.replacement.charAt(pos) == ',') {
                    info.setHasCommaBefore(true);
                }
                info.setBeforeDelimiterPos(pos);
            }
            for (pos = offset; pos < this.replacement.length() && Character.isWhitespace(this.replacement.charAt(pos)); ++pos) {
            }
            if (pos < this.replacement.length()) {
                char ch = this.replacement.charAt(pos);
                if (ch == ';') {
                    info.setStatementContext(true);
                } else if (ch == ',' || ch == ')') {
                    info.setArgumentContext(true);
                    info.setHasCommaAfter(ch == ',');
                }
            }
            info.setAfterDelimiterPos(pos);
            this.parameterizations.add(info);
        }
        StructuralSearchProfile structuralSearchProfile = profile = this.parameterizations != null ? StructuralSearchUtil.getProfileByFileType(fileType) : null;
        if (profile != null) {
            try {
                PsiElement[] elements = MatcherImplUtil.createTreeFromText(_replacement, PatternTreeContext.Block, fileType, options.getMatchOptions().getDialect(), options.getMatchOptions().getPatternContext(), project, false);
                if (elements.length > 0) {
                    PsiElement patternNode = elements[0].getParent();
                    patternNode.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                        public void visitElement(PsiElement element) {
                            ParameterInfo parameterInfo;
                            super.visitElement(element);
                            String text = element.getText();
                            if (StructuralSearchUtil.isTypedVariable(text) && (parameterInfo = ReplacementBuilder.this.findParameterization(Replacer.stripTypedVariableDecoration(text))) != null && parameterInfo.getElement() == null) {
                                parameterInfo.setElement(element);
                            }
                        }
                    });
                    profile.provideAdditionalReplaceOptions(patternNode, options, this);
                }
            }
            catch (IncorrectOperationException e) {
                throw new MalformedPatternException(e.getMessage());
            }
        }
    }

    private static void fill(MatchResult r, Map<String, MatchResult> m) {
        List<MatchResult> allSons;
        if (r.getName() != null) {
            m.putIfAbsent(r.getName(), r);
        }
        if (!r.isScopeMatch() || !r.isMultipleMatch()) {
            for (MatchResult matchResult : r.getAllSons()) {
                ReplacementBuilder.fill(matchResult, m);
            }
        } else if (r.hasSons() && (allSons = r.getAllSons()).size() > 0) {
            ReplacementBuilder.fill(allSons.get(0), m);
        }
    }

    String process(MatchResult match, ReplacementInfoImpl replacementInfo, FileType type) {
        if (this.parameterizations == null) {
            return this.replacement;
        }
        StringBuilder result = new StringBuilder(this.replacement);
        HashMap<String, MatchResult> matchMap = new HashMap<String, MatchResult>();
        ReplacementBuilder.fill(match, matchMap);
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(type);
        assert (profile != null);
        int offset = 0;
        for (ParameterInfo info : this.parameterizations) {
            MatchResult r = matchMap.get(info.getName());
            if (info.isReplacementVariable()) {
                offset = Replacer.insertSubstitution(result, offset, info, this.generateReplacement(info, match));
                continue;
            }
            if (r != null) {
                offset = profile.handleSubstitution(info, r, result, offset, matchMap);
                continue;
            }
            offset = profile.handleNoSubstitution(info, offset, result);
        }
        replacementInfo.variableMap = matchMap;
        return result.toString();
    }

    private String generateReplacement(ParameterInfo info, MatchResult match) {
        ScriptSupport scriptSupport = this.replacementVarsMap.get(info.getName());
        if (scriptSupport == null) {
            String constraint = this.options.getVariableDefinition(info.getName()).getScriptCodeConstraint();
            scriptSupport = new ScriptSupport(this.myProject, StringUtil.stripQuotesAroundValue((String)constraint), info.getName());
            this.replacementVarsMap.put(info.getName(), scriptSupport);
        }
        return scriptSupport.evaluate(match, null);
    }

    @Nullable
    public ParameterInfo findParameterization(String name) {
        for (ParameterInfo info : this.parameterizations) {
            if (!info.getName().equals(name)) continue;
            return info;
        }
        return null;
    }

    public void addParametrization(@NotNull ParameterInfo e) {
        if (e == null) {
            ReplacementBuilder.$$$reportNull$$$0(0);
        }
        this.parameterizations.add(e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/replace/impl/ReplacementBuilder", "addParametrization"));
    }
}

