/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ConfigurationUtil;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.TestClassCollector;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.junit.TestClassFilter;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.SearchForTestsTask;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import gnu.trove.THashSet;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class TestPackage
extends TestObject {
    public TestPackage(JUnitConfiguration configuration, ExecutionEnvironment environment) {
        super(configuration, environment);
    }

    @Override
    @Nullable
    public SourceScope getSourceScope() {
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        return data.getScope().getSourceScope((ModuleBasedConfiguration)this.getConfiguration());
    }

    public SearchForTestsTask createSearchingForTestsTask() {
        final JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        return new SearchForTestsTask(this.getConfiguration().getProject(), this.myServerSocket){
            private final THashSet<PsiClass> myClasses;
            {
                super(arg0, arg1);
                this.myClasses = new THashSet();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void search() {
                this.myClasses.clear();
                SourceScope sourceScope = TestPackage.this.getSourceScope();
                Module module = ((JavaRunConfigurationModule)TestPackage.this.getConfiguration().getConfigurationModule()).getModule();
                if (sourceScope != null && !"-junit5".equals(TestPackage.this.getRunner())) {
                    DumbService instance = DumbService.getInstance((Project)this.myProject);
                    try {
                        instance.setAlternativeResolveEnabled(true);
                        TestClassFilter classFilter = TestPackage.this.getClassFilter(data);
                        TestObject.LOG.assertTrue(classFilter.getBase() != null);
                        long start = System.currentTimeMillis();
                        if (Registry.is((String)"junit4.search.4.tests.in.classpath", (boolean)false)) {
                            String packageName = TestPackage.this.getPackageName(data);
                            String[] classNames = TestClassCollector.collectClassFQNames((String)packageName, (Path)TestPackage.this.getRootPath(), (JavaTestConfigurationBase)TestPackage.this.getConfiguration(), x$0 -> TestPackage.createPredicate(x$0));
                            PsiManager manager = PsiManager.getInstance((Project)this.myProject);
                            Arrays.stream(classNames).filter(className -> TestPackage.this.acceptClassName((String)className)).map(name -> (PsiClass)ReadAction.compute(() -> ClassUtil.findPsiClass((PsiManager)manager, (String)name, null, (boolean)true, (GlobalSearchScope)classFilter.getScope()))).filter(aClass -> aClass != null).forEach(arg_0 -> this.myClasses.add(arg_0));
                            TestObject.LOG.info("Found tests in " + (System.currentTimeMillis() - start));
                        } else {
                            ConfigurationUtil.findAllTestClasses(classFilter, module, this.myClasses);
                        }
                    }
                    catch (CantRunException cantRunException) {
                    }
                    finally {
                        instance.setAlternativeResolveEnabled(false);
                    }
                }
            }

            protected void onFound() {
                try {
                    TestPackage.this.addClassesListToJavaParameters(this.myClasses, psiClass -> psiClass != null ? JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiClass) : null, TestPackage.this.getPackageName(data), TestPackage.this.createTempFiles(), TestPackage.this.getJavaParameters());
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        };
    }

    @Nullable
    protected Path getRootPath() {
        Module module = ((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule();
        boolean chooseSingleModule = this.getConfiguration().getTestSearchScope() == TestSearchScope.SINGLE_MODULE;
        return TestClassCollector.getRootPath((Module)module, (boolean)chooseSingleModule);
    }

    protected boolean acceptClassName(String className) {
        return true;
    }

    protected boolean createTempFiles() {
        return false;
    }

    protected String getPackageName(JUnitConfiguration.Data data) throws CantRunException {
        return this.getPackage(data).getQualifiedName();
    }

    @Override
    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters javaParameters = super.createJavaParameters();
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        Project project = this.getConfiguration().getProject();
        SourceScope sourceScope = data.getScope().getSourceScope((ModuleBasedConfiguration)this.getConfiguration());
        if (sourceScope == null || !"-junit5".equals(this.getRunner())) {
            JUnitUtil.checkTestCase((SourceScope)sourceScope, (Project)project);
        }
        this.createTempFiles(javaParameters);
        this.createServerSocket(javaParameters);
        return javaParameters;
    }

    protected boolean configureByModule(Module module) {
        return super.configureByModule(module) && this.getConfiguration().getPersistentData().getScope() != TestSearchScope.WHOLE_PROJECT;
    }

    protected TestClassFilter getClassFilter(JUnitConfiguration.Data data) throws CantRunException {
        Module module = ((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule();
        if (this.getConfiguration().getPersistentData().getScope() == TestSearchScope.WHOLE_PROJECT) {
            module = null;
        }
        TestClassFilter classFilter = TestClassFilter.create(this.getSourceScope(), module);
        return classFilter.intersectionWith(this.filterScope(data));
    }

    protected GlobalSearchScope filterScope(JUnitConfiguration.Data data) throws CantRunException {
        Ref ref = new Ref();
        GlobalSearchScope aPackage = (GlobalSearchScope)ReadAction.compute(() -> {
            try {
                return PackageScope.packageScope((PsiPackage)this.getPackage(data), (boolean)true);
            }
            catch (CantRunException e) {
                ref.set((Object)e);
                return null;
            }
        });
        CantRunException exception = (CantRunException)((Object)ref.get());
        if (exception != null) {
            throw exception;
        }
        return aPackage;
    }

    protected PsiPackage getPackage(JUnitConfiguration.Data data) throws CantRunException {
        Project project = this.getConfiguration().getProject();
        String packageName = data.getPackageName();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage(packageName);
        if (aPackage == null) {
            throw CantRunException.packageNotFound((String)packageName);
        }
        return aPackage;
    }

    @Override
    public String suggestActionName() {
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        if (data.getPackageName().trim().length() > 0) {
            return ExecutionBundle.message((String)"test.in.scope.presentable.text", (Object[])new Object[]{data.getPackageName()});
        }
        return ExecutionBundle.message((String)"all.tests.scope.presentable.text", (Object[])new Object[0]);
    }

    @Override
    public RefactoringElementListener getListener(PsiElement element, JUnitConfiguration configuration) {
        if (!(element instanceof PsiPackage)) {
            return null;
        }
        return RefactoringListeners.getListener((PsiPackage)((PsiPackage)element), configuration.myPackage);
    }

    @Override
    public boolean isConfiguredByElement(JUnitConfiguration configuration, PsiClass testClass, PsiMethod testMethod, PsiPackage testPackage, PsiDirectory testDir) {
        return testPackage != null && Comparing.equal((String)testPackage.getQualifiedName(), (String)configuration.getPersistentData().getPackageName());
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        String packageName = this.getConfiguration().getPersistentData().getPackageName();
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.getConfiguration().getProject()).findPackage(packageName);
        if (aPackage == null) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"package.does.not.exist.error.message", (Object[])new Object[]{packageName}));
        }
        if (this.getSourceScope() == null) {
            ((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).checkForWarning();
        }
    }

    public File getWorkingDirsFile() {
        return this.myWorkingDirsFile;
    }

    private static Predicate<Class<?>> createPredicate(ClassLoader classLoader) {
        try {
            Class<?> testCaseClass = Class.forName("junit.framework.TestCase", true, classLoader);
            Class<?> runWithClass = Class.forName("org.junit.runner.RunWith", true, classLoader);
            Class<?> testClass = Class.forName("org.junit.Test", true, classLoader);
            return aClass -> {
                if (aClass.isAnnotationPresent(runWithClass)) {
                    return true;
                }
                if (testCaseClass.isAssignableFrom((Class<?>)aClass)) {
                    return TestPackage.hasSingleConstructor(aClass);
                }
                for (Method method : aClass.getMethods()) {
                    if (Modifier.isStatic(method.getModifiers()) && "suite".equals(method.getName())) {
                        return true;
                    }
                    if (!method.isAnnotationPresent(testClass)) continue;
                    return TestPackage.hasSingleConstructor(aClass);
                }
                return false;
            };
        }
        catch (ClassNotFoundException e) {
            LOG.error((Throwable)e);
            return aClass -> false;
        }
    }

    private static boolean hasSingleConstructor(Class<?> aClass) {
        Constructor<?>[] constructors = aClass.getConstructors();
        return constructors.length == 1 && constructors[0].getParameterTypes().length == 0;
    }
}

