/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.interfaces.mochaTdd;

import com.intellij.javascript.testFramework.AbstractTestFileStructureBuilder;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.AbstractMochaTddElement;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructure;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddSuite;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddTest;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MochaTddFileStructureBuilder
extends AbstractTestFileStructureBuilder<MochaTddFileStructure> {
    private static final String SUITE_NAME = "suite";
    private static final String TEST_NAME = "test";
    private static final MochaTddFileStructureBuilder INSTANCE = new MochaTddFileStructureBuilder();

    public static MochaTddFileStructureBuilder getInstance() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public MochaTddFileStructure buildTestFileStructure(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            MochaTddFileStructureBuilder.$$$reportNull$$$0(0);
        }
        List children = null;
        if (JsPsiUtils.mightContainGlobalCall((PsiFile)jsFile, SUITE_NAME, false)) {
            children = ContainerUtil.newSmartList();
            List<JSStatement> statements = JsPsiUtils.listStatementsInExecutionOrder(jsFile);
            for (JSStatement statement : statements) {
                JSCallExpression callExpr = JsPsiUtils.toCallExpressionFromStatement(statement);
                if (callExpr == null) continue;
                this.handleCallExpr(null, callExpr, children);
            }
        }
        if (TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(jsFile.getFileType()) && StringUtil.indexOf((CharSequence)jsFile.getViewProvider().getContents(), (CharSequence)"@suite") >= 0) {
            if (children == null) {
                children = ContainerUtil.newSmartList();
            }
            MochaTddFileStructureBuilder.collectAttributeBasedStructure(jsFile, children);
        }
        children = ContainerUtil.notNullize((List)children);
        MochaTddFileStructure mochaTddFileStructure = new MochaTddFileStructure(jsFile, children);
        if (mochaTddFileStructure == null) {
            MochaTddFileStructureBuilder.$$$reportNull$$$0(1);
        }
        return mochaTddFileStructure;
    }

    private static void collectAttributeBasedStructure(@NotNull JSFile file, @NotNull List<AbstractMochaTddElement> structure) {
        if (file == null) {
            MochaTddFileStructureBuilder.$$$reportNull$$$0(2);
        }
        if (structure == null) {
            MochaTddFileStructureBuilder.$$$reportNull$$$0(3);
        }
        for (PsiElement element : file.getChildren()) {
            String className;
            TypeScriptClass clazz;
            if (!(element instanceof TypeScriptClass) || (clazz = (TypeScriptClass)element).getAttributeList() == null || !MochaTddFileStructureBuilder.attrNameEquals(clazz.getAttributeList(), SUITE_NAME) || (className = clazz.getName()) == null) continue;
            MochaTddSuite suite = new MochaTddSuite(className, (PsiElement)clazz, null);
            structure.add(suite);
            List children = ContainerUtil.newSmartList();
            for (JSElement jsElement : clazz.getMembers()) {
                TypeScriptFunction tsf;
                String testName;
                if (!(jsElement instanceof TypeScriptFunction) || (testName = (tsf = (TypeScriptFunction)jsElement).getName()) == null) continue;
                MochaTddTest test = new MochaTddTest(testName, (PsiElement)tsf, suite);
                children.add(test);
            }
            suite.setChildren(children);
        }
    }

    private static boolean attrNameEquals(@Nullable JSAttributeList attributeList, @NotNull String name) {
        PsiElement[] children;
        if (name == null) {
            MochaTddFileStructureBuilder.$$$reportNull$$$0(4);
        }
        if (attributeList == null) {
            return false;
        }
        for (PsiElement child : children = attributeList.getChildren()) {
            ES6Decorator decorator;
            if (!(child instanceof ES6Decorator) || !name.equals((decorator = (ES6Decorator)child).getName())) continue;
            return true;
        }
        return true;
    }

    private void handleCallExpr(@Nullable MochaTddSuite parentSuite, @NotNull JSCallExpression callExpr, @NotNull List<AbstractMochaTddElement> children) {
        JSReferenceExpression methodRefExpr;
        if (callExpr == null) {
            MochaTddFileStructureBuilder.$$$reportNull$$$0(5);
        }
        if (children == null) {
            MochaTddFileStructureBuilder.$$$reportNull$$$0(6);
        }
        if ((methodRefExpr = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpr.getMethodExpression(), JSReferenceExpression.class)) != null && methodRefExpr.getQualifier() == null) {
            String testName;
            JSFunctionExpression testDefinitions;
            String suiteName;
            JSExpression[] arguments = callExpr.getArguments();
            if (arguments.length != 2) {
                return;
            }
            String methodName = methodRefExpr.getReferenceName();
            if (SUITE_NAME.equals(methodName) && (suiteName = JsPsiUtils.extractStringValue(arguments[0])) != null && (testDefinitions = JsPsiUtils.extractFunctionExpression(arguments[1])) != null) {
                MochaTddSuite suite = new MochaTddSuite(suiteName, (PsiElement)callExpr, parentSuite);
                children.add(suite);
                int suiteInd = children.size() - 1;
                this.handleSuite(suite, testDefinitions, children);
                if (children.get(suiteInd) != suite) {
                    throw new AssertionError((Object)"Cannot find self in list");
                }
                suite.setChildren(children.subList(suiteInd + 1, children.size()));
                while (suiteInd + 1 != children.size()) {
                    children.remove(children.size() - 1);
                }
            }
            if (TEST_NAME.equals(methodName) && (testName = JsPsiUtils.extractStringValue(arguments[0])) != null) {
                MochaTddTest test = new MochaTddTest(testName, (PsiElement)callExpr, parentSuite);
                children.add(test);
            }
        }
    }

    private void handleSuite(@NotNull MochaTddSuite suite, @NotNull JSFunctionExpression specDefinitions, @NotNull List<AbstractMochaTddElement> children) {
        JSSourceElement[] sourceElements;
        if (suite == null) {
            MochaTddFileStructureBuilder.$$$reportNull$$$0(7);
        }
        if (specDefinitions == null) {
            MochaTddFileStructureBuilder.$$$reportNull$$$0(8);
        }
        if (children == null) {
            MochaTddFileStructureBuilder.$$$reportNull$$$0(9);
        }
        for (JSSourceElement sourceElement : sourceElements = (JSSourceElement[])ObjectUtils.notNull((Object)specDefinitions.getBody(), (Object)JSSourceElement.EMPTY_ARRAY)) {
            JSStatement[] statements;
            JSBlockStatement blockStatement = (JSBlockStatement)ObjectUtils.tryCast((Object)sourceElement, JSBlockStatement.class);
            if (blockStatement == null) continue;
            for (JSStatement statement : statements = (JSStatement[])ObjectUtils.notNull((Object)blockStatement.getStatements(), (Object)JSStatement.EMPTY)) {
                JSCallExpression callExpr = JsPsiUtils.toCallExpressionFromStatement(statement);
                if (callExpr == null) continue;
                this.handleCallExpr(suite, callExpr, children);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructureBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = SUITE_NAME;
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specDefinitions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructureBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTestFileStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildTestFileStructure";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectAttributeBasedStructure";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "attrNameEquals";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleCallExpr";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleSuite";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

