/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectName
implements Comparable<ObjectName> {
    public static final ObjectName[] EMPTY_ARRAY = new ObjectName[0];
    public final String name;
    public final boolean quoted;
    private Integer myInsensitiveHash;

    public static ObjectName quoted(@Nullable String name) {
        return name == null ? null : new ObjectName(name, true);
    }

    public static ObjectName plain(@Nullable String name) {
        return name == null ? null : new ObjectName(name, false);
    }

    public ObjectName(@NotNull String name, boolean quoted) {
        if (name == null) {
            ObjectName.$$$reportNull$$$0(0);
        }
        this.myInsensitiveHash = null;
        this.name = name;
        this.quoted = quoted;
    }

    public static boolean equals(@Nullable ObjectName a, @Nullable ObjectName b, @NotNull Casing casing) {
        if (casing == null) {
            ObjectName.$$$reportNull$$$0(1);
        }
        return a == null || b == null ? a == b : a.equals(b, casing);
    }

    public boolean equals(@NotNull ObjectName other, @NotNull Casing casing) {
        if (other == null) {
            ObjectName.$$$reportNull$$$0(2);
        }
        if (casing == null) {
            ObjectName.$$$reportNull$$$0(3);
        }
        if (this == other) {
            return true;
        }
        if (this.hashCode(casing) != other.hashCode(casing)) {
            return false;
        }
        Case case1 = this.getCase(casing);
        Case case2 = other.getCase(casing);
        if (case1 == Case.MIXED || case2 == Case.MIXED) {
            return StringUtil.equalsIgnoreCase((CharSequence)this.name, (CharSequence)other.name);
        }
        return case1.apply(this.name).equals(case2.apply(other.name));
    }

    @NotNull
    private Case getCase(@NotNull Casing casing) {
        if (casing == null) {
            ObjectName.$$$reportNull$$$0(4);
        }
        Case case_ = casing.choose(!this.quoted);
        if (case_ == null) {
            ObjectName.$$$reportNull$$$0(5);
        }
        return case_;
    }

    public int hashCode(@NotNull Casing casing) {
        if (casing == null) {
            ObjectName.$$$reportNull$$$0(6);
        }
        if (casing.plain == Case.EXACT && casing.quoted == Case.EXACT) {
            return this.name.hashCode();
        }
        if (this.myInsensitiveHash == null) {
            this.myInsensitiveHash = StringUtil.stringHashCodeInsensitive((CharSequence)this.name);
        }
        return this.myInsensitiveHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectName name1 = (ObjectName)o;
        if (this.quoted != name1.quoted) {
            return false;
        }
        return this.name.equals(name1.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.quoted ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.quoted ? "`" + this.name.replace("`", "``") + "`" : this.name;
    }

    public static ObjectName[] toArray(@Nullable Iterable<ObjectName> items) {
        if (items == null) {
            return null;
        }
        Collection collection = items instanceof Collection ? (Collection)items : ContainerUtil.collect(items.iterator());
        return collection.isEmpty() ? EMPTY_ARRAY : collection.toArray(new ObjectName[collection.size()]);
    }

    @Override
    public int compareTo(@NotNull ObjectName o) {
        int res;
        if (o == null) {
            ObjectName.$$$reportNull$$$0(7);
        }
        return (res = Comparing.compare((Comparable)((Object)this.name), (Comparable)((Object)o.name))) != 0 ? res : Comparing.compare((boolean)this.quoted, (boolean)o.quoted);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/ObjectName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/ObjectName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCase";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hashCode";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class HashingStrategy
    implements TObjectHashingStrategy<ObjectName> {
        private final Casing myCasing;

        public HashingStrategy(@NotNull Casing casing) {
            if (casing == null) {
                HashingStrategy.$$$reportNull$$$0(0);
            }
            this.myCasing = casing;
        }

        public int computeHashCode(ObjectName object) {
            return object.hashCode(this.myCasing);
        }

        public boolean equals(ObjectName o1, ObjectName o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2;
            }
            return o1.equals(o2, this.myCasing);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casing", "com/intellij/database/model/ObjectName$HashingStrategy", "<init>"));
        }
    }
}

