/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteredTraverserBase;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DasUtil {
    public static final Function<DasObject, String> TO_NAME = o -> o == null ? null : o.getName();
    public static final Function<DasObject, ObjectKind> TO_KIND = DasObject::getKind;
    public static final Function<DasObject, Iterable<DasObject>> ALL_CHILDREN = t -> t.getDbChildren(DasObject.class, ObjectKind.NONE);
    public static final Function<DasObject, DasObject> TO_PARENT = t -> {
        DasObject o = t.getDbParent();
        ObjectKind kind = DasUtil.getKind(o);
        return kind == ObjectKind.NONE || kind == ObjectKind.ROOT ? null : o;
    };
    public static final Condition<DasArgument> OUTPUT_ARGUMENT = definition -> definition.getArgumentDirection().isOut();
    public static final Condition<DasArgument> INPUT_ARGUMENT = definition -> {
        DasArgument.Direction type = definition.getArgumentDirection();
        return type.isIn() || type == DasArgument.Direction.SELF;
    };
    public static final Condition<DasArgument> PARAMETER = definition -> !definition.getArgumentDirection().isReturnOrResult();
    public static final Condition<Object> CHECK_CANCELLED = o -> {
        DasUtil.checkCancelled();
        return true;
    };
    public static final String NO_NAME = new String("");
    public static final Set<DasColumn.Attribute> NO_ATTRS = Collections.emptySet();
    public static final Casing CASING_MIXED = Casing.create(Case.MIXED, Case.EXACT);
    public static final Casing CASING_EXACT = Casing.create(Case.EXACT, Case.EXACT);
    public static final CasingProvider NO_CASING_PROVIDER = (kind, context) -> CASING_MIXED;
    private static final Function<DasObject, Iterable<? extends DasObject>> DAS_STRUCTURE = o -> o.getDbChildren(DasObject.class, ObjectKind.NONE);
    private static final JBTreeTraverser<DasObject> DAS_TRAVERSER = new JBTreeTraverser(DAS_STRUCTURE);

    private DasUtil() {
    }

    private static void checkCancelled() {
        Application app = ApplicationManager.getApplication();
        if (app == null || app.isUnitTestMode()) {
            return;
        }
        ProgressManager.checkCanceled();
    }

    @NotNull
    public static <V> Map<String, V> newCaseAwareMap(boolean sensitive) {
        THashMap tHashMap = ContainerUtil.newTroveMap((TObjectHashingStrategy)(sensitive ? TObjectHashingStrategy.CANONICAL : CaseInsensitiveStringHashingStrategy.INSTANCE));
        if (tHashMap == null) {
            DasUtil.$$$reportNull$$$0(0);
        }
        return tHashMap;
    }

    @NotNull
    public static Set<String> newCaseAwareSet(boolean sensitive) {
        THashSet tHashSet = ContainerUtil.newTroveSet((TObjectHashingStrategy)(sensitive ? TObjectHashingStrategy.CANONICAL : CaseInsensitiveStringHashingStrategy.INSTANCE));
        if (tHashSet == null) {
            DasUtil.$$$reportNull$$$0(1);
        }
        return tHashSet;
    }

    @NotNull
    public static JBTreeTraverser<DasObject> dasTraverser() {
        JBTreeTraverser<DasObject> jBTreeTraverser = DAS_TRAVERSER;
        if (jBTreeTraverser == null) {
            DasUtil.$$$reportNull$$$0(2);
        }
        return jBTreeTraverser;
    }

    @NotNull
    public static ObjectKind getKind(@Nullable DasObject o) {
        ObjectKind objectKind = o == null ? ObjectKind.NONE : o.getKind();
        if (objectKind == null) {
            DasUtil.$$$reportNull$$$0(3);
        }
        return objectKind;
    }

    @NotNull
    public static <C extends DasObject> Condition<C> byKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            DasUtil.$$$reportNull$$$0(4);
        }
        Condition condition = kind == ObjectKind.NONE ? Conditions.alwaysTrue() : object -> {
            if (kind == null) {
                DasUtil.$$$reportNull$$$0(55);
            }
            return DasUtil.getKind(object) == kind;
        };
        if (condition == null) {
            DasUtil.$$$reportNull$$$0(5);
        }
        return condition;
    }

    @NotNull
    public static <C extends DasObject> Condition<C> byKindNot(@NotNull ObjectKind kind) {
        if (kind == null) {
            DasUtil.$$$reportNull$$$0(6);
        }
        Condition condition = kind == ObjectKind.NONE ? Conditions.alwaysTrue() : object -> {
            if (kind == null) {
                DasUtil.$$$reportNull$$$0(54);
            }
            return DasUtil.getKind(object) != kind;
        };
        if (condition == null) {
            DasUtil.$$$reportNull$$$0(7);
        }
        return condition;
    }

    @NotNull
    public static <C extends DasObject> Condition<C> byName(@Nullable String name) {
        Condition<C> condition = DasUtil.byName(name, NO_CASING_PROVIDER);
        if (condition == null) {
            DasUtil.$$$reportNull$$$0(8);
        }
        return condition;
    }

    @NotNull
    public static <C extends DasObject> Condition<C> byName(@Nullable String name, @NotNull CasingProvider casing) {
        if (casing == null) {
            DasUtil.$$$reportNull$$$0(9);
        }
        if (name == null) {
            Condition condition = Conditions.alwaysFalse();
            if (condition == null) {
                DasUtil.$$$reportNull$$$0(10);
            }
            return condition;
        }
        Condition condition = object -> {
            if (casing == null) {
                DasUtil.$$$reportNull$$$0(53);
            }
            return DasUtil.nameEqual(object, name, casing);
        };
        if (condition == null) {
            DasUtil.$$$reportNull$$$0(11);
        }
        return condition;
    }

    @NotNull
    public static <C> Condition<C> byClass(@NotNull Class clazz) {
        if (clazz == null) {
            DasUtil.$$$reportNull$$$0(12);
        }
        Condition condition = Conditions.instanceOf((Class)clazz);
        if (condition == null) {
            DasUtil.$$$reportNull$$$0(13);
        }
        return condition;
    }

    @NotNull
    public static DasModel emptyModel() {
        EmptyModel emptyModel = EmptyModel.INSTANCE;
        if (emptyModel == null) {
            DasUtil.$$$reportNull$$$0(14);
        }
        return emptyModel;
    }

    public static boolean nameEqual(@Nullable DasObject obj, @Nullable String name, @NotNull CasingProvider casing) {
        if (casing == null) {
            DasUtil.$$$reportNull$$$0(15);
        }
        return DasUtil.nameEqual(obj, name, casing.getCasing(obj == null ? ObjectKind.NONE : obj.getKind(), obj));
    }

    public static boolean nameEqual(@Nullable DasObject obj, @Nullable String name, @NotNull Casing casing) {
        if (casing == null) {
            DasUtil.$$$reportNull$$$0(16);
        }
        return obj != null && DasUtil.equal(obj.getName(), name, casing);
    }

    public static boolean isCaseSensitive(@NotNull Casing casing) {
        if (casing == null) {
            DasUtil.$$$reportNull$$$0(17);
        }
        return casing.plain == Case.EXACT;
    }

    public static boolean equal(@Nullable String name1, @Nullable String name2, @NotNull Casing casing) {
        if (casing == null) {
            DasUtil.$$$reportNull$$$0(18);
        }
        return Comparing.equal((String)name1, (String)name2, (boolean)DasUtil.isCaseSensitive(casing));
    }

    @NotNull
    public static <T> MultiRef<T> emptyMultiRef() {
        EmptyMultiRef emptyMultiRef = EmptyMultiRef.INSTANCE;
        if (emptyMultiRef == null) {
            DasUtil.$$$reportNull$$$0(19);
        }
        return emptyMultiRef;
    }

    @NotNull
    public static <S, T> MultiRef<? extends T> transform(@NotNull MultiRef<S> ref, @NotNull Function<? super S, T> fun) {
        if (ref == null) {
            DasUtil.$$$reportNull$$$0(20);
        }
        if (fun == null) {
            DasUtil.$$$reportNull$$$0(21);
        }
        MappedMultiRef mappedMultiRef = new MappedMultiRef(ref, fun);
        if (mappedMultiRef == null) {
            DasUtil.$$$reportNull$$$0(22);
        }
        return mappedMultiRef;
    }

    @NotNull
    public static <T> MultiRef.It<T> emptyMultiRefIterator() {
        MultiRef.It it = EmptyMultiRef.INSTANCE.iterate();
        if (it == null) {
            DasUtil.$$$reportNull$$$0(23);
        }
        return it;
    }

    @Nullable
    public static DasObject getParentOfKind(@Nullable DasObject object, @Nullable ObjectKind kind, boolean strict) {
        DasObject o;
        if (kind == null) {
            return null;
        }
        DasObject dasObject = o = strict && object != null ? object.getDbParent() : object;
        while (o != null) {
            if (o.getKind() == kind) {
                return o;
            }
            o = o.getDbParent();
        }
        return null;
    }

    @Nullable
    public static <T> T getParentOfClass(@Nullable DasObject object, @Nullable Class<? extends T> clazz, boolean strict) {
        DasObject o;
        if (clazz == null) {
            return null;
        }
        DasObject dasObject = o = strict && object != null ? object.getDbParent() : object;
        while (o != null) {
            if (clazz.isInstance(o)) {
                return (T)o;
            }
            o = o.getDbParent();
        }
        return null;
    }

    @Nullable
    public static DasNamespace getNamespace(@Nullable DasObject object) {
        return DasUtil.getParentOfClass(object, DasNamespace.class, true);
    }

    @NotNull
    public static JBIterable<DasObject> dasParents(@Nullable DasObject object) {
        if (object == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DasUtil.$$$reportNull$$$0(24);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.generate((Object)object, TO_PARENT);
        if (jBIterable == null) {
            DasUtil.$$$reportNull$$$0(25);
        }
        return jBIterable;
    }

    @Nullable
    public static <C extends DasObject> C findChild(@Nullable DasObject parent, Class<C> clazz, ObjectKind kind, String name) {
        return (C)(parent == null ? null : (DasObject)parent.getDbChildren(clazz, kind).filter(DasUtil.byName(name)).first());
    }

    @Nullable
    public static DasObject getCatalogObject(@Nullable DasObject object) {
        return DasUtil.getParentOfKind(object, ObjectKind.DATABASE, false);
    }

    @Nullable
    public static DasObject getSchemaObject(@Nullable DasObject object) {
        return DasUtil.getParentOfKind(object, ObjectKind.SCHEMA, false);
    }

    @NotNull
    public static String getName(@Nullable DasObject object) {
        String string = object == null ? NO_NAME : object.getName();
        if (string == null) {
            DasUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static String getCatalog(@Nullable DasObject object) {
        String string = DasUtil.getName(DasUtil.getCatalogObject(object));
        if (string == null) {
            DasUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public static String getSchema(@Nullable DasObject object) {
        String string = DasUtil.getName(DasUtil.getSchemaObject(object));
        if (string == null) {
            DasUtil.$$$reportNull$$$0(28);
        }
        return string;
    }

    public static <T extends DasObject> MultiRef<T> asRef(Iterable<T> objects) {
        return DasUtil.asRef(objects, TO_NAME, Function.ID);
    }

    public static <S, T extends DasObject> MultiRef<T> asRef(final Iterable<S> objects, final Function<? super S, String> namer, final Function<S, T> resolver) {
        final JBIterable fi = JBIterable.from(objects);
        return new MultiRef<T>(){

            @Override
            public MultiRef.It<T> iterate() {
                final Iterator it = objects.iterator();
                return new MultiRef.It<T>(){
                    S cur;

                    @Override
                    @Nullable
                    public T resolve() {
                        return (DasObject)resolver.fun(this.cur);
                    }

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public String next() {
                        this.cur = it.next();
                        return (String)namer.fun(this.cur);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public Iterable<String> names() {
                return fi.transform(namer);
            }

            @Override
            public Iterable<? extends T> resolveObjects() {
                return fi.transform(resolver).filter(Condition.NOT_NULL);
            }

            @Override
            public int size() {
                return fi.size();
            }
        };
    }

    @Nullable
    public static DasObject resolveFinalTarget(@Nullable DasSynonym synonym) {
        int k = 9;
        DasObject o = synonym;
        while (o instanceof DasSynonym && k-- > 0) {
            o = o.resolveTarget();
        }
        return k == 0 ? null : o;
    }

    public static boolean isPrimary(@Nullable DasColumn column) {
        return DasUtil.hasAttribute(column, DasColumn.Attribute.PRIMARY_KEY);
    }

    public static boolean isForeign(@Nullable DasColumn column) {
        return DasUtil.hasAttribute(column, DasColumn.Attribute.FOREIGN_KEY);
    }

    public static boolean isAuto(@Nullable DasColumn column) {
        return DasUtil.isAutoGenerated(column) || DasUtil.isComputed(column);
    }

    public static boolean isAutoGenerated(@Nullable DasColumn column) {
        return DasUtil.hasAttribute(column, DasColumn.Attribute.AUTO_GENERATED);
    }

    public static boolean isComputed(@Nullable DasColumn column) {
        return DasUtil.hasAttribute(column, DasColumn.Attribute.COMPUTED);
    }

    public static boolean isIndexColumn(@Nullable DasColumn column) {
        return DasUtil.hasAttribute(column, DasColumn.Attribute.INDEX);
    }

    private static boolean hasAttribute(@Nullable DasColumn column, @NotNull DasColumn.Attribute attribute) {
        if (attribute == null) {
            DasUtil.$$$reportNull$$$0(29);
        }
        DasTable table = column == null ? null : column.getTable();
        return table != null && table.getColumnAttrs(column).contains((Object)attribute);
    }

    public static boolean isAncestor(@Nullable DasObject ancestor, @Nullable DasObject element, boolean strict) {
        if (ancestor == null || element == null) {
            return false;
        }
        if (ancestor == element) {
            return !strict;
        }
        for (DasObject object : DasUtil.dasParents(element)) {
            if (object != ancestor) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static JBIterable<? extends DasNamespace> getSchemas(@NotNull DatabaseSystem dataSource) {
        if (dataSource == null) {
            DasUtil.$$$reportNull$$$0(30);
        }
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)dataSource.getModel().traverser().expandAndFilter(DasUtil.byClass(DasNamespace.class))).filter(DasUtil.byKind(ObjectKind.SCHEMA))).filter(DasNamespace.class);
        if (jBIterable == null) {
            DasUtil.$$$reportNull$$$0(31);
        }
        return jBIterable;
    }

    public static JBIterable<? extends DasTable> getTables(@NotNull DatabaseSystem dataSource) {
        if (dataSource == null) {
            DasUtil.$$$reportNull$$$0(32);
        }
        return DasUtil.getSchemaElements(dataSource, DasTable.class);
    }

    public static <T> JBIterable<? extends T> getSchemaElements(@NotNull DatabaseSystem dataSource, Class<T> clazz) {
        if (dataSource == null) {
            DasUtil.$$$reportNull$$$0(33);
        }
        return ((JBTreeTraverser)dataSource.getModel().traverser().expandAndSkip(DasUtil.byClass(DasNamespace.class))).filter(clazz);
    }

    public static JBIterable<? extends DasColumn> getColumns(@NotNull DasObject table) {
        if (table == null) {
            DasUtil.$$$reportNull$$$0(34);
        }
        return table.getDbChildren(DasColumn.class, ObjectKind.COLUMN);
    }

    public static JBIterable<? extends DasForeignKey> getForeignKeys(@NotNull DasTable table) {
        if (table == null) {
            DasUtil.$$$reportNull$$$0(35);
        }
        return table.getDbChildren(DasForeignKey.class, ObjectKind.FOREIGN_KEY);
    }

    public static JBIterable<? extends DasIndex> getIndices(@NotNull DasTable table) {
        if (table == null) {
            DasUtil.$$$reportNull$$$0(36);
        }
        return table.getDbChildren(DasIndex.class, ObjectKind.INDEX);
    }

    public static JBIterable<? extends DasTableKey> getTableKeys(@NotNull DasTable table) {
        if (table == null) {
            DasUtil.$$$reportNull$$$0(37);
        }
        return table.getDbChildren(DasTableKey.class, ObjectKind.KEY);
    }

    @Nullable
    public static DasTableKey getPrimaryKey(@NotNull DasTable table) {
        if (table == null) {
            DasUtil.$$$reportNull$$$0(38);
        }
        for (DasTableKey key : DasUtil.getTableKeys(table)) {
            if (!key.isPrimary()) continue;
            return key;
        }
        return null;
    }

    public static boolean containsName(@NotNull String name, @NotNull MultiRef<?> ref) {
        if (name == null) {
            DasUtil.$$$reportNull$$$0(39);
        }
        if (ref == null) {
            DasUtil.$$$reportNull$$$0(40);
        }
        return ContainerUtil.find(ref.names(), (Object)name) != null;
    }

    @NotNull
    public static JBIterable<? extends DasArgument> getParameters(@NotNull DasRoutine routine) {
        if (routine == null) {
            DasUtil.$$$reportNull$$$0(41);
        }
        JBIterable jBIterable = JBIterable.from(routine.getArguments()).filter(PARAMETER);
        if (jBIterable == null) {
            DasUtil.$$$reportNull$$$0(42);
        }
        return jBIterable;
    }

    @NotNull
    public static <C> JBIterable<C> getDbChildren(@NotNull DasObject object, @NotNull DasModel model, @NotNull Class<C> clazz, @NotNull ObjectKind kind) {
        if (object == null) {
            DasUtil.$$$reportNull$$$0(43);
        }
        if (model == null) {
            DasUtil.$$$reportNull$$$0(44);
        }
        if (clazz == null) {
            DasUtil.$$$reportNull$$$0(45);
        }
        if (kind == null) {
            DasUtil.$$$reportNull$$$0(46);
        }
        JBIterable<C> jBIterable = DasUtil.getDbChildren(object, model == DasUtil.emptyModel() ? DasUtil.dasTraverser() : model.traverser(), clazz, kind);
        if (jBIterable == null) {
            DasUtil.$$$reportNull$$$0(47);
        }
        return jBIterable;
    }

    @NotNull
    public static <C> JBIterable<C> getDbChildren(@NotNull DasObject object, @NotNull JBTreeTraverser<DasObject> traverser, @NotNull Class<C> clazz, @NotNull ObjectKind kind) {
        if (object == null) {
            DasUtil.$$$reportNull$$$0(48);
        }
        if (traverser == null) {
            DasUtil.$$$reportNull$$$0(49);
        }
        if (clazz == null) {
            DasUtil.$$$reportNull$$$0(50);
        }
        if (kind == null) {
            DasUtil.$$$reportNull$$$0(51);
        }
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)((JBTreeTraverser)traverser.withRoot((Object)object)).expandAndSkip(Conditions.is((Object)object))).filter(DasUtil.byKind(kind))).filter(clazz);
        if (jBIterable == null) {
            DasUtil.$$$reportNull$$$0(52);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DasUtil";
                break;
            }
            case 4: 
            case 6: 
            case 46: 
            case 51: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
            case 12: 
            case 45: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 20: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 30: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 43: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traverser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "newCaseAwareMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "newCaseAwareSet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "dasTraverser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DasUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "byKind";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "byKindNot";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "byName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "byClass";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyModel";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyMultiRef";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "transform";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyMultiRefIterator";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "dasParents";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getCatalog";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchema";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemas";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 47: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbChildren";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "byKind";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "byKindNot";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "byName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "byClass";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "nameEqual";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isCaseSensitive";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "equal";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "transform";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "hasAttribute";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getSchemas";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getTables";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaElements";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getForeignKeys";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getIndices";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getTableKeys";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getPrimaryKey";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "containsName";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getParameters";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getDbChildren";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "lambda$byName$11";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "lambda$byKindNot$10";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "lambda$byKind$9";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EmptyModel
    extends JBTreeTraverser<DasObject>
    implements DasModel {
        private static final EmptyModel INSTANCE = new EmptyModel("empty");
        final String debugName;

        private EmptyModel(String debugName) {
            super(Functions.constant((Object)JBIterable.empty()));
            this.debugName = debugName;
        }

        @Override
        @NotNull
        public JBIterable<? extends DasObject> getModelRoots() {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                EmptyModel.$$$reportNull$$$0(0);
            }
            return jBIterable;
        }

        @Override
        @Nullable
        public DasNamespace getCurrentRootNamespace() {
            return null;
        }

        @Override
        @NotNull
        public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
            if (kind == null) {
                EmptyModel.$$$reportNull$$$0(1);
            }
            Casing casing = CASING_MIXED;
            if (casing == null) {
                EmptyModel.$$$reportNull$$$0(2);
            }
            return casing;
        }

        @Override
        @NotNull
        public JBTreeTraverser<DasObject> traverser() {
            EmptyModel emptyModel = this;
            if (emptyModel == null) {
                EmptyModel.$$$reportNull$$$0(3);
            }
            return emptyModel;
        }

        @NotNull
        protected JBTreeTraverser<DasObject> newInstance(FilteredTraverserBase.Meta<DasObject> meta) {
            EmptyModel emptyModel = this;
            if (emptyModel == null) {
                EmptyModel.$$$reportNull$$$0(4);
            }
            return emptyModel;
        }

        @Override
        @NotNull
        public JBIterable<? extends DasConstraint> getExportedKeys(DasTable table) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                EmptyModel.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        public String toString() {
            return this.debugName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/DasUtil$EmptyModel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModelRoots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/DasUtil$EmptyModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCasing";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "traverser";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "newInstance";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExportedKeys";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getCasing";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MappedMultiRef<S, T>
    implements MultiRef<T> {
        final MultiRef<? extends S> original;
        final Function<? super S, T> fun;

        private MappedMultiRef(MultiRef<? extends S> original, Function<? super S, T> fun) {
            this.original = original;
            this.fun = fun;
        }

        @Override
        public MultiRef.It<T> iterate() {
            final MultiRef.It<? extends S> it = this.original.iterate();
            return new MultiRef.It<T>(){

                @Override
                @Nullable
                public T resolve() {
                    return fun.fun(it.resolve());
                }

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public String next() {
                    return (String)it.next();
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
        }

        @Override
        public Iterable<String> names() {
            return this.original.names();
        }

        @Override
        public Iterable<T> resolveObjects() {
            return JBIterable.from(this.original.resolveObjects()).transform(this.fun).filter(Condition.NOT_NULL);
        }

        @Override
        public int size() {
            return this.original.size();
        }
    }

    private static class EmptyMultiRef
    implements MultiRef,
    MultiRef.It {
        static final EmptyMultiRef INSTANCE = new EmptyMultiRef();

        private EmptyMultiRef() {
        }

        public MultiRef.It iterate() {
            return this;
        }

        @Override
        public Iterable<String> names() {
            return Collections.emptyList();
        }

        public Iterable resolveObjects() {
            return JBIterable.empty();
        }

        @Override
        public int size() {
            return 0;
        }

        @Nullable
        public Object resolve() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

