/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.model.MavenDomProperties;
import org.jetbrains.idea.maven.dom.references.MavenContextlessPropertyReference;
import org.jetbrains.idea.maven.dom.references.MavenPropertyPsiReference;
import org.jetbrains.idea.maven.plugins.api.MavenPluginParamInfo;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenPropertyPsiReferenceProvider
extends PsiReferenceProvider {
    public static final boolean SOFT_DEFAULT = false;

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            MavenPropertyPsiReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            MavenPropertyPsiReferenceProvider.$$$reportNull$$$0(1);
        }
        PsiReference[] psiReferenceArray = MavenPropertyPsiReferenceProvider.getReferences(element, false);
        if (psiReferenceArray == null) {
            MavenPropertyPsiReferenceProvider.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    private static boolean isElementCanContainReference(PsiElement element) {
        if (element instanceof XmlTag) {
            for (MavenPluginParamInfo.ParamInfo info : MavenPluginParamInfo.getParamInfoList((XmlTag)element)) {
                if (!Boolean.TRUE.equals(info.getParam().disableReferences)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static MavenProject findMavenProject(PsiElement element) {
        VirtualFile virtualFile = MavenDomUtil.getVirtualFile(element);
        if (virtualFile == null) {
            return null;
        }
        MavenProjectsManager manager = MavenProjectsManager.getInstance(element.getProject());
        return manager.findProject(virtualFile);
    }

    public static PsiReference[] getReferences(PsiElement element, boolean isSoft) {
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)element);
        if (textRange.isEmpty()) {
            return PsiReference.EMPTY_ARRAY;
        }
        String text = element.getText();
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (!MavenPropertyPsiReferenceProvider.isElementCanContainReference(element)) {
            return PsiReference.EMPTY_ARRAY;
        }
        MavenProject mavenProject = null;
        XmlTag propertiesTag = null;
        ArrayList<MavenContextlessPropertyReference> result = null;
        Matcher matcher = MavenPropertyResolver.PATTERN.matcher(textRange.substring(text));
        while (matcher.find()) {
            int from;
            String propertyName = matcher.group(1);
            if (propertyName == null) {
                propertyName = matcher.group(2);
                from = matcher.start(2);
            } else {
                from = matcher.start(1);
            }
            TextRange range = TextRange.from((int)(textRange.getStartOffset() + from), (int)propertyName.length());
            if (result == null) {
                result = new ArrayList<MavenContextlessPropertyReference>();
                mavenProject = MavenPropertyPsiReferenceProvider.findMavenProject(element);
                if (mavenProject == null && (propertiesTag = MavenPropertyPsiReferenceProvider.findPropertiesParentTag(element)) == null) {
                    return PsiReference.EMPTY_ARRAY;
                }
            }
            Object ref = mavenProject != null ? new MavenPropertyPsiReference(mavenProject, element, propertyName, range, isSoft) : new MavenContextlessPropertyReference(propertiesTag, element, range, true);
            result.add((MavenContextlessPropertyReference)((Object)ref));
        }
        return result == null ? PsiReference.EMPTY_ARRAY : result.toArray(new PsiReference[result.size()]);
    }

    private static XmlTag findPropertiesParentTag(@NotNull PsiElement element) {
        DomElement domElement;
        if (element == null) {
            MavenPropertyPsiReferenceProvider.$$$reportNull$$$0(3);
        }
        return (domElement = DomUtil.getDomElement((PsiElement)element)) instanceof MavenDomProperties ? domElement.getXmlTag() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/references/MavenPropertyPsiReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/references/MavenPropertyPsiReferenceProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findPropertiesParentTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

