/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.composite.references;

import com.intellij.jsf.references.JsfResourceIdentifierReferenceSet;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class CompositeURIReferenceProvider
extends PsiReferenceProvider {
    public static final ElementFilter ELEMENT_FILTER = new ElementFilter(){

        public boolean isAcceptable(Object element, PsiElement context) {
            PsiElement parent = context.getParent();
            if (!(parent instanceof XmlAttribute)) {
                return false;
            }
            XmlAttribute attribute = (XmlAttribute)parent;
            if (!attribute.isNamespaceDeclaration()) {
                return false;
            }
            String value = attribute.getValue();
            return value != null && (value.startsWith("http://java.sun.com/jsf/composite/") || value.startsWith("http://xmlns.jcp.org/jsf/composite/"));
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    };

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        String text;
        String s;
        if (element == null) {
            CompositeURIReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            CompositeURIReferenceProvider.$$$reportNull$$$0(1);
        }
        String compositeNamespace = (s = StringUtil.unquoteString((String)(text = element.getText()))).contains("http://java.sun.com/jsf/composite") ? "http://java.sun.com/jsf/composite" : "http://xmlns.jcp.org/jsf/composite";
        int offset = (compositeNamespace + "/").length();
        Object[] psiReferences = new JsfResourceIdentifierReferenceSet(element, s.substring(offset), '/', offset + 1).getPsiReferences();
        PsiReference[] psiReferenceArray = (PsiReference[])ArrayUtil.append((Object[])psiReferences, (Object)CompositeURIReferenceProvider.getCompositeNamespaceURIReference(element, compositeNamespace));
        if (psiReferenceArray == null) {
            CompositeURIReferenceProvider.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    private static URLReference getCompositeNamespaceURIReference(PsiElement element, String compositeNamespace) {
        return new URLReference(element, TextRange.from((int)1, (int)compositeNamespace.length()), false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsf/composite/references/CompositeURIReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsf/composite/references/CompositeURIReferenceProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

