/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.utils;

import com.intellij.javaee.model.xml.ParamValue;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsf.model.common.JsfCommonConverter;
import com.intellij.jsf.model.common.JsfConvertersDiscoverer;
import com.intellij.jsf.model.xml.FacesConfig;
import com.intellij.jsf.model.xml.FacesDomModel;
import com.intellij.jsf.model.xml.FacesDomModelManager;
import com.intellij.jsf.model.xml.managedBeans.ManagedProperty;
import com.intellij.jsf.model.xml.managedBeans.propertyValue.ListEntriesProperty;
import com.intellij.jsf.model.xml.managedBeans.propertyValue.MapEntriesProperty;
import com.intellij.jsf.model.xml.managedBeans.propertyValue.ValuableProperty;
import com.intellij.jsf.model.xml.navigationRules.NavigationCase;
import com.intellij.jsf.model.xml.navigationRules.NavigationRule;
import com.intellij.jsf.references.JsfResourceIdentifierReferenceSet;
import com.intellij.jsf.references.JsfResourceNameReference;
import com.intellij.jsf.references.libraries.extensions.iceFaces.IceFacesAceProvider;
import com.intellij.jsf.references.libraries.extensions.iceFaces.IceFacesProvider;
import com.intellij.jsf.references.libraries.extensions.openfaces.OpenFacesProvider;
import com.intellij.jsf.references.libraries.extensions.primeFaces.PrimeFaces_1_2_Provider;
import com.intellij.jsf.references.libraries.extensions.primeFaces.PrimeFaces_3_4_Provider;
import com.intellij.jsf.references.libraries.extensions.richFaces.RichFacesProvider;
import com.intellij.jsf.utils.FacesConfigTemplateManager;
import com.intellij.jsp.impl.TldTagDescriptorImpl;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.libraries.JarVersionDetectionUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.jsp.WebDirectoryUtil;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.JspUtil;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.jsp.el.ELElementVisitor;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.jsp.el.ELVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.xml.util.XmlUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsfCommonUtils {
    private static final String INCLUDE_TAG_NAME = "include";

    private JsfCommonUtils() {
    }

    public static boolean isJsf_2_0(@Nullable Module module) {
        if (module == null) {
            return false;
        }
        PsiClass managedBeanAnno = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("javax.faces.bean.ManagedBean", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        return managedBeanAnno != null;
    }

    public static boolean isJsf_2_2(@Nullable Module module) {
        return JsfCommonUtils.isFlowSupported(module);
    }

    public static boolean isFlowSupported(@Nullable Module module) {
        if (module == null) {
            return false;
        }
        Project project = module.getProject();
        return (Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
            PsiClass managedBeanAnno = JavaPsiFacade.getInstance((Project)project).findClass("javax.faces.flow.builder.FlowDefinition", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
            return managedBeanAnno != null;
        });
    }

    public static boolean isJsfSupported(@Nullable Module module) {
        return module != null && JsfCommonUtils.isModuleContainsJsf(module);
    }

    public static boolean isModuleContainsJsf(@NotNull Module module) {
        if (module == null) {
            JsfCommonUtils.$$$reportNull$$$0(0);
        }
        return (Boolean)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            if (module == null) {
                JsfCommonUtils.$$$reportNull$$$0(28);
            }
            return CachedValueProvider.Result.create((Object)JsfCommonUtils.calcContainsJsf(module), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    private static boolean calcContainsJsf(@NotNull Module module) {
        if (module == null) {
            JsfCommonUtils.$$$reportNull$$$0(1);
        }
        Query allDirs = DirectoryIndex.getInstance((Project)module.getProject()).getDirectoriesByPackageName("javax.faces.application", false);
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        return ContainerUtil.exists((Iterable)allDirs.findAll(), dir -> scope.contains(dir) && dir.findChild("ApplicationFactory.class") != null);
    }

    public static Collection<JspFile> getIncludes(FacesConfig facesConfig, String pageId) {
        JspFile file = JsfCommonUtils.getJspFile(facesConfig, pageId);
        if (file != null) {
            return JspUtil.collectAllIncludedFilesRecursively((BaseJspFile)file, (boolean)true);
        }
        return Collections.emptyList();
    }

    public static Set<XmlTag> getManagedBeansForPage(FacesConfig facesConfig, String pageId) {
        JspFile file = JsfCommonUtils.getJspFile(facesConfig, pageId);
        if (file != null) {
            return JsfCommonUtils.getManagedBeansForPage(file);
        }
        return Collections.emptySet();
    }

    @Nullable
    private static JspFile getJspFile(FacesConfig facesConfig, String pageId) {
        PsiFileSystemItem element;
        Project project;
        WebFacet webFacet;
        VirtualFile file = JsfCommonUtils.getFileByRelativePath(facesConfig, pageId);
        if (file != null && (webFacet = WebUtil.getWebFacet((VirtualFile)file, (Project)(project = facesConfig.getManager().getProject()))) != null && (element = WebDirectoryUtil.getWebDirectoryUtil((Project)project).findFileByPath(pageId, webFacet)) instanceof JspFile) {
            return (JspFile)element;
        }
        return null;
    }

    private static Set<XmlTag> getManagedBeansForPage(JspFile jsp) {
        final HashSet<XmlTag> variables = new HashSet<XmlTag>();
        jsp.accept((PsiElementVisitor)new ELElementVisitor(){

            public void visitELExpressionHolder(ELExpressionHolder holder) {
                if (holder.isJSFELHolder()) {
                    variables.addAll(JsfCommonUtils.getReferences(holder));
                }
            }

            public void visitElement(PsiElement element) {
                element.acceptChildren((PsiElementVisitor)this);
                super.visitElement(element);
            }
        });
        return variables;
    }

    private static Set<XmlTag> getReferences(ELExpressionHolder holder) {
        final HashSet<XmlTag> variables = new HashSet<XmlTag>();
        holder.accept((PsiElementVisitor)new ELElementVisitor(){

            public void visitELVariable(@NotNull ELVariable variable) {
                if (variable == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (PsiReference reference : variable.getReferences()) {
                    PsiElement psiElement = reference.resolve();
                    if (!(psiElement instanceof XmlTag) || !((XmlTag)psiElement).getName().equals("managed-bean")) continue;
                    variables.add((XmlTag)psiElement);
                }
            }

            public void visitElement(PsiElement element) {
                element.acceptChildren((PsiElementVisitor)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/jsf/utils/JsfCommonUtils$2", "visitELVariable"));
            }
        });
        return variables;
    }

    public static List<XmlAttributeValue> getRuntimeIncludes(FacesConfig facesConfig, String pageId) {
        JspFile file = JsfCommonUtils.getJspFile(facesConfig, pageId);
        if (file != null) {
            return JsfCommonUtils.getRuntimeIncludes(file);
        }
        return Collections.emptyList();
    }

    private static List<XmlAttributeValue> getRuntimeIncludes(JspFile jsp) {
        return JsfCommonUtils.getRuntimeIncludes(jsp.getDocument().getRootTag());
    }

    private static List<XmlAttributeValue> getRuntimeIncludes(XmlTag rootTag) {
        ArrayList<XmlAttributeValue> result = new ArrayList<XmlAttributeValue>();
        if (rootTag != null) {
            for (XmlTag tag : rootTag.getSubTags()) {
                if (INCLUDE_TAG_NAME.equals(tag.getLocalName()) && "http://java.sun.com/JSP/Page".equals(tag.getNamespace())) {
                    XmlAttributeValue valueElement;
                    XmlAttribute attribute = tag.getAttribute("page", null);
                    if (attribute == null || (valueElement = attribute.getValueElement()) == null) continue;
                    result.add(valueElement);
                    continue;
                }
                result.addAll(JsfCommonUtils.getRuntimeIncludes(tag));
            }
        }
        return result;
    }

    @Nullable
    public static FacesConfig getFacesConfigForFile(WebFacet webFacet, VirtualFile file) {
        Project project = webFacet.getModule().getProject();
        for (FacesDomModel facesDomModel : FacesDomModelManager.getInstance(project).getAllModels(webFacet)) {
            FacesConfig facesConfig = facesDomModel.getFacesConfig();
            if (JsfCommonUtils.getViewId(facesConfig, file) == null) continue;
            return facesConfig;
        }
        return null;
    }

    @Nullable
    public static GenericValue<PathReference> getViewId(@NotNull FacesConfig facesConfig, VirtualFile file) {
        if (facesConfig == null) {
            JsfCommonUtils.$$$reportNull$$$0(2);
        }
        for (NavigationRule navigationRule : facesConfig.getNavigationRules()) {
            if (JsfCommonUtils.isResolved((PathReference)navigationRule.getFromViewId().getValue(), file)) {
                return navigationRule.getFromViewId();
            }
            for (NavigationCase navigationCase : navigationRule.getNavigationCases()) {
                if (!JsfCommonUtils.isResolved((PathReference)navigationCase.getToViewId().getValue(), file)) continue;
                return navigationCase.getToViewId();
            }
        }
        return null;
    }

    private static boolean isResolved(PathReference value, VirtualFile file) {
        PsiElement psiElement;
        return value != null && (psiElement = value.resolve()) instanceof PsiFile && file.equals(((PsiFile)psiElement).getVirtualFile());
    }

    @Nullable
    public static VirtualFile getFileByRelativePath(FacesConfig facesConfig, String pageId) {
        if (pageId == null || pageId.trim().length() == 0 || facesConfig == null) {
            return null;
        }
        XmlFile xmlFile = (XmlFile)DomUtil.getFile((DomElement)facesConfig).getOriginalFile();
        Project project = facesConfig.getManager().getProject();
        VirtualFile virtualFile = xmlFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        WebFacet webFacet = WebUtil.getWebFacet((VirtualFile)virtualFile, (Project)project);
        VirtualFile file = JsfCommonUtils.getFileByRelativePath(webFacet, pageId);
        if (file != null) {
            return file;
        }
        PathReference webPath = JsfCommonUtils.getWebPath(facesConfig, pageId);
        if (webPath != null) {
            PsiElement element = webPath.resolve();
            if (element instanceof PsiFile) {
                return ((PsiFile)element).getVirtualFile();
            }
            if (element instanceof PsiDirectory) {
                return ((PsiDirectory)element).getVirtualFile();
            }
        }
        return null;
    }

    @Nullable
    private static PathReference getWebPath(FacesConfig facesConfig, String pageId) {
        for (NavigationRule rule : facesConfig.getNavigationRules()) {
            if (pageId.equals(rule.getFromViewId().getStringValue())) {
                return (PathReference)rule.getFromViewId().getValue();
            }
            for (NavigationCase aCase : rule.getNavigationCases()) {
                if (!pageId.equals(aCase.getToViewId().getStringValue())) continue;
                return (PathReference)aCase.getToViewId().getValue();
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile getFileByRelativePath(@Nullable WebFacet webFacet, String pageId) {
        if (webFacet == null || pageId == null) {
            return null;
        }
        return WebDirectoryUtil.getWebDirectoryUtil((Project)webFacet.getModule().getProject()).findVirtualFileByPath(pageId, webFacet);
    }

    public static void navigate(FacesConfig facesConfig, String pageName) {
        VirtualFile virtualFile = JsfCommonUtils.getFileByRelativePath(facesConfig, pageName);
        if (virtualFile != null) {
            if (virtualFile.isDirectory()) {
                PsiDirectory psiDirectory = PsiManager.getInstance((Project)facesConfig.getManager().getProject()).findDirectory(virtualFile);
                if (psiDirectory != null) {
                    psiDirectory.navigate(false);
                }
            } else {
                Project project = facesConfig.getManager().getProject();
                OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(project, virtualFile);
                FileEditorManager.getInstance((Project)project).openEditor(openFileDescriptor, true);
            }
        }
    }

    @Nullable
    public static String getRelatedPath(Project project, VirtualFile file) {
        return JsfCommonUtils.getRelatedPath(PsiManager.getInstance((Project)project).findFile(file));
    }

    @Nullable
    public static String getRelatedPath(PsiFile psiFile) {
        WebRoot webRoot;
        if (psiFile == null) {
            return null;
        }
        WebFacet webFacet = WebUtil.getWebFacet((PsiElement)psiFile);
        if (webFacet != null && (webRoot = WebUtil.findParentWebRoot((VirtualFile)psiFile.getVirtualFile(), (List)webFacet.getWebRoots())) != null) {
            String webRootPath = webRoot.getRelativePath();
            String relativePath = (webRootPath = webRootPath + (webRootPath.equals("/") ? "" : "/")) + VfsUtilCore.getRelativePath((VirtualFile)psiFile.getVirtualFile(), (VirtualFile)webRoot.getFile(), (char)'/');
            if (relativePath != null) {
                return relativePath;
            }
        }
        String name = psiFile.getName();
        assert (name != null) : psiFile.getVirtualFile();
        return name;
    }

    public static boolean isFacesComponentTag(XmlTag tag) {
        String tagNamespace = tag.getNamespace();
        if (Arrays.asList(XmlUtil.JSF_CORE_URIS).contains(tagNamespace)) {
            return true;
        }
        if (tag.getDescriptor() instanceof TldTagDescriptorImpl) {
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)tag);
            TldTagDescriptorImpl descriptor = (TldTagDescriptorImpl)tag.getDescriptor();
            if (descriptor != null) {
                return descriptor.isJsfComponent(module);
            }
        }
        return false;
    }

    public static String getFacesConfigTemplateText(@Nullable String version) throws IOException {
        return FacesConfigTemplateManager.getFacesConfigTemplateText(version);
    }

    public static String getFacesConfigTemplateTextForModule(@Nullable Module module) throws IOException {
        String version;
        if (module != null && (version = JarVersionDetectionUtil.detectJarVersion((String)"javax.faces.webapp.FacesServlet", (Module)module)) != null) {
            return FacesConfigTemplateManager.getFacesConfigTemplateText(version);
        }
        version = JsfCommonUtils.isJsf_2_2(module) ? FacesConfigTemplateManager.FacesConfigVersion.VERSION_2_2.getVersionName() : FacesConfigTemplateManager.FacesConfigVersion.VERSION_2_0.getVersionName();
        return FacesConfigTemplateManager.getFacesConfigTemplateText(version);
    }

    @NotNull
    public static Set<PsiDirectory> getTopLevelResourcesDirectories(@Nullable Module module) {
        HashSet<PsiDirectory> dirs = new HashSet<PsiDirectory>();
        if (module != null) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
            JsfCommonUtils.collectMetaInfResources(dirs, facade);
            JsfCommonUtils.collectSourceResources(dirs, facade);
            JsfCommonUtils.collectWebAppResources(dirs, module);
            dirs.addAll(JsfCommonUtils.getContractsDirectories(module));
        }
        HashSet<PsiDirectory> hashSet = dirs;
        if (hashSet == null) {
            JsfCommonUtils.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    private static void collectWebAppResources(Set<PsiDirectory> dirs, Module module) {
        Collection webFacets = WebFacet.getInstances((Module)module);
        for (WebFacet webFacet : webFacets) {
            String contextParamResourceDirectory = null;
            ParamValue contextParameter = JsfCommonUtils.findContextParameter(webFacet, "javax.faces.WEBAPP_RESOURCES_DIRECTORY");
            if (contextParameter != null) {
                contextParamResourceDirectory = contextParameter.getParamValue().getStringValue();
            }
            for (WebRoot root : webFacet.getWebRoots()) {
                VirtualFile file = root.getFile();
                if (file == null) continue;
                JsfCommonUtils.addResourceDir(dirs, module, file.findChild("resources"));
                JsfCommonUtils.addResourceDir(dirs, module, file.findFileByRelativePath("WEB-INF/resources"));
                if (contextParamResourceDirectory == null) continue;
                JsfCommonUtils.addResourceDir(dirs, module, file.findFileByRelativePath(contextParamResourceDirectory));
            }
        }
    }

    private static void addResourceDir(@NotNull Set<PsiDirectory> dirs, @NotNull Module module, @Nullable VirtualFile resources) {
        PsiDirectory psiDirectory;
        if (dirs == null) {
            JsfCommonUtils.$$$reportNull$$$0(4);
        }
        if (module == null) {
            JsfCommonUtils.$$$reportNull$$$0(5);
        }
        if (resources != null && (psiDirectory = PsiManager.getInstance((Project)module.getProject()).findDirectory(resources)) != null) {
            dirs.add(psiDirectory);
        }
    }

    public static Set<PsiDirectory> getMetaInfResources(@Nullable Module module) {
        HashSet<PsiDirectory> set = new HashSet<PsiDirectory>();
        if (module != null) {
            JsfCommonUtils.collectMetaInfResources(set, JavaPsiFacade.getInstance((Project)module.getProject()));
        }
        return set;
    }

    private static void collectSourceResources(Set<PsiDirectory> dirs, JavaPsiFacade facade) {
        JsfCommonUtils.collectDirectories(dirs, facade, "resources");
    }

    private static void collectMetaInfResources(Set<PsiDirectory> dirs, JavaPsiFacade facade) {
        JsfCommonUtils.collectDirectories(dirs, facade, "META-INF.resources");
    }

    @NotNull
    public static Set<PsiDirectory> getContractsDirectories(@Nullable Module module) {
        HashSet<PsiDirectory> dirs = new HashSet<PsiDirectory>();
        if (module != null) {
            JsfCommonUtils.collectMetaInfContractDirectories(dirs, JavaPsiFacade.getInstance((Project)module.getProject()), module);
            JsfCommonUtils.collectWebAppContracts(dirs, module);
        }
        HashSet<PsiDirectory> hashSet = dirs;
        if (hashSet == null) {
            JsfCommonUtils.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    private static void collectWebAppContracts(@NotNull Set<PsiDirectory> dirs, @NotNull Module module) {
        if (dirs == null) {
            JsfCommonUtils.$$$reportNull$$$0(7);
        }
        if (module == null) {
            JsfCommonUtils.$$$reportNull$$$0(8);
        }
        Collection webFacets = WebFacet.getInstances((Module)module);
        for (WebFacet webFacet : webFacets) {
            WebDirectoryElement[] contracts;
            WebDirectoryElement directoryElement = WebUtil.getWebUtil().findWebDirectoryElement("contracts", webFacet);
            if (directoryElement == null) continue;
            for (WebDirectoryElement contractDirectory : contracts = directoryElement.getChildren()) {
                List virtualFiles = contractDirectory.getOriginalVirtualFiles();
                for (VirtualFile virtualFile : virtualFiles) {
                    PsiDirectory psiDirectory = PsiManager.getInstance((Project)module.getProject()).findDirectory(virtualFile);
                    if (psiDirectory == null) continue;
                    dirs.add(psiDirectory);
                }
            }
        }
    }

    private static void collectMetaInfContractDirectories(@NotNull Set<PsiDirectory> dirs, @NotNull JavaPsiFacade facade, @NotNull Module module) {
        PsiPackage psiPackage;
        if (dirs == null) {
            JsfCommonUtils.$$$reportNull$$$0(9);
        }
        if (facade == null) {
            JsfCommonUtils.$$$reportNull$$$0(10);
        }
        if (module == null) {
            JsfCommonUtils.$$$reportNull$$$0(11);
        }
        if ((psiPackage = facade.findPackage("META-INF.contracts")) != null) {
            PsiPackage[] subPackages;
            for (PsiPackage subPackage : subPackages = psiPackage.getSubPackages(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module))) {
                ContainerUtil.addAll(dirs, (Object[])subPackage.getDirectories());
            }
        }
    }

    private static void collectDirectories(@NotNull Set<PsiDirectory> dirs, @NotNull JavaPsiFacade facade, @NotNull String qualifiedName) {
        PsiPackage psiPackage;
        if (dirs == null) {
            JsfCommonUtils.$$$reportNull$$$0(12);
        }
        if (facade == null) {
            JsfCommonUtils.$$$reportNull$$$0(13);
        }
        if (qualifiedName == null) {
            JsfCommonUtils.$$$reportNull$$$0(14);
        }
        if ((psiPackage = facade.findPackage(qualifiedName)) != null) {
            ContainerUtil.addAll(dirs, (Object[])psiPackage.getDirectories());
        }
    }

    public static Set<PsiDirectory> collectDirectories(Module module, String resourcesPath) {
        Set<PsiDirectory> directories = new HashSet<PsiDirectory>();
        Set<PsiDirectory> parentDirectories = JsfCommonUtils.getTopLevelResourcesDirectories(module);
        StringTokenizer tokenizer = new StringTokenizer(resourcesPath, "/");
        while (tokenizer.hasMoreTokens()) {
            String subDirectory = tokenizer.nextToken().trim();
            if (StringUtil.isEmptyOrSpaces((String)subDirectory)) {
                return Collections.emptySet();
            }
            directories = JsfCommonUtils.getSubdirectories(parentDirectories, subDirectory);
            if (!tokenizer.hasMoreTokens()) continue;
            parentDirectories = directories;
        }
        return directories;
    }

    private static Set<PsiDirectory> getSubdirectories(@NotNull Set<PsiDirectory> parentDirectories, @NotNull String subDirectory) {
        if (parentDirectories == null) {
            JsfCommonUtils.$$$reportNull$$$0(15);
        }
        if (subDirectory == null) {
            JsfCommonUtils.$$$reportNull$$$0(16);
        }
        HashSet<PsiDirectory> directories = new HashSet<PsiDirectory>();
        for (PsiDirectory parentDirectory : parentDirectories) {
            PsiDirectory psiDirectory = parentDirectory.findSubdirectory(subDirectory);
            if (psiDirectory == null) continue;
            directories.add(psiDirectory);
        }
        return directories;
    }

    public static PsiReference[] createTopLevelResourceIdentifierReferences(String contextValue, PsiElement psiElement) {
        return JsfCommonUtils.createResourceIdentifierReferences(contextValue, psiElement, "/");
    }

    private static PsiReference[] createResourceIdentifierReferences(String contextValue, PsiElement psiElement, String librarySeparator) {
        return JsfCommonUtils.getResourceIdentifierReferences(contextValue, psiElement, librarySeparator, (Function<String, JsfResourceIdentifierReferenceSet>)((Function)libraryPath -> new JsfResourceIdentifierReferenceSet(psiElement, (String)libraryPath, '/', 1)));
    }

    public static PsiReference[] createResourceIdentifierReferences(String resourceIdentifier, PsiElement psiElement, final @NotNull Set<PsiDirectory> contexts) {
        if (contexts == null) {
            JsfCommonUtils.$$$reportNull$$$0(17);
        }
        return JsfCommonUtils.getResourceIdentifierReferences(resourceIdentifier, psiElement, "/", (Function<String, JsfResourceIdentifierReferenceSet>)((Function)resourcePath -> {
            if (contexts == null) {
                JsfCommonUtils.$$$reportNull$$$0(27);
            }
            return new JsfResourceIdentifierReferenceSet(psiElement, (String)resourcePath, '/', 1){

                @Override
                @NotNull
                public Set<PsiDirectory> getResourceLibraryDirectories() {
                    Set set = contexts;
                    if (set == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return set;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/utils/JsfCommonUtils$3", "getResourceLibraryDirectories"));
                }
            };
        }));
    }

    private static PsiReference[] getResourceIdentifierReferences(String resourceIdentifier, PsiElement psiElement, String librarySeparator, Function<String, JsfResourceIdentifierReferenceSet> libraryReferenceSetFactory) {
        int lastSeparator = resourceIdentifier.lastIndexOf(librarySeparator);
        String libraryPath = lastSeparator < 0 ? resourceIdentifier : resourceIdentifier.substring(0, lastSeparator);
        String resourceName = lastSeparator < 0 ? "" : resourceIdentifier.substring(lastSeparator + 1);
        JsfResourceIdentifierReferenceSet libraryReferenceSet = (JsfResourceIdentifierReferenceSet)((Object)libraryReferenceSetFactory.fun((Object)libraryPath));
        Object[] psiReferences = libraryReferenceSet.getPsiReferences();
        TextRange textRange = TextRange.from((int)(psiElement.getText().lastIndexOf(librarySeparator) + 1), (int)resourceName.length());
        return (PsiReference[])ArrayUtil.append((Object[])psiReferences, (Object)JsfCommonUtils.createResourceReferenceWithSeparatedLibrary(psiElement, textRange, libraryReferenceSet));
    }

    public static PsiReference[] createLibraryWithResourceReferences(String contextValue, PsiElement psiElement) {
        return JsfCommonUtils.createResourceIdentifierReferences(contextValue, psiElement, ":");
    }

    private static PsiReference createResourceReferenceWithSeparatedLibrary(PsiElement psiElement, TextRange textRange, final JsfResourceIdentifierReferenceSet referenceSet) {
        return new JsfResourceNameReference<PsiLiteralExpression>(psiElement, textRange, true){

            @Override
            public Set<PsiDirectory> getLibraries() {
                return referenceSet.getLibraries();
            }
        };
    }

    @NotNull
    public static Set<PsiDirectory> getTopLevelLibraryDirectories(@Nullable Module module) {
        Set<PsiDirectory> set = JsfCommonUtils.getTopLevelResourcesDirectories(module);
        if (set == null) {
            JsfCommonUtils.$$$reportNull$$$0(18);
        }
        return set;
    }

    public static Set<PsiDirectory> getResourceLibraryDirectories(@Nullable Module module, @Nullable String libraryName) {
        Set<PsiDirectory> topLevelResourcesDirectories = JsfCommonUtils.getTopLevelResourcesDirectories(module);
        if (StringUtil.isEmptyOrSpaces((String)libraryName)) {
            return topLevelResourcesDirectories;
        }
        com.intellij.util.containers.HashSet directories = new com.intellij.util.containers.HashSet();
        for (PsiDirectory directory : topLevelResourcesDirectories) {
            PsiDirectory subdirectory = directory.findSubdirectory(libraryName);
            if (subdirectory == null) continue;
            directories.add(subdirectory);
        }
        return directories;
    }

    public static Set<PsiDirectory> getResourceLibraryDirectoriesWithVersions(@Nullable Module module, @Nullable String libraryName) {
        return JsfCommonUtils.filterResourceLibraryVersionDirectories(JsfCommonUtils.getResourceLibraryDirectories(module, libraryName));
    }

    @NotNull
    public static Set<PsiDirectory> filterResourceLibraryVersionDirectories(@NotNull Set<PsiDirectory> directories) {
        if (directories == null) {
            JsfCommonUtils.$$$reportNull$$$0(19);
        }
        com.intellij.util.containers.HashSet actualDirectories = new com.intellij.util.containers.HashSet();
        for (PsiDirectory directory : directories) {
            Set<PsiDirectory> versions = JsfCommonUtils.getVersions(directory);
            if (versions.size() == 0) {
                actualDirectories.add(directory);
                continue;
            }
            actualDirectories.addAll(versions);
        }
        com.intellij.util.containers.HashSet hashSet = actualDirectories;
        if (hashSet == null) {
            JsfCommonUtils.$$$reportNull$$$0(20);
        }
        return hashSet;
    }

    @NotNull
    public static Set<PsiDirectory> getVersions(@NotNull PsiDirectory subdirectory) {
        if (subdirectory == null) {
            JsfCommonUtils.$$$reportNull$$$0(21);
        }
        com.intellij.util.containers.HashSet directories = new com.intellij.util.containers.HashSet();
        Pattern pattern = Pattern.compile("[0-9]+(_[0-9]+)*");
        for (PsiDirectory psiDirectory : subdirectory.getSubdirectories()) {
            String name = psiDirectory.getName();
            if (!pattern.matcher(name).matches()) continue;
            directories.add(psiDirectory);
        }
        com.intellij.util.containers.HashSet hashSet = directories;
        if (hashSet == null) {
            JsfCommonUtils.$$$reportNull$$$0(22);
        }
        return hashSet;
    }

    @Nullable
    public static PsiType getManagedPropertyExpectedType(@Nullable ManagedProperty property) {
        if (property instanceof ValuableProperty) {
            return (PsiType)((ValuableProperty)property).getPropertyClass().getValue();
        }
        if (property instanceof MapEntriesProperty) {
            return JsfCommonUtils.findClass(property.getModule(), "java.util.Map");
        }
        if (property instanceof ListEntriesProperty) {
            return JsfCommonUtils.findClass(property.getModule(), "java.util.List");
        }
        return null;
    }

    @Nullable
    private static PsiClassType findClass(@Nullable Module module, @NotNull String s) {
        if (s == null) {
            JsfCommonUtils.$$$reportNull$$$0(23);
        }
        if (module == null) {
            return null;
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(s, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        return psiClass == null ? null : JavaPsiFacade.getInstance((Project)module.getProject()).getElementFactory().createType(psiClass);
    }

    @NotNull
    public static List<FacesDomModel> getAllFacesModels(@NotNull Module module) {
        if (module == null) {
            JsfCommonUtils.$$$reportNull$$$0(24);
        }
        ArrayList<FacesDomModel> models = new ArrayList<FacesDomModel>();
        for (WebFacet webFacet : WebFacet.getInstances((Module)module)) {
            models.addAll(FacesDomModelManager.getInstance(module.getProject()).getAllModels(webFacet));
        }
        ArrayList<FacesDomModel> arrayList = models;
        if (arrayList == null) {
            JsfCommonUtils.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @NotNull
    public static Set<JsfCommonConverter> getJsfConverters(@Nullable Module module) {
        com.intellij.util.containers.HashSet converters = new com.intellij.util.containers.HashSet();
        if (module != null) {
            for (JsfConvertersDiscoverer discoverer : (JsfConvertersDiscoverer[])Extensions.getExtensions(JsfConvertersDiscoverer.EP_NAME)) {
                discoverer.addJsfConverters(module, (Set<JsfCommonConverter>)converters);
            }
        }
        com.intellij.util.containers.HashSet hashSet = converters;
        if (hashSet == null) {
            JsfCommonUtils.$$$reportNull$$$0(26);
        }
        return hashSet;
    }

    @Nullable
    public static ParamValue findContextParameter(WebFacet webFacet, String paramName) {
        WebApp root = webFacet.getRoot();
        if (root == null) {
            return null;
        }
        List parameters = root.getContextParams();
        for (ParamValue param : parameters) {
            if (!paramName.equals(param.getParamName().getValue())) continue;
            return param;
        }
        return null;
    }

    public static Set<String> getJsfNamespaces() {
        com.intellij.util.containers.HashSet namespaces = new com.intellij.util.containers.HashSet();
        namespaces.add("http://java.sun.com/jsf/html");
        namespaces.add("http://xmlns.jcp.org/jsf/html");
        namespaces.add("http://java.sun.com/jsf/core");
        namespaces.add("http://xmlns.jcp.org/jsf/core");
        namespaces.add("http://xmlns.jcp.org/jsf");
        namespaces.addAll(Arrays.asList(RichFacesProvider.NAMESPACES));
        namespaces.addAll(Arrays.asList(OpenFacesProvider.NAMESPACES));
        namespaces.addAll(Arrays.asList(PrimeFaces_1_2_Provider.NAMESPACES));
        namespaces.addAll(Arrays.asList(PrimeFaces_3_4_Provider.NAMESPACES));
        namespaces.addAll(Arrays.asList(IceFacesProvider.NAMESPACES));
        namespaces.addAll(Arrays.asList(IceFacesAceProvider.NAMESPACES));
        return namespaces;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facesConfig";
                break;
            }
            case 3: 
            case 6: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsf/utils/JsfCommonUtils";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDirectories";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subDirectory";
                break;
            }
            case 17: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contexts";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directories";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subdirectory";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsf/utils/JsfCommonUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelResourcesDirectories";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContractsDirectories";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelLibraryDirectories";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "filterResourceLibraryVersionDirectories";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersions";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFacesModels";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getJsfConverters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isModuleContainsJsf";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calcContainsJsf";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getViewId";
                break;
            }
            case 3: 
            case 6: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 26: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addResourceDir";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectWebAppContracts";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectMetaInfContractDirectories";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectDirectories";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSubdirectories";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createResourceIdentifierReferences";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "filterResourceLibraryVersionDirectories";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getVersions";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAllFacesModels";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createResourceIdentifierReferences$4";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isModuleContainsJsf$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

