/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;
import org.jetbrains.idea.devkit.inspections.RegistrationCheckerUtil;
import org.jetbrains.idea.devkit.inspections.quickfix.RegisterActionFix;
import org.jetbrains.idea.devkit.inspections.quickfix.RegisterComponentFix;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.ComponentType;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class ComponentNotRegisteredInspection
extends DevKitInspectionBase {
    public boolean CHECK_ACTIONS = true;
    public boolean IGNORE_NON_PUBLIC = true;
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.idea.devkit.inspections.ComponentNotRegisteredInspection");
    private static final Map<ComponentType, RegistrationCheckerUtil.RegistrationType> COMPONENT_TYPE_TO_REGISTRATION_TYPE = ContainerUtil.immutableMapBuilder().put((Object)ComponentType.APPLICATION, (Object)RegistrationCheckerUtil.RegistrationType.APPLICATION_COMPONENT).put((Object)ComponentType.PROJECT, (Object)RegistrationCheckerUtil.RegistrationType.PROJECT_COMPONENT).put((Object)ComponentType.MODULE, (Object)RegistrationCheckerUtil.RegistrationType.MODULE_COMPONENT).build();

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        final JCheckBox ignoreNonPublic = new JCheckBox(DevKitBundle.message("inspections.component.not.registered.option.ignore.non.public", new Object[0]), this.IGNORE_NON_PUBLIC);
        ignoreNonPublic.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ComponentNotRegisteredInspection.this.IGNORE_NON_PUBLIC = ignoreNonPublic.isSelected();
            }
        });
        final JCheckBox checkJavaActions = new JCheckBox(DevKitBundle.message("inspections.component.not.registered.option.check.actions", new Object[0]), this.CHECK_ACTIONS);
        checkJavaActions.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean selected;
                ComponentNotRegisteredInspection.this.CHECK_ACTIONS = selected = checkJavaActions.isSelected();
                ignoreNonPublic.setEnabled(selected);
            }
        });
        jPanel.add(checkJavaActions);
        jPanel.add(ignoreNonPublic);
        return jPanel;
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass checkedClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiIdentifier classIdentifier;
        if (checkedClass == null) {
            ComponentNotRegisteredInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ComponentNotRegisteredInspection.$$$reportNull$$$0(1);
        }
        if (!((classIdentifier = checkedClass.getNameIdentifier()) == null || checkedClass.getQualifiedName() == null || checkedClass.getContainingFile().getVirtualFile() == null || checkedClass.hasModifierProperty("abstract") || checkedClass.isEnum() || com.intellij.psi.util.PsiUtil.isInnerClass((PsiClass)checkedClass))) {
            PsiClass compClass;
            GlobalSearchScope scope = checkedClass.getResolveScope();
            if (this.shouldCheckActionClass(checkedClass)) {
                PsiClass actionClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(AnAction.class.getName(), scope);
                if (actionClass == null) {
                    return null;
                }
                if (checkedClass.isInheritor(actionClass, true)) {
                    if (!ComponentNotRegisteredInspection.isActionRegistered(checkedClass) && ComponentNotRegisteredInspection.canFix(checkedClass)) {
                        RegisterActionFix fix = new RegisterActionFix(PsiUtil.createPointer(checkedClass));
                        ProblemDescriptor problem = manager.createProblemDescriptor((PsiElement)classIdentifier, DevKitBundle.message("inspections.component.not.registered.message", DevKitBundle.message("new.menu.action.text", new Object[0])), (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
                        return new ProblemDescriptor[]{problem};
                    }
                    return null;
                }
            }
            if ((compClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(BaseComponent.class.getName(), scope)) == null) {
                return null;
            }
            if (!checkedClass.isInheritor(compClass, true)) {
                return null;
            }
            for (ComponentType componentType : ComponentType.values()) {
                if (!InheritanceUtil.isInheritor((PsiClass)checkedClass, (String)componentType.myClassName)) continue;
                if (ComponentNotRegisteredInspection.findRegistrationType(checkedClass, COMPONENT_TYPE_TO_REGISTRATION_TYPE.get((Object)componentType)) != null) {
                    return null;
                }
                if (!ComponentNotRegisteredInspection.canFix(checkedClass)) {
                    return null;
                }
                RegisterComponentFix fix = new RegisterComponentFix(componentType, PsiUtil.createPointer(checkedClass));
                ProblemDescriptor problem = manager.createProblemDescriptor((PsiElement)classIdentifier, DevKitBundle.message("inspections.component.not.registered.message", DevKitBundle.message(componentType.myPropertyKey, new Object[0])), (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
                return new ProblemDescriptor[]{problem};
            }
        }
        return null;
    }

    private static PsiClass findRegistrationType(@Nullable PsiClass checkedClass, RegistrationCheckerUtil.RegistrationType type) {
        Set<PsiClass> types = RegistrationCheckerUtil.getRegistrationTypes(checkedClass, type);
        return (PsiClass)ContainerUtil.getFirstItem(types);
    }

    private boolean shouldCheckActionClass(PsiClass psiClass) {
        if (!this.CHECK_ACTIONS) {
            return false;
        }
        return !this.IGNORE_NON_PUBLIC || psiClass.hasModifierProperty("public");
    }

    private static boolean isActionRegistered(PsiClass actionClass) {
        PsiClass registrationType = ComponentNotRegisteredInspection.findRegistrationType(actionClass, RegistrationCheckerUtil.RegistrationType.ACTION);
        if (registrationType != null) {
            return true;
        }
        for (PsiMethod method : actionClass.getConstructors()) {
            Query search = MethodReferencesSearch.search((PsiMethod)method);
            if (search.findFirst() == null) continue;
            return true;
        }
        Query search = ReferencesSearch.search((PsiElement)actionClass);
        for (PsiReference reference : search) {
            PsiJavaCodeReferenceElement classReference;
            PsiNewExpression newExpression;
            if (!(reference instanceof PsiJavaCodeReferenceElement) || (newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiNewExpression.class)) == null || (classReference = newExpression.getClassReference()) == null || !classReference.getQualifiedName().equals(actionClass.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static boolean canFix(PsiClass psiClass) {
        Project project = psiClass.getProject();
        PsiFile psiFile = psiClass.getContainingFile();
        LOG.assertTrue(psiFile != null);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)psiFile.getVirtualFile(), (Project)project);
        return PluginModuleType.isPluginModuleOrDependency(module) || module != null && PsiUtil.isPluginModule(module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "checkedClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/devkit/inspections/ComponentNotRegisteredInspection";
        objectArray[2] = "checkClass";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

