/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;
import org.jetbrains.idea.devkit.inspections.quickfix.ChangeToPairCreateQuickFix;

public class DontUseNewPairInspection
extends DevKitInspectionBase {
    private static final String PAIR_FQN = "com.intellij.openapi.util.Pair";

    @Override
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DontUseNewPairInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitNewExpression(PsiNewExpression expression) {
                Object[] types;
                PsiType type = expression.getType();
                PsiExpressionList params = expression.getArgumentList();
                if (type instanceof PsiClassType && ((PsiClassType)type).rawType().equalsToText(DontUseNewPairInspection.PAIR_FQN) && params != null && expression.getArgumentList() != null && !PsiUtil.getLanguageLevel((PsiElement)expression).isAtLeast(LanguageLevel.JDK_1_7) && Arrays.equals(types = ((PsiClassType)type).getParameters(), params.getExpressionTypes())) {
                    holder.registerProblem((PsiElement)expression, "Replace to Pair.create()", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ChangeToPairCreateQuickFix()});
                }
                super.visitNewExpression(expression);
            }
        };
    }

    @NotNull
    public String getShortName() {
        if ("DontUsePairConstructor" == null) {
            DontUseNewPairInspection.$$$reportNull$$$0(1);
        }
        return "DontUsePairConstructor";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/internal/DontUseNewPairInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/DontUseNewPairInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildInternalVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

