/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;
import org.jetbrains.idea.devkit.inspections.quickfix.UseCoupleQuickFix;

public class UseCoupleInspection
extends DevKitInspectionBase {
    private static final String PAIR_FQN = "com.intellij.openapi.util.Pair";

    @Override
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UseCoupleInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitTypeElement(PsiTypeElement type) {
                String genericTypes;
                List types;
                String canonicalText = type.getType().getCanonicalText();
                if (canonicalText.startsWith(UseCoupleInspection.PAIR_FQN) && canonicalText.contains("<") && canonicalText.endsWith(">") && (types = StringUtil.split((String)(genericTypes = canonicalText.substring(canonicalText.indexOf(60) + 1, canonicalText.length() - 1)), (String)",")).size() == 2 && StringUtil.equals((CharSequence)((CharSequence)types.get(0)), (CharSequence)((CharSequence)types.get(1)))) {
                    List parts = StringUtil.split((String)((String)types.get(0)), (String)".");
                    String typeName = (String)parts.get(parts.size() - 1);
                    String name = "Change to Couple<" + typeName + ">";
                    holder.registerProblem((PsiElement)type, name, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new UseCoupleQuickFix(name)});
                }
                super.visitTypeElement(type);
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                PsiType[] types;
                PsiClass psiClass;
                PsiElement method;
                PsiReference reference;
                if (expression.getText().startsWith("Pair.create") && (reference = expression.getMethodExpression().getReference()) != null && (method = reference.resolve()) instanceof PsiMethod && (psiClass = ((PsiMethod)method).getContainingClass()) != null && UseCoupleInspection.PAIR_FQN.equals(psiClass.getQualifiedName()) && (types = expression.getArgumentList().getExpressionTypes()).length == 2 && types[0].equals(types[1])) {
                    String name = "Change to Couple.of";
                    holder.registerProblem((PsiElement)expression, "Change to Couple.of", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new UseCoupleQuickFix("Change to Couple.of")});
                }
                super.visitMethodCallExpression(expression);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/idea/devkit/inspections/internal/UseCoupleInspection", "buildInternalVisitor"));
    }
}

