/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.annotations.NotNull;

public class UseCoupleQuickFix
extends LocalQuickFixBase {
    private static final String COUPLE_FQN = "com.intellij.openapi.util.Couple";

    public UseCoupleQuickFix(String text) {
        super(text);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement newElement;
        if (project == null) {
            UseCoupleQuickFix.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            UseCoupleQuickFix.$$$reportNull$$$0(1);
        }
        PsiElement element = descriptor.getPsiElement();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        if (element instanceof PsiTypeElement) {
            String canonicalText = ((PsiTypeElement)element).getType().getCanonicalText();
            String type = canonicalText.substring(canonicalText.indexOf(60) + 1, canonicalText.indexOf(44));
            PsiTypeElement newType = factory.createTypeElementFromText("com.intellij.openapi.util.Couple<" + type + ">", element.getContext());
            newElement = element.replace((PsiElement)newType);
        } else {
            String text = "com.intellij.openapi.util.Couple.of" + element.getText().substring("Pair.create".length());
            PsiExpression expression = factory.createExpressionFromText(text, element.getContext());
            newElement = element.replace((PsiElement)expression);
        }
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(newElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptor";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/devkit/inspections/quickfix/UseCoupleQuickFix";
        objectArray[2] = "applyFix";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

