/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessorBase;
import com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.annotations.NotNull;

public class CssPsiTreeChangeProcessor
extends PsiTreeChangePreprocessorBase {
    public static final SimpleModificationTracker CSS_MODIFICATION_TRACKER = new SimpleModificationTracker();

    @NotNull
    public static ModificationTracker getCssModificationTracker(@NotNull PsiManager manager) {
        PsiModificationTracker tracker;
        ModificationTracker cssTracker;
        if (manager == null) {
            CssPsiTreeChangeProcessor.$$$reportNull$$$0(0);
        }
        Object object = (cssTracker = ((PsiModificationTrackerImpl)(tracker = manager.getModificationTracker())).forLanguages(language -> language.isKindOf((Language)CSSLanguage.INSTANCE))) == tracker && tracker.getOutOfCodeBlockModificationTracker() != tracker ? CSS_MODIFICATION_TRACKER : cssTracker;
        if (object == null) {
            CssPsiTreeChangeProcessor.$$$reportNull$$$0(1);
        }
        return object;
    }

    public CssPsiTreeChangeProcessor(@NotNull PsiManager psiManager) {
        if (psiManager == null) {
            CssPsiTreeChangeProcessor.$$$reportNull$$$0(2);
        }
        super(psiManager);
    }

    protected boolean acceptsEvent(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            CssPsiTreeChangeProcessor.$$$reportNull$$$0(3);
        }
        return event.getFile() instanceof StylesheetFile || CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)event.getFile());
    }

    protected void onTreeChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            CssPsiTreeChangeProcessor.$$$reportNull$$$0(4);
        }
        if (event.getParent() instanceof PsiFileSystemItem) {
            CSS_MODIFICATION_TRACKER.incModificationCount();
        } else {
            PsiElement child = event.getChild();
            if (child != null && !(child instanceof SyntheticElement) && CssPsiUtil.getStylesheetLanguage((PsiElement)child) != null) {
                CSS_MODIFICATION_TRACKER.incModificationCount();
            }
        }
        super.onTreeChanged(event);
    }

    public boolean isOutOfCodeBlock(@NotNull PsiElement element) {
        if (element == null) {
            CssPsiTreeChangeProcessor.$$$reportNull$$$0(5);
        }
        if (CssPsiUtil.getStylesheetLanguage((PsiElement)element) == null) {
            return false;
        }
        int blockCount = 0;
        for (PsiElement p : SyntaxTraverser.psiApi().parents((Object)element)) {
            if (p instanceof CssSelectorList) {
                return true;
            }
            if (!(p instanceof CssBlock)) continue;
            ++blockCount;
        }
        return blockCount != 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/CssPsiTreeChangeProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/CssPsiTreeChangeProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCssModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCssModificationTracker";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "acceptsEvent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onTreeChanged";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isOutOfCodeBlock";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

