/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssValueOwner;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssInspectionsUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssInvalidPropertyValueInspection
extends CssBaseInspection {
    private static final CssPropertyInvalidValueRangeProvider INVALID_VALUE_RANGE_PROVIDER = new CssPropertyInvalidValueRangeProvider();

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssInvalidPropertyValueInspection.$$$reportNull$$$0(0);
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssDeclaration(@NotNull CssDeclaration declaration) {
                Collection filteredByMediaTypeDescriptors;
                if (declaration == null) {
                    1.$$$reportNull$$$0(0);
                }
                String name = declaration.getPropertyName();
                PsiElement nameIdentifier = declaration.getPropertyNameElement();
                if (StringUtil.isEmpty((String)name) || nameIdentifier == null) {
                    return;
                }
                Collection descriptors = declaration.getDescriptors();
                Collection filteredByContextDescriptors = CssDescriptorsUtil.filterDescriptorsByContext((Collection)descriptors, (PsiElement)nameIdentifier);
                if (!filteredByContextDescriptors.isEmpty() && !(filteredByMediaTypeDescriptors = CssDescriptorsUtil.filterDescriptorsByMediaType((Collection)(descriptors = filteredByContextDescriptors), (PsiElement)nameIdentifier)).isEmpty()) {
                    descriptors = filteredByMediaTypeDescriptors;
                }
                CssInspectionsUtil.checkDescriptorValue(descriptors, (CssValueOwner)declaration, holder, "css.inspections.property.mismatched.values", INVALID_VALUE_RANGE_PROVIDER, true, true, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/psi/css/inspections/invalid/CssInvalidPropertyValueInspection$1", "visitCssDeclaration"));
            }
        };
        if (cssElementVisitor == null) {
            CssInvalidPropertyValueInspection.$$$reportNull$$$0(1);
        }
        return cssElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/invalid/CssInvalidPropertyValueInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/invalid/CssInvalidPropertyValueInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CssPropertyInvalidValueRangeProvider
    extends CssInspectionsUtil.CssInvalidValueRangeProvider {
        private CssPropertyInvalidValueRangeProvider() {
        }

        @Override
        public TextRange calculateInvalidRange(@NotNull CssValueOwner valueOwner, @Nullable PsiElement lastMatchedElement, @NotNull TextRange defaultValue) {
            if (valueOwner == null) {
                CssPropertyInvalidValueRangeProvider.$$$reportNull$$$0(0);
            }
            if (defaultValue == null) {
                CssPropertyInvalidValueRangeProvider.$$$reportNull$$$0(1);
            }
            if (valueOwner instanceof CssDeclaration) {
                int endOfValue;
                int startOfInvalidElements;
                TextRange range;
                CssDeclaration declaration = (CssDeclaration)valueOwner;
                TextRange declarationTextRange = declaration.getTextRange();
                int declarationStartOffset = declarationTextRange.getStartOffset();
                if (lastMatchedElement != null && !(range = TextRange.create((int)(startOfInvalidElements = lastMatchedElement.getTextRange().getEndOffset()), (int)(endOfValue = Math.max(declaration.getTrimmedValueTextRange().getEndOffset(), startOfInvalidElements)))).isEmpty()) {
                    return range.shiftRight(-declarationStartOffset);
                }
            }
            return super.calculateInvalidRange(valueOwner, lastMatchedElement, defaultValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "valueOwner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "defaultValue";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/css/inspections/invalid/CssInvalidPropertyValueInspection$CssPropertyInvalidValueRangeProvider";
            objectArray[2] = "calculateInvalidRange";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

