/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.animation;

import com.android.tools.sherpa.animation.Animation;
import com.android.tools.sherpa.drawing.ViewTransform;
import java.awt.Graphics2D;
import java.util.Iterator;
import java.util.LinkedList;

public class Choreographer {
    private final LinkedList<Animation> mAnimations = new LinkedList();

    public void addAnimation(Animation animation) {
        if (this.mAnimations.contains(animation)) {
            return;
        }
        this.mAnimations.add(animation);
        animation.start();
    }

    public void removeAnimation(Animation animation) {
        this.mAnimations.remove(animation);
    }

    public boolean onPaint(ViewTransform transform, Graphics2D g) {
        Iterator it = this.mAnimations.iterator();
        while (it.hasNext()) {
            Animation animation = (Animation)it.next();
            if (!animation.step()) {
                it.remove();
            }
            animation.onPaint(transform, g);
        }
        return this.mAnimations.size() > 0;
    }
}

