/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.inplace.gutter;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.struts.StrutsManager;
import com.intellij.struts.StrutsModel;
import com.intellij.struts.inplace.gutter.GotoDeclGutter;
import com.intellij.util.xml.DomElement;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ClassAnnotator {
    private final String myClassName;
    private final Icon myIcon;

    protected ClassAnnotator(@NotNull @NonNls String className, @NotNull Icon icon) {
        if (className == null) {
            ClassAnnotator.$$$reportNull$$$0(0);
        }
        if (icon == null) {
            ClassAnnotator.$$$reportNull$$$0(1);
        }
        this.myClassName = className;
        this.myIcon = icon;
    }

    public boolean annotate(final PsiClass clazz, AnnotationHolder holder) {
        if (!clazz.hasModifierProperty("public") || clazz.hasModifierProperty("abstract")) {
            return false;
        }
        PsiClass superClass = JavaPsiFacade.getInstance((Project)clazz.getProject()).findClass(this.myClassName, GlobalSearchScope.allScope((Project)clazz.getProject()));
        if (superClass != null && clazz.isInheritor(superClass, true)) {
            DomElement[] destinations = this.getDestinations(clazz);
            if (destinations == null) {
                Annotation annotation = holder.createWarningAnnotation((PsiElement)clazz.getNameIdentifier(), "Unused declaration");
                annotation.setTextAttributes(CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES);
            } else {
                StringBuilder clazzToolTip = new StringBuilder(destinations[0].getPresentation().getTypeName()).append(" ");
                for (int i = 0; i < destinations.length; ++i) {
                    clazzToolTip.append(destinations[i].getPresentation().getElementName());
                    if (i >= destinations.length - 1) continue;
                    clazzToolTip.append(" | ");
                }
                Annotation annotation = holder.createInfoAnnotation((PsiElement)clazz.getNameIdentifier(), clazzToolTip.toString());
                annotation.setGutterIconRenderer((GutterIconRenderer)new GotoDeclGutter((PsiElement)clazz, this.myIcon, null){

                    @Override
                    protected DomElement[] getDestinations(@NotNull PsiElement element) {
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return ClassAnnotator.this.getDestinations(clazz);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/struts/inplace/gutter/ClassAnnotator$1", "getDestinations"));
                    }
                });
                return true;
            }
        }
        return false;
    }

    @Nullable
    protected static StrutsModel getCombinedStrutsModel(PsiClass clazz) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)clazz);
        return StrutsManager.getInstance().getCombinedStrutsModel(module);
    }

    @Nullable
    protected abstract DomElement[] getDestinations(PsiClass var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "className";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "icon";
                break;
            }
        }
        objectArray[1] = "com/intellij/struts/inplace/gutter/ClassAnnotator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

