/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.gutter;

import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.jam.CdiJamModel;
import com.intellij.cdi.jam.events.CdiObserves;
import com.intellij.cdi.jam.inject.CdiInject;
import com.intellij.cdi.manager.CdiManager;
import com.intellij.cdi.resources.CdiBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.jam.JamService;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import icons.CdiCoreIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiEventsModelClassAnnotator
implements Annotator {
    private static final PsiElementListCellRenderer listRenderer = new PsiElementListCellRenderer<PsiMember>(){

        public String getElementText(PsiMember element) {
            return element.getName();
        }

        protected String getContainerText(PsiMember element, String name) {
            return null;
        }

        protected int getIconFlags() {
            return 0;
        }
    };
    private static final PsiElementListCellRenderer psiParametereListRenderer = new PsiElementListCellRenderer<PsiParameter>(){

        public String getElementText(PsiParameter element) {
            PsiMethod method = (PsiMethod)element.getParent().getParent();
            StringBuffer sb = new StringBuffer();
            sb.append(method.getName());
            sb.append("(");
            ArrayList<String> params = new ArrayList<String>();
            for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
                if (psiParameter.equals(element)) {
                    params.add(element.getText());
                    continue;
                }
                params.add(psiParameter.getType().getPresentableText());
            }
            sb.append(StringUtil.join(params, (String)","));
            sb.append(")");
            return sb.toString();
        }

        protected Icon getIcon(PsiElement element) {
            return PlatformIcons.METHOD_ICON;
        }

        protected String getContainerText(PsiParameter element, String name) {
            return "(" + element.getContainingFile().getName() + ")";
        }

        protected int getIconFlags() {
            return 0;
        }
    };

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        Module module;
        PsiElement parent;
        if (psiElement == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(1);
        }
        if (psiElement instanceof PsiIdentifier && (parent = psiElement.getParent()) instanceof PsiClass && (module = ModuleUtil.findModuleForPsiElement((PsiElement)parent)) != null && CdiCommonUtils.isCdiInstalled(module)) {
            PsiClassType eventType = CdiEventsModelClassAnnotator.getEventPsiType(module);
            if (eventType == null) {
                return;
            }
            PsiClass psiClass = (PsiClass)parent;
            JamService service = JamService.getJamService((Project)psiClass.getProject());
            List injected = service.getAnnotatedMembersList(psiClass, CdiInject.SEM_KEY, true, true, true, true);
            Set<CdiInject> injectedEvents = CdiInjectionUtils.getInjects((PsiType)eventType, injected).keySet();
            if (injectedEvents.size() > 0) {
                List<CdiObserves> observesList = CdiJamModel.getModel(module).getObserves();
                for (CdiInject injectedEvent : injectedEvents) {
                    if (!this.isInFileScope((PsiMember)injectedEvent.getPsiElement(), psiElement.getContainingFile())) continue;
                    CdiEventsModelClassAnnotator.annotateEvents(psiElement.getContainingFile(), injectedEvent, holder, module, observesList);
                }
            }
            ArrayList<PsiParameter> observesParameters = new ArrayList<PsiParameter>();
            for (PsiMethod psiMethod : psiClass.getMethods()) {
                for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                    if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, (String)"javax.enterprise.event.Observes", (boolean)false)) continue;
                    observesParameters.add(psiParameter);
                }
            }
            if (observesParameters.size() > 0) {
                Set<CdiInject> allInjects = CdiInjectionUtils.getInjects((PsiType)eventType, CdiJamModel.getModel(module).getInjects()).keySet();
                for (PsiParameter psiParameter : observesParameters) {
                    CdiEventsModelClassAnnotator.annotateObserves(psiParameter, holder, module, allInjects);
                }
            }
        }
    }

    private boolean isInFileScope(@Nullable PsiMember element, @Nullable PsiFile file) {
        if (element != null && file != null) {
            return file.equals(element.getContainingFile());
        }
        return false;
    }

    @Nullable
    private static PsiClassType getEventPsiType(@NotNull Module module) {
        JavaPsiFacade psiFacade;
        PsiClass eventPsiClass;
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(2);
        }
        if ((eventPsiClass = (psiFacade = JavaPsiFacade.getInstance((Project)module.getProject())).findClass("javax.enterprise.event.Event", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module))) != null) {
            return psiFacade.getElementFactory().createType(eventPsiClass);
        }
        return null;
    }

    private static void annotateObserves(PsiParameter psiParameter, AnnotationHolder holder, Module module, Set<CdiInject> allInjects) {
        final CdiInject[] injects = CdiEventsModelClassAnnotator.collectInjects(psiParameter, allInjects, module);
        if (injects.length > 0) {
            CdiEventsModelClassAnnotator.addGotoFiresIcon(holder, psiParameter, new NotNullLazyValue<Collection<? extends PsiElement>>(){

                @NotNull
                protected Collection<PsiMember> compute() {
                    List list = ContainerUtil.mapNotNull((Object[])injects, inject -> inject.isPsiValid() ? (PsiMember)inject.getPsiElement() : null);
                    if (list == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/gutter/CdiEventsModelClassAnnotator$3", "compute"));
                }
            });
        }
    }

    private static CdiInject[] collectInjects(PsiParameter observesParameter, Set<CdiInject> injects, Module module) {
        HashSet observes2injects = new HashSet();
        PsiType observesType = observesParameter.getType();
        for (CdiInject inject : injects) {
            PsiType eventType = CdiEventsModelClassAnnotator.getEventType(inject, CdiEventsModelClassAnnotator.getEventPsiType(module));
            if (eventType == null || "java.lang.Object".equals(eventType.getCanonicalText()) || !observesType.isAssignableFrom(eventType) || !CdiEventsModelClassAnnotator.isQualifiersAssignable(inject.getQualifierAnnotations(), (PsiModifierListOwner)observesParameter, module)) continue;
            observes2injects.add((Object)inject);
        }
        return (CdiInject[])observes2injects.toArray((Object[])new CdiInject[observes2injects.size()]);
    }

    private static void annotateEvents(@NotNull PsiFile scope, CdiInject event, AnnotationHolder holder, Module module, List<CdiObserves> allObservesList) {
        CdiObserves[] observes;
        if (scope == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(3);
        }
        if ((observes = CdiEventsModelClassAnnotator.collectObserves(event, allObservesList, module)).length > 0) {
            CdiEventsModelClassAnnotator.addGotoObservesIcon(holder, event.getPsiElement(), new NotNullLazyValue<Collection<? extends PsiElement>>(){

                @NotNull
                protected Collection<PsiParameter> compute() {
                    List list = ContainerUtil.mapNotNull((Object[])observes, cdiObserves -> cdiObserves.getPsiElement());
                    if (list == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/gutter/CdiEventsModelClassAnnotator$4", "compute"));
                }
            });
        }
    }

    private static void addGotoObservesIcon(AnnotationHolder holder, PsiElement psiIdentifier, NotNullLazyValue<Collection<? extends PsiElement>> targets) {
        NavigationGutterIconBuilder.create((Icon)CdiCoreIcons.GotoObserves).setCellRenderer(psiParametereListRenderer).setTargets(targets).setPopupTitle(CdiBundle.message("gutter.choose.goto.observes", new Object[0])).setTooltipText(CdiBundle.message("gutter.navigate.to.observes", new Object[0])).install(holder, psiIdentifier);
    }

    private static void addGotoFiresIcon(AnnotationHolder holder, PsiParameter psiParameter, NotNullLazyValue<Collection<? extends PsiElement>> targets) {
        NavigationGutterIconBuilder.create((Icon)CdiCoreIcons.GotoFires).setTargets(targets).setPopupTitle(CdiBundle.message("gutter.choose.goto.fires", new Object[0])).setTooltipText(CdiBundle.message("gutter.navigate.to.fires", new Object[0])).install(holder, (PsiElement)psiParameter);
    }

    private static CdiObserves[] collectObserves(CdiInject event, List<CdiObserves> allObservesList, Module module) {
        ArrayList<CdiObserves> event2observes = new ArrayList<CdiObserves>();
        PsiType eventType = CdiEventsModelClassAnnotator.getEventType(event, CdiEventsModelClassAnnotator.getEventPsiType(module));
        PsiAnnotation[] eventQualifierAnnotations = event.getQualifierAnnotations();
        if (eventType != null) {
            for (CdiObserves observes : allObservesList) {
                PsiType type = observes.getType();
                if (type == null || !type.isAssignableFrom(eventType) || !CdiEventsModelClassAnnotator.isQualifiersAssignable(eventQualifierAnnotations, (PsiModifierListOwner)observes.getPsiElement(), module)) continue;
                event2observes.add(observes);
            }
        }
        return event2observes.toArray(new CdiObserves[event2observes.size()]);
    }

    @Nullable
    private static PsiType getEventType(CdiInject<PsiMember> event, PsiClassType eventPsiType) {
        for (InjectionPointDescriptor pair : event.getInjectionPoints()) {
            PsiType injectionPointType = pair.getType();
            if (injectionPointType == null || !injectionPointType.isAssignableFrom((PsiType)eventPsiType)) continue;
            return PsiUtil.substituteTypeParameter((PsiType)injectionPointType, (String)"javax.enterprise.event.Event", (int)0, (boolean)false);
        }
        return null;
    }

    private static boolean isQualifiersAssignable(PsiAnnotation[] qualifierAnnotation, PsiModifierListOwner candidate, Module module) {
        return CdiManager.hasAnnotated(candidate, qualifierAnnotation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/cdi/gutter/CdiEventsModelClassAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getEventPsiType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateEvents";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

