/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.utils;

import com.intellij.cdi.beans.AbstractCdiBeanDescriptor;
import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.CdiBeanPsiClassDescriptor;
import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.jam.CdiJamModel;
import com.intellij.cdi.jam.events.CdiObserves;
import com.intellij.cdi.jam.inject.CdiInject;
import com.intellij.cdi.jam.lifecycle.CdiDispose;
import com.intellij.cdi.jam.producers.CdiProduces;
import com.intellij.cdi.manager.CdiDescriptorsFactory;
import com.intellij.cdi.manager.CdiManager;
import com.intellij.cdi.model.CdiBeansXmlDomModelManager;
import com.intellij.cdi.model.CdiBeansXmlModel;
import com.intellij.cdi.model.xml.AlternativeClass;
import com.intellij.cdi.model.xml.Alternatives;
import com.intellij.cdi.model.xml.BeanDiscoveryMode;
import com.intellij.cdi.model.xml.Beans;
import com.intellij.cdi.model.xml.Exclude;
import com.intellij.cdi.model.xml.Scan;
import com.intellij.cdi.model.xml.StereotypeClass;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiManagedBeanValidationUtils;
import com.intellij.cdi.utils.CdiVersion;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiInjectionUtils {
    private CdiInjectionUtils() {
    }

    public static Map<CdiInject, InjectionPointDescriptor> getInjects(@NotNull PsiType psiType, @NotNull List<CdiInject> injects) {
        if (psiType == null) {
            CdiInjectionUtils.$$$reportNull$$$0(0);
        }
        if (injects == null) {
            CdiInjectionUtils.$$$reportNull$$$0(1);
        }
        HashMap<CdiInject, InjectionPointDescriptor> result = new HashMap<CdiInject, InjectionPointDescriptor>();
        for (CdiInject inject : injects) {
            List<InjectionPointDescriptor> injectionPoints = inject.getInjectionPoints();
            for (InjectionPointDescriptor descriptor : injectionPoints) {
                PsiType injectionPointType = descriptor.getType();
                if (injectionPointType == null || !injectionPointType.isAssignableFrom(psiType)) continue;
                result.put(inject, descriptor);
            }
        }
        return result;
    }

    public static List<InjectionPointDescriptor> getInjectionPoints(@NotNull PsiMethod method) {
        if (method == null) {
            CdiInjectionUtils.$$$reportNull$$$0(2);
        }
        LinkedList ips = ContainerUtil.newLinkedList();
        for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, Arrays.asList("javax.enterprise.event.Observes", "javax.enterprise.inject.Disposes", "javax.decorator.Delegate"))) continue;
            ips.add(new InjectionPointDescriptor((PsiModifierListOwner)psiParameter));
        }
        return ips;
    }

    public static Set<InjectionPointDescriptor> getInjectionPoints(@NotNull Module module) {
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(3);
        }
        return (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            if (module == null) {
                CdiInjectionUtils.$$$reportNull$$$0(43);
            }
            Set<InjectionPointDescriptor> ips = CdiInjectionUtils.getInjectionPoints(module, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
            return CachedValueProvider.Result.create(ips, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    public static Set<InjectionPointDescriptor> getInjectionPoints(@NotNull Module module, @NotNull GlobalSearchScope scope) {
        PsiMethod method;
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            CdiInjectionUtils.$$$reportNull$$$0(5);
        }
        HashSet ips = new HashSet();
        for (CdiInject inject : CdiJamModel.getModel(module).getInjects(scope)) {
            ips.addAll(inject.getInjectionPoints());
        }
        for (CdiProduces produces : CdiJamModel.getModel(module).getProduces(scope)) {
            ips.addAll(produces.getInjectionPoints());
        }
        for (CdiObserves observes : CdiJamModel.getModel(module).getObserves(scope)) {
            method = observes.getPsiMethod();
            if (method == null) continue;
            ips.addAll(CdiInjectionUtils.getInjectionPoints(method));
        }
        for (CdiDispose dispose : CdiJamModel.getModel(module).getDisposes(scope)) {
            method = dispose.getPsiMethod();
            if (method == null) continue;
            ips.addAll(CdiInjectionUtils.getInjectionPoints(method));
        }
        return ips;
    }

    public static Set<InjectionPointDescriptor> getInjectionPoints(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiInjectionUtils.$$$reportNull$$$0(6);
        }
        HashSet ips = new HashSet();
        JamService service = JamService.getJamService((Project)psiClass.getProject());
        for (CdiInject inject : service.getAnnotatedMembersList(psiClass, CdiInject.SEM_KEY, true, true, true, true)) {
            ips.addAll(inject.getInjectionPoints());
        }
        for (CdiProduces produces : service.getAnnotatedMembersList(psiClass, CdiProduces.SEM_KEY, true, true, true, true)) {
            ips.addAll(produces.getInjectionPoints());
        }
        for (PsiMethod observesMethod : CdiCommonUtils.getObservesMethods(psiClass)) {
            ips.addAll(CdiInjectionUtils.getInjectionPoints(observesMethod));
        }
        for (PsiMethod disposerMethod : CdiCommonUtils.getDisposerMethods(psiClass)) {
            ips.addAll(CdiInjectionUtils.getInjectionPoints(disposerMethod));
        }
        return ips;
    }

    public static Set<InjectionPointDescriptor> getInjectionPoints(@NotNull PsiType psiType, @NotNull Set<InjectionPointDescriptor> ipd) {
        if (psiType == null) {
            CdiInjectionUtils.$$$reportNull$$$0(7);
        }
        if (ipd == null) {
            CdiInjectionUtils.$$$reportNull$$$0(8);
        }
        HashSet result = new HashSet();
        for (InjectionPointDescriptor descriptor : ipd) {
            PsiType injectionPointType = descriptor.getType();
            if (injectionPointType == null || !injectionPointType.isAssignableFrom(psiType)) continue;
            result.add(descriptor);
        }
        return result;
    }

    public static Set<CdiBeanDescriptor> getInjectedBeans(@NotNull InjectionPointDescriptor ipd) {
        if (ipd == null) {
            CdiInjectionUtils.$$$reportNull$$$0(9);
        }
        return CdiInjectionUtils.getInjectedBeans(ipd, true, true, true);
    }

    public static Set<CdiBeanDescriptor> getInjectedBeans(@NotNull InjectionPointDescriptor ipd, boolean checkVetoed, boolean checkDiscoveryMode, boolean checkExcludeFilters) {
        if (ipd == null) {
            CdiInjectionUtils.$$$reportNull$$$0(10);
        }
        return CdiInjectionUtils.getInjectedBeans(ipd.getOwner(), ipd.getType(), checkVetoed, checkDiscoveryMode, checkExcludeFilters);
    }

    public static Set<CdiBeanDescriptor> filterVetoedBeans(@NotNull Set<CdiBeanDescriptor> allBeans, @NotNull Module module) {
        if (allBeans == null) {
            CdiInjectionUtils.$$$reportNull$$$0(11);
        }
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(12);
        }
        HashSet filtered = new HashSet();
        for (CdiBeanDescriptor beanDescriptor : allBeans) {
            PsiClass psiClass = CdiInjectionUtils.getContaingClass(beanDescriptor);
            if (psiClass == null || CdiInjectionUtils.isVetoedClass(module, psiClass)) continue;
            filtered.add(beanDescriptor);
        }
        return filtered;
    }

    @NotNull
    public static Set<CdiBeanDescriptor> filterBeanDiscoveryMode(@NotNull Set<CdiBeanDescriptor> allBeans, @NotNull Module module) {
        BeanDiscoveryMode value;
        if (allBeans == null) {
            CdiInjectionUtils.$$$reportNull$$$0(13);
        }
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(14);
        }
        if ((value = CdiInjectionUtils.getBeanDiscoveryMode(module)) == BeanDiscoveryMode.NONE) {
            Set<CdiBeanDescriptor> set = Collections.emptySet();
            if (set == null) {
                CdiInjectionUtils.$$$reportNull$$$0(15);
            }
            return set;
        }
        if (value == BeanDiscoveryMode.ALL) {
            Set<CdiBeanDescriptor> set = allBeans;
            if (set == null) {
                CdiInjectionUtils.$$$reportNull$$$0(16);
            }
            return set;
        }
        com.intellij.util.containers.hash.HashSet filtered = new com.intellij.util.containers.hash.HashSet();
        List<String> qualifiedNames = CdiCommonUtils.collectCdiBeansAnnotations(module);
        qualifiedNames.removeAll(CdiInjectionUtils.getNonScannedBeanDiscoveryModeAnnos());
        for (CdiBeanDescriptor beanDescriptor : allBeans) {
            Object psiMember = beanDescriptor.getIdentifyingElement();
            if (AnnotationUtil.findAnnotations(psiMember, qualifiedNames).length > 0) {
                filtered.add(beanDescriptor);
                continue;
            }
            if (!(psiMember instanceof PsiClass) || !CdiManagedBeanValidationUtils.isEjbBean((PsiClass)psiMember) && !CdiManagedBeanValidationUtils.isJpaEntity((PsiClass)psiMember)) continue;
            filtered.add(beanDescriptor);
        }
        com.intellij.util.containers.hash.HashSet hashSet = filtered;
        if (hashSet == null) {
            CdiInjectionUtils.$$$reportNull$$$0(17);
        }
        return hashSet;
    }

    private static Collection<String> getNonScannedBeanDiscoveryModeAnnos() {
        return Collections.singleton("javax.inject.Named");
    }

    @NotNull
    public static BeanDiscoveryMode getBeanDiscoveryMode(@NotNull Module module) {
        Beans beans;
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(18);
        }
        if ((beans = CdiInjectionUtils.getBeansXml(module)) != null && DomUtil.hasXml(beans.getBeanDiscoveryMode())) {
            BeanDiscoveryMode discoveryMode = (BeanDiscoveryMode)((Object)beans.getBeanDiscoveryMode().getValue());
            if (discoveryMode != null) {
                BeanDiscoveryMode beanDiscoveryMode = discoveryMode;
                if (beanDiscoveryMode == null) {
                    CdiInjectionUtils.$$$reportNull$$$0(19);
                }
                return beanDiscoveryMode;
            }
            BeanDiscoveryMode beanDiscoveryMode = BeanDiscoveryMode.ANNOTATED;
            if (beanDiscoveryMode == null) {
                CdiInjectionUtils.$$$reportNull$$$0(20);
            }
            return beanDiscoveryMode;
        }
        BeanDiscoveryMode beanDiscoveryMode = BeanDiscoveryMode.ALL;
        if (beanDiscoveryMode == null) {
            CdiInjectionUtils.$$$reportNull$$$0(21);
        }
        return beanDiscoveryMode;
    }

    @NotNull
    public static Set<CdiBeanDescriptor> filterScanExcludedBeans(@NotNull Set<CdiBeanDescriptor> allBeans, @NotNull Module module) {
        Beans beans;
        if (allBeans == null) {
            CdiInjectionUtils.$$$reportNull$$$0(22);
        }
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(23);
        }
        if ((beans = CdiInjectionUtils.getBeansXml(module)) != null) {
            com.intellij.util.containers.hash.HashSet patterns = new com.intellij.util.containers.hash.HashSet();
            for (Scan scan : beans.getScans()) {
                for (Exclude exclude : scan.getExcludes()) {
                    String text = exclude.getName().getRawText();
                    if (text == null) continue;
                    try {
                        String regexp = FileUtil.convertAntToRegexp((String)text);
                        patterns.add(Pattern.compile(regexp));
                    }
                    catch (PatternSyntaxException patternSyntaxException) {}
                }
            }
            if (patterns.size() != 0) {
                com.intellij.util.containers.hash.HashSet filtered = new com.intellij.util.containers.hash.HashSet();
                for (CdiBeanDescriptor descriptor : allBeans) {
                    PsiClass psiClass = CdiInjectionUtils.getContaingClass(descriptor);
                    if (psiClass == null || CdiInjectionUtils.isExcludeClass((Set<Pattern>)patterns, psiClass)) continue;
                    filtered.add(descriptor);
                }
                com.intellij.util.containers.hash.HashSet hashSet = filtered;
                if (hashSet == null) {
                    CdiInjectionUtils.$$$reportNull$$$0(24);
                }
                return hashSet;
            }
        }
        Set<CdiBeanDescriptor> set = allBeans;
        if (set == null) {
            CdiInjectionUtils.$$$reportNull$$$0(25);
        }
        return set;
    }

    private static PsiClass getContaingClass(CdiBeanDescriptor descriptor) {
        Object identifyingElement = descriptor.getIdentifyingElement();
        return identifyingElement instanceof PsiClass ? (PsiClass)identifyingElement : identifyingElement.getContainingClass();
    }

    private static boolean isExcludeClass(Set<Pattern> patterns, PsiClass psiClass) {
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName != null) {
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(qualifiedName).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canBeInjected(@NotNull PsiClass psiClass, @NotNull Module module) {
        if (psiClass == null) {
            CdiInjectionUtils.$$$reportNull$$$0(26);
        }
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(27);
        }
        if (!CdiInjectionUtils.isManagedBean(psiClass)) {
            return false;
        }
        if (CdiInjectionUtils.isVetoedClass(module, psiClass)) {
            return false;
        }
        Set<CdiBeanDescriptor> descriptors = Collections.singleton(CdiDescriptorsFactory.createCdiBeanDescriptor(psiClass));
        return CdiInjectionUtils.filterDescriptors(module, descriptors, true, true, true).size() > 0;
    }

    public static boolean isManagedBean(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiInjectionUtils.$$$reportNull$$$0(28);
        }
        return !CdiManagedBeanValidationUtils.isParameterizedType(psiClass) && (CdiManagedBeanValidationUtils.isConcreteClass(psiClass) || CdiManagedBeanValidationUtils.isDecoratorClass(psiClass)) && !CdiManagedBeanValidationUtils.isNonStaticInner(psiClass);
    }

    @Nullable
    private static Beans getBeansXml(@NotNull Module module) {
        CdiBeansXmlModel beansXmlModel;
        List roots;
        List<CdiBeansXmlModel> models;
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(29);
        }
        if ((models = CdiBeansXmlDomModelManager.getInstance(module.getProject()).getAllModels(module)).size() == 1 && (roots = (beansXmlModel = models.iterator().next()).getRoots()).size() == 1) {
            return (Beans)((DomFileElement)roots.get(0)).getRootElement();
        }
        return null;
    }

    public static boolean isVetoedClass(@NotNull Module module, @NotNull PsiClass psiClass) {
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(30);
        }
        if (psiClass == null) {
            CdiInjectionUtils.$$$reportNull$$$0(31);
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"javax.enterprise.inject.Vetoed", (boolean)true)) {
            return true;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        for (PsiPackage vetoedPackage : CdiCommonUtils.getVetoedPackages(module)) {
            if (!facade.isInPackage((PsiElement)psiClass, vetoedPackage)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Set<CdiBeanDescriptor> getInjectedBeans(@NotNull PsiModifierListOwner owner, PsiType type, boolean checkVetoed, boolean checkDiscoveryMode, boolean checkExcludeFilters) {
        Module module;
        if (owner == null) {
            CdiInjectionUtils.$$$reportNull$$$0(32);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)owner)) == null) {
            Set<CdiBeanDescriptor> set = Collections.emptySet();
            if (set == null) {
                CdiInjectionUtils.$$$reportNull$$$0(33);
            }
            return set;
        }
        Set<CdiBeanDescriptor> set = CdiInjectionUtils.filterDescriptors(module, CdiInjectionUtils.getInjectedBeans(owner, module, type), checkVetoed, checkDiscoveryMode, checkExcludeFilters);
        if (set == null) {
            CdiInjectionUtils.$$$reportNull$$$0(34);
        }
        return set;
    }

    private static Set<CdiBeanDescriptor> filterDescriptors(Module module, Set<CdiBeanDescriptor> allBeans, boolean checkVetoed, boolean checkDiscoveryMode, boolean checkExcludeFilters) {
        allBeans = CdiInjectionUtils.filterUnsatisfiedDescriptors(allBeans);
        allBeans = CdiInjectionUtils.chooseAlternatives(allBeans, module);
        if (checkVetoed) {
            allBeans = CdiInjectionUtils.filterVetoedBeans(allBeans, module);
        }
        if (checkDiscoveryMode) {
            allBeans = CdiInjectionUtils.filterBeanDiscoveryMode(allBeans, module);
        }
        if (checkExcludeFilters) {
            allBeans = CdiInjectionUtils.filterScanExcludedBeans(allBeans, module);
        }
        return allBeans;
    }

    private static Set<CdiBeanDescriptor> filterUnsatisfiedDescriptors(@NotNull Set<CdiBeanDescriptor> beans) {
        if (beans == null) {
            CdiInjectionUtils.$$$reportNull$$$0(35);
        }
        return new LinkedHashSet<CdiBeanDescriptor>(ContainerUtil.filter(beans, descriptor -> CdiInjectionUtils.isLoadedInContainer(descriptor)));
    }

    private static boolean isLoadedInContainer(@NotNull CdiBeanDescriptor descriptor) {
        Module moduleForPsiElement;
        Object identifyingElement;
        if (descriptor == null) {
            CdiInjectionUtils.$$$reportNull$$$0(36);
        }
        return (identifyingElement = descriptor.getIdentifyingElement()) == null || (moduleForPsiElement = ModuleUtilCore.findModuleForPsiElement(identifyingElement)) == null || !CdiCommonUtils.isCdiInstalled(moduleForPsiElement, CdiVersion.CDI_1_1) || !CdiBeansXmlDomModelManager.getInstance(moduleForPsiElement.getProject()).getAllModels(moduleForPsiElement).isEmpty();
    }

    @NotNull
    private static Set<CdiBeanDescriptor> chooseAlternatives(@NotNull Set<CdiBeanDescriptor> allBeans, @NotNull Module module) {
        Beans beans;
        if (allBeans == null) {
            CdiInjectionUtils.$$$reportNull$$$0(37);
        }
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(38);
        }
        com.intellij.util.containers.hash.HashSet alternatives = new com.intellij.util.containers.hash.HashSet();
        com.intellij.util.containers.hash.HashSet nonAlternatives = new com.intellij.util.containers.hash.HashSet();
        for (CdiBeanDescriptor descriptor : allBeans) {
            Object annotatedItem;
            if (descriptor instanceof AbstractCdiBeanDescriptor && CdiCommonUtils.isAlternativeAnnotated(annotatedItem = ((AbstractCdiBeanDescriptor)descriptor).getAnnotatedItem())) {
                alternatives.add((AbstractCdiBeanDescriptor)descriptor);
                continue;
            }
            nonAlternatives.add(descriptor);
        }
        if (alternatives.size() > 0 && (beans = CdiInjectionUtils.getBeansXml(module)) != null) {
            com.intellij.util.containers.hash.HashSet result = new com.intellij.util.containers.hash.HashSet();
            for (Alternatives definedAlternatives : beans.getAlternativeses()) {
                for (AlternativeClass alternativeClass : definedAlternatives.getClasses()) {
                    String alternativeClassFQN = alternativeClass.getStringValue();
                    if (StringUtil.isEmptyOrSpaces((String)alternativeClassFQN)) continue;
                    for (CdiBeanDescriptor beanDescriptor : alternatives) {
                        PsiClass psiClass = beanDescriptor instanceof CdiBeanPsiClassDescriptor ? ((CdiBeanPsiClassDescriptor)beanDescriptor).getAnnotatedItem() : ((AbstractCdiBeanDescriptor)beanDescriptor).getAnnotatedItem().getContainingClass();
                        if (psiClass == null || !alternativeClassFQN.equals(psiClass.getQualifiedName())) continue;
                        result.add(beanDescriptor);
                    }
                }
                for (StereotypeClass stereotypeClass : definedAlternatives.getStereotypes()) {
                    String stereotypeClassValue = stereotypeClass.getStringValue();
                    if (stereotypeClassValue == null) continue;
                    for (CdiBeanDescriptor beanDescriptor : alternatives) {
                        Object psiMember = ((AbstractCdiBeanDescriptor)beanDescriptor).getAnnotatedItem();
                        if (!AnnotationUtil.isAnnotated(psiMember, Collections.singleton(stereotypeClassValue))) continue;
                        result.add(beanDescriptor);
                    }
                }
            }
            if (result.size() > 0) {
                com.intellij.util.containers.hash.HashSet hashSet = result;
                if (hashSet == null) {
                    CdiInjectionUtils.$$$reportNull$$$0(39);
                }
                return hashSet;
            }
        }
        com.intellij.util.containers.hash.HashSet hashSet = nonAlternatives;
        if (hashSet == null) {
            CdiInjectionUtils.$$$reportNull$$$0(40);
        }
        return hashSet;
    }

    public static Set<CdiBeanDescriptor> getInjectedBeans(@NotNull PsiModifierListOwner psiMember, @NotNull Module module, PsiType type) {
        if (psiMember == null) {
            CdiInjectionUtils.$$$reportNull$$$0(41);
        }
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(42);
        }
        return CdiManager.getService(module).resolveBeanByType(psiMember, module, type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 33: 
            case 34: 
            case 39: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 33: 
            case 34: 
            case 39: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 14: 
            case 18: 
            case 23: 
            case 27: 
            case 29: 
            case 30: 
            case 38: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: 
            case 26: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ipd";
                break;
            }
            case 11: 
            case 13: 
            case 22: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allBeans";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 33: 
            case 34: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/utils/CdiInjectionUtils";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMember";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/utils/CdiInjectionUtils";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "filterBeanDiscoveryMode";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeanDiscoveryMode";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "filterScanExcludedBeans";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedBeans";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseAlternatives";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInjects";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInjectionPoints";
                break;
            }
            case 9: 
            case 10: 
            case 32: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedBeans";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "filterVetoedBeans";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "filterBeanDiscoveryMode";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 33: 
            case 34: 
            case 39: 
            case 40: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getBeanDiscoveryMode";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "filterScanExcludedBeans";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "canBeInjected";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isManagedBean";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getBeansXml";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isVetoedClass";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "filterUnsatisfiedDescriptors";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isLoadedInContainer";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "chooseAlternatives";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getInjectionPoints$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 33: 
            case 34: 
            case 39: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

