/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.utils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.javaee.ejb.EjbHelper;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiManagedBeanValidationUtils {
    private static final String[] unallowedAncestors = new String[]{"javax.ejb.EnterpriseBean"};

    private CdiManagedBeanValidationUtils() {
    }

    public static boolean isManagedBean(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiManagedBeanValidationUtils.$$$reportNull$$$0(0);
        }
        return !CdiManagedBeanValidationUtils.isParameterizedType(psiClass) && (CdiManagedBeanValidationUtils.isConcreteClass(psiClass) || CdiManagedBeanValidationUtils.isDecoratorClass(psiClass)) && !CdiManagedBeanValidationUtils.isNonStaticInner(psiClass) && CdiManagedBeanValidationUtils.hasAppropriateConstructor(psiClass) && !CdiManagedBeanValidationUtils.hasUnallowedAncestor(psiClass) && !CdiManagedBeanValidationUtils.isEjbBean(psiClass) && !CdiManagedBeanValidationUtils.isJpaEntity(psiClass);
    }

    public static boolean isJpaEntity(PsiClass psiClass) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"javax.persistence.Entity", (boolean)false);
    }

    public static boolean isEjbBean(PsiClass psiClass) {
        return EjbHelper.getEjbHelper().getEjbRoles(psiClass).length > 0;
    }

    public static boolean hasAppropriateConstructor(@NotNull PsiClass psiClass) {
        PsiMethod[] methods;
        if (psiClass == null) {
            CdiManagedBeanValidationUtils.$$$reportNull$$$0(1);
        }
        if ((methods = psiClass.getConstructors()).length == 0) {
            return true;
        }
        for (PsiMethod psiMethod : methods) {
            if (psiMethod.getParameterList().getParametersCount() != 0 && !AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)"javax.inject.Inject", (boolean)true)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNonArgConstructor(@NotNull PsiClass psiClass) {
        PsiMethod[] methods;
        if (psiClass == null) {
            CdiManagedBeanValidationUtils.$$$reportNull$$$0(2);
        }
        if ((methods = psiClass.getConstructors()).length == 0) {
            return true;
        }
        for (PsiMethod psiMethod : methods) {
            if (psiMethod.getParameterList().getParametersCount() != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean hasUnallowedAncestor(PsiClass psiClass) {
        return CdiManagedBeanValidationUtils.getUnallowedAncestor(psiClass) != null;
    }

    @Nullable
    public static String getUnallowedAncestor(PsiClass psiClass) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)psiClass.getProject());
        for (String ancestorFQN : unallowedAncestors) {
            PsiClass ancestorClass = psiFacade.findClass(ancestorFQN, GlobalSearchScope.allScope((Project)psiClass.getProject()));
            if (ancestorClass == null || !psiClass.isInheritor(ancestorClass, true)) continue;
            return ancestorFQN;
        }
        return null;
    }

    public static boolean isNonStaticInner(PsiClass psiClass) {
        return !psiClass.hasModifierProperty("static") && psiClass.getContainingClass() != null;
    }

    public static boolean isConcreteClass(PsiClass psiClass) {
        return !psiClass.isInterface() && !psiClass.isEnum() && !psiClass.isAnnotationType() && !(psiClass instanceof PsiAnonymousClass) && !psiClass.hasModifierProperty("abstract");
    }

    public static boolean isDecoratorClass(PsiClass psiClass) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"javax.decorator.Decorator", (boolean)false);
    }

    public static boolean isParameterizedType(@Nullable PsiClass psiClass) {
        return psiClass != null && psiClass.hasTypeParameters();
    }

    public static boolean isPassivatingScopeDeclared(PsiModifierListOwner owner) {
        return AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{"javax.enterprise.context.SessionScoped", "javax.enterprise.context.ConversationScoped"}) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "psiClass";
        objectArray2[1] = "com/intellij/cdi/utils/CdiManagedBeanValidationUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isManagedBean";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasAppropriateConstructor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasNonArgConstructor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

