/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.TypeEvaluator;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.visitor.UastVisitor;

public class ViewTagDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create("ViewTag", "Tagged object leaks", "Prior to Android 4.0, the implementation of `View.setTag(int, Object)` would store the objects in a static map, where the values were strongly referenced. This means that if the object contains any references pointing back to the context, the context (which points to pretty much everything else) will leak. If you pass a view, the view provides a reference to the context that created it. Similarly, view holders typically contain a view, and cursors are sometimes also associated with views.", Category.PERFORMANCE, 6, Severity.WARNING, new Implementation(ViewTagDetector.class, Scope.JAVA_FILE_SCOPE));

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("setTag");
    }

    @Override
    public void visitMethod(JavaContext context, UastVisitor visitor, UCallExpression call, UMethod method) {
        String objectType;
        if (context.getMainProject().getMinSdk() >= 14) {
            return;
        }
        JavaEvaluator evaluator = context.getEvaluator();
        if (!evaluator.isMemberInSubClassOf((PsiMember)method, "android.view.View", false)) {
            return;
        }
        List arguments = call.getValueArguments();
        if (arguments.size() != 2) {
            return;
        }
        UExpression tagArgument = (UExpression)arguments.get(1);
        if (tagArgument == null) {
            return;
        }
        PsiType type2 = TypeEvaluator.evaluate(context, (UElement)tagArgument);
        if (!(type2 instanceof PsiClassType)) {
            return;
        }
        PsiClass typeClass = ((PsiClassType)type2).resolve();
        if (typeClass == null) {
            return;
        }
        if (InheritanceUtil.isInheritor((PsiClass)typeClass, (boolean)false, (String)"android.view.View")) {
            objectType = "views";
        } else if (InheritanceUtil.isInheritor((PsiClass)typeClass, (boolean)false, (String)"android.database.Cursor")) {
            objectType = "cursors";
        } else if (typeClass.getName() != null && typeClass.getName().endsWith("ViewHolder")) {
            objectType = "view holders";
        } else {
            return;
        }
        String message = String.format("Avoid setting %1$s as values for `setTag`: Can lead to memory leaks in versions older than Android 4.0", objectType);
        context.report(ISSUE, (UElement)call, context.getUastLocation((UElement)tagArgument), message);
    }
}

