/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.detector.api;

import com.android.tools.klint.client.api.JavaParser;
import com.android.tools.klint.client.api.UastLintUtils;
import com.android.tools.klint.detector.api.JavaContext;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ListIterator;
import lombok.ast.BinaryExpression;
import lombok.ast.BinaryOperator;
import lombok.ast.BooleanLiteral;
import lombok.ast.Cast;
import lombok.ast.CharLiteral;
import lombok.ast.Expression;
import lombok.ast.ExpressionStatement;
import lombok.ast.FloatingPointLiteral;
import lombok.ast.InlineIfExpression;
import lombok.ast.IntegralLiteral;
import lombok.ast.Literal;
import lombok.ast.Node;
import lombok.ast.NullLiteral;
import lombok.ast.Statement;
import lombok.ast.StringLiteral;
import lombok.ast.UnaryExpression;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContext;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

public class TypeEvaluator {
    private final JavaContext mContext;

    public TypeEvaluator(JavaContext context) {
        this.mContext = context;
    }

    @Deprecated
    public JavaParser.TypeDescriptor evaluate(Node node) {
        JavaParser.ResolvedNode resolved = null;
        if (this.mContext != null) {
            resolved = this.mContext.resolve(node);
        }
        if (resolved instanceof JavaParser.ResolvedMethod) {
            JavaParser.TypeDescriptor type2;
            JavaParser.ResolvedMethod method = (JavaParser.ResolvedMethod)resolved;
            if (method.isConstructor()) {
                JavaParser.ResolvedClass containingClass = method.getContainingClass();
                type2 = containingClass.getType();
            } else {
                type2 = method.getReturnType();
            }
            return type2;
        }
        if (resolved instanceof JavaParser.ResolvedField) {
            JavaParser.TypeDescriptor type3;
            Expression initializer;
            VariableDefinitionEntry first;
            VariableDeclaration declaration2;
            VariableDefinition definition;
            JavaParser.ResolvedField field = (JavaParser.ResolvedField)resolved;
            Node astNode = field.findAstNode();
            if (astNode instanceof VariableDeclaration && (definition = (declaration2 = (VariableDeclaration)astNode).astDefinition()) != null && (first = (VariableDefinitionEntry)definition.astVariables().first()) != null && (initializer = first.astInitializer()) != null && (type3 = this.evaluate((Node)initializer)) != null) {
                return type3;
            }
            return field.getType();
        }
        if (node instanceof VariableReference) {
            Statement statement = JavaContext.getParentOfType(node, Statement.class, false);
            if (statement != null) {
                ListIterator iterator = statement.getParent().getChildren().listIterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != statement) continue;
                    if (!iterator.hasPrevious()) break;
                    iterator.previous();
                    break;
                }
                String targetName = ((VariableReference)node).astIdentifier().astValue();
                while (iterator.hasPrevious()) {
                    BinaryExpression binaryExpression;
                    ExpressionStatement expressionStatement;
                    Expression expression2;
                    Node previous = (Node)iterator.previous();
                    if (previous instanceof VariableDeclaration) {
                        VariableDeclaration declaration3 = (VariableDeclaration)previous;
                        VariableDefinition definition = declaration3.astDefinition();
                        for (VariableDefinitionEntry entry : definition.astVariables()) {
                            if (entry.astInitializer() == null || !entry.astName().astValue().equals(targetName)) continue;
                            return this.evaluate((Node)entry.astInitializer());
                        }
                        continue;
                    }
                    if (!(previous instanceof ExpressionStatement) || !((expression2 = (expressionStatement = (ExpressionStatement)previous).astExpression()) instanceof BinaryExpression) || ((BinaryExpression)expression2).astOperator() != BinaryOperator.ASSIGN || !targetName.equals((binaryExpression = (BinaryExpression)expression2).astLeft().toString())) continue;
                    return this.evaluate((Node)binaryExpression.astRight());
                }
            }
        } else if (node instanceof Cast) {
            JavaParser.ResolvedNode typeReference2;
            Cast cast = (Cast)node;
            if (this.mContext != null && (typeReference2 = this.mContext.resolve((Node)cast.astTypeReference())) instanceof JavaParser.ResolvedClass) {
                return ((JavaParser.ResolvedClass)typeReference2).getType();
            }
            JavaParser.TypeDescriptor viewType = this.evaluate((Node)cast.astOperand());
            if (viewType != null) {
                return viewType;
            }
        } else if (node instanceof Literal) {
            if (node instanceof NullLiteral) {
                return null;
            }
            if (node instanceof BooleanLiteral) {
                return new JavaParser.DefaultTypeDescriptor("boolean");
            }
            if (node instanceof StringLiteral) {
                return new JavaParser.DefaultTypeDescriptor("java.lang.String");
            }
            if (node instanceof CharLiteral) {
                return new JavaParser.DefaultTypeDescriptor("char");
            }
            if (node instanceof IntegralLiteral) {
                IntegralLiteral literal = (IntegralLiteral)node;
                if (literal.astMarkedAsLong()) {
                    return new JavaParser.DefaultTypeDescriptor("long");
                }
                return new JavaParser.DefaultTypeDescriptor("int");
            }
            if (node instanceof FloatingPointLiteral) {
                FloatingPointLiteral literal = (FloatingPointLiteral)node;
                if (literal.astMarkedAsFloat()) {
                    return new JavaParser.DefaultTypeDescriptor("float");
                }
                return new JavaParser.DefaultTypeDescriptor("double");
            }
        } else {
            if (node instanceof UnaryExpression) {
                return this.evaluate((Node)((UnaryExpression)node).astOperand());
            }
            if (node instanceof InlineIfExpression) {
                InlineIfExpression expression3 = (InlineIfExpression)node;
                if (expression3.astIfTrue() != null) {
                    return this.evaluate((Node)expression3.astIfTrue());
                }
                if (expression3.astIfFalse() != null) {
                    return this.evaluate((Node)expression3.astIfFalse());
                }
            } else if (node instanceof BinaryExpression) {
                BinaryExpression expression4 = (BinaryExpression)node;
                BinaryOperator operator = expression4.astOperator();
                switch (operator) {
                    case LOGICAL_OR: 
                    case LOGICAL_AND: 
                    case EQUALS: 
                    case NOT_EQUALS: 
                    case GREATER: 
                    case GREATER_OR_EQUAL: 
                    case LESS: 
                    case LESS_OR_EQUAL: {
                        return new JavaParser.DefaultTypeDescriptor("boolean");
                    }
                }
                JavaParser.TypeDescriptor type4 = this.evaluate((Node)expression4.astLeft());
                if (type4 != null) {
                    return type4;
                }
                return this.evaluate((Node)expression4.astRight());
            }
        }
        if (resolved instanceof JavaParser.ResolvedVariable) {
            JavaParser.ResolvedVariable variable2 = (JavaParser.ResolvedVariable)resolved;
            return variable2.getType();
        }
        return null;
    }

    public PsiType evaluate(PsiElement node) {
        if (node == null) {
            return null;
        }
        PsiElement resolved = null;
        if (node instanceof PsiReference) {
            resolved = ((PsiReference)node).resolve();
        }
        if (resolved instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolved;
            if (method.isConstructor()) {
                PsiClass containingClass = method.getContainingClass();
                if (containingClass != null && this.mContext != null) {
                    return this.mContext.getEvaluator().getClassType(containingClass);
                }
            } else {
                return method.getReturnType();
            }
        }
        if (resolved instanceof PsiField) {
            PsiType type2;
            PsiField field = (PsiField)resolved;
            if (field.getInitializer() != null && (type2 = this.evaluate((PsiElement)field.getInitializer())) != null) {
                return type2;
            }
            return field.getType();
        }
        if (resolved instanceof PsiLocalVariable) {
            PsiLocalVariable variable2 = (PsiLocalVariable)resolved;
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PsiStatement.class, (boolean)false);
            if (statement != null) {
                PsiStatement prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
                String targetName = variable2.getName();
                if (targetName == null) {
                    return null;
                }
                while (prev != null) {
                    PsiReferenceExpression reference;
                    PsiAssignmentExpression assign;
                    PsiExpression lhs;
                    PsiExpression expression2;
                    if (prev instanceof PsiDeclarationStatement) {
                        for (PsiElement element : ((PsiDeclarationStatement)prev).getDeclaredElements()) {
                            if (!variable2.equals(element)) continue;
                            return this.evaluate((PsiElement)variable2.getInitializer());
                        }
                    } else if (prev instanceof PsiExpressionStatement && (expression2 = ((PsiExpressionStatement)prev).getExpression()) instanceof PsiAssignmentExpression && (lhs = (assign = (PsiAssignmentExpression)expression2).getLExpression()) instanceof PsiReferenceExpression && targetName.equals((reference = (PsiReferenceExpression)lhs).getReferenceName()) && reference.getQualifier() == null) {
                        return this.evaluate((PsiElement)assign.getRExpression());
                    }
                    prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prev, PsiStatement.class);
                }
            }
            return variable2.getType();
        }
        if (node instanceof PsiExpression) {
            PsiExpression expression3 = (PsiExpression)node;
            return expression3.getType();
        }
        return null;
    }

    public static PsiType evaluate(JavaContext context, UElement node) {
        if (node == null) {
            return null;
        }
        UElement resolved = node;
        if (resolved instanceof UReferenceExpression) {
            resolved = UastUtils.tryResolveUDeclaration((UElement)resolved, (UastContext)context.getUastContext());
        }
        if (resolved instanceof UMethod) {
            return ((UMethod)resolved).getPsi().getReturnType();
        }
        if (resolved instanceof UVariable) {
            UVariable variable2 = (UVariable)resolved;
            UExpression lastAssignment = UastLintUtils.findLastAssignment((PsiVariable)variable2, node, context);
            if (lastAssignment != null) {
                return TypeEvaluator.evaluate(context, (UElement)lastAssignment);
            }
            return variable2.getType();
        }
        if (resolved instanceof UCallExpression) {
            if (UastExpressionUtils.isMethodCall((UElement)resolved)) {
                PsiMethod resolvedMethod = ((UCallExpression)resolved).resolve();
                return resolvedMethod != null ? resolvedMethod.getReturnType() : null;
            }
            return ((UCallExpression)resolved).getExpressionType();
        }
        if (resolved instanceof UExpression) {
            return ((UExpression)resolved).getExpressionType();
        }
        return null;
    }

    @Deprecated
    public static JavaParser.TypeDescriptor evaluate(JavaContext context, Node node) {
        return new TypeEvaluator(context).evaluate(node);
    }

    public static PsiType evaluate(JavaContext context, PsiElement node) {
        return new TypeEvaluator(context).evaluate(node);
    }
}

