/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.execution.testframework.sm.runner.ui.SMRootTestProxyFormatter;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.TestTreeRenderer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.externalSystem.execution.ExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemExecuteTaskTask;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.action.GradleRerunFailedTestsAction;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleConsoleProperties;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsoleOutputProcessor;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleTestsExecutionConsoleManager
implements ExternalSystemExecutionConsoleManager<ExternalSystemRunConfiguration, GradleTestsExecutionConsole, ProcessHandler> {
    @NotNull
    public ProjectSystemId getExternalSystemId() {
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        if (projectSystemId == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(0);
        }
        return projectSystemId;
    }

    @NotNull
    public GradleTestsExecutionConsole attachExecutionConsole(@NotNull ExternalSystemTask task, @NotNull Project project, @NotNull ExternalSystemRunConfiguration configuration, @NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler processHandler) {
        ExternalSystemExecuteTaskTask executeTask;
        TestTreeRenderer originalRenderer;
        if (task == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(1);
        }
        if (project == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(2);
        }
        if (configuration == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(3);
        }
        if (executor == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(4);
        }
        if (env == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(5);
        }
        if (processHandler == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(6);
        }
        GradleConsoleProperties consoleProperties = new GradleConsoleProperties(configuration, executor);
        String testFrameworkName = configuration.getSettings().getExternalSystemId().getReadableName();
        String splitterPropertyName = SMTestRunnerConnectionUtil.getSplitterPropertyName((String)testFrameworkName);
        GradleTestsExecutionConsole consoleView = new GradleTestsExecutionConsole((TestConsoleProperties)consoleProperties, splitterPropertyName);
        SMTestRunnerConnectionUtil.initConsoleView((SMTRunnerConsoleView)consoleView, (String)testFrameworkName);
        TestTreeView testTreeView = consoleView.getResultsViewer().getTreeView();
        if (testTreeView != null && (originalRenderer = (TestTreeRenderer)ObjectUtils.tryCast((Object)testTreeView.getCellRenderer(), TestTreeRenderer.class)) != null) {
            originalRenderer.setAdditionalRootFormatter(new SMRootTestProxyFormatter(){

                public void format(@NotNull SMTestProxy.SMRootTestProxy testProxy, @NotNull TestTreeRenderer renderer) {
                    TestStateInfo.Magnitude magnitude;
                    if (testProxy == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (renderer == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if ((magnitude = testProxy.getMagnitudeInfo()) == TestStateInfo.Magnitude.RUNNING_INDEX) {
                        renderer.clear();
                        renderer.append(GradleBundle.message("gradle.test.runner.ui.tests.tree.presentation.labels.waiting.tests", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else if (!testProxy.isInProgress() && testProxy.isEmptySuite()) {
                        renderer.clear();
                        renderer.append(GradleBundle.message("gradle.test.runner.ui.tests.tree.presentation.labels.no.tests.were.found", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "testProxy";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "renderer";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/gradle/execution/test/runner/GradleTestsExecutionConsoleManager$1";
                    objectArray[2] = "format";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        if (task instanceof ExternalSystemExecuteTaskTask && ((executeTask = (ExternalSystemExecuteTaskTask)task).getArguments() == null || !StringUtil.contains((CharSequence)executeTask.getArguments(), (CharSequence)"--tests"))) {
            executeTask.appendArguments("--tests *");
        }
        GradleTestsExecutionConsole gradleTestsExecutionConsole = consoleView;
        if (gradleTestsExecutionConsole == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(7);
        }
        return gradleTestsExecutionConsole;
    }

    public void onOutput(@NotNull GradleTestsExecutionConsole executionConsole, @NotNull ProcessHandler processHandler, @NotNull String text, @NotNull Key processOutputType) {
        if (executionConsole == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(8);
        }
        if (processHandler == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(9);
        }
        if (text == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(10);
        }
        if (processOutputType == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(11);
        }
        GradleTestsExecutionConsoleOutputProcessor.onOutput(executionConsole, text, processOutputType);
    }

    public boolean isApplicableFor(@NotNull ExternalSystemTask task) {
        if (task == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(12);
        }
        if (task instanceof ExternalSystemExecuteTaskTask) {
            ExternalSystemExecuteTaskTask taskTask = (ExternalSystemExecuteTaskTask)task;
            if (!StringUtil.equals((CharSequence)taskTask.getExternalSystemId().getId(), (CharSequence)GradleConstants.SYSTEM_ID.getId())) {
                return false;
            }
            return ContainerUtil.find((Iterable)taskTask.getTasksToExecute(), taskToExecute -> {
                ExternalProjectInfo externalProjectInfo;
                String projectPath = taskTask.getExternalProjectPath();
                File file = new File(projectPath);
                if (file.isFile()) {
                    projectPath = StringUtil.trimEnd((String)projectPath, (String)("/" + file.getName()));
                }
                if ((externalProjectInfo = ExternalSystemUtil.getExternalProjectInfo((Project)taskTask.getIdeProject(), (ProjectSystemId)this.getExternalSystemId(), (String)projectPath)) == null) {
                    return false;
                }
                DataNode<TaskData> taskDataNode = GradleProjectResolverUtil.findTask((DataNode<ProjectData>)externalProjectInfo.getExternalProjectStructure(), projectPath, taskToExecute);
                return taskDataNode != null && ("check".equals(((TaskData)taskDataNode.getData()).getName()) && "verification".equals(((TaskData)taskDataNode.getData()).getGroup()) || "org.gradle.api.tasks.testing.Test".equals(((TaskData)taskDataNode.getData()).getType()));
            }) != null;
        }
        return false;
    }

    public AnAction[] getRestartActions(@NotNull GradleTestsExecutionConsole consoleView) {
        if (consoleView == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(13);
        }
        GradleRerunFailedTestsAction rerunFailedTestsAction = new GradleRerunFailedTestsAction(consoleView);
        rerunFailedTestsAction.setModelProvider(() -> {
            if (consoleView == null) {
                GradleTestsExecutionConsoleManager.$$$reportNull$$$0(14);
            }
            return consoleView.getResultsViewer();
        });
        return new AnAction[]{rerunFailedTestsAction};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/test/runner/GradleTestsExecutionConsoleManager";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionConsole";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processOutputType";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalSystemId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/test/runner/GradleTestsExecutionConsoleManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "attachExecutionConsole";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "attachExecutionConsole";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onOutput";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableFor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRestartActions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getRestartActions$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

