/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@State(name="GradleLocalSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class GradleLocalSettings
extends AbstractExternalSystemLocalSettings
implements PersistentStateComponent<MyState> {
    private final AtomicReference<Map<String, String>> myGradleHomes;
    private final AtomicReference<Map<String, String>> myGradleVersions;

    public GradleLocalSettings(@NotNull Project project) {
        if (project == null) {
            GradleLocalSettings.$$$reportNull$$$0(0);
        }
        super(GradleConstants.SYSTEM_ID, project);
        this.myGradleHomes = new AtomicReference<HashMap>(ContainerUtilRt.newHashMap());
        this.myGradleVersions = new AtomicReference<HashMap>(ContainerUtilRt.newHashMap());
    }

    @NotNull
    public static GradleLocalSettings getInstance(@NotNull Project project) {
        if (project == null) {
            GradleLocalSettings.$$$reportNull$$$0(1);
        }
        GradleLocalSettings gradleLocalSettings = (GradleLocalSettings)((Object)ServiceManager.getService((Project)project, GradleLocalSettings.class));
        if (gradleLocalSettings == null) {
            GradleLocalSettings.$$$reportNull$$$0(2);
        }
        return gradleLocalSettings;
    }

    @Nullable
    public String getGradleHome(String linkedProjectPath) {
        return this.myGradleHomes.get().get(linkedProjectPath);
    }

    @Nullable
    public String getGradleVersion(String linkedProjectPath) {
        return this.myGradleVersions.get().get(linkedProjectPath);
    }

    public void setGradleHome(@NotNull String linkedProjectPath, @NotNull String gradleHome) {
        if (linkedProjectPath == null) {
            GradleLocalSettings.$$$reportNull$$$0(3);
        }
        if (gradleHome == null) {
            GradleLocalSettings.$$$reportNull$$$0(4);
        }
        this.myGradleHomes.get().put(linkedProjectPath, gradleHome);
        this.myGradleVersions.get().put(linkedProjectPath, GradleInstallationManager.getGradleVersion(gradleHome));
    }

    public void forgetExternalProjects(@NotNull Set<String> linkedProjectPathsToForget) {
        if (linkedProjectPathsToForget == null) {
            GradleLocalSettings.$$$reportNull$$$0(5);
        }
        super.forgetExternalProjects(linkedProjectPathsToForget);
        for (String path : linkedProjectPathsToForget) {
            this.myGradleHomes.get().remove(path);
            this.myGradleVersions.get().remove(path);
        }
    }

    @Nullable
    public MyState getState() {
        MyState state = new MyState();
        this.fillState(state);
        state.myGradleHomes = this.myGradleHomes.get();
        state.myGradleVersions = this.myGradleVersions.get();
        return state;
    }

    public void loadState(@NotNull MyState state) {
        if (state == null) {
            GradleLocalSettings.$$$reportNull$$$0(6);
        }
        super.loadState((AbstractExternalSystemLocalSettings.State)state);
        GradleLocalSettings.setIfNotNull(this.myGradleHomes, state.myGradleHomes);
        GradleLocalSettings.setIfNotNull(this.myGradleVersions, state.myGradleVersions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/settings/GradleLocalSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProjectPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleHome";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProjectPathsToForget";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleLocalSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setGradleHome";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forgetExternalProjects";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyState
    extends AbstractExternalSystemLocalSettings.State {
        public Map<String, String> myGradleHomes = ContainerUtilRt.newHashMap();
        public Map<String, String> myGradleVersions = ContainerUtilRt.newHashMap();
    }
}

