/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.model.impl.sdk;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gwt.model.GwtSdkPaths;
import org.jetbrains.jps.gwt.model.impl.sdk.GwtSdkPathUtil;
import org.jetbrains.jps.util.JpsPathUtil;

public class GwtVaadinMavenSdkPaths
implements GwtSdkPaths {
    public static final String TYPE_ID = "Vaadin-Maven";
    private final String myBasePath;
    private final String myClientDirPath;
    private final String myVersion;

    public GwtVaadinMavenSdkPaths(@NotNull String homePath) {
        if (homePath == null) {
            GwtVaadinMavenSdkPaths.$$$reportNull$$$0(0);
        }
        this.myClientDirPath = homePath;
        this.myBasePath = PathUtilRt.getParentPath((String)PathUtilRt.getParentPath((String)homePath));
        this.myVersion = GwtVaadinMavenSdkPaths.getVersion(homePath);
    }

    public String getVersion() {
        return this.myVersion;
    }

    public static String getVersion(String homePath) {
        return PathUtilRt.getFileName((String)homePath);
    }

    @Override
    @NotNull
    public String getDevJarPath(boolean systemIndependent) {
        String string = this.getJarPath("vaadin-client-compiler");
        if (string == null) {
            GwtVaadinMavenSdkPaths.$$$reportNull$$$0(1);
        }
        return string;
    }

    private String getJarPath(String artifactName) {
        return FileUtil.toSystemDependentName((String)(this.myBasePath + "/" + artifactName + "/" + this.myVersion + "/" + artifactName + "-" + this.myVersion + ".jar"));
    }

    @Override
    @NotNull
    public String getServletJarPath() {
        String string = this.getJarPath("vaadin-server");
        if (string == null) {
            GwtVaadinMavenSdkPaths.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getUserJarPath() {
        String string = this.getJarPath("vaadin-client");
        if (string == null) {
            GwtVaadinMavenSdkPaths.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public String getCodeServerJarPath() {
        return null;
    }

    @Override
    @NotNull
    public List<String> getAdditionalCompilerJars() {
        String repositoryPath = PathUtilRt.getParentPath((String)PathUtilRt.getParentPath((String)this.myBasePath));
        ArrayList<String> additionalJars = new ArrayList<String>();
        additionalJars.addAll(GwtSdkPathUtil.findValidationJarsInMavenRepo(repositoryPath));
        ContainerUtil.addIfNotNull(additionalJars, (Object)GwtVaadinMavenSdkPaths.getLatestArtifactPath(repositoryPath, "ant", "ant"));
        ContainerUtil.addIfNotNull(additionalJars, (Object)GwtVaadinMavenSdkPaths.getLatestArtifactPath(repositoryPath, "com.vaadin", "vaadin-client-compiler-deps"));
        ArrayList<String> arrayList = additionalJars;
        if (arrayList == null) {
            GwtVaadinMavenSdkPaths.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    public static String getLatestArtifactPath(String repositoryPath, String groupId, String artifactId) {
        String version;
        File jar;
        File dir = new File(FileUtil.toSystemDependentName((String)(repositoryPath + "/" + groupId.replace('.', '/') + "/" + artifactId)));
        String[] fileNames = dir.list();
        if (fileNames != null && fileNames.length > 0 && (jar = new File(dir, (version = Collections.max(Arrays.asList(fileNames), VersionComparatorUtil.COMPARATOR)) + "/" + artifactId + "-" + version + ".jar")).isFile()) {
            return jar.getAbsolutePath();
        }
        return null;
    }

    @Override
    @NotNull
    public String getHomeDirectoryUrl() {
        String string = JpsPathUtil.pathToUrl((String)FileUtil.toSystemIndependentName((String)this.myClientDirPath));
        if (string == null) {
            GwtVaadinMavenSdkPaths.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/gwt/model/impl/sdk/GwtVaadinMavenSdkPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/gwt/model/impl/sdk/GwtVaadinMavenSdkPaths";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevJarPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getServletJarPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserJarPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalCompilerJars";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeDirectoryUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

