/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.BinaryFileDecompiler;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.CharsetUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.ByteArrayCharSequence;
import com.intellij.util.text.CharArrayUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LoadTextUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.fileEditor.impl.LoadTextUtil");
    private static final Charset INTERNAL_SEVEN_BIT_UTF8 = new SevenBitCharset(CharsetToolkit.UTF8_CHARSET);
    private static final Charset INTERNAL_SEVEN_BIT_ISO_8859_1 = new SevenBitCharset(CharsetToolkit.ISO_8859_1_CHARSET);
    private static final Charset INTERNAL_SEVEN_BIT_WIN_1251 = new SevenBitCharset(CharsetToolkit.WIN_1251_CHARSET);
    private static final boolean GUESS_UTF = Boolean.parseBoolean(System.getProperty("idea.guess.utf.encoding", "true"));
    private static final Key<String> CHARSET_WAS_DETECTED_FROM_BYTES = Key.create("CHARSET_WAS_DETECTED_FROM_BYTES");

    private LoadTextUtil() {
    }

    @NotNull
    private static Pair<CharSequence, String> convertLineSeparatorsToSlashN(@NotNull CharBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertLineSeparatorsToSlashN"));
        }
        int dst = 0;
        int prev = 32;
        int crCount = 0;
        int lfCount = 0;
        int crlfCount = 0;
        int length = buffer.length();
        char[] bufferArray = CharArrayUtil.fromSequenceWithoutCopying(buffer);
        for (int src = 0; src < length; ++src) {
            int c = bufferArray != null ? bufferArray[src] : buffer.charAt(src);
            switch (c) {
                case 13: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    ++crCount;
                    break;
                }
                case 10: {
                    if (prev == 13) {
                        --crCount;
                        ++crlfCount;
                        break;
                    }
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    ++lfCount;
                    break;
                }
                default: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = c;
                        break;
                    }
                    buffer.put(dst++, (char)c);
                }
            }
            prev = c;
        }
        String detectedLineSeparator = LoadTextUtil.guessLineSeparator(crCount, lfCount, crlfCount);
        CharBuffer result2 = buffer.length() == dst ? buffer : buffer.subSequence(0, dst);
        Pair<CharSequence, String> pair = Pair.create(result2, detectedLineSeparator);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertLineSeparatorsToSlashN"));
        }
        return pair;
    }

    @NotNull
    private static Pair<CharSequence, String> convertLineSeparatorsToSlashN(@NotNull byte[] charsAsBytes, int startOffset, int endOffset) {
        if (charsAsBytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charsAsBytes", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertLineSeparatorsToSlashN"));
        }
        int index2 = ArrayUtil.indexOf(charsAsBytes, (byte)13, startOffset, endOffset);
        if (index2 == -1) {
            ByteArrayCharSequence sequence2 = new ByteArrayCharSequence(charsAsBytes, startOffset, endOffset);
            String detectedLineSeparator = ArrayUtil.indexOf(charsAsBytes, (byte)10, startOffset, endOffset) == -1 ? null : "\n";
            Pair<CharSequence, String> pair = Pair.create(sequence2, detectedLineSeparator);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertLineSeparatorsToSlashN"));
            }
            return pair;
        }
        int dst = 0;
        int prev = 32;
        int crCount = 0;
        int lfCount = 0;
        int crlfCount = 0;
        byte[] result2 = new byte[endOffset - startOffset];
        for (int src = startOffset; src < endOffset; ++src) {
            char c = (char)charsAsBytes[src];
            switch (c) {
                case '\r': {
                    result2[dst++] = 10;
                    ++crCount;
                    break;
                }
                case '\n': {
                    if (prev == 13) {
                        --crCount;
                        ++crlfCount;
                        break;
                    }
                    result2[dst++] = 10;
                    ++lfCount;
                    break;
                }
                default: {
                    result2[dst++] = (byte)c;
                }
            }
            prev = c;
        }
        String detectedLineSeparator = LoadTextUtil.guessLineSeparator(crCount, lfCount, crlfCount);
        ByteArrayCharSequence sequence3 = new ByteArrayCharSequence(result2, 0, dst);
        Pair<CharSequence, String> pair = Pair.create(sequence3, detectedLineSeparator);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertLineSeparatorsToSlashN"));
        }
        return pair;
    }

    @Nullable
    private static String guessLineSeparator(int crCount, int lfCount, int crlfCount) {
        String detectedLineSeparator = null;
        if (crlfCount > crCount && crlfCount > lfCount) {
            detectedLineSeparator = "\r\n";
        } else if (crCount > lfCount) {
            detectedLineSeparator = "\r";
        } else if (lfCount > 0) {
            detectedLineSeparator = "\n";
        }
        return detectedLineSeparator;
    }

    private static boolean isSevenBit(byte[] content, int startOffset, int endOffset) {
        for (int i = startOffset; i < endOffset; ++i) {
            byte b = content[i];
            if (b >= 0) continue;
            return false;
        }
        return true;
    }

    private static Charset detectCharset(@NotNull VirtualFile virtualFile2, @NotNull byte[] content, int startOffset, int endOffset, @NotNull FileType fileType, @NotNull Function<VirtualFile, Charset> computeCharsetIfNotDetected) {
        if (virtualFile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharset"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharset"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharset"));
        }
        if (computeCharsetIfNotDetected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computeCharsetIfNotDetected", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharset"));
        }
        Charset charset = null;
        String charsetName = fileType.getCharset(virtualFile2, content);
        Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> guessed = null;
        if (charsetName == null) {
            Charset hardCodedCharset;
            guessed = LoadTextUtil.guessFromContent(virtualFile2, content, startOffset, endOffset);
            Charset charset2 = hardCodedCharset = guessed == null ? null : (Charset)guessed.first;
            if (hardCodedCharset != null) {
                charset = hardCodedCharset;
            }
        } else {
            charset = CharsetToolkit.forName(charsetName);
        }
        if (charset == null) {
            charset = computeCharsetIfNotDetected.apply(virtualFile2);
        }
        if (charset == null && guessed != null && guessed.second != null) {
            if (guessed.second == CharsetToolkit.GuessedEncoding.VALID_UTF8) {
                return CharsetToolkit.UTF8_CHARSET;
            }
            if (guessed.second == CharsetToolkit.GuessedEncoding.SEVEN_BIT) {
                return CharsetToolkit.US_ASCII_CHARSET;
            }
        }
        return charset;
    }

    @NotNull
    private static Charset getDefaultCharsetFromEncodingManager(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getDefaultCharsetFromEncodingManager"));
        }
        Charset result2 = null;
        Charset specifiedExplicitly = EncodingRegistry.getInstance().getEncoding(virtualFile2, true);
        if (specifiedExplicitly != null) {
            result2 = specifiedExplicitly;
        }
        if (result2 == null) {
            result2 = EncodingRegistry.getInstance().getDefaultCharset();
        }
        Charset charset = result2;
        if (charset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getDefaultCharsetFromEncodingManager"));
        }
        return charset;
    }

    @NotNull
    private static Pair<Charset, byte[]> doDetectCharsetAndSetBOM(@NotNull VirtualFile virtualFile2, @NotNull byte[] content, int startOffset, int endOffset, boolean saveBOM, @NotNull FileType fileType, @Nullable Charset initialCharset, @NotNull Function<VirtualFile, Charset> computeCharsetIfNotDetected) {
        byte[] bom;
        if (virtualFile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "doDetectCharsetAndSetBOM"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "doDetectCharsetAndSetBOM"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "doDetectCharsetAndSetBOM"));
        }
        if (computeCharsetIfNotDetected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computeCharsetIfNotDetected", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "doDetectCharsetAndSetBOM"));
        }
        Charset charset = initialCharset != null ? initialCharset : LoadTextUtil.detectCharset(virtualFile2, content, startOffset, endOffset, fileType, computeCharsetIfNotDetected);
        Charset fromBOM = CharsetToolkit.guessFromBOM(content);
        charset = fromBOM == null || charset != null && charset.name().startsWith("NATIVE_TO_ASCII_") && charset.name().endsWith(fromBOM.name()) ? charset : fromBOM;
        byte[] byArray = bom = charset == null || fromBOM == null ? ArrayUtil.EMPTY_BYTE_ARRAY : LoadTextUtil.getBOM(content, charset);
        if (saveBOM && bom.length != 0) {
            virtualFile2.setBOM(bom);
            LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile2, "auto-detected from BOM");
        }
        virtualFile2.setCharset(charset);
        if (charset == CharsetToolkit.UTF8_CHARSET) {
            if (LoadTextUtil.isSevenBit(content, startOffset, endOffset)) {
                charset = INTERNAL_SEVEN_BIT_UTF8;
            }
        } else if (charset == CharsetToolkit.ISO_8859_1_CHARSET) {
            if (LoadTextUtil.isSevenBit(content, startOffset, endOffset)) {
                charset = INTERNAL_SEVEN_BIT_ISO_8859_1;
            }
        } else if (charset == CharsetToolkit.WIN_1251_CHARSET && LoadTextUtil.isSevenBit(content, startOffset, endOffset)) {
            charset = INTERNAL_SEVEN_BIT_WIN_1251;
        }
        Pair<Charset, byte[]> pair = Pair.create(charset, bom);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "doDetectCharsetAndSetBOM"));
        }
        return pair;
    }

    @Nullable(value="null means no luck, otherwise it's tuple(guessed encoding, hint about content if was unable to guess, BOM)")
    public static Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> guessFromContent(@NotNull VirtualFile virtualFile2, @NotNull byte[] content, int length) {
        if (virtualFile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "guessFromContent"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "guessFromContent"));
        }
        return LoadTextUtil.guessFromContent(virtualFile2, content, 0, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> guessFromContent(@NotNull VirtualFile virtualFile2, @NotNull byte[] content, int startOffset, int endOffset) {
        String detectedFromBytes;
        block8: {
            CharsetToolkit.GuessedEncoding guessed;
            block10: {
                CharsetToolkit toolkit;
                block9: {
                    if (virtualFile2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "guessFromContent"));
                    }
                    if (content == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "guessFromContent"));
                    }
                    Charset defaultCharset = ObjectUtils.notNull(EncodingManager.getInstance().getEncoding(virtualFile2, true), CharsetToolkit.getDefaultSystemCharset());
                    toolkit = GUESS_UTF ? new CharsetToolkit(content, defaultCharset) : null;
                    detectedFromBytes = null;
                    if (!GUESS_UTF) break block8;
                    toolkit.setEnforce8Bit(true);
                    Charset charset = toolkit.guessFromBOM();
                    if (charset == null) break block9;
                    detectedFromBytes = "auto-detected from BOM";
                    byte[] bom = ObjectUtils.notNull(CharsetToolkit.getMandatoryBom(charset), CharsetToolkit.UTF8_BOM);
                    Trinity<Charset, Object, byte[]> trinity = Trinity.create(charset, null, bom);
                    LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile2, detectedFromBytes);
                    return trinity;
                }
                guessed = toolkit.guessFromContent(startOffset, endOffset);
                if (guessed != CharsetToolkit.GuessedEncoding.VALID_UTF8) break block10;
                detectedFromBytes = "auto-detected from bytes";
                Trinity<Charset, CharsetToolkit.GuessedEncoding, Object> trinity = Trinity.create(CharsetToolkit.UTF8_CHARSET, CharsetToolkit.GuessedEncoding.VALID_UTF8, null);
                LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile2, detectedFromBytes);
                return trinity;
            }
            if (guessed != CharsetToolkit.GuessedEncoding.SEVEN_BIT) break block8;
            Trinity<Object, CharsetToolkit.GuessedEncoding, Object> trinity = Trinity.create(null, CharsetToolkit.GuessedEncoding.SEVEN_BIT, null);
            LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile2, detectedFromBytes);
            return trinity;
        }
        try {
            Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> trinity = null;
            return trinity;
        }
        finally {
            LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile2, detectedFromBytes);
        }
    }

    @NotNull
    private static byte[] getBOM(@NotNull byte[] content, @NotNull Charset charset) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getBOM"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getBOM"));
        }
        if (charset.name().contains("UTF-8") && CharsetToolkit.hasUTF8Bom(content)) {
            if (CharsetToolkit.UTF8_BOM == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getBOM"));
            }
            return CharsetToolkit.UTF8_BOM;
        }
        byte[] bom = ObjectUtils.notNull(CharsetToolkit.getMandatoryBom(charset), ArrayUtil.EMPTY_BYTE_ARRAY);
        byte[] byArray = ObjectUtils.notNull(bom, ArrayUtil.EMPTY_BYTE_ARRAY);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getBOM"));
        }
        return byArray;
    }

    public static void write(@Nullable Project project, @NotNull VirtualFile virtualFile2, @NotNull Object requestor, @NotNull String text2, long newModificationStamp) throws IOException {
        if (virtualFile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "write"));
        }
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "write"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "write"));
        }
        Charset existing = virtualFile2.getCharset();
        Pair.NonNull<Charset, byte[]> chosen = LoadTextUtil.charsetForWriting(project, virtualFile2, text2, existing);
        Charset charset = (Charset)chosen.first;
        byte[] buffer = (byte[])chosen.second;
        if (!charset.equals(existing)) {
            virtualFile2.setCharset(charset);
        }
        LoadTextUtil.setDetectedFromBytesFlagBack(virtualFile2, buffer);
        virtualFile2.setBinaryContent(buffer, newModificationStamp, -1L, requestor);
    }

    @NotNull
    private static Pair.NonNull<Charset, byte[]> charsetForWriting(@Nullable Project project, @NotNull VirtualFile virtualFile2, @NotNull String text2, @NotNull Charset existing) {
        Charset fromBom;
        if (virtualFile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "charsetForWriting"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "charsetForWriting"));
        }
        if (existing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existing", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "charsetForWriting"));
        }
        Charset specified = LoadTextUtil.extractCharsetFromFileContent(project, virtualFile2, text2);
        Pair.NonNull<Charset, byte[]> chosen = LoadTextUtil.chooseMostlyHarmlessCharset(existing, specified, text2);
        Charset charset = (Charset)chosen.first;
        byte[] bom = virtualFile2.getBOM();
        Charset charset2 = fromBom = bom == null ? null : CharsetToolkit.guessFromBOM(bom);
        if (fromBom != null && !fromBom.equals(charset)) {
            chosen = Pair.createNonNull(fromBom, text2.getBytes(fromBom));
        }
        Pair.NonNull<Charset, byte[]> nonNull = chosen;
        if (nonNull == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "charsetForWriting"));
        }
        return nonNull;
    }

    private static void setDetectedFromBytesFlagBack(@NotNull VirtualFile virtualFile2, @NotNull byte[] content) {
        if (virtualFile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "setDetectedFromBytesFlagBack"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "setDetectedFromBytesFlagBack"));
        }
        if (virtualFile2.getBOM() == null) {
            LoadTextUtil.guessFromContent(virtualFile2, content, content.length);
        } else {
            LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile2, "auto-detected from BOM");
        }
    }

    @NotNull
    public static Pair.NonNull<Charset, byte[]> chooseMostlyHarmlessCharset(@NotNull Charset existing, @NotNull Charset specified, @NotNull String text2) {
        block15: {
            byte[] out;
            block14: {
                block13: {
                    Pair.NonNull<Charset, byte[]> nonNull;
                    if (existing == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existing", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
                    }
                    if (specified == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specified", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
                    }
                    if (text2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
                    }
                    try {
                        if (!specified.equals(existing)) break block13;
                        nonNull = Pair.createNonNull(specified, text2.getBytes(existing));
                    }
                    catch (RuntimeException e) {
                        Charset defaultCharset = Charset.defaultCharset();
                        Pair.NonNull<Charset, byte[]> nonNull2 = Pair.createNonNull(defaultCharset, text2.getBytes(defaultCharset));
                        if (nonNull2 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
                        }
                        return nonNull2;
                    }
                    if (nonNull == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
                    }
                    return nonNull;
                }
                out = LoadTextUtil.isSupported(specified, text2);
                if (out == null) break block14;
                Pair.NonNull<Charset, byte[]> nonNull = Pair.createNonNull(specified, out);
                if (nonNull == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
                }
                return nonNull;
            }
            out = LoadTextUtil.isSupported(existing, text2);
            if (out == null) break block15;
            Pair.NonNull<Charset, byte[]> nonNull = Pair.createNonNull(existing, out);
            if (nonNull == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
            }
            return nonNull;
        }
        Pair.NonNull<Charset, byte[]> nonNull = Pair.createNonNull(specified, text2.getBytes(specified));
        if (nonNull == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
        }
        return nonNull;
    }

    @Nullable(value="null means not supported, otherwise it is converted byte stream")
    private static byte[] isSupported(@NotNull Charset charset, @NotNull String str) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "isSupported"));
        }
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "isSupported"));
        }
        try {
            if (!charset.canEncode()) {
                return null;
            }
            byte[] bytes = str.getBytes(charset);
            if (!str.equals(new String(bytes, charset))) {
                return null;
            }
            return bytes;
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public static Charset extractCharsetFromFileContent(@Nullable Project project, @NotNull VirtualFile virtualFile2, @NotNull CharSequence text2) {
        if (virtualFile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "extractCharsetFromFileContent"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "extractCharsetFromFileContent"));
        }
        Charset charset = ObjectUtils.notNull(LoadTextUtil.charsetFromContentOrNull(project, virtualFile2, text2), virtualFile2.getCharset());
        if (charset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "extractCharsetFromFileContent"));
        }
        return charset;
    }

    @Nullable(value="returns null if cannot determine from content")
    public static Charset charsetFromContentOrNull(@Nullable Project project, @NotNull VirtualFile virtualFile2, @NotNull CharSequence text2) {
        if (virtualFile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "charsetFromContentOrNull"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "charsetFromContentOrNull"));
        }
        return CharsetUtil.extractCharsetFromFileContent(project, virtualFile2, virtualFile2.getFileType(), text2);
    }

    @NotNull
    public static CharSequence loadText(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "loadText"));
        }
        FileType type2 = file.getFileType();
        if (type2.isBinary()) {
            BinaryFileDecompiler decompiler = (BinaryFileDecompiler)BinaryFileTypeDecompilers.INSTANCE.forFileType(type2);
            if (decompiler != null) {
                CharSequence text2 = decompiler.decompile(file);
                try {
                    StringUtil.assertValidSeparators(text2);
                }
                catch (AssertionError e) {
                    LOG.error((Throwable)((Object)e));
                }
                CharSequence charSequence = text2;
                if (charSequence == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "loadText"));
                }
                return charSequence;
            }
            throw new IllegalArgumentException("Attempt to load text for binary file which doesn't have a decompiler plugged in: " + file.getPresentableUrl() + ". File type: " + type2.getName());
        }
        CharSequence charSequence = LoadTextUtil.loadText(file, -1);
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "loadText"));
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence loadText(@NotNull VirtualFile file, int limit) {
        CharSequence charSequence;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "loadText"));
        }
        FileType type2 = file.getFileType();
        if (type2.isBinary()) {
            throw new IllegalArgumentException("Attempt to load truncated text for binary file: " + file.getPresentableUrl() + ". File type: " + type2.getName());
        }
        if (file instanceof LightVirtualFile) {
            CharSequence charSequence2 = LoadTextUtil.limitCharSequence(((LightVirtualFile)file).getContent(), limit);
            if (charSequence2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "loadText"));
            }
            return charSequence2;
        }
        if (file.isDirectory()) {
            throw new AssertionError((Object)("'" + file.getPresentableUrl() + "' is a directory"));
        }
        try {
            byte[] bytes = limit == -1 ? file.contentsToByteArray() : FileUtil.loadFirstAndClose(file.getInputStream(), limit);
            charSequence = LoadTextUtil.getTextByBinaryPresentation(bytes, file);
        }
        catch (IOException e) {
            CharSequence charSequence3 = ArrayUtil.EMPTY_CHAR_SEQUENCE;
            if (charSequence3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "loadText"));
            }
            return charSequence3;
        }
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "loadText"));
        }
        return charSequence;
    }

    @NotNull
    private static CharSequence limitCharSequence(@NotNull CharSequence sequence2, int limit) {
        if (sequence2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "limitCharSequence"));
        }
        CharSequence charSequence = limit == -1 ? sequence2 : sequence2.subSequence(0, Math.min(limit, sequence2.length()));
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "limitCharSequence"));
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull VirtualFile virtualFile2) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        if (virtualFile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        CharSequence charSequence = LoadTextUtil.getTextByBinaryPresentation(bytes, virtualFile2, true, true);
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull VirtualFile virtualFile2, boolean saveDetectedSeparators, boolean saveBOM) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        if (virtualFile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        Pair<Charset, byte[]> pair = LoadTextUtil.doDetectCharsetAndSetBOM(virtualFile2, bytes, 0, bytes.length, saveBOM, virtualFile2.getFileType(), virtualFile2.isCharsetSet() ? virtualFile2.getCharset() : null, LoadTextUtil::getDefaultCharsetFromEncodingManager);
        Charset internalCharset = pair.getFirst();
        byte[] bom = pair.getSecond();
        Pair<CharSequence, String> result2 = LoadTextUtil.convertBytes(bytes, Math.min(bom.length, bytes.length), bytes.length, internalCharset);
        if (saveDetectedSeparators) {
            virtualFile2.setDetectedLineSeparator(result2.getSecond());
        }
        CharSequence charSequence = result2.getFirst();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        return charSequence;
    }

    @NotNull
    private static Pair<CharSequence, String> convertBytes(@NotNull byte[] bytes, int startOffset, int endOffset, @NotNull Charset internalCharset) {
        CharBuffer charBuffer;
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertBytes"));
        }
        if (internalCharset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalCharset", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertBytes"));
        }
        assert (startOffset >= 0 && startOffset <= endOffset && endOffset <= bytes.length) : startOffset + "," + endOffset + ": " + bytes.length;
        if (internalCharset instanceof SevenBitCharset || internalCharset == CharsetToolkit.US_ASCII_CHARSET) {
            Pair<CharSequence, String> pair = LoadTextUtil.convertLineSeparatorsToSlashN(bytes, startOffset, endOffset);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertBytes"));
            }
            return pair;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, startOffset, endOffset - startOffset);
        try {
            charBuffer = internalCharset.decode(byteBuffer);
        }
        catch (Exception e) {
            charBuffer = CharBuffer.wrap(ArrayUtil.EMPTY_CHAR_ARRAY);
        }
        Pair<CharSequence, String> pair = LoadTextUtil.convertLineSeparatorsToSlashN(charBuffer);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertBytes"));
        }
        return pair;
    }

    public static void setCharsetWasDetectedFromBytes(@NotNull VirtualFile virtualFile2, @Nullable(value="null if was not detected, otherwise the reason it was") String reason) {
        if (virtualFile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "setCharsetWasDetectedFromBytes"));
        }
        virtualFile2.putUserData(CHARSET_WAS_DETECTED_FROM_BYTES, reason);
    }

    private static class SevenBitCharset
    extends Charset {
        private final Charset myBaseCharset;

        SevenBitCharset(Charset baseCharset) {
            super("MY__7BIT_" + baseCharset.name(), ArrayUtil.EMPTY_STRING_ARRAY);
            this.myBaseCharset = baseCharset;
        }

        @Override
        public boolean contains(Charset cs) {
            throw new IllegalStateException();
        }

        @Override
        public CharsetDecoder newDecoder() {
            throw new IllegalStateException();
        }

        @Override
        public CharsetEncoder newEncoder() {
            throw new IllegalStateException();
        }
    }
}

