/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.ThreadLocalCachedByteArray;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import org.iq80.snappy.Snappy;
import org.jetbrains.annotations.NotNull;

public class CompressionUtil {
    private static final ThreadLocalCachedByteArray spareBufferLocal = new ThreadLocalCachedByteArray();
    private static final AtomicInteger myCompressionRequests = new AtomicInteger();
    private static final AtomicLong myCompressionTime = new AtomicLong();
    private static final AtomicInteger myDecompressionRequests = new AtomicInteger();
    private static final AtomicLong myDecompressionTime = new AtomicLong();
    private static final AtomicLong myDecompressedSize = new AtomicLong();
    private static final AtomicLong mySizeBeforeCompression = new AtomicLong();
    private static final AtomicLong mySizeAfterCompression = new AtomicLong();
    public static final boolean DUMP_COMPRESSION_STATS = SystemProperties.getBooleanProperty("idea.dump.compression.stats", false);
    public static final boolean USE_SNAPPY = SystemProperties.getBooleanProperty("idea.use.snappy", true);

    public static int writeCompressedWithoutOriginalBufferLength(@NotNull DataOutput out, @NotNull byte[] bytes, int length) throws IOException {
        int compressedSize;
        byte[] compressedOutputBuffer;
        long started;
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/util/CompressionUtil", "writeCompressedWithoutOriginalBufferLength"));
        }
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/util/CompressionUtil", "writeCompressedWithoutOriginalBufferLength"));
        }
        long l = started = DUMP_COMPRESSION_STATS ? System.nanoTime() : 0L;
        if (USE_SNAPPY) {
            compressedOutputBuffer = spareBufferLocal.getBuffer(Snappy.maxCompressedLength(length));
            compressedSize = Snappy.compress(bytes, 0, length, compressedOutputBuffer, 0);
        } else {
            LZ4Compressor compressor = LZ4Factory.fastestJavaInstance().fastCompressor();
            compressedOutputBuffer = spareBufferLocal.getBuffer(compressor.maxCompressedLength(length));
            compressedSize = compressor.compress(bytes, 0, length, compressedOutputBuffer, 0);
        }
        long time = (DUMP_COMPRESSION_STATS ? System.nanoTime() : 0L) - started;
        mySizeAfterCompression.addAndGet(compressedSize);
        mySizeBeforeCompression.addAndGet(length);
        int requests = myCompressionRequests.incrementAndGet();
        long l2 = myCompressionTime.addAndGet(time);
        if (DUMP_COMPRESSION_STATS && requests % 1000 == 0) {
            System.out.println("Compressed " + requests + " times, size:" + mySizeBeforeCompression + "->" + mySizeAfterCompression + " for " + l2 / 1000000L + "ms");
        }
        DataInputOutputUtil.writeINT(out, compressedSize);
        out.write(compressedOutputBuffer, 0, compressedSize);
        return compressedSize;
    }

    @NotNull
    public static byte[] readCompressedWithoutOriginalBufferLength(@NotNull DataInput in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/util/CompressionUtil", "readCompressedWithoutOriginalBufferLength"));
        }
        int size = DataInputOutputUtil.readINT(in);
        byte[] bytes = spareBufferLocal.getBuffer(size);
        in.readFully(bytes, 0, size);
        int decompressedRequests = myDecompressionRequests.incrementAndGet();
        long started = DUMP_COMPRESSION_STATS ? System.nanoTime() : 0L;
        byte[] decompressedResult = USE_SNAPPY ? Snappy.uncompress(bytes, 0, size) : LZ4Factory.fastestJavaInstance().fastDecompressor().decompress(bytes, 0, 32768);
        long doneTime = (DUMP_COMPRESSION_STATS ? System.nanoTime() : 0L) - started;
        long decompressedSize = myDecompressedSize.addAndGet(size);
        long decompressedTime = myDecompressionTime.addAndGet(doneTime);
        if (DUMP_COMPRESSION_STATS && decompressedRequests % 1000 == 0) {
            System.out.println("Decompressed " + decompressedRequests + " times, size: " + decompressedSize + " for " + decompressedTime / 1000000L + "ms");
        }
        if (decompressedResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CompressionUtil", "readCompressedWithoutOriginalBufferLength"));
        }
        return decompressedResult;
    }
}

