/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.common.output.outputUtils.OutputUtilsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.ContentRootsKt;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.incremental.js.TranslationResultValue;
import org.jetbrains.kotlin.js.analyze.TopDownAnalyzerFacadeForJS;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.config.EcmaVersion;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.config.SourceMapSourceEmbedding;
import org.jetbrains.kotlin.js.facade.K2JSTranslator;
import org.jetbrains.kotlin.js.facade.MainCallParameters;
import org.jetbrains.kotlin.js.facade.TranslationResult;
import org.jetbrains.kotlin.js.facade.TranslationUnit;
import org.jetbrains.kotlin.js.facade.exceptions.TranslationException;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.StringsKt;

public class K2JSCompiler
extends CLICompiler<K2JSCompilerArguments> {
    private static final Map<String, ModuleKind> moduleKindMap = new HashMap<String, ModuleKind>();
    private static final Map<String, SourceMapSourceEmbedding> sourceMapContentEmbeddingMap = new LinkedHashMap<String, SourceMapSourceEmbedding>();

    public static void main(String ... args) {
        K2JSCompiler.doMain(new K2JSCompiler(), args);
    }

    @Override
    @NotNull
    public K2JSCompilerArguments createArguments() {
        K2JSCompilerArguments k2JSCompilerArguments = new K2JSCompilerArguments();
        if (k2JSCompilerArguments == null) {
            K2JSCompiler.$$$reportNull$$$0(0);
        }
        return k2JSCompilerArguments;
    }

    @NotNull
    protected TranslationResult translate(@NotNull JsConfig.Reporter reporter2, @NotNull List<KtFile> allKotlinFiles2, @NotNull JsAnalysisResult jsAnalysisResult, @NotNull MainCallParameters mainCallParameters, @NotNull JsConfig config) throws TranslationException {
        if (reporter2 == null) {
            K2JSCompiler.$$$reportNull$$$0(1);
        }
        if (allKotlinFiles2 == null) {
            K2JSCompiler.$$$reportNull$$$0(2);
        }
        if (jsAnalysisResult == null) {
            K2JSCompiler.$$$reportNull$$$0(3);
        }
        if (mainCallParameters == null) {
            K2JSCompiler.$$$reportNull$$$0(4);
        }
        if (config == null) {
            K2JSCompiler.$$$reportNull$$$0(5);
        }
        K2JSTranslator translator = new K2JSTranslator(config);
        IncrementalDataProvider incrementalDataProvider = config.getConfiguration().get(JSConfigurationKeys.INCREMENTAL_DATA_PROVIDER);
        if (incrementalDataProvider != null) {
            HashMap<File, KtFile> nonCompiledSources = new HashMap<File, KtFile>(allKotlinFiles2.size());
            for (KtFile ktFile : allKotlinFiles2) {
                nonCompiledSources.put(VfsUtilCore.virtualToIoFile(ktFile.getVirtualFile()), ktFile);
            }
            Map<File, TranslationResultValue> compiledParts = incrementalDataProvider.getCompiledPackageParts();
            Object[] allSources = new File[compiledParts.size() + allKotlinFiles2.size()];
            int i = 0;
            for (File file : compiledParts.keySet()) {
                allSources[i++] = file;
            }
            for (File file : nonCompiledSources.keySet()) {
                allSources[i++] = file;
            }
            Arrays.sort(allSources);
            ArrayList<TranslationUnit> translationUnits = new ArrayList<TranslationUnit>();
            for (i = 0; i < allSources.length; ++i) {
                KtFile nonCompiled = (KtFile)nonCompiledSources.get(allSources[i]);
                if (nonCompiled != null) {
                    translationUnits.add(new TranslationUnit.SourceFile(nonCompiled));
                    continue;
                }
                TranslationResultValue translatedValue = compiledParts.get(allSources[i]);
                translationUnits.add(new TranslationUnit.BinaryAst(translatedValue.getBinaryAst()));
            }
            TranslationResult translationResult = translator.translateUnits(reporter2, translationUnits, mainCallParameters, jsAnalysisResult);
            if (translationResult == null) {
                K2JSCompiler.$$$reportNull$$$0(6);
            }
            return translationResult;
        }
        TranslationResult translationResult = translator.translate(reporter2, allKotlinFiles2, mainCallParameters, jsAnalysisResult);
        if (translationResult == null) {
            K2JSCompiler.$$$reportNull$$$0(7);
        }
        return translationResult;
    }

    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JSCompilerArguments arguments2, @NotNull CompilerConfiguration configuration, @NotNull Disposable rootDisposable, @Nullable KotlinPaths paths) {
        TranslationResult translationResult;
        if (arguments2 == null) {
            K2JSCompiler.$$$reportNull$$$0(8);
        }
        if (configuration == null) {
            K2JSCompiler.$$$reportNull$$$0(9);
        }
        if (rootDisposable == null) {
            K2JSCompiler.$$$reportNull$$$0(10);
        }
        final MessageCollector messageCollector2 = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (arguments2.getFreeArgs().isEmpty() && !IncrementalCompilation.isEnabledForJs()) {
            if (arguments2.getVersion()) {
                ExitCode exitCode2 = ExitCode.OK;
                if (exitCode2 == null) {
                    K2JSCompiler.$$$reportNull$$$0(11);
                }
                return exitCode2;
            }
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Specify at least one source file or directory", null);
            ExitCode exitCode3 = ExitCode.COMPILATION_ERROR;
            if (exitCode3 == null) {
                K2JSCompiler.$$$reportNull$$$0(12);
            }
            return exitCode3;
        }
        configuration.put(JSConfigurationKeys.LIBRARIES, K2JSCompiler.configureLibraries(arguments2, paths, messageCollector2));
        ContentRootsKt.addKotlinSourceRoots(configuration, arguments2.getFreeArgs());
        KotlinCoreEnvironment environmentForJS = KotlinCoreEnvironment.createForProduction(rootDisposable, configuration, EnvironmentConfigFiles.JS_CONFIG_FILES);
        Project project = environmentForJS.getProject();
        List<KtFile> sourcesFiles = environmentForJS.getSourceFiles();
        environmentForJS.getConfiguration().put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments2.getAllowKotlinPackage());
        if (!UtilsKt.checkKotlinPackageUsage(environmentForJS, sourcesFiles)) {
            ExitCode exitCode4 = ExitCode.COMPILATION_ERROR;
            if (exitCode4 == null) {
                K2JSCompiler.$$$reportNull$$$0(13);
            }
            return exitCode4;
        }
        if (arguments2.getOutputFile() == null) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Specify output file via -output", null);
            ExitCode exitCode5 = ExitCode.COMPILATION_ERROR;
            if (exitCode5 == null) {
                K2JSCompiler.$$$reportNull$$$0(14);
            }
            return exitCode5;
        }
        if (messageCollector2.hasErrors()) {
            ExitCode exitCode6 = ExitCode.COMPILATION_ERROR;
            if (exitCode6 == null) {
                K2JSCompiler.$$$reportNull$$$0(15);
            }
            return exitCode6;
        }
        if (sourcesFiles.isEmpty() && !IncrementalCompilation.isEnabledForJs()) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "No source files", null);
            ExitCode exitCode7 = ExitCode.COMPILATION_ERROR;
            if (exitCode7 == null) {
                K2JSCompiler.$$$reportNull$$$0(16);
            }
            return exitCode7;
        }
        if (arguments2.getVerbose()) {
            K2JSCompiler.reportCompiledSourcesList(messageCollector2, sourcesFiles);
        }
        File outputFile = new File(arguments2.getOutputFile());
        configuration.put(CommonConfigurationKeys.MODULE_NAME, FileUtil.getNameWithoutExtension(outputFile));
        JsConfig config = new JsConfig(project, configuration);
        JsConfig.Reporter reporter2 = new JsConfig.Reporter(){

            @Override
            public void error(@NotNull String message) {
                if (message == null) {
                    1.$$$reportNull$$$0(0);
                }
                messageCollector2.report(CompilerMessageSeverity.ERROR, message, null);
            }

            @Override
            public void warning(@NotNull String message) {
                if (message == null) {
                    1.$$$reportNull$$$0(1);
                }
                messageCollector2.report(CompilerMessageSeverity.STRONG_WARNING, message, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "message";
                objectArray2[1] = "org/jetbrains/kotlin/cli/js/K2JSCompiler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "error";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "warning";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (config.checkLibFilesAndReportErrors(reporter2)) {
            ExitCode exitCode8 = ExitCode.COMPILATION_ERROR;
            if (exitCode8 == null) {
                K2JSCompiler.$$$reportNull$$$0(17);
            }
            return exitCode8;
        }
        AnalyzerWithCompilerReport analyzerWithCompilerReport = new AnalyzerWithCompilerReport(messageCollector2);
        analyzerWithCompilerReport.analyzeAndReport(sourcesFiles, () -> TopDownAnalyzerFacadeForJS.analyzeFiles(sourcesFiles, config));
        if (analyzerWithCompilerReport.hasErrors()) {
            ExitCode exitCode9 = ExitCode.COMPILATION_ERROR;
            if (exitCode9 == null) {
                K2JSCompiler.$$$reportNull$$$0(18);
            }
            return exitCode9;
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        AnalysisResult analysisResult2 = analyzerWithCompilerReport.getAnalysisResult();
        assert (analysisResult2 instanceof JsAnalysisResult) : "analysisResult should be instance of JsAnalysisResult, but " + analysisResult2;
        JsAnalysisResult jsAnalysisResult = (JsAnalysisResult)analysisResult2;
        File outputPrefixFile = null;
        if (arguments2.getOutputPrefix() != null && !(outputPrefixFile = new File(arguments2.getOutputPrefix())).exists()) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Output prefix file '" + arguments2.getOutputPrefix() + "' not found", null);
            ExitCode exitCode10 = ExitCode.COMPILATION_ERROR;
            if (exitCode10 == null) {
                K2JSCompiler.$$$reportNull$$$0(19);
            }
            return exitCode10;
        }
        File outputPostfixFile = null;
        if (arguments2.getOutputPostfix() != null && !(outputPostfixFile = new File(arguments2.getOutputPostfix())).exists()) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Output postfix file '" + arguments2.getOutputPostfix() + "' not found", null);
            ExitCode exitCode11 = ExitCode.COMPILATION_ERROR;
            if (exitCode11 == null) {
                K2JSCompiler.$$$reportNull$$$0(20);
            }
            return exitCode11;
        }
        if (config.getConfiguration().getBoolean(JSConfigurationKeys.SOURCE_MAP)) {
            K2JSCompiler.checkDuplicateSourceFileNames(messageCollector2, sourcesFiles, config.getSourceMapRoots());
        }
        MainCallParameters mainCallParameters = K2JSCompiler.createMainCallParameters(arguments2.getMain());
        try {
            translationResult = this.translate(reporter2, sourcesFiles, jsAnalysisResult, mainCallParameters, config);
        }
        catch (Exception e) {
            throw ExceptionUtilsKt.rethrow(e);
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        AnalyzerWithCompilerReport.Companion.reportDiagnostics(translationResult.getDiagnostics(), messageCollector2);
        if (!(translationResult instanceof TranslationResult.Success)) {
            ExitCode exitCode12 = ExitCode.COMPILATION_ERROR;
            if (exitCode12 == null) {
                K2JSCompiler.$$$reportNull$$$0(21);
            }
            return exitCode12;
        }
        TranslationResult.Success successResult = (TranslationResult.Success)translationResult;
        OutputFileCollection outputFiles = successResult.getOutputFiles(outputFile, outputPrefixFile, outputPostfixFile);
        if (outputFile.isDirectory()) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Cannot open output file '" + outputFile.getPath() + "': is a directory", null);
            ExitCode exitCode13 = ExitCode.COMPILATION_ERROR;
            if (exitCode13 == null) {
                K2JSCompiler.$$$reportNull$$$0(22);
            }
            return exitCode13;
        }
        File outputDir2 = outputFile.getParentFile();
        if (outputDir2 == null) {
            outputDir2 = outputFile.getAbsoluteFile().getParentFile();
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        OutputUtilsKt.writeAll(outputFiles, outputDir2, messageCollector2, configuration.getBoolean(CommonConfigurationKeys.REPORT_OUTPUT_FILES));
        ExitCode exitCode14 = ExitCode.OK;
        if (exitCode14 == null) {
            K2JSCompiler.$$$reportNull$$$0(23);
        }
        return exitCode14;
    }

    private static void checkDuplicateSourceFileNames(@NotNull MessageCollector log2, @NotNull List<KtFile> sourceFiles2, @NotNull List<String> sourceRoots) {
        if (log2 == null) {
            K2JSCompiler.$$$reportNull$$$0(24);
        }
        if (sourceFiles2 == null) {
            K2JSCompiler.$$$reportNull$$$0(25);
        }
        if (sourceRoots == null) {
            K2JSCompiler.$$$reportNull$$$0(26);
        }
        if (sourceRoots.isEmpty()) {
            return;
        }
        List<File> sourceRootFiles = sourceRoots.stream().map(File::new).collect(Collectors.toList());
        SourceFilePathResolver pathResolver = new SourceFilePathResolver(sourceRootFiles);
        HashMap<String, String> pathMap = new HashMap<String, String>();
        HashSet<String> duplicatePaths = new HashSet<String>();
        try {
            for (KtFile sourceFile : sourceFiles2) {
                String path = sourceFile.getVirtualFile().getPath();
                String relativePath = pathResolver.getPathRelativeToSourceRoots(new File(sourceFile.getVirtualFile().getPath()));
                String existingPath = (String)pathMap.get(relativePath);
                if (existingPath != null) {
                    if (!duplicatePaths.add(relativePath)) continue;
                    log2.report(CompilerMessageSeverity.WARNING, "There are files with same path '" + relativePath + "', relative to source roots: '" + path + "' and '" + existingPath + "'. This will likely cause problems with debugger", null);
                    continue;
                }
                pathMap.put(relativePath, path);
            }
        }
        catch (IOException e) {
            log2.report(CompilerMessageSeverity.ERROR, "IO error occurred validating source path:\n" + ExceptionUtil.getThrowableText(e), null);
        }
    }

    private static void reportCompiledSourcesList(@NotNull MessageCollector messageCollector2, @NotNull List<KtFile> sourceFiles2) {
        if (messageCollector2 == null) {
            K2JSCompiler.$$$reportNull$$$0(27);
        }
        if (sourceFiles2 == null) {
            K2JSCompiler.$$$reportNull$$$0(28);
        }
        List<String> fileNames = CollectionsKt.map(sourceFiles2, file -> {
            VirtualFile virtualFile2 = file.getVirtualFile();
            if (virtualFile2 != null) {
                return MessageUtil.virtualFileToPath(virtualFile2);
            }
            return file.getName() + " (no virtual file)";
        });
        messageCollector2.report(CompilerMessageSeverity.LOGGING, "Compiling source files: " + StringsKt.join(fileNames, ", "), null);
    }

    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration, @NotNull K2JSCompilerArguments arguments2, @NotNull Services services) {
        String sourceMapEmbedContentString;
        SourceMapSourceEmbedding sourceMapContentEmbedding;
        LookupTracker lookupTracker;
        IncrementalResultsConsumer incrementalResultsConsumer;
        String moduleKindName;
        ModuleKind moduleKind;
        if (configuration == null) {
            K2JSCompiler.$$$reportNull$$$0(29);
        }
        if (arguments2 == null) {
            K2JSCompiler.$$$reportNull$$$0(30);
        }
        if (services == null) {
            K2JSCompiler.$$$reportNull$$$0(31);
        }
        MessageCollector messageCollector2 = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (arguments2.getTarget() != null) assert (arguments2.getTarget() == "v5") : "Unsupported ECMA version: " + arguments2.getTarget();
        configuration.put(JSConfigurationKeys.TARGET, EcmaVersion.defaultVersion());
        if (arguments2.getSourceMap()) {
            configuration.put(JSConfigurationKeys.SOURCE_MAP, true);
            if (arguments2.getSourceMapPrefix() != null) {
                configuration.put(JSConfigurationKeys.SOURCE_MAP_PREFIX, arguments2.getSourceMapPrefix());
            }
            String sourceMapSourceRoots = arguments2.getSourceMapSourceRoots() != null ? arguments2.getSourceMapSourceRoots() : K2JSCompiler.calculateSourceMapSourceRoot(messageCollector2, arguments2);
            List<String> sourceMapSourceRootList = StringUtil.split(sourceMapSourceRoots, File.pathSeparator);
            configuration.put(JSConfigurationKeys.SOURCE_MAP_SOURCE_ROOTS, sourceMapSourceRootList);
        } else {
            if (arguments2.getSourceMapPrefix() != null) {
                messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-prefix argument has no effect without source map", null);
            }
            if (arguments2.getSourceMapSourceRoots() != null) {
                messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-source-root argument has no effect without source map", null);
            }
        }
        if (arguments2.getMetaInfo()) {
            configuration.put(JSConfigurationKeys.META_INFO, true);
        }
        if (arguments2.getTypedArrays()) {
            configuration.put(JSConfigurationKeys.TYPED_ARRAYS_ENABLED, true);
        }
        configuration.put(JSConfigurationKeys.FRIEND_PATHS_DISABLED, arguments2.getFriendModulesDisabled());
        if (!arguments2.getFriendModulesDisabled() && arguments2.getFriendModules() != null) {
            List<String> friendPaths = ArraysKt.filterNot(arguments2.getFriendModules().split(File.pathSeparator), String::isEmpty);
            configuration.put(JSConfigurationKeys.FRIEND_PATHS, friendPaths);
        }
        ModuleKind moduleKind2 = moduleKind = (moduleKindName = arguments2.getModuleKind()) != null ? moduleKindMap.get(moduleKindName) : ModuleKind.PLAIN;
        if (moduleKind == null) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Unknown module kind: " + moduleKindName + ". Valid values are: plain, amd, commonjs, umd", null);
            moduleKind = ModuleKind.PLAIN;
        }
        configuration.put(JSConfigurationKeys.MODULE_KIND, moduleKind);
        IncrementalDataProvider incrementalDataProvider = services.get(IncrementalDataProvider.class);
        if (incrementalDataProvider != null) {
            configuration.put(JSConfigurationKeys.INCREMENTAL_DATA_PROVIDER, incrementalDataProvider);
        }
        if ((incrementalResultsConsumer = services.get(IncrementalResultsConsumer.class)) != null) {
            configuration.put(JSConfigurationKeys.INCREMENTAL_RESULTS_CONSUMER, incrementalResultsConsumer);
        }
        if ((lookupTracker = services.get(LookupTracker.class)) != null) {
            configuration.put(CommonConfigurationKeys.LOOKUP_TRACKER, lookupTracker);
        }
        SourceMapSourceEmbedding sourceMapSourceEmbedding = sourceMapContentEmbedding = (sourceMapEmbedContentString = arguments2.getSourceMapEmbedSources()) != null ? sourceMapContentEmbeddingMap.get(sourceMapEmbedContentString) : SourceMapSourceEmbedding.INLINING;
        if (sourceMapContentEmbedding == null) {
            String message = "Unknown source map source embedding mode: " + sourceMapEmbedContentString + ". Valid values are: " + StringUtil.join(sourceMapContentEmbeddingMap.keySet(), ", ");
            messageCollector2.report(CompilerMessageSeverity.ERROR, message, null);
            sourceMapContentEmbedding = SourceMapSourceEmbedding.INLINING;
        }
        configuration.put(JSConfigurationKeys.SOURCE_MAP_EMBED_SOURCES, sourceMapContentEmbedding);
        if (!arguments2.getSourceMap() && sourceMapEmbedContentString != null) {
            messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-embed-sources argument has no effect without source map", null);
        }
    }

    @NotNull
    private static List<String> configureLibraries(@NotNull K2JSCompilerArguments arguments2, @Nullable KotlinPaths paths, @NotNull MessageCollector messageCollector2) {
        File stdlibJar;
        if (arguments2 == null) {
            K2JSCompiler.$$$reportNull$$$0(32);
        }
        if (messageCollector2 == null) {
            K2JSCompiler.$$$reportNull$$$0(33);
        }
        SmartList<String> libraries = new SmartList<String>();
        if (!arguments2.getNoStdlib() && (stdlibJar = K2JSCompiler.getLibraryFromHome(paths, KotlinPaths::getJsStdLibJarPath, "kotlin-stdlib-js.jar", messageCollector2, "'-no-stdlib'")) != null) {
            libraries.add(stdlibJar.getAbsolutePath());
        }
        if (arguments2.getLibraries() != null) {
            libraries.addAll(ArraysKt.filterNot(arguments2.getLibraries().split(File.pathSeparator), String::isEmpty));
        }
        SmartList<String> smartList = libraries;
        if (smartList == null) {
            K2JSCompiler.$$$reportNull$$$0(34);
        }
        return smartList;
    }

    @NotNull
    private static String calculateSourceMapSourceRoot(@NotNull MessageCollector messageCollector2, @NotNull K2JSCompilerArguments arguments2) {
        if (messageCollector2 == null) {
            K2JSCompiler.$$$reportNull$$$0(35);
        }
        if (arguments2 == null) {
            K2JSCompiler.$$$reportNull$$$0(36);
        }
        File commonPath = null;
        ArrayList<File> pathToRoot = new ArrayList<File>();
        HashMap pathToRootIndexes = new HashMap();
        try {
            for (String path : arguments2.getFreeArgs()) {
                File file;
                if (commonPath == null) {
                    commonPath = file;
                    for (file = new File(path).getCanonicalFile(); file != null; file = file.getParentFile()) {
                        pathToRoot.add(file);
                    }
                    Collections.reverse(pathToRoot);
                    for (int i = 0; i < pathToRoot.size(); ++i) {
                        pathToRootIndexes.put(pathToRoot.get(i), i);
                    }
                    continue;
                }
                while (file != null) {
                    Integer existingIndex = (Integer)pathToRootIndexes.get(file);
                    if (existingIndex != null) {
                        existingIndex = Math.min(existingIndex, pathToRoot.size() - 1);
                        pathToRoot.subList(existingIndex + 1, pathToRoot.size()).clear();
                        commonPath = (File)pathToRoot.get(pathToRoot.size() - 1);
                        break;
                    }
                    file = file.getParentFile();
                }
                if (file != null) continue;
                break;
            }
        }
        catch (IOException e) {
            String text2 = ExceptionUtil.getThrowableText(e);
            messageCollector2.report(CompilerMessageSeverity.ERROR, "IO error occurred calculating source root:\n" + text2, null);
            if ("." == null) {
                K2JSCompiler.$$$reportNull$$$0(37);
            }
            return ".";
        }
        String string = commonPath != null ? commonPath.getPath() : ".";
        if (string == null) {
            K2JSCompiler.$$$reportNull$$$0(38);
        }
        return string;
    }

    private static MainCallParameters createMainCallParameters(String main2) {
        if ("noCall".equals(main2)) {
            return MainCallParameters.noCall();
        }
        return MainCallParameters.mainWithoutArguments();
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        if ("kotlinc-js" == null) {
            K2JSCompiler.$$$reportNull$$$0(39);
        }
        return "kotlinc-js";
    }

    static {
        moduleKindMap.put("plain", ModuleKind.PLAIN);
        moduleKindMap.put("commonjs", ModuleKind.COMMON_JS);
        moduleKindMap.put("amd", ModuleKind.AMD);
        moduleKindMap.put("umd", ModuleKind.UMD);
        sourceMapContentEmbeddingMap.put("always", SourceMapSourceEmbedding.ALWAYS);
        sourceMapContentEmbeddingMap.put("never", SourceMapSourceEmbedding.NEVER);
        sourceMapContentEmbeddingMap.put("inlining", SourceMapSourceEmbedding.INLINING);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/js/K2JSCompiler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allKotlinFiles";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsAnalysisResult";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainCallParameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 8: 
            case 30: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 9: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDisposable";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 27: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageCollector";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "services";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createArguments";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/js/K2JSCompiler";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "doExecute";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "configureLibraries";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateSourceMapSourceRoot";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "executableScriptFileName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "translate";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkDuplicateSourceFileNames";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "reportCompiledSourcesList";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setupPlatformSpecificArgumentsAndServices";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "configureLibraries";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "calculateSourceMapSourceRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

