/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SupertypeLoopChecker;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationSplitter;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.CompositeAnnotations;
import org.jetbrains.kotlin.descriptors.impl.ClassConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertySetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.TypeAliasExpansionReportStrategy;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.VariableAsPropertyInfo;
import org.jetbrains.kotlin.resolve.VariableTypeAndInitializerResolver;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfoFactory;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;
import org.jetbrains.kotlin.resolve.extensions.SyntheticResolveExtension;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyTypeAliasDescriptor;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.ScopeUtils;
import org.jetbrains.kotlin.resolve.scopes.TraceBasedLocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.TypeApproximator;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.WrappedTypeFactory;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.DestructuringDeclarationResolver;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.FunctionsTypingVisitor;
import org.jetbrains.kotlin.types.expressions.PreliminaryDeclarationVisitor;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public class DescriptorResolver {
    private final TypeResolver typeResolver;
    private final AnnotationResolver annotationResolver;
    private final StorageManager storageManager;
    private final KotlinBuiltIns builtIns;
    private final SupertypeLoopChecker supertypeLoopsResolver;
    private final VariableTypeAndInitializerResolver variableTypeAndInitializerResolver;
    private final ExpressionTypingServices expressionTypingServices;
    private final OverloadChecker overloadChecker;
    private final LanguageVersionSettings languageVersionSettings;
    private final FunctionsTypingVisitor functionsTypingVisitor;
    private final DestructuringDeclarationResolver destructuringDeclarationResolver;
    private final ModifiersChecker modifiersChecker;
    private final WrappedTypeFactory wrappedTypeFactory;
    private final SyntheticResolveExtension syntheticResolveExtension;
    private final TypeApproximator typeApproximator;

    public DescriptorResolver(@NotNull AnnotationResolver annotationResolver, @NotNull KotlinBuiltIns builtIns, @NotNull StorageManager storageManager, @NotNull TypeResolver typeResolver, @NotNull SupertypeLoopChecker supertypeLoopsResolver, @NotNull VariableTypeAndInitializerResolver variableTypeAndInitializerResolver, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull OverloadChecker overloadChecker, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull FunctionsTypingVisitor functionsTypingVisitor, @NotNull DestructuringDeclarationResolver destructuringDeclarationResolver, @NotNull ModifiersChecker modifiersChecker, @NotNull WrappedTypeFactory wrappedTypeFactory, @NotNull Project project, TypeApproximator approximator) {
        if (annotationResolver == null) {
            DescriptorResolver.$$$reportNull$$$0(0);
        }
        if (builtIns == null) {
            DescriptorResolver.$$$reportNull$$$0(1);
        }
        if (storageManager == null) {
            DescriptorResolver.$$$reportNull$$$0(2);
        }
        if (typeResolver == null) {
            DescriptorResolver.$$$reportNull$$$0(3);
        }
        if (supertypeLoopsResolver == null) {
            DescriptorResolver.$$$reportNull$$$0(4);
        }
        if (variableTypeAndInitializerResolver == null) {
            DescriptorResolver.$$$reportNull$$$0(5);
        }
        if (expressionTypingServices == null) {
            DescriptorResolver.$$$reportNull$$$0(6);
        }
        if (overloadChecker == null) {
            DescriptorResolver.$$$reportNull$$$0(7);
        }
        if (languageVersionSettings == null) {
            DescriptorResolver.$$$reportNull$$$0(8);
        }
        if (functionsTypingVisitor == null) {
            DescriptorResolver.$$$reportNull$$$0(9);
        }
        if (destructuringDeclarationResolver == null) {
            DescriptorResolver.$$$reportNull$$$0(10);
        }
        if (modifiersChecker == null) {
            DescriptorResolver.$$$reportNull$$$0(11);
        }
        if (wrappedTypeFactory == null) {
            DescriptorResolver.$$$reportNull$$$0(12);
        }
        if (project == null) {
            DescriptorResolver.$$$reportNull$$$0(13);
        }
        this.annotationResolver = annotationResolver;
        this.builtIns = builtIns;
        this.storageManager = storageManager;
        this.typeResolver = typeResolver;
        this.supertypeLoopsResolver = supertypeLoopsResolver;
        this.variableTypeAndInitializerResolver = variableTypeAndInitializerResolver;
        this.expressionTypingServices = expressionTypingServices;
        this.overloadChecker = overloadChecker;
        this.languageVersionSettings = languageVersionSettings;
        this.functionsTypingVisitor = functionsTypingVisitor;
        this.destructuringDeclarationResolver = destructuringDeclarationResolver;
        this.modifiersChecker = modifiersChecker;
        this.wrappedTypeFactory = wrappedTypeFactory;
        this.syntheticResolveExtension = SyntheticResolveExtension.Companion.getInstance(project);
        this.typeApproximator = approximator;
    }

    public List<KotlinType> resolveSupertypes(@NotNull LexicalScope scope, @NotNull ClassDescriptor classDescriptor, @Nullable KtPureClassOrObject correspondingClassOrObject, BindingTrace trace) {
        if (scope == null) {
            DescriptorResolver.$$$reportNull$$$0(14);
        }
        if (classDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(15);
        }
        ArrayList<KotlinType> supertypes2 = Lists.newArrayList();
        List<KtSuperTypeListEntry> delegationSpecifiers = correspondingClassOrObject == null ? Collections.emptyList() : correspondingClassOrObject.getSuperTypeListEntries();
        Collection<KotlinType> declaredSupertypes = DescriptorResolver.resolveSuperTypeListEntries(scope, delegationSpecifiers, this.typeResolver, trace, false);
        for (KotlinType declaredSupertype : declaredSupertypes) {
            DescriptorResolver.addValidSupertype(supertypes2, declaredSupertype);
        }
        if (classDescriptor.getKind() == ClassKind.ENUM_CLASS && !DescriptorResolver.containsClass(supertypes2)) {
            supertypes2.add(0, this.builtIns.getEnumType(classDescriptor.getDefaultType()));
        }
        this.syntheticResolveExtension.addSyntheticSupertypes(classDescriptor, supertypes2);
        if (supertypes2.isEmpty()) {
            DescriptorResolver.addValidSupertype(supertypes2, this.getDefaultSupertype(classDescriptor));
        }
        return supertypes2;
    }

    private static void addValidSupertype(List<KotlinType> supertypes2, KotlinType declaredSupertype) {
        if (!KotlinTypeKt.isError(declaredSupertype)) {
            supertypes2.add(declaredSupertype);
        }
    }

    private static boolean containsClass(Collection<KotlinType> result2) {
        for (KotlinType type2 : result2) {
            ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
            if (!(descriptor2 instanceof ClassDescriptor) || ((ClassDescriptor)descriptor2).getKind() == ClassKind.INTERFACE) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private KotlinType getDefaultSupertype(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(16);
        }
        if (classDescriptor.getKind() == ClassKind.ENUM_ENTRY) {
            SimpleType simpleType2 = ((ClassDescriptor)classDescriptor.getContainingDeclaration()).getDefaultType();
            if (simpleType2 == null) {
                DescriptorResolver.$$$reportNull$$$0(17);
            }
            return simpleType2;
        }
        if (classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS) {
            SimpleType simpleType3 = this.builtIns.getAnnotationType();
            if (simpleType3 == null) {
                DescriptorResolver.$$$reportNull$$$0(18);
            }
            return simpleType3;
        }
        SimpleType simpleType4 = this.builtIns.getAnyType();
        if (simpleType4 == null) {
            DescriptorResolver.$$$reportNull$$$0(19);
        }
        return simpleType4;
    }

    private static Collection<KotlinType> resolveSuperTypeListEntries(LexicalScope extensibleScope, List<KtSuperTypeListEntry> delegationSpecifiers, @NotNull TypeResolver resolver2, BindingTrace trace, boolean checkBounds) {
        if (resolver2 == null) {
            DescriptorResolver.$$$reportNull$$$0(20);
        }
        if (delegationSpecifiers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<KotlinType> result2 = Lists.newArrayList();
        for (KtSuperTypeListEntry delegationSpecifier : delegationSpecifiers) {
            KtTypeReference typeReference = delegationSpecifier.getTypeReference();
            if (typeReference != null) {
                KotlinType supertype = resolver2.resolveType(extensibleScope, typeReference, trace, checkBounds);
                if (DynamicTypesKt.isDynamic(supertype)) {
                    trace.report(Errors.DYNAMIC_SUPERTYPE.on(typeReference));
                    continue;
                }
                result2.add(supertype);
                KtTypeElement bareSuperType = DescriptorResolver.checkNullableSupertypeAndStripQuestionMarks(trace, typeReference.getTypeElement());
                DescriptorResolver.checkProjectionsInImmediateArguments(trace, bareSuperType, supertype);
                continue;
            }
            result2.add(ErrorUtils.createErrorType("No type reference"));
        }
        return result2;
    }

    @Nullable
    private static KtTypeElement checkNullableSupertypeAndStripQuestionMarks(@NotNull BindingTrace trace, @Nullable KtTypeElement typeElement) {
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(21);
        }
        while (typeElement instanceof KtNullableType) {
            KtNullableType nullableType = (KtNullableType)typeElement;
            if ((typeElement = nullableType.getInnerType()) instanceof KtNullableType || typeElement == null) continue;
            trace.report(Errors.NULLABLE_SUPERTYPE.on(nullableType));
        }
        return typeElement;
    }

    private static void checkProjectionsInImmediateArguments(@NotNull BindingTrace trace, @Nullable KtTypeElement typeElement, @NotNull KotlinType type2) {
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(22);
        }
        if (type2 == null) {
            DescriptorResolver.$$$reportNull$$$0(23);
        }
        if (typeElement == null) {
            return;
        }
        boolean hasProjectionsInWrittenArguments = false;
        if (typeElement instanceof KtUserType) {
            KtUserType userType = (KtUserType)typeElement;
            List<KtTypeProjection> typeArguments2 = userType.getTypeArguments();
            for (KtTypeProjection typeArgument : typeArguments2) {
                if (typeArgument.getProjectionKind() == KtProjectionKind.NONE) continue;
                trace.report(Errors.PROJECTION_IN_IMMEDIATE_ARGUMENT_TO_SUPERTYPE.on(typeArgument));
                hasProjectionsInWrittenArguments = true;
            }
        }
        if (!KotlinTypeKt.isError(type2) && SpecialTypesKt.getAbbreviatedType(type2) != null && !hasProjectionsInWrittenArguments && TypeUtilsKt.isInterface(type2) && TypeUtilsKt.containsTypeProjectionsInTopLevelArguments(type2)) {
            trace.report(Errors.EXPANDED_TYPE_CANNOT_BE_INHERITED.on(typeElement, type2));
        }
    }

    public static Visibility getDefaultVisibility(KtModifierListOwner modifierListOwner, DeclarationDescriptor containingDescriptor) {
        KtModifierList modifierList;
        Visibility defaultVisibility = containingDescriptor instanceof ClassDescriptor ? ((modifierList = modifierListOwner.getModifierList()) != null && modifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD) ? Visibilities.INHERITED : Visibilities.DEFAULT_VISIBILITY) : (containingDescriptor instanceof FunctionDescriptor || containingDescriptor instanceof PropertyDescriptor ? Visibilities.LOCAL : Visibilities.DEFAULT_VISIBILITY);
        return defaultVisibility;
    }

    public static Modality getDefaultModality(DeclarationDescriptor containingDescriptor, Visibility visibility, boolean isBodyPresent) {
        Modality defaultModality;
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean isTrait = ((ClassDescriptor)containingDescriptor).getKind() == ClassKind.INTERFACE;
            boolean isDefinitelyAbstract = isTrait && !isBodyPresent;
            Modality basicModality = isTrait && !Visibilities.isPrivate(visibility) ? Modality.OPEN : Modality.FINAL;
            defaultModality = isDefinitelyAbstract ? Modality.ABSTRACT : basicModality;
        } else {
            defaultModality = Modality.FINAL;
        }
        return defaultModality;
    }

    @NotNull
    public ValueParameterDescriptorImpl resolveValueParameterDescriptor(@NotNull LexicalScope scope, @NotNull FunctionDescriptor owner, @NotNull KtParameter valueParameter, int index2, @NotNull KotlinType type2, @NotNull BindingTrace trace) {
        Function0<List> destructuringVariables;
        KtDestructuringDeclaration destructuringDeclaration;
        if (scope == null) {
            DescriptorResolver.$$$reportNull$$$0(24);
        }
        if (owner == null) {
            DescriptorResolver.$$$reportNull$$$0(25);
        }
        if (valueParameter == null) {
            DescriptorResolver.$$$reportNull$$$0(26);
        }
        if (type2 == null) {
            DescriptorResolver.$$$reportNull$$$0(27);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(28);
        }
        KotlinType varargElementType = null;
        KotlinType variableType = type2;
        if (valueParameter.hasModifier(KtTokens.VARARG_KEYWORD)) {
            varargElementType = type2;
            variableType = this.getVarargParameterType(type2);
        }
        KtModifierList modifierList = valueParameter.getModifierList();
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithoutArguments(scope, valueParameter.getModifierList(), trace);
        Annotations valueParameterAnnotations = Annotations.Companion.getEMPTY();
        if (modifierList != null) {
            if (valueParameter.hasValOrVar()) {
                AnnotationSplitter annotationSplitter = AnnotationSplitter.create(this.storageManager, allAnnotations, SetsKt.setOf(AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER));
                valueParameterAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER);
            } else {
                valueParameterAnnotations = allAnnotations;
            }
        }
        if ((destructuringDeclaration = valueParameter.getDestructuringDeclaration()) != null) {
            if (!this.languageVersionSettings.supportsFeature(LanguageFeature.DestructuringLambdaParameters)) {
                trace.report(Errors.UNSUPPORTED_FEATURE.on(valueParameter, TuplesKt.to(LanguageFeature.DestructuringLambdaParameters, this.languageVersionSettings)));
            }
            destructuringVariables = () -> {
                if (owner == null) {
                    DescriptorResolver.$$$reportNull$$$0(146);
                }
                if (scope == null) {
                    DescriptorResolver.$$$reportNull$$$0(147);
                }
                if (type2 == null) {
                    DescriptorResolver.$$$reportNull$$$0(148);
                }
                if (trace == null) {
                    DescriptorResolver.$$$reportNull$$$0(149);
                }
                assert (owner.getDispatchReceiverParameter() == null) : "Destructuring declarations are only be parsed for lambdas, and they must not have a dispatch receiver";
                LexicalScope scopeForDestructuring = ScopeUtilsKt.createScopeForDestructuring(scope, owner.getExtensionReceiverParameter());
                List<VariableDescriptor> result2 = this.destructuringDeclarationResolver.resolveLocalVariablesFromDestructuringDeclaration(scope, destructuringDeclaration, new TransientReceiver(type2), null, ExpressionTypingContext.newContext(trace, scopeForDestructuring, DataFlowInfoFactory.EMPTY, TypeUtils.NO_EXPECTED_TYPE));
                this.modifiersChecker.withTrace(trace).checkModifiersForDestructuringDeclaration(destructuringDeclaration);
                return result2;
            };
        } else {
            destructuringVariables = null;
        }
        Name parameterName = destructuringDeclaration == null ? (!valueParameter.hasValOrVar() && UnderscoreUtilKt.isSingleUnderscore(valueParameter) ? Name.special("<anonymous parameter " + index2 + ">") : KtPsiUtil.safeName(valueParameter.getName())) : Name.special("<name for destructuring parameter " + index2 + ">");
        ValueParameterDescriptorImpl valueParameterDescriptor = ValueParameterDescriptorImpl.createWithDestructuringDeclarations(owner, null, index2, valueParameterAnnotations, parameterName, variableType, valueParameter.hasDefaultValue(), valueParameter.hasModifier(KtTokens.CROSSINLINE_KEYWORD), valueParameter.hasModifier(KtTokens.NOINLINE_KEYWORD), varargElementType, KotlinSourceElementKt.toSourceElement(valueParameter), destructuringVariables);
        trace.record(BindingContext.VALUE_PARAMETER, valueParameter, valueParameterDescriptor);
        ValueParameterDescriptorImpl valueParameterDescriptorImpl = valueParameterDescriptor;
        if (valueParameterDescriptorImpl == null) {
            DescriptorResolver.$$$reportNull$$$0(29);
        }
        return valueParameterDescriptorImpl;
    }

    @NotNull
    private KotlinType getVarargParameterType(@NotNull KotlinType elementType) {
        SimpleType primitiveArrayType;
        if (elementType == null) {
            DescriptorResolver.$$$reportNull$$$0(30);
        }
        if ((primitiveArrayType = this.builtIns.getPrimitiveArrayKotlinTypeByPrimitiveKotlinType(elementType)) != null) {
            SimpleType simpleType2 = primitiveArrayType;
            if (simpleType2 == null) {
                DescriptorResolver.$$$reportNull$$$0(31);
            }
            return simpleType2;
        }
        SimpleType simpleType3 = this.builtIns.getArrayType(Variance.OUT_VARIANCE, elementType);
        if (simpleType3 == null) {
            DescriptorResolver.$$$reportNull$$$0(32);
        }
        return simpleType3;
    }

    public List<TypeParameterDescriptorImpl> resolveTypeParametersForDescriptor(DeclarationDescriptor containingDescriptor, LexicalWritableScope extensibleScope, LexicalScope scopeForAnnotationsResolve, List<KtTypeParameter> typeParameters2, BindingTrace trace) {
        List<TypeParameterDescriptorImpl> descriptors = this.resolveTypeParametersForDescriptor(containingDescriptor, scopeForAnnotationsResolve, typeParameters2, trace);
        for (TypeParameterDescriptorImpl descriptor2 : descriptors) {
            extensibleScope.addClassifierDescriptor(descriptor2);
        }
        return descriptors;
    }

    private List<TypeParameterDescriptorImpl> resolveTypeParametersForDescriptor(DeclarationDescriptor containingDescriptor, LexicalScope scopeForAnnotationsResolve, List<KtTypeParameter> typeParameters2, BindingTrace trace) {
        assert (containingDescriptor instanceof FunctionDescriptor || containingDescriptor instanceof PropertyDescriptor || containingDescriptor instanceof TypeAliasDescriptor) : "This method should be called for functions, properties, or type aliases, got " + containingDescriptor;
        ArrayList<TypeParameterDescriptorImpl> result2 = new ArrayList<TypeParameterDescriptorImpl>();
        int typeParametersSize = typeParameters2.size();
        for (int i = 0; i < typeParametersSize; ++i) {
            KtTypeParameter typeParameter = typeParameters2.get(i);
            result2.add(this.resolveTypeParameterForDescriptor(containingDescriptor, scopeForAnnotationsResolve, typeParameter, i, trace));
        }
        return result2;
    }

    private TypeParameterDescriptorImpl resolveTypeParameterForDescriptor(DeclarationDescriptor containingDescriptor, LexicalScope scopeForAnnotationsResolve, KtTypeParameter typeParameter, int index2, BindingTrace trace) {
        if (typeParameter.getVariance() != Variance.INVARIANT) {
            trace.report(Errors.VARIANCE_ON_TYPE_PARAMETER_NOT_ALLOWED.on(typeParameter));
        }
        Annotations annotations2 = this.annotationResolver.resolveAnnotationsWithArguments(scopeForAnnotationsResolve, typeParameter.getModifierList(), trace);
        TypeParameterDescriptorImpl typeParameterDescriptor = TypeParameterDescriptorImpl.createForFurtherModification(containingDescriptor, annotations2, typeParameter.hasModifier(KtTokens.REIFIED_KEYWORD), typeParameter.getVariance(), KtPsiUtil.safeName(typeParameter.getName()), index2, KotlinSourceElementKt.toSourceElement(typeParameter), type2 -> {
            if (!(containingDescriptor instanceof TypeAliasDescriptor)) {
                trace.report(Errors.CYCLIC_GENERIC_UPPER_BOUND.on(typeParameter));
            }
            return null;
        }, this.supertypeLoopsResolver);
        trace.record(BindingContext.TYPE_PARAMETER, typeParameter, typeParameterDescriptor);
        return typeParameterDescriptor;
    }

    @NotNull
    public static ClassConstructorDescriptorImpl createAndRecordPrimaryConstructorForObject(@Nullable KtPureClassOrObject object, @NotNull ClassDescriptor classDescriptor, @NotNull BindingTrace trace) {
        if (classDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(33);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(34);
        }
        ClassConstructorDescriptorImpl constructorDescriptor = DescriptorFactory.createPrimaryConstructorForObject(classDescriptor, KotlinSourceElementKt.toSourceElement(object));
        if (object instanceof PsiElement) {
            KtPrimaryConstructor primaryConstructor2 = object.getPrimaryConstructor();
            trace.record(BindingContext.CONSTRUCTOR, primaryConstructor2 != null ? primaryConstructor2 : (PsiElement)((Object)object), constructorDescriptor);
        }
        ClassConstructorDescriptorImpl classConstructorDescriptorImpl = constructorDescriptor;
        if (classConstructorDescriptorImpl == null) {
            DescriptorResolver.$$$reportNull$$$0(35);
        }
        return classConstructorDescriptorImpl;
    }

    public void resolveGenericBounds(@NotNull KtTypeParameterListOwner declaration, @NotNull DeclarationDescriptor descriptor2, LexicalScope scope, List<TypeParameterDescriptorImpl> parameters2, BindingTrace trace) {
        if (declaration == null) {
            DescriptorResolver.$$$reportNull$$$0(36);
        }
        if (descriptor2 == null) {
            DescriptorResolver.$$$reportNull$$$0(37);
        }
        ArrayList<UpperBoundCheckRequest> upperBoundCheckRequests = Lists.newArrayList();
        List<KtTypeParameter> typeParameters2 = declaration.getTypeParameters();
        HashMap<Name, TypeParameterDescriptorImpl> parameterByName = Maps.newHashMap();
        for (int i = 0; i < typeParameters2.size(); ++i) {
            KtTypeParameter ktTypeParameter = typeParameters2.get(i);
            TypeParameterDescriptorImpl typeParameterDescriptor = parameters2.get(i);
            parameterByName.put(typeParameterDescriptor.getName(), typeParameterDescriptor);
            KtTypeReference extendsBound = ktTypeParameter.getExtendsBound();
            if (extendsBound == null) continue;
            KotlinType type2 = this.typeResolver.resolveType(scope, extendsBound, trace, false);
            typeParameterDescriptor.addUpperBound(type2);
            upperBoundCheckRequests.add(new UpperBoundCheckRequest(ktTypeParameter.getNameAsName(), extendsBound, type2));
        }
        for (KtTypeConstraint constraint : declaration.getTypeConstraints()) {
            KtSimpleNameExpression subjectTypeParameterName = constraint.getSubjectTypeParameterName();
            if (subjectTypeParameterName == null) continue;
            Name referencedName = subjectTypeParameterName.getReferencedNameAsName();
            TypeParameterDescriptorImpl typeParameterDescriptor = (TypeParameterDescriptorImpl)parameterByName.get(referencedName);
            KtTypeReference boundTypeReference = constraint.getBoundTypeReference();
            KotlinType bound = null;
            if (boundTypeReference != null) {
                bound = this.typeResolver.resolveType(scope, boundTypeReference, trace, false);
                upperBoundCheckRequests.add(new UpperBoundCheckRequest(referencedName, boundTypeReference, bound));
            }
            if (typeParameterDescriptor == null) continue;
            trace.record(BindingContext.REFERENCE_TARGET, subjectTypeParameterName, typeParameterDescriptor);
            if (bound == null) continue;
            typeParameterDescriptor.addUpperBound(bound);
        }
        for (TypeParameterDescriptorImpl parameter : parameters2) {
            parameter.addDefaultUpperBound();
            parameter.setInitialized();
        }
        for (TypeParameterDescriptorImpl parameter : parameters2) {
            DescriptorResolver.checkConflictingUpperBounds(trace, parameter, typeParameters2.get(parameter.getIndex()));
        }
        if (!(declaration instanceof KtClass)) {
            DescriptorResolver.checkUpperBoundTypes(trace, upperBoundCheckRequests);
            this.checkNamesInConstraints(declaration, descriptor2, scope, trace);
        }
    }

    public static void checkUpperBoundTypes(@NotNull BindingTrace trace, @NotNull List<UpperBoundCheckRequest> requests) {
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(38);
        }
        if (requests == null) {
            DescriptorResolver.$$$reportNull$$$0(39);
        }
        if (requests.isEmpty()) {
            return;
        }
        HashSet<Name> classBoundEncountered = new HashSet<Name>();
        HashSet<Pair<Name, TypeConstructor>> allBounds = new HashSet<Pair<Name, TypeConstructor>>();
        for (UpperBoundCheckRequest request : requests) {
            Name typeParameterName = request.typeParameterName;
            KotlinType upperBound = request.upperBoundType;
            KtTypeReference upperBoundElement = request.upperBound;
            if (!KotlinTypeKt.isError(upperBound)) {
                if (!allBounds.add(new Pair<Name, TypeConstructor>(typeParameterName, upperBound.getConstructor()))) {
                    trace.report(Errors.REPEATED_BOUND.on(upperBoundElement));
                } else {
                    ClassKind kind;
                    ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(upperBound);
                    if (!(classDescriptor == null || (kind = classDescriptor.getKind()) != ClassKind.CLASS && kind != ClassKind.ENUM_CLASS && kind != ClassKind.OBJECT || classBoundEncountered.add(typeParameterName))) {
                        trace.report(Errors.ONLY_ONE_CLASS_BOUND_ALLOWED.on(upperBoundElement));
                    }
                }
            }
            DescriptorResolver.checkUpperBoundType(upperBoundElement, upperBound, trace);
        }
    }

    public static void checkConflictingUpperBounds(@NotNull BindingTrace trace, @NotNull TypeParameterDescriptor parameter, @NotNull KtTypeParameter typeParameter) {
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(40);
        }
        if (parameter == null) {
            DescriptorResolver.$$$reportNull$$$0(41);
        }
        if (typeParameter == null) {
            DescriptorResolver.$$$reportNull$$$0(42);
        }
        if (KotlinBuiltIns.isNothing(TypeIntersector.getUpperBoundsAsType(parameter))) {
            trace.report(Errors.CONFLICTING_UPPER_BOUNDS.on(typeParameter, parameter));
        }
    }

    public void checkNamesInConstraints(@NotNull KtTypeParameterListOwner declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull LexicalScope scope, @NotNull BindingTrace trace) {
        if (declaration == null) {
            DescriptorResolver.$$$reportNull$$$0(43);
        }
        if (descriptor2 == null) {
            DescriptorResolver.$$$reportNull$$$0(44);
        }
        if (scope == null) {
            DescriptorResolver.$$$reportNull$$$0(45);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(46);
        }
        for (KtTypeConstraint constraint : declaration.getTypeConstraints()) {
            KtTypeReference boundTypeReference;
            Name name;
            ClassifierDescriptor classifier2;
            KtSimpleNameExpression nameExpression = constraint.getSubjectTypeParameterName();
            if (nameExpression == null || (classifier2 = ScopeUtilsKt.findClassifier(scope, name = nameExpression.getReferencedNameAsName(), NoLookupLocation.FOR_NON_TRACKED_SCOPE)) instanceof TypeParameterDescriptor && classifier2.getContainingDeclaration() == descriptor2) continue;
            if (classifier2 != null) {
                trace.report(Errors.NAME_IN_CONSTRAINT_IS_NOT_A_TYPE_PARAMETER.on(nameExpression, constraint, declaration));
                trace.record(BindingContext.REFERENCE_TARGET, nameExpression, classifier2);
            } else {
                trace.report(Errors.UNRESOLVED_REFERENCE.on(nameExpression, nameExpression));
            }
            if ((boundTypeReference = constraint.getBoundTypeReference()) == null) continue;
            this.typeResolver.resolveType(scope, boundTypeReference, trace, true);
        }
    }

    public static void checkUpperBoundType(KtTypeReference upperBound, @NotNull KotlinType upperBoundType, BindingTrace trace) {
        if (upperBoundType == null) {
            DescriptorResolver.$$$reportNull$$$0(47);
        }
        if (!TypeUtils.canHaveSubtypes(KotlinTypeChecker.DEFAULT, upperBoundType)) {
            trace.report(Errors.FINAL_UPPER_BOUND.on(upperBound, upperBoundType));
        }
        if (DynamicTypesKt.isDynamic(upperBoundType)) {
            trace.report(Errors.DYNAMIC_UPPER_BOUND.on(upperBound));
        }
        if (FunctionTypesKt.isExtensionFunctionType(upperBoundType)) {
            trace.report(Errors.UPPER_BOUND_IS_EXTENSION_FUNCTION_TYPE.on(upperBound));
        }
    }

    @NotNull
    public VariableDescriptor resolveLocalVariableDescriptor(@NotNull LexicalScope scope, @NotNull KtParameter parameter, BindingTrace trace) {
        if (scope == null) {
            DescriptorResolver.$$$reportNull$$$0(48);
        }
        if (parameter == null) {
            DescriptorResolver.$$$reportNull$$$0(49);
        }
        KotlinType type2 = this.resolveParameterType(scope, parameter, trace);
        VariableDescriptor variableDescriptor = this.resolveLocalVariableDescriptor(parameter, type2, trace, scope);
        if (variableDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(50);
        }
        return variableDescriptor;
    }

    private KotlinType resolveParameterType(LexicalScope scope, KtParameter parameter, BindingTrace trace) {
        KtTypeReference typeReference = parameter.getTypeReference();
        KotlinType type2 = typeReference != null ? this.typeResolver.resolveType(scope, typeReference, trace, true) : ErrorUtils.createErrorType("Annotation is absent");
        if (parameter.hasModifier(KtTokens.VARARG_KEYWORD)) {
            return this.getVarargParameterType(type2);
        }
        return type2;
    }

    public VariableDescriptor resolveLocalVariableDescriptor(@NotNull KtParameter parameter, @NotNull KotlinType type2, BindingTrace trace, @NotNull LexicalScope scope) {
        if (parameter == null) {
            DescriptorResolver.$$$reportNull$$$0(51);
        }
        if (type2 == null) {
            DescriptorResolver.$$$reportNull$$$0(52);
        }
        if (scope == null) {
            DescriptorResolver.$$$reportNull$$$0(53);
        }
        UnwrappedType approximatedType = this.typeApproximator.approximateDeclarationType(type2, true);
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(scope.getOwnerDescriptor(), this.annotationResolver.resolveAnnotationsWithArguments(scope, parameter.getModifierList(), trace), KtPsiUtil.safeName(parameter.getName()), approximatedType, false, false, KotlinSourceElementKt.toSourceElement(parameter));
        trace.record(BindingContext.VALUE_PARAMETER, parameter, variableDescriptor);
        ForceResolveUtil.forceResolveAllContents(type2.getAnnotations());
        return variableDescriptor;
    }

    @NotNull
    public TypeAliasDescriptor resolveTypeAliasDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull LexicalScope scope, @NotNull KtTypeAlias typeAlias, @NotNull BindingTrace trace) {
        List<TypeParameterDescriptorImpl> typeParameterDescriptors;
        LexicalScope scopeWithTypeParameters;
        if (containingDeclaration == null) {
            DescriptorResolver.$$$reportNull$$$0(54);
        }
        if (scope == null) {
            DescriptorResolver.$$$reportNull$$$0(55);
        }
        if (typeAlias == null) {
            DescriptorResolver.$$$reportNull$$$0(56);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(57);
        }
        if (!(containingDeclaration instanceof PackageFragmentDescriptor) && !(containingDeclaration instanceof ScriptDescriptor)) {
            trace.report(Errors.TOPLEVEL_TYPEALIASES_ONLY.on(typeAlias));
        }
        KtModifierList modifierList = typeAlias.getModifierList();
        Visibility visibility = ModifiersChecker.resolveVisibilityFromModifiers(typeAlias, DescriptorResolver.getDefaultVisibility(typeAlias, containingDeclaration));
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithArguments(scope, modifierList, trace);
        Name name = KtPsiUtil.safeName(typeAlias.getName());
        SourceElement sourceElement = KotlinSourceElementKt.toSourceElement(typeAlias);
        LazyTypeAliasDescriptor typeAliasDescriptor = LazyTypeAliasDescriptor.create(this.storageManager, trace, containingDeclaration, allAnnotations, name, sourceElement, visibility);
        List<KtTypeParameter> typeParameters2 = typeAlias.getTypeParameters();
        if (typeParameters2.isEmpty()) {
            scopeWithTypeParameters = scope;
            typeParameterDescriptors = Collections.emptyList();
        } else {
            LexicalWritableScope writableScope = new LexicalWritableScope(scope, containingDeclaration, false, new TraceBasedLocalRedeclarationChecker(trace, this.overloadChecker), LexicalScopeKind.TYPE_ALIAS_HEADER);
            typeParameterDescriptors = this.resolveTypeParametersForDescriptor(typeAliasDescriptor, writableScope, scope, typeParameters2, trace);
            writableScope.freeze();
            DescriptorResolver.checkNoGenericBoundsOnTypeAliasParameters(typeAlias, trace);
            this.resolveGenericBounds(typeAlias, typeAliasDescriptor, writableScope, typeParameterDescriptors, trace);
            scopeWithTypeParameters = writableScope;
        }
        KtTypeReference typeReference = typeAlias.getTypeReference();
        if (typeReference == null) {
            typeAliasDescriptor.initialize(typeParameterDescriptors, ErrorUtils.createErrorType(name.asString()), ErrorUtils.createErrorType(name.asString()));
        } else if (!this.languageVersionSettings.supportsFeature(LanguageFeature.TypeAliases)) {
            this.typeResolver.resolveAbbreviatedType(scopeWithTypeParameters, typeReference, trace);
            PsiElement typeAliasKeyword = typeAlias.getTypeAliasKeyword();
            trace.report(Errors.UNSUPPORTED_FEATURE.on(typeAliasKeyword != null ? typeAliasKeyword : typeAlias, TuplesKt.to(LanguageFeature.TypeAliases, this.languageVersionSettings)));
            typeAliasDescriptor.initialize(typeParameterDescriptors, ErrorUtils.createErrorType(name.asString()), ErrorUtils.createErrorType(name.asString()));
        } else {
            typeAliasDescriptor.initialize(typeParameterDescriptors, this.storageManager.createRecursionTolerantLazyValue(() -> {
                if (trace == null) {
                    DescriptorResolver.$$$reportNull$$$0(145);
                }
                return this.typeResolver.resolveAbbreviatedType(scopeWithTypeParameters, typeReference, trace);
            }, ErrorUtils.createErrorType("Recursive type alias expansion for " + typeAliasDescriptor.getName().asString())), this.storageManager.createRecursionTolerantLazyValue(() -> this.typeResolver.resolveExpandedTypeForTypeAlias(typeAliasDescriptor), ErrorUtils.createErrorType("Recursive type alias expansion for " + typeAliasDescriptor.getName().asString())));
        }
        trace.record(BindingContext.TYPE_ALIAS, typeAlias, typeAliasDescriptor);
        LazyTypeAliasDescriptor lazyTypeAliasDescriptor = typeAliasDescriptor;
        if (lazyTypeAliasDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(58);
        }
        return lazyTypeAliasDescriptor;
    }

    private static void checkNoGenericBoundsOnTypeAliasParameters(@NotNull KtTypeAlias typeAlias, @NotNull BindingTrace trace) {
        if (typeAlias == null) {
            DescriptorResolver.$$$reportNull$$$0(59);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(60);
        }
        for (KtTypeParameter typeParameter : typeAlias.getTypeParameters()) {
            KtTypeReference bound = typeParameter.getExtendsBound();
            if (bound == null) continue;
            trace.report(Errors.BOUND_ON_TYPE_ALIAS_PARAMETER_NOT_ALLOWED.on(bound));
        }
    }

    @NotNull
    public PropertyDescriptor resolveDestructuringDeclarationEntryAsProperty(@NotNull DeclarationDescriptor containingDeclaration, @NotNull LexicalScope scopeForDeclarationResolution, @NotNull LexicalScope scopeForInitializerResolution2, @NotNull KtDestructuringDeclarationEntry entry, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo) {
        if (containingDeclaration == null) {
            DescriptorResolver.$$$reportNull$$$0(61);
        }
        if (scopeForDeclarationResolution == null) {
            DescriptorResolver.$$$reportNull$$$0(62);
        }
        if (scopeForInitializerResolution2 == null) {
            DescriptorResolver.$$$reportNull$$$0(63);
        }
        if (entry == null) {
            DescriptorResolver.$$$reportNull$$$0(64);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(65);
        }
        if (dataFlowInfo == null) {
            DescriptorResolver.$$$reportNull$$$0(66);
        }
        KtDestructuringDeclaration destructuringDeclaration = (KtDestructuringDeclaration)entry.getParent();
        KtExpression initializer2 = destructuringDeclaration.getInitializer();
        ExpressionTypingContext context = ExpressionTypingContext.newContext(trace, scopeForDeclarationResolution, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE);
        ExpressionReceiver receiver = this.createReceiverForDestructuringDeclaration(destructuringDeclaration, context);
        int componentIndex = destructuringDeclaration.getEntries().indexOf(entry);
        KotlinType componentType = this.destructuringDeclarationResolver.resolveInitializer(entry, receiver, initializer2, context, componentIndex);
        PropertyDescriptor propertyDescriptor = this.resolveAsPropertyDescriptor(containingDeclaration, scopeForDeclarationResolution, scopeForInitializerResolution2, entry, trace, dataFlowInfo, VariableAsPropertyInfo.Companion.createFromDestructuringDeclarationEntry(componentType));
        if (propertyDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(67);
        }
        return propertyDescriptor;
    }

    private ExpressionReceiver createReceiverForDestructuringDeclaration(@NotNull KtDestructuringDeclaration destructuringDeclaration, @NotNull ExpressionTypingContext context) {
        KtExpression initializer2;
        if (destructuringDeclaration == null) {
            DescriptorResolver.$$$reportNull$$$0(68);
        }
        if (context == null) {
            DescriptorResolver.$$$reportNull$$$0(69);
        }
        if ((initializer2 = destructuringDeclaration.getInitializer()) == null) {
            return null;
        }
        KotlinType initializerType = this.expressionTypingServices.getTypeInfo(initializer2, context).getType();
        if (initializerType == null) {
            return null;
        }
        return ExpressionReceiver.Companion.create(initializer2, initializerType, context.trace.getBindingContext());
    }

    @NotNull
    public PropertyDescriptor resolvePropertyDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull LexicalScope scopeForDeclarationResolution, @NotNull LexicalScope scopeForInitializerResolution2, @NotNull KtProperty property, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo) {
        if (containingDeclaration == null) {
            DescriptorResolver.$$$reportNull$$$0(70);
        }
        if (scopeForDeclarationResolution == null) {
            DescriptorResolver.$$$reportNull$$$0(71);
        }
        if (scopeForInitializerResolution2 == null) {
            DescriptorResolver.$$$reportNull$$$0(72);
        }
        if (property == null) {
            DescriptorResolver.$$$reportNull$$$0(73);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(74);
        }
        if (dataFlowInfo == null) {
            DescriptorResolver.$$$reportNull$$$0(75);
        }
        PropertyDescriptor propertyDescriptor = this.resolveAsPropertyDescriptor(containingDeclaration, scopeForDeclarationResolution, scopeForInitializerResolution2, property, trace, dataFlowInfo, VariableAsPropertyInfo.Companion.createFromProperty(property));
        if (propertyDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(76);
        }
        return propertyDescriptor;
    }

    @NotNull
    private PropertyDescriptor resolveAsPropertyDescriptor(@NotNull DeclarationDescriptor container2, @NotNull LexicalScope scopeForDeclarationResolution, @NotNull LexicalScope scopeForInitializerResolution2, @NotNull KtVariableDeclaration variableDeclaration, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo, @NotNull VariableAsPropertyInfo propertyInfo) {
        KotlinType type2;
        List<Object> typeParameterDescriptors;
        LexicalScope scopeForInitializerResolutionWithTypeParameters;
        LexicalScope scopeForDeclarationResolutionWithTypeParameters;
        if (container2 == null) {
            DescriptorResolver.$$$reportNull$$$0(77);
        }
        if (scopeForDeclarationResolution == null) {
            DescriptorResolver.$$$reportNull$$$0(78);
        }
        if (scopeForInitializerResolution2 == null) {
            DescriptorResolver.$$$reportNull$$$0(79);
        }
        if (variableDeclaration == null) {
            DescriptorResolver.$$$reportNull$$$0(80);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(81);
        }
        if (dataFlowInfo == null) {
            DescriptorResolver.$$$reportNull$$$0(82);
        }
        if (propertyInfo == null) {
            DescriptorResolver.$$$reportNull$$$0(83);
        }
        KtModifierList modifierList = variableDeclaration.getModifierList();
        boolean isVar = variableDeclaration.isVar();
        Visibility visibility = ModifiersChecker.resolveVisibilityFromModifiers(variableDeclaration, DescriptorResolver.getDefaultVisibility(variableDeclaration, container2));
        Modality modality = container2 instanceof ClassDescriptor ? ModifiersChecker.resolveMemberModalityFromModifiers(variableDeclaration, DescriptorResolver.getDefaultModality(container2, visibility, propertyInfo.getHasBody()), trace.getBindingContext(), container2) : Modality.FINAL;
        AnnotationSplitter.PropertyWrapper wrapper = new AnnotationSplitter.PropertyWrapper(variableDeclaration);
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithoutArguments(scopeForDeclarationResolution, modifierList, trace);
        AnnotationSplitter annotationSplitter = new AnnotationSplitter(this.storageManager, allAnnotations, () -> {
            if (trace == null) {
                DescriptorResolver.$$$reportNull$$$0(144);
            }
            return AnnotationSplitter.getTargetSet(false, trace.getBindingContext(), wrapper);
        });
        CompositeAnnotations propertyAnnotations = new CompositeAnnotations(CollectionsKt.listOf(new Annotations[]{annotationSplitter.getAnnotationsForTargets(AnnotationUseSiteTarget.PROPERTY, AnnotationUseSiteTarget.FIELD, AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD), annotationSplitter.getOtherAnnotations()}));
        PropertyDescriptorImpl propertyDescriptor = PropertyDescriptorImpl.create(container2, propertyAnnotations, modality, visibility, isVar, KtPsiUtil.safeName(variableDeclaration.getName()), CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement(variableDeclaration), modifierList != null && modifierList.hasModifier(KtTokens.LATEINIT_KEYWORD), modifierList != null && modifierList.hasModifier(KtTokens.CONST_KEYWORD), modifierList != null && modifierList.hasModifier(KtTokens.HEADER_KEYWORD) && container2 instanceof PackageFragmentDescriptor || container2 instanceof ClassDescriptor && ((ClassDescriptor)container2).isHeader(), modifierList != null && modifierList.hasModifier(KtTokens.IMPL_KEYWORD), modifierList != null && modifierList.hasModifier(KtTokens.EXTERNAL_KEYWORD), propertyInfo.getHasDelegate());
        wrapper.setDescriptor(propertyDescriptor);
        KotlinType receiverType = null;
        List<KtTypeParameter> typeParameters2 = variableDeclaration.getTypeParameters();
        if (typeParameters2.isEmpty()) {
            scopeForDeclarationResolutionWithTypeParameters = scopeForDeclarationResolution;
            scopeForInitializerResolutionWithTypeParameters = scopeForInitializerResolution2;
            typeParameterDescriptors = Collections.emptyList();
        } else {
            LexicalWritableScope writableScopeForDeclarationResolution = new LexicalWritableScope(scopeForDeclarationResolution, container2, false, new TraceBasedLocalRedeclarationChecker(trace, this.overloadChecker), LexicalScopeKind.PROPERTY_HEADER);
            LexicalWritableScope writableScopeForInitializerResolution = new LexicalWritableScope(scopeForInitializerResolution2, container2, false, LocalRedeclarationChecker.DO_NOTHING.INSTANCE, LexicalScopeKind.PROPERTY_HEADER);
            typeParameterDescriptors = this.resolveTypeParametersForDescriptor(propertyDescriptor, scopeForDeclarationResolution, typeParameters2, trace);
            for (TypeParameterDescriptor typeParameterDescriptor : typeParameterDescriptors) {
                writableScopeForDeclarationResolution.addClassifierDescriptor(typeParameterDescriptor);
                writableScopeForInitializerResolution.addClassifierDescriptor(typeParameterDescriptor);
            }
            writableScopeForDeclarationResolution.freeze();
            writableScopeForInitializerResolution.freeze();
            this.resolveGenericBounds(variableDeclaration, propertyDescriptor, writableScopeForDeclarationResolution, typeParameterDescriptors, trace);
            scopeForDeclarationResolutionWithTypeParameters = writableScopeForDeclarationResolution;
            scopeForInitializerResolutionWithTypeParameters = writableScopeForInitializerResolution;
        }
        KtTypeReference receiverTypeRef = variableDeclaration.getReceiverTypeReference();
        if (receiverTypeRef != null) {
            receiverType = this.typeResolver.resolveType(scopeForDeclarationResolutionWithTypeParameters, receiverTypeRef, trace, true);
        }
        ReceiverParameterDescriptor receiverDescriptor = DescriptorFactory.createExtensionReceiverParameterForCallable(propertyDescriptor, receiverType);
        LexicalScope scopeForInitializer = ScopeUtils.makeScopeForPropertyInitializer(scopeForInitializerResolutionWithTypeParameters, propertyDescriptor);
        KotlinType propertyType = propertyInfo.getVariableType();
        KotlinType typeIfKnown = propertyType != null ? propertyType : this.variableTypeAndInitializerResolver.resolveTypeNullable(propertyDescriptor, scopeForInitializer, variableDeclaration, dataFlowInfo, trace, false);
        PropertyGetterDescriptorImpl propertyGetterDescriptorImpl = this.resolvePropertyGetterDescriptor(scopeForDeclarationResolutionWithTypeParameters, variableDeclaration, propertyDescriptor, annotationSplitter, trace, typeIfKnown, propertyInfo.getPropertyGetter(), propertyInfo.getHasDelegate());
        KotlinType kotlinType = type2 = typeIfKnown != null ? typeIfKnown : propertyGetterDescriptorImpl.getReturnType();
        assert (type2 != null) : "At least getter type must be initialized via resolvePropertyGetterDescriptor";
        this.variableTypeAndInitializerResolver.setConstantForVariableIfNeeded(propertyDescriptor, scopeForInitializer, variableDeclaration, dataFlowInfo, type2, trace);
        propertyDescriptor.setType(type2, typeParameterDescriptors, DescriptorUtils.getDispatchReceiverParameterIfNeeded(container2), receiverDescriptor);
        PropertySetterDescriptor setter2 = this.resolvePropertySetterDescriptor(scopeForDeclarationResolutionWithTypeParameters, variableDeclaration, propertyDescriptor, annotationSplitter, trace, propertyInfo.getPropertySetter(), propertyInfo.getHasDelegate());
        propertyDescriptor.initialize(propertyGetterDescriptorImpl, setter2);
        trace.record(BindingContext.VARIABLE, variableDeclaration, propertyDescriptor);
        PropertyDescriptorImpl propertyDescriptorImpl = propertyDescriptor;
        if (propertyDescriptorImpl == null) {
            DescriptorResolver.$$$reportNull$$$0(84);
        }
        return propertyDescriptorImpl;
    }

    @NotNull
    static KotlinType transformAnonymousTypeIfNeeded(@NotNull DeclarationDescriptorWithVisibility descriptor2, @NotNull KtDeclaration declaration, @NotNull KotlinType type2, @NotNull BindingTrace trace) {
        ClassifierDescriptor classifier2;
        if (descriptor2 == null) {
            DescriptorResolver.$$$reportNull$$$0(85);
        }
        if (declaration == null) {
            DescriptorResolver.$$$reportNull$$$0(86);
        }
        if (type2 == null) {
            DescriptorResolver.$$$reportNull$$$0(87);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(88);
        }
        if ((classifier2 = type2.getConstructor().getDeclarationDescriptor()) == null || !DescriptorUtils.isAnonymousObject(classifier2) || DescriptorUtils.isLocal(descriptor2)) {
            KotlinType kotlinType = type2;
            if (kotlinType == null) {
                DescriptorResolver.$$$reportNull$$$0(89);
            }
            return kotlinType;
        }
        if (!Visibilities.isPrivate(descriptor2.getVisibility())) {
            if (type2.getConstructor().getSupertypes().size() == 1) {
                KotlinType kotlinType = type2.getConstructor().getSupertypes().iterator().next();
                if (kotlinType == null) {
                    DescriptorResolver.$$$reportNull$$$0(90);
                }
                return kotlinType;
            }
            trace.report(Errors.AMBIGUOUS_ANONYMOUS_TYPE_INFERRED.on(declaration, type2.getConstructor().getSupertypes()));
        }
        KotlinType kotlinType = type2;
        if (kotlinType == null) {
            DescriptorResolver.$$$reportNull$$$0(91);
        }
        return kotlinType;
    }

    @Nullable
    private PropertySetterDescriptor resolvePropertySetterDescriptor(@NotNull LexicalScope scopeWithTypeParameters, @NotNull KtVariableDeclaration property, @NotNull PropertyDescriptor propertyDescriptor, @NotNull AnnotationSplitter annotationSplitter, @NotNull BindingTrace trace, @Nullable KtPropertyAccessor setter2, boolean hasDelegate) {
        if (scopeWithTypeParameters == null) {
            DescriptorResolver.$$$reportNull$$$0(92);
        }
        if (property == null) {
            DescriptorResolver.$$$reportNull$$$0(93);
        }
        if (propertyDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(94);
        }
        if (annotationSplitter == null) {
            DescriptorResolver.$$$reportNull$$$0(95);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(96);
        }
        PropertySetterDescriptorImpl setterDescriptor = null;
        if (setter2 != null) {
            KotlinType returnType;
            CompositeAnnotations annotations2 = new CompositeAnnotations(CollectionsKt.listOf(new Annotations[]{annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_SETTER), this.annotationResolver.resolveAnnotationsWithoutArguments(scopeWithTypeParameters, setter2.getModifierList(), trace)}));
            KtParameter parameter = setter2.getParameter();
            setterDescriptor = new PropertySetterDescriptorImpl(propertyDescriptor, annotations2, ModifiersChecker.resolveMemberModalityFromModifiers(setter2, propertyDescriptor.getModality(), trace.getBindingContext(), propertyDescriptor.getContainingDeclaration()), ModifiersChecker.resolveVisibilityFromModifiers(setter2, propertyDescriptor.getVisibility()), false, setter2.hasModifier(KtTokens.EXTERNAL_KEYWORD), property.hasModifier(KtTokens.INLINE_KEYWORD) || setter2.hasModifier(KtTokens.INLINE_KEYWORD), CallableMemberDescriptor.Kind.DECLARATION, null, KotlinSourceElementKt.toSourceElement(setter2));
            KtTypeReference returnTypeReference = setter2.getReturnTypeReference();
            if (returnTypeReference != null && !KotlinBuiltIns.isUnit(returnType = this.typeResolver.resolveType(scopeWithTypeParameters, returnTypeReference, trace, true))) {
                trace.report(Errors.WRONG_SETTER_RETURN_TYPE.on(returnTypeReference));
            }
            if (parameter != null) {
                KotlinType type2;
                KtTypeReference typeReference;
                if (parameter.hasDefaultValue()) {
                    trace.report(Errors.SETTER_PARAMETER_WITH_DEFAULT_VALUE.on(parameter.getDefaultValue()));
                }
                if ((typeReference = parameter.getTypeReference()) == null) {
                    type2 = propertyDescriptor.getType();
                } else {
                    KotlinType inType;
                    type2 = this.typeResolver.resolveType(scopeWithTypeParameters, typeReference, trace, true);
                    if (!TypeUtils.equalTypes(type2, inType = propertyDescriptor.getType())) {
                        trace.report(Errors.WRONG_SETTER_PARAMETER_TYPE.on(typeReference, inType, type2));
                    }
                }
                ValueParameterDescriptorImpl valueParameterDescriptor = this.resolveValueParameterDescriptor(scopeWithTypeParameters, setterDescriptor, parameter, 0, type2, trace);
                setterDescriptor.initialize(valueParameterDescriptor);
            } else {
                setterDescriptor.initializeDefault();
            }
            trace.record(BindingContext.PROPERTY_ACCESSOR, setter2, setterDescriptor);
        } else if (property.isVar()) {
            Annotations setterAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_SETTER);
            setterDescriptor = DescriptorFactory.createSetter(propertyDescriptor, setterAnnotations, !hasDelegate, false, property.hasModifier(KtTokens.INLINE_KEYWORD), propertyDescriptor.getSource());
        }
        if (!property.isVar() && setter2 != null) {
            trace.report(Errors.VAL_WITH_SETTER.on(setter2));
        }
        return setterDescriptor;
    }

    @NotNull
    private PropertyGetterDescriptorImpl resolvePropertyGetterDescriptor(@NotNull LexicalScope scopeForDeclarationResolution, @NotNull KtVariableDeclaration property, @NotNull PropertyDescriptor propertyDescriptor, @NotNull AnnotationSplitter annotationSplitter, @NotNull BindingTrace trace, @Nullable KotlinType propertyTypeIfKnown, @Nullable KtPropertyAccessor getter2, boolean hasDelegate) {
        KotlinType getterType;
        PropertyGetterDescriptorImpl getterDescriptor;
        if (scopeForDeclarationResolution == null) {
            DescriptorResolver.$$$reportNull$$$0(97);
        }
        if (property == null) {
            DescriptorResolver.$$$reportNull$$$0(98);
        }
        if (propertyDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(99);
        }
        if (annotationSplitter == null) {
            DescriptorResolver.$$$reportNull$$$0(100);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(101);
        }
        if (getter2 != null) {
            CompositeAnnotations getterAnnotations = new CompositeAnnotations(CollectionsKt.listOf(new Annotations[]{annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_GETTER), this.annotationResolver.resolveAnnotationsWithoutArguments(scopeForDeclarationResolution, getter2.getModifierList(), trace)}));
            getterDescriptor = new PropertyGetterDescriptorImpl(propertyDescriptor, getterAnnotations, ModifiersChecker.resolveMemberModalityFromModifiers(getter2, propertyDescriptor.getModality(), trace.getBindingContext(), propertyDescriptor.getContainingDeclaration()), ModifiersChecker.resolveVisibilityFromModifiers(getter2, propertyDescriptor.getVisibility()), false, getter2.hasModifier(KtTokens.EXTERNAL_KEYWORD), property.hasModifier(KtTokens.INLINE_KEYWORD) || getter2.hasModifier(KtTokens.INLINE_KEYWORD), CallableMemberDescriptor.Kind.DECLARATION, null, KotlinSourceElementKt.toSourceElement(getter2));
            getterType = this.determineGetterReturnType(scopeForDeclarationResolution, trace, getterDescriptor, getter2, propertyTypeIfKnown);
            trace.record(BindingContext.PROPERTY_ACCESSOR, getter2, getterDescriptor);
        } else {
            Annotations getterAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_GETTER);
            getterDescriptor = DescriptorFactory.createGetter(propertyDescriptor, getterAnnotations, !hasDelegate, false, property.hasModifier(KtTokens.INLINE_KEYWORD));
            getterType = propertyTypeIfKnown;
        }
        getterDescriptor.initialize(getterType != null ? getterType : VariableTypeAndInitializerResolver.STUB_FOR_PROPERTY_WITHOUT_TYPE);
        PropertyGetterDescriptorImpl propertyGetterDescriptorImpl = getterDescriptor;
        if (propertyGetterDescriptorImpl == null) {
            DescriptorResolver.$$$reportNull$$$0(102);
        }
        return propertyGetterDescriptorImpl;
    }

    @Nullable
    private KotlinType determineGetterReturnType(@NotNull LexicalScope scope, @NotNull BindingTrace trace, @NotNull PropertyGetterDescriptor getterDescriptor, @NotNull KtPropertyAccessor getter2, @Nullable KotlinType propertyTypeIfKnown) {
        KtTypeReference returnTypeReference;
        if (scope == null) {
            DescriptorResolver.$$$reportNull$$$0(103);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(104);
        }
        if (getterDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(105);
        }
        if (getter2 == null) {
            DescriptorResolver.$$$reportNull$$$0(106);
        }
        if ((returnTypeReference = getter2.getReturnTypeReference()) != null) {
            KotlinType explicitReturnType = this.typeResolver.resolveType(scope, returnTypeReference, trace, true);
            if (propertyTypeIfKnown != null && !TypeUtils.equalTypes(explicitReturnType, propertyTypeIfKnown)) {
                trace.report(Errors.WRONG_GETTER_RETURN_TYPE.on(returnTypeReference, propertyTypeIfKnown, explicitReturnType));
            }
            return explicitReturnType;
        }
        KtProperty property = getter2.getProperty();
        if (!property.hasDelegateExpressionOrInitializer() && property.getTypeReference() == null && getter2.hasBody() && !getter2.hasBlockBody()) {
            return this.inferReturnTypeFromExpressionBody(trace, scope, DataFlowInfoFactory.EMPTY, getter2, getterDescriptor);
        }
        return propertyTypeIfKnown;
    }

    @NotNull
    KotlinType inferReturnTypeFromExpressionBody(@NotNull BindingTrace trace, @NotNull LexicalScope scope, @NotNull DataFlowInfo dataFlowInfo, @NotNull KtDeclarationWithBody function2, @NotNull FunctionDescriptor functionDescriptor) {
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(107);
        }
        if (scope == null) {
            DescriptorResolver.$$$reportNull$$$0(108);
        }
        if (dataFlowInfo == null) {
            DescriptorResolver.$$$reportNull$$$0(109);
        }
        if (function2 == null) {
            DescriptorResolver.$$$reportNull$$$0(110);
        }
        if (functionDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(111);
        }
        KotlinType kotlinType = this.wrappedTypeFactory.createRecursionIntolerantDeferredType(trace, () -> {
            if (function2 == null) {
                DescriptorResolver.$$$reportNull$$$0(139);
            }
            if (trace == null) {
                DescriptorResolver.$$$reportNull$$$0(140);
            }
            if (scope == null) {
                DescriptorResolver.$$$reportNull$$$0(141);
            }
            if (dataFlowInfo == null) {
                DescriptorResolver.$$$reportNull$$$0(142);
            }
            if (functionDescriptor == null) {
                DescriptorResolver.$$$reportNull$$$0(143);
            }
            PreliminaryDeclarationVisitor.Companion.createForDeclaration(function2, trace, this.languageVersionSettings);
            KotlinType type2 = this.expressionTypingServices.getBodyExpressionType(trace, scope, dataFlowInfo, function2, functionDescriptor);
            KotlinType result2 = DescriptorResolver.transformAnonymousTypeIfNeeded(functionDescriptor, function2, type2, trace);
            UnwrappedType approximatedType = this.typeApproximator.approximateDeclarationType(result2, false);
            this.functionsTypingVisitor.checkTypesForReturnStatements(function2, trace, approximatedType);
            return approximatedType;
        });
        if (kotlinType == null) {
            DescriptorResolver.$$$reportNull$$$0(112);
        }
        return kotlinType;
    }

    @NotNull
    public PropertyDescriptor resolvePrimaryConstructorParameterToAProperty(@NotNull ClassDescriptor classDescriptor, @NotNull ValueParameterDescriptor valueParameter, @NotNull LexicalScope scope, @NotNull KtParameter parameter, BindingTrace trace) {
        if (classDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(113);
        }
        if (valueParameter == null) {
            DescriptorResolver.$$$reportNull$$$0(114);
        }
        if (scope == null) {
            DescriptorResolver.$$$reportNull$$$0(115);
        }
        if (parameter == null) {
            DescriptorResolver.$$$reportNull$$$0(116);
        }
        KotlinType type2 = this.resolveParameterType(scope, parameter, trace);
        Name name = parameter.getNameAsSafeName();
        boolean isMutable = parameter.isMutable();
        KtModifierList modifierList = parameter.getModifierList();
        if (modifierList != null && modifierList.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            trace.report(Errors.ABSTRACT_PROPERTY_IN_PRIMARY_CONSTRUCTOR_PARAMETERS.on(parameter));
        }
        AnnotationSplitter.PropertyWrapper propertyWrapper = new AnnotationSplitter.PropertyWrapper(parameter);
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithoutArguments(scope, parameter.getModifierList(), trace);
        AnnotationSplitter annotationSplitter = new AnnotationSplitter(this.storageManager, allAnnotations, () -> AnnotationSplitter.getTargetSet(true, trace.getBindingContext(), propertyWrapper));
        CompositeAnnotations propertyAnnotations = new CompositeAnnotations(annotationSplitter.getAnnotationsForTargets(AnnotationUseSiteTarget.PROPERTY, AnnotationUseSiteTarget.FIELD), annotationSplitter.getOtherAnnotations());
        PropertyDescriptorImpl propertyDescriptor = PropertyDescriptorImpl.create(classDescriptor, propertyAnnotations, ModifiersChecker.resolveMemberModalityFromModifiers(parameter, Modality.FINAL, trace.getBindingContext(), classDescriptor), ModifiersChecker.resolveVisibilityFromModifiers(parameter, DescriptorResolver.getDefaultVisibility(parameter, classDescriptor)), isMutable, name, CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement(parameter), false, false, classDescriptor.isHeader(), modifierList != null && modifierList.hasModifier(KtTokens.IMPL_KEYWORD), false, false);
        propertyWrapper.setDescriptor(propertyDescriptor);
        propertyDescriptor.setType(type2, Collections.emptyList(), DescriptorUtils.getDispatchReceiverParameterIfNeeded(classDescriptor), (ReceiverParameterDescriptor)null);
        Annotations setterAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_SETTER);
        CompositeAnnotations getterAnnotations = new CompositeAnnotations(CollectionsKt.listOf(annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_GETTER)));
        PropertyGetterDescriptorImpl getter2 = DescriptorFactory.createDefaultGetter(propertyDescriptor, getterAnnotations);
        PropertySetterDescriptorImpl setter2 = propertyDescriptor.isVar() ? DescriptorFactory.createDefaultSetter(propertyDescriptor, setterAnnotations) : null;
        propertyDescriptor.initialize(getter2, setter2);
        getter2.initialize(propertyDescriptor.getType());
        trace.record(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter, propertyDescriptor);
        trace.record(BindingContext.VALUE_PARAMETER_AS_PROPERTY, valueParameter, propertyDescriptor);
        PropertyDescriptorImpl propertyDescriptorImpl = propertyDescriptor;
        if (propertyDescriptorImpl == null) {
            DescriptorResolver.$$$reportNull$$$0(117);
        }
        return propertyDescriptorImpl;
    }

    public static void checkBounds(@NotNull KtTypeReference typeReference, @NotNull KotlinType type2, @NotNull BindingTrace trace) {
        if (typeReference == null) {
            DescriptorResolver.$$$reportNull$$$0(118);
        }
        if (type2 == null) {
            DescriptorResolver.$$$reportNull$$$0(119);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(120);
        }
        if (KotlinTypeKt.isError(type2)) {
            return;
        }
        KtTypeElement typeElement = typeReference.getTypeElement();
        if (typeElement == null) {
            return;
        }
        List<TypeParameterDescriptor> parameters2 = type2.getConstructor().getParameters();
        List<TypeProjection> arguments2 = type2.getArguments();
        assert (parameters2.size() == arguments2.size());
        List<KtTypeReference> ktTypeArguments = typeElement.getTypeArgumentsAsTypes();
        if (FlexibleTypesKt.isFlexible(type2) && !DynamicTypesKt.isDynamic(type2)) {
            assert (ktTypeArguments.size() == 2) : "Flexible type cannot be denoted in Kotlin otherwise than as ft<T1, T2>, but was: " + PsiUtilsKt.getElementTextWithContext(typeReference);
            FlexibleType flexibleType = FlexibleTypesKt.asFlexibleType(type2);
            DescriptorResolver.checkBounds(ktTypeArguments.get(0), flexibleType.getLowerBound(), trace);
            DescriptorResolver.checkBounds(ktTypeArguments.get(1), flexibleType.getUpperBound(), trace);
            return;
        }
        if (ktTypeArguments.size() != arguments2.size()) {
            return;
        }
        TypeSubstitutor substitutor2 = TypeSubstitutor.create(type2);
        for (int i = 0; i < ktTypeArguments.size(); ++i) {
            KtTypeReference ktTypeArgument = ktTypeArguments.get(i);
            if (ktTypeArgument == null) continue;
            KotlinType typeArgument = arguments2.get(i).getType();
            DescriptorResolver.checkBounds(ktTypeArgument, typeArgument, trace);
            TypeParameterDescriptor typeParameterDescriptor = parameters2.get(i);
            DescriptorResolver.checkBounds(ktTypeArgument, typeArgument, typeParameterDescriptor, substitutor2, trace);
        }
    }

    public static void checkBounds(@NotNull KtTypeReference jetTypeArgument, @NotNull KotlinType typeArgument, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull TypeSubstitutor substitutor2, @NotNull BindingTrace trace) {
        if (jetTypeArgument == null) {
            DescriptorResolver.$$$reportNull$$$0(121);
        }
        if (typeArgument == null) {
            DescriptorResolver.$$$reportNull$$$0(122);
        }
        if (typeParameterDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(123);
        }
        if (substitutor2 == null) {
            DescriptorResolver.$$$reportNull$$$0(124);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(125);
        }
        for (KotlinType bound : typeParameterDescriptor.getUpperBounds()) {
            KotlinType substitutedBound = substitutor2.safeSubstitute(bound, Variance.INVARIANT);
            if (KotlinTypeChecker.DEFAULT.isSubtypeOf(typeArgument, substitutedBound)) continue;
            trace.report(Errors.UPPER_BOUND_VIOLATED.on(jetTypeArgument, substitutedBound, typeArgument));
        }
    }

    public static void checkBoundsInTypeAlias(@NotNull TypeAliasExpansionReportStrategy reportStrategy, @NotNull KotlinType unsubstitutedArgument, @NotNull KotlinType typeArgument, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull TypeSubstitutor substitutor2) {
        if (reportStrategy == null) {
            DescriptorResolver.$$$reportNull$$$0(126);
        }
        if (unsubstitutedArgument == null) {
            DescriptorResolver.$$$reportNull$$$0(127);
        }
        if (typeArgument == null) {
            DescriptorResolver.$$$reportNull$$$0(128);
        }
        if (typeParameterDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(129);
        }
        if (substitutor2 == null) {
            DescriptorResolver.$$$reportNull$$$0(130);
        }
        for (KotlinType bound : typeParameterDescriptor.getUpperBounds()) {
            KotlinType substitutedBound = substitutor2.safeSubstitute(bound, Variance.INVARIANT);
            if (KotlinTypeChecker.DEFAULT.isSubtypeOf(typeArgument, substitutedBound)) continue;
            reportStrategy.boundsViolationInSubstitution(substitutedBound, unsubstitutedArgument, typeArgument, typeParameterDescriptor);
        }
    }

    public static boolean checkHasOuterClassInstance(@NotNull LexicalScope scope, @NotNull BindingTrace trace, @NotNull PsiElement reportErrorsOn, @NotNull ClassDescriptor target) {
        ClassDescriptor classDescriptor;
        if (scope == null) {
            DescriptorResolver.$$$reportNull$$$0(131);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(132);
        }
        if (reportErrorsOn == null) {
            DescriptorResolver.$$$reportNull$$$0(133);
        }
        if (target == null) {
            DescriptorResolver.$$$reportNull$$$0(134);
        }
        if (!DescriptorResolver.isInsideOuterClassOrItsSubclass(classDescriptor = DescriptorResolver.getContainingClass(scope), target)) {
            return true;
        }
        while (classDescriptor != null) {
            if (DescriptorUtils.isSubclass(classDescriptor, target)) {
                return true;
            }
            if (DescriptorUtils.isStaticNestedClass(classDescriptor)) {
                trace.report(Errors.INACCESSIBLE_OUTER_CLASS_EXPRESSION.on(reportErrorsOn, classDescriptor));
                return false;
            }
            classDescriptor = DescriptorUtils.getParentOfType(classDescriptor, ClassDescriptor.class, true);
        }
        return true;
    }

    private static boolean isInsideOuterClassOrItsSubclass(@Nullable DeclarationDescriptor nested, @NotNull ClassDescriptor outer) {
        if (outer == null) {
            DescriptorResolver.$$$reportNull$$$0(135);
        }
        if (nested == null) {
            return false;
        }
        if (nested instanceof ClassDescriptor && DescriptorUtils.isSubclass((ClassDescriptor)nested, outer)) {
            return true;
        }
        return DescriptorResolver.isInsideOuterClassOrItsSubclass(nested.getContainingDeclaration(), outer);
    }

    @Nullable
    public static ClassDescriptor getContainingClass(@NotNull LexicalScope scope) {
        if (scope == null) {
            DescriptorResolver.$$$reportNull$$$0(136);
        }
        return DescriptorUtils.getParentOfType(scope.getOwnerDescriptor(), ClassDescriptor.class, false);
    }

    public static void registerFileInPackage(@NotNull BindingTrace trace, @NotNull KtFile file) {
        FqName fqName2;
        Collection<KtFile> files2;
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(137);
        }
        if (file == null) {
            DescriptorResolver.$$$reportNull$$$0(138);
        }
        if ((files2 = trace.get(BindingContext.PACKAGE_TO_FILES, fqName2 = file.getPackageFqName())) == null) {
            files2 = Sets.newIdentityHashSet();
        }
        files2.add(file);
        trace.record(BindingContext.PACKAGE_TO_FILES, fqName2, files2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 50: 
            case 58: 
            case 67: 
            case 76: 
            case 84: 
            case 89: 
            case 90: 
            case 91: 
            case 102: 
            case 112: 
            case 117: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 50: 
            case 58: 
            case 67: 
            case 76: 
            case 84: 
            case 89: 
            case 90: 
            case 91: 
            case 102: 
            case 112: 
            case 117: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationResolver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtIns";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeResolver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supertypeLoopsResolver";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableTypeAndInitializerResolver";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionTypingServices";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overloadChecker";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionsTypingVisitor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringDeclarationResolver";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiersChecker";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappedTypeFactory";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 24: 
            case 45: 
            case 48: 
            case 53: 
            case 55: 
            case 103: 
            case 108: 
            case 115: 
            case 131: 
            case 136: 
            case 141: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 15: 
            case 16: 
            case 33: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 50: 
            case 58: 
            case 67: 
            case 76: 
            case 84: 
            case 89: 
            case 90: 
            case 91: 
            case 102: 
            case 112: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/DescriptorResolver";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 21: 
            case 22: 
            case 28: 
            case 34: 
            case 38: 
            case 40: 
            case 46: 
            case 57: 
            case 60: 
            case 65: 
            case 74: 
            case 81: 
            case 88: 
            case 96: 
            case 101: 
            case 104: 
            case 107: 
            case 120: 
            case 125: 
            case 132: 
            case 137: 
            case 140: 
            case 144: 
            case 145: 
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 23: 
            case 27: 
            case 52: 
            case 87: 
            case 119: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 25: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 26: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParameter";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 36: 
            case 43: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 37: 
            case 44: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 41: 
            case 49: 
            case 51: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upperBoundType";
                break;
            }
            case 54: 
            case 61: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingDeclaration";
                break;
            }
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAlias";
                break;
            }
            case 62: 
            case 71: 
            case 78: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeForDeclarationResolution";
                break;
            }
            case 63: 
            case 72: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeForInitializerResolution";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 66: 
            case 75: 
            case 82: 
            case 109: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlowInfo";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringDeclaration";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 73: 
            case 93: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableDeclaration";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyInfo";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeWithTypeParameters";
                break;
            }
            case 94: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 95: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationSplitter";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getterDescriptor";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 110: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 111: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeReference";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetTypeArgument";
                break;
            }
            case 122: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArgument";
                break;
            }
            case 123: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameterDescriptor";
                break;
            }
            case 124: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportStrategy";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unsubstitutedArgument";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportErrorsOn";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outer";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/DescriptorResolver";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSupertype";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveValueParameterDescriptor";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarargParameterType";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndRecordPrimaryConstructorForObject";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocalVariableDescriptor";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTypeAliasDescriptor";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDestructuringDeclarationEntryAsProperty";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePropertyDescriptor";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAsPropertyDescriptor";
                break;
            }
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "transformAnonymousTypeIfNeeded";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePropertyGetterDescriptor";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "inferReturnTypeFromExpressionBody";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePrimaryConstructorParameterToAProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveSupertypes";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSupertype";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 50: 
            case 58: 
            case 67: 
            case 76: 
            case 84: 
            case 89: 
            case 90: 
            case 91: 
            case 102: 
            case 112: 
            case 117: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "resolveSuperTypeListEntries";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkNullableSupertypeAndStripQuestionMarks";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkProjectionsInImmediateArguments";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resolveValueParameterDescriptor";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getVarargParameterType";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createAndRecordPrimaryConstructorForObject";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "resolveGenericBounds";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkUpperBoundTypes";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "checkConflictingUpperBounds";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "checkNamesInConstraints";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "checkUpperBoundType";
                break;
            }
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocalVariableDescriptor";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeAliasDescriptor";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "checkNoGenericBoundsOnTypeAliasParameters";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "resolveDestructuringDeclarationEntryAsProperty";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "createReceiverForDestructuringDeclaration";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "resolvePropertyDescriptor";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "resolveAsPropertyDescriptor";
                break;
            }
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "transformAnonymousTypeIfNeeded";
                break;
            }
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "resolvePropertySetterDescriptor";
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "resolvePropertyGetterDescriptor";
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "determineGetterReturnType";
                break;
            }
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "inferReturnTypeFromExpressionBody";
                break;
            }
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "resolvePrimaryConstructorParameterToAProperty";
                break;
            }
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "checkBounds";
                break;
            }
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "checkBoundsInTypeAlias";
                break;
            }
            case 131: 
            case 132: 
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "checkHasOuterClassInstance";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "isInsideOuterClassOrItsSubclass";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "getContainingClass";
                break;
            }
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "registerFileInPackage";
                break;
            }
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "lambda$inferReturnTypeFromExpressionBody$5";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveAsPropertyDescriptor$4";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveTypeAliasDescriptor$2";
                break;
            }
            case 146: 
            case 147: 
            case 148: 
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveValueParameterDescriptor$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 50: 
            case 58: 
            case 67: 
            case 76: 
            case 84: 
            case 89: 
            case 90: 
            case 91: 
            case 102: 
            case 112: 
            case 117: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class UpperBoundCheckRequest {
        public final Name typeParameterName;
        public final KtTypeReference upperBound;
        public final KotlinType upperBoundType;

        UpperBoundCheckRequest(Name typeParameterName, KtTypeReference upperBound, KotlinType upperBoundType) {
            this.typeParameterName = typeParameterName;
            this.upperBound = upperBound;
            this.upperBoundType = upperBoundType;
        }
    }
}

