/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.descriptorUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt$WhenMappings;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.DFS;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000\u00da\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a\u0014\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00010E2\u0006\u0010F\u001a\u00020\u0001\u001a\u001e\u0010G\u001a\n\u0012\u0004\u0012\u00020H\u0018\u00010@2\u0006\u0010I\u001a\u00020\u00012\u0006\u0010J\u001a\u00020\u0001\u001a\u0012\u0010K\u001a\b\u0012\u0004\u0012\u00020\u000106*\u00020\u0001H\u0002\u001a\f\u0010L\u001a\u0004\u0018\u00010M*\u00020\u0002\u001a*\u0010N\u001a\u0004\u0018\u00010<*\u00020<2\b\b\u0002\u0010O\u001a\u00020#2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020#0Q\u001a\f\u0010R\u001a\u0004\u0018\u00010\u001b*\u00020S\u001a\u0012\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00130@*\u00020\u0001H\u0002\u001a\u0010\u0010U\u001a\b\u0012\u0004\u0012\u00020V06*\u00020V\u001a\u0010\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00010X*\u00020\u0001\u001a\f\u0010Y\u001a\u0004\u0018\u00010Z*\u00020[\u001a\n\u0010\\\u001a\u00020\u0001*\u00020\u0001\u001a\u0010\u0010]\u001a\b\u0012\u0004\u0012\u00020A0@*\u00020\u0001\u001a\n\u0010^\u001a\u00020\u0007*\u00020\u0007\u001a\f\u0010_\u001a\u0004\u0018\u00010A*\u00020\u0001\u001a\f\u0010`\u001a\u0004\u0018\u00010\u0007*\u00020S\u001a\f\u0010a\u001a\u0004\u0018\u00010\u0001*\u00020\u0001\u001a\n\u0010b\u001a\u00020\u0001*\u00020\u0001\u001a\u0010\u0010c\u001a\b\u0012\u0004\u0012\u00020\u00010@*\u00020\u0001\u001a\n\u0010d\u001a\u00020#*\u00020e\u001a\n\u0010f\u001a\u00020#*\u00020g\u001a\n\u0010h\u001a\u00020#*\u00020g\u001a\u001a\u0010i\u001a\u00020#*\u00020\u00072\u0006\u0010j\u001a\u00020\u00072\u0006\u0010k\u001a\u00020#\u001a\n\u0010l\u001a\u00020#*\u00020\u0007\u001a\n\u0010m\u001a\u00020#*\u00020[\u001a\n\u0010n\u001a\u00020#*\u00020o\u001a\n\u0010p\u001a\u00020#*\u00020g\u001a\n\u0010q\u001a\u00020#*\u00020\u0007\u001a\n\u0010r\u001a\u00020#*\u00020[\u001a\u0012\u0010s\u001a\u00020#*\u00020\u00012\u0006\u0010t\u001a\u00020\u0001\u001a\u0018\u0010u\u001a\b\u0012\u0004\u0012\u00020<06*\u00020<2\u0006\u0010O\u001a\u00020#\u001a'\u0010v\u001a\b\u0012\u0004\u0012\u0002Hw06\"\b\b\u0000\u0010w*\u00020S*\u0002Hw2\u0006\u0010O\u001a\u00020#\u00a2\u0006\u0002\u0010x\u001a\u001c\u0010y\u001a\u0004\u0018\u00010\u0001*\u0002022\u0006\u0010z\u001a\u00020\u001b2\u0006\u0010{\u001a\u00020|\u001a\u0012\u0010}\u001a\u00020~*\u00020<2\u0006\u0010\u007f\u001a\u00020<\u001a\f\u0010\u0080\u0001\u001a\u00030\u0081\u0001*\u00020S\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u0001*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u0001*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011\"\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u0001*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011\"\u0015\u0010\u001a\u001a\u00020\u001b*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\"\u0015\u0010\u001e\u001a\u00020\u001f*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\"\u0015\u0010\"\u001a\u00020#*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\"\u0015\u0010&\u001a\u00020#*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\"\u0015\u0010)\u001a\u00020#*\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010+\"\u0015\u0010,\u001a\u00020#*\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010+\"\u0015\u0010-\u001a\u00020#*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\"\u0015\u0010/\u001a\u00020#*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b/\u0010.\"\u0015\u00100\u001a\u00020#*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b0\u0010.\"\u0015\u00101\u001a\u000202*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b3\u00104\"\u001b\u00105\u001a\b\u0012\u0004\u0012\u00020\u000706*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b7\u00108\"\u001b\u00109\u001a\b\u0012\u0004\u0012\u00020\u000706*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b:\u00108\"\u0015\u0010;\u001a\u00020<*\u00020<8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010>\"\u001b\u0010?\u001a\b\u0012\u0004\u0012\u00020A0@*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\bB\u0010C\u00a8\u0006\u0082\u0001"}, d2={"annotationClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "getAnnotationClass", "(Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;)Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getBuiltIns", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;", "getClassId", "(Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;)Lorg/jetbrains/kotlin/name/ClassId;", "classValueDescriptor", "getClassValueDescriptor", "(Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;)Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "classValueType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getClassValueType", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Lorg/jetbrains/kotlin/types/KotlinType;", "classValueTypeDescriptor", "getClassValueTypeDescriptor", "denotedClassDescriptor", "getDenotedClassDescriptor", "fqNameSafe", "Lorg/jetbrains/kotlin/name/FqName;", "getFqNameSafe", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/name/FqName;", "fqNameUnsafe", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "getFqNameUnsafe", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "hasClassValueDescriptor", "", "getHasClassValueDescriptor", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Z", "hasCompanionObject", "getHasCompanionObject", "(Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;)Z", "isEffectivelyPrivateApi", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;)Z", "isEffectivelyPublicApi", "isExtension", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "isExtensionProperty", "isInsidePrivateClass", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getModule", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "parents", "Lkotlin/sequences/Sequence;", "getParents", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lkotlin/sequences/Sequence;", "parentsWithSelf", "getParentsWithSelf", "propertyIfAccessor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "getPropertyIfAccessor", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;)Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "secondaryConstructors", "", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "getSecondaryConstructors", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Ljava/util/List;", "computeSealedSubclasses", "", "sealedClass", "findImplicitOuterClassArguments", "Lorg/jetbrains/kotlin/types/TypeProjection;", "scopeOwner", "outerClass", "classesFromInnerToOuter", "firstArgumentValue", "", "firstOverridden", "useOriginal", "predicate", "Lkotlin/Function1;", "fqNameOrNull", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getAllSuperClassesTypesIncludeItself", "getAllSuperClassifiers", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "getAllSuperclassesWithoutAny", "Lorg/jetbrains/kotlin/utils/SmartList;", "getAnnotationRetention", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinRetention;", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotated;", "getClassObjectReferenceTarget", "getConstructorForEmptyArgumentsList", "getImportableDescriptor", "getNoArgsConstructor", "getOwnerForEffectiveDispatchReceiverParameter", "getSuperClassNotAny", "getSuperClassOrAny", "getSuperInterfaces", "hasDefaultValue", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "hasOrInheritsParametersWithDefaultValue", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "hasOwnParametersWithDefaultValue", "isAncestorOf", "descriptor", "strict", "isCompanionObject", "isDocumentedAnnotation", "isEffectivelyExternal", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "isEnumValueOfMethod", "isPublishedApi", "isRepeatableAnnotation", "isSubclassOf", "superclass", "overriddenTreeAsSequence", "overriddenTreeUniqueAsSequence", "D", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Z)Lkotlin/sequences/Sequence;", "resolveTopLevelClass", "topLevelClassFqName", "location", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "setSingleOverridden", "", "overridden", "varargParameterPosition", "", "kotlin-compiler"})
public final class DescriptorUtilsKt {
    @NotNull
    public static final ClassDescriptor getClassObjectReferenceTarget(@NotNull ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassDescriptor classDescriptor = $receiver.getCompanionObjectDescriptor();
        if (classDescriptor == null) {
            classDescriptor = $receiver;
        }
        return classDescriptor;
    }

    @NotNull
    public static final DeclarationDescriptor getImportableDescriptor(@NotNull DeclarationDescriptor $receiver) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver instanceof TypeAliasConstructorDescriptor) {
            declarationDescriptor = ((TypeAliasConstructorDescriptor)$receiver).getContainingDeclaration();
        } else if ($receiver instanceof ConstructorDescriptor) {
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)$receiver).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(classifierDescriptorWithTypeParameters, "containingDeclaration");
            declarationDescriptor = classifierDescriptorWithTypeParameters;
        } else if ($receiver instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty();
            Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "correspondingProperty");
            declarationDescriptor = propertyDescriptor;
        } else {
            declarationDescriptor = $receiver;
        }
        return declarationDescriptor;
    }

    @NotNull
    public static final FqNameUnsafe getFqNameUnsafe(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName($receiver);
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "DescriptorUtils.getFqName(this)");
        return fqNameUnsafe;
    }

    @NotNull
    public static final FqName getFqNameSafe(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        FqName fqName2 = DescriptorUtils.getFqNameSafe($receiver);
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "DescriptorUtils.getFqNameSafe(this)");
        return fqName2;
    }

    public static final boolean isExtension(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver instanceof CallableDescriptor && ((CallableDescriptor)$receiver).getExtensionReceiverParameter() != null;
    }

    @NotNull
    public static final ModuleDescriptor getModule(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule($receiver);
        Intrinsics.checkExpressionValueIsNotNull(moduleDescriptor, "DescriptorUtils.getContainingModule(this)");
        return moduleDescriptor;
    }

    @Nullable
    public static final ClassDescriptor resolveTopLevelClass(@NotNull ModuleDescriptor $receiver, @NotNull FqName topLevelClassFqName, @NotNull LookupLocation location2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(topLevelClassFqName, "topLevelClassFqName");
        Intrinsics.checkParameterIsNotNull(location2, "location");
        boolean bl2 = bl = !topLevelClassFqName.isRoot();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        FqName fqName2 = topLevelClassFqName.parent();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "topLevelClassFqName.parent()");
        MemberScope memberScope2 = $receiver.getPackage(fqName2).getMemberScope();
        Name name = topLevelClassFqName.shortName();
        Intrinsics.checkExpressionValueIsNotNull(name, "topLevelClassFqName.shortName()");
        ClassifierDescriptor classifierDescriptor = memberScope2.getContributedClassifier(name, location2);
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        return (ClassDescriptor)classifierDescriptor;
    }

    @Nullable
    public static final ClassDescriptor getDenotedClassDescriptor(@NotNull ClassifierDescriptorWithTypeParameters $receiver) {
        ClassDescriptor classDescriptor;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = $receiver;
        if (classifierDescriptorWithTypeParameters instanceof ClassDescriptor) {
            classDescriptor = (ClassDescriptor)$receiver;
        } else if (classifierDescriptorWithTypeParameters instanceof TypeAliasDescriptor) {
            classDescriptor = ((TypeAliasDescriptor)$receiver).getClassDescriptor();
        } else {
            throw (Throwable)new UnsupportedOperationException("Unexpected descriptor kind: " + $receiver);
        }
        return classDescriptor;
    }

    @Nullable
    public static final ClassId getClassId(@NotNull ClassifierDescriptorWithTypeParameters $receiver) {
        ClassId classId;
        DeclarationDescriptor declarationDescriptor;
        DeclarationDescriptor owner;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        DeclarationDescriptor declarationDescriptor2 = owner = (declarationDescriptor = $receiver.getContainingDeclaration());
        if (declarationDescriptor2 instanceof PackageFragmentDescriptor) {
            classId = new ClassId(((PackageFragmentDescriptor)owner).getFqName(), $receiver.getName());
        } else if (declarationDescriptor2 instanceof ClassifierDescriptorWithTypeParameters) {
            ClassId classId2 = DescriptorUtilsKt.getClassId((ClassifierDescriptorWithTypeParameters)owner);
            classId = classId2 != null ? classId2.createNestedClassId($receiver.getName()) : null;
        } else {
            classId = null;
        }
        return classId;
    }

    public static final boolean getHasCompanionObject(@NotNull ClassifierDescriptorWithTypeParameters $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getDenotedClassDescriptor($receiver);
        return (classDescriptor != null ? classDescriptor.getCompanionObjectDescriptor() : null) != null;
    }

    public static final boolean getHasClassValueDescriptor(@NotNull ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return DescriptorUtilsKt.getClassValueDescriptor($receiver) != null;
    }

    @Nullable
    public static final ClassDescriptor getClassValueDescriptor(@NotNull ClassifierDescriptorWithTypeParameters $receiver) {
        ClassDescriptor classDescriptor;
        ClassDescriptor it;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getDenotedClassDescriptor($receiver);
        return classDescriptor2 != null ? ((it = (classDescriptor = classDescriptor2)).getKind().isSingleton() ? it : it.getCompanionObjectDescriptor()) : null;
    }

    @Nullable
    public static final ClassDescriptor getClassValueTypeDescriptor(@NotNull ClassifierDescriptorWithTypeParameters $receiver) {
        ClassDescriptor classDescriptor;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getDenotedClassDescriptor($receiver);
        if (classDescriptor2 != null) {
            ClassDescriptor classDescriptor3;
            ClassDescriptor it = classDescriptor3 = classDescriptor2;
            switch (DescriptorUtilsKt$WhenMappings.$EnumSwitchMapping$0[it.getKind().ordinal()]) {
                case 1: {
                    classDescriptor = it;
                    break;
                }
                case 2: {
                    boolean bl;
                    DeclarationDescriptor container2 = $receiver.getContainingDeclaration();
                    boolean bl2 = bl = container2 instanceof ClassDescriptor && Intrinsics.areEqual((Object)((ClassDescriptor)container2).getKind(), (Object)ClassKind.ENUM_CLASS);
                    if (_Assertions.ENABLED && !bl) {
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    DeclarationDescriptor declarationDescriptor = container2;
                    if (declarationDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                    }
                    classDescriptor = (ClassDescriptor)declarationDescriptor;
                    break;
                }
                default: {
                    classDescriptor = it.getCompanionObjectDescriptor();
                }
            }
        } else {
            classDescriptor = null;
        }
        return classDescriptor;
    }

    @Nullable
    public static final KotlinType getClassValueType(@NotNull ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getClassValueTypeDescriptor($receiver);
        return classDescriptor != null ? classDescriptor.getDefaultType() : null;
    }

    public static final boolean isEffectivelyPublicApi(@NotNull DeclarationDescriptorWithVisibility $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return EffectiveVisibilityKt.effectiveVisibility$default($receiver, null, false, 3, null).getPublicApi();
    }

    public static final boolean isEffectivelyPrivateApi(@NotNull DeclarationDescriptorWithVisibility $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return EffectiveVisibilityKt.effectiveVisibility$default($receiver, null, false, 3, null).getPrivateApi();
    }

    public static final boolean isInsidePrivateClass(@NotNull DeclarationDescriptor $receiver) {
        ClassDescriptor parent2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        return (parent2 = (ClassDescriptor)declarationDescriptor) != null && Visibilities.isPrivate(parent2.getVisibility());
    }

    @Nullable
    public static final ClassDescriptor getSuperClassNotAny(@NotNull ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        for (KotlinType supertype : $receiver.getDefaultType().getConstructor().getSupertypes()) {
            ClassifierDescriptor superClassifier;
            if (KotlinBuiltIns.isAnyOrNullableAny(supertype) || !DescriptorUtils.isClassOrEnumClass(superClassifier = supertype.getConstructor().getDeclarationDescriptor())) continue;
            ClassifierDescriptor classifierDescriptor = superClassifier;
            if (classifierDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            return (ClassDescriptor)classifierDescriptor;
        }
        return null;
    }

    @NotNull
    public static final ClassDescriptor getSuperClassOrAny(@NotNull ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getSuperClassNotAny($receiver);
        if (classDescriptor == null) {
            ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getBuiltIns($receiver).getAny();
            classDescriptor = classDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "builtIns.any");
        }
        return classDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ClassDescriptor> getSuperInterfaces(@NotNull ClassDescriptor $receiver) {
        void var3_3;
        Iterable $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Iterable $receiver$iv = $receiver.getDefaultType().getConstructor().getSupertypes();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KotlinType it = (KotlinType)element$iv$iv;
            if (KotlinBuiltIns.isAnyOrNullableAny(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            ClassDescriptor classDescriptor;
            ClassDescriptor classDescriptor2;
            Object element$iv$iv = element$iv$iv$iv;
            KotlinType it = (KotlinType)element$iv$iv;
            ClassifierDescriptor superClassifier = it.getConstructor().getDeclarationDescriptor();
            if (DescriptorUtils.isInterface(superClassifier)) {
                ClassifierDescriptor classifierDescriptor = superClassifier;
                if (classifierDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                }
                classDescriptor2 = (ClassDescriptor)classifierDescriptor;
            } else {
                classDescriptor2 = null;
            }
            if (classDescriptor2 == null) continue;
            ClassDescriptor it$iv$iv = classDescriptor = classDescriptor2;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ClassConstructorDescriptor> getSecondaryConstructors(@NotNull ClassDescriptor $receiver) {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Iterable iterable = $receiver$iv = (Iterable)$receiver.getConstructors();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ClassConstructorDescriptor it = (ClassConstructorDescriptor)element$iv$iv;
            if (it.isPrimary()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    @NotNull
    public static final KotlinBuiltIns getBuiltIns(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return DescriptorUtilsKt.getModule($receiver).getBuiltIns();
    }

    @Nullable
    public static final DeclarationDescriptor getOwnerForEffectiveDispatchReceiverParameter(@NotNull CallableDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver instanceof CallableMemberDescriptor && Intrinsics.areEqual((Object)((CallableMemberDescriptor)$receiver).getKind(), (Object)CallableMemberDescriptor.Kind.FAKE_OVERRIDE)) {
            return $receiver.getContainingDeclaration();
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = $receiver.getDispatchReceiverParameter();
        return receiverParameterDescriptor != null ? receiverParameterDescriptor.getContainingDeclaration() : null;
    }

    public static final boolean hasDefaultValue(@NotNull ValueParameterDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Boolean bl = DFS.ifAny((Collection)CollectionsKt.listOf($receiver), hasDefaultValue.1.INSTANCE, hasDefaultValue.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(bl, "DFS.ifAny(\n            l\u2026eclaresDefaultValue\n    )");
        return bl;
    }

    public static final boolean hasOrInheritsParametersWithDefaultValue(@NotNull FunctionDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Boolean bl = DFS.ifAny((Collection)CollectionsKt.listOf($receiver), hasOrInheritsParametersWithDefaultValue.1.INSTANCE, hasOrInheritsParametersWithDefaultValue.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(bl, "DFS.ifAny(\n        listO\u2026ersWithDefaultValue() }\n)");
        return bl;
    }

    public static final boolean hasOwnParametersWithDefaultValue(@NotNull FunctionDescriptor $receiver) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Iterable $receiver$iv = $receiver.getOriginal().getValueParameters();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                    if (!it.declaresDefaultValue()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isRepeatableAnnotation(@NotNull Annotated $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.repeatable;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.FQ_NAMES.repeatable");
        return annotations2.findAnnotation(fqName2) != null;
    }

    public static final boolean isDocumentedAnnotation(@NotNull Annotated $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.mustBeDocumented;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.FQ_NAMES.mustBeDocumented");
        return annotations2.findAnnotation(fqName2) != null;
    }

    @Nullable
    public static final KotlinRetention getAnnotationRetention(@NotNull Annotated $receiver) {
        ConstantValue constantValue;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.retention;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.FQ_NAMES.retention");
        Object object = annotations2.findAnnotation(fqName2);
        if (!((object != null && (object = object.getAllValueArguments()) != null ? (ConstantValue)object.get(Name.identifier("value")) : (constantValue = null)) instanceof EnumValue)) {
            constantValue = null;
        }
        EnumValue enumValue = (EnumValue)constantValue;
        if (enumValue == null) {
            return null;
        }
        EnumValue retentionArgumentValue = enumValue;
        String string = ((ClassDescriptor)retentionArgumentValue.getValue()).getName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "retentionArgumentValue.value.name.asString()");
        return KotlinRetention.valueOf(string);
    }

    @NotNull
    public static final Sequence<DeclarationDescriptor> getParentsWithSelf(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return SequencesKt.generateSequence($receiver, (Function1)parentsWithSelf.1.INSTANCE);
    }

    @NotNull
    public static final Sequence<DeclarationDescriptor> getParents(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return SequencesKt.drop(DescriptorUtilsKt.getParentsWithSelf($receiver), 1);
    }

    @NotNull
    public static final CallableMemberDescriptor getPropertyIfAccessor(@NotNull CallableMemberDescriptor $receiver) {
        CallableMemberDescriptor callableMemberDescriptor;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty();
            Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "correspondingProperty");
            callableMemberDescriptor = propertyDescriptor;
        } else {
            callableMemberDescriptor = $receiver;
        }
        return callableMemberDescriptor;
    }

    @Nullable
    public static final FqName fqNameOrNull(@NotNull CallableDescriptor $receiver) {
        FqNameUnsafe fqNameUnsafe;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        FqNameUnsafe it = fqNameUnsafe = DescriptorUtilsKt.getFqNameUnsafe($receiver);
        FqNameUnsafe fqNameUnsafe2 = it.isSafe() ? fqNameUnsafe : null;
        return fqNameUnsafe2 != null ? fqNameUnsafe2.toSafe() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final CallableMemberDescriptor firstOverridden(@NotNull CallableMemberDescriptor $receiver, boolean useOriginal, @NotNull Function1<? super CallableMemberDescriptor, Boolean> predicate) {
        void result2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        return (CallableMemberDescriptor)DFS.dfs((Collection)CollectionsKt.listOf($receiver), new DFS.Neighbors<N>(useOriginal){
            final /* synthetic */ boolean $useOriginal;

            @NotNull
            public final Iterable<CallableMemberDescriptor> getNeighbors(CallableMemberDescriptor current) {
                CallableMemberDescriptor descriptor2;
                Object object;
                CallableMemberDescriptor callableMemberDescriptor;
                if (this.$useOriginal) {
                    CallableMemberDescriptor callableMemberDescriptor2 = current;
                    callableMemberDescriptor = callableMemberDescriptor2 != null ? callableMemberDescriptor2.getOriginal() : null;
                } else {
                    callableMemberDescriptor = current;
                }
                return (object = (descriptor2 = callableMemberDescriptor)) != null && (object = object.getOverriddenDescriptors()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList();
            }
            {
                this.$useOriginal = bl;
            }
        }, new DFS.AbstractNodeHandler<CallableMemberDescriptor, CallableMemberDescriptor>((Ref.ObjectRef)result2, predicate){
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ Function1 $predicate;

            public boolean beforeChildren(@NotNull CallableMemberDescriptor current) {
                Intrinsics.checkParameterIsNotNull(current, "current");
                return (CallableMemberDescriptor)this.$result.element == null;
            }

            public void afterChildren(@NotNull CallableMemberDescriptor current) {
                Intrinsics.checkParameterIsNotNull(current, "current");
                if ((CallableMemberDescriptor)this.$result.element == null && ((Boolean)this.$predicate.invoke(current)).booleanValue()) {
                    this.$result.element = current;
                }
            }

            @Nullable
            public CallableMemberDescriptor result() {
                return (CallableMemberDescriptor)this.$result.element;
            }
            {
                this.$result = $captured_local_variable$0;
                this.$predicate = $captured_local_variable$1;
            }
        });
    }

    @Nullable
    public static /* bridge */ /* synthetic */ CallableMemberDescriptor firstOverridden$default(CallableMemberDescriptor callableMemberDescriptor, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return DescriptorUtilsKt.firstOverridden(callableMemberDescriptor, bl, function1);
    }

    public static final void setSingleOverridden(@NotNull CallableMemberDescriptor $receiver, @NotNull CallableMemberDescriptor overridden) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(overridden, "overridden");
        $receiver.setOverriddenDescriptors((Collection<? extends CallableMemberDescriptor>)CollectionsKt.listOf(overridden));
    }

    @NotNull
    public static final Sequence<CallableMemberDescriptor> overriddenTreeAsSequence(@NotNull CallableMemberDescriptor $receiver, boolean useOriginal) {
        CallableMemberDescriptor callableMemberDescriptor;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        CallableMemberDescriptor $receiver2 = callableMemberDescriptor = useOriginal ? $receiver.getOriginal() : $receiver;
        return SequencesKt.plus(SequencesKt.sequenceOf($receiver2), SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)$receiver2.getOverriddenDescriptors()), (Function1)new Function1<CallableMemberDescriptor, Sequence<? extends CallableMemberDescriptor>>(useOriginal){
            final /* synthetic */ boolean $useOriginal$inlined;
            {
                this.$useOriginal$inlined = bl;
                super(1);
            }

            @NotNull
            public final Sequence<CallableMemberDescriptor> invoke(CallableMemberDescriptor it) {
                return DescriptorUtilsKt.overriddenTreeAsSequence(it, this.$useOriginal$inlined);
            }
        }));
    }

    @NotNull
    public static final <D extends CallableDescriptor> Sequence<D> overriddenTreeUniqueAsSequence(@NotNull D $receiver, boolean useOriginal) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        HashSet set = new HashSet();
        Function1 doBuildOverriddenTreeAsSequence$ = new Function1<D, Sequence<? extends D>>(useOriginal, set){
            final /* synthetic */ boolean $useOriginal;
            final /* synthetic */ HashSet $set;

            @NotNull
            public final Sequence<D> invoke(@NotNull D $receiver) {
                Sequence<Object> sequence2;
                D d;
                D $receiver2;
                Object object;
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                if (this.$useOriginal) {
                    object = $receiver.getOriginal();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type D");
                    }
                } else {
                    object = $receiver;
                }
                if (CollectionsKt.contains(this.$set, ($receiver2 = (d = object)).getOriginal())) {
                    sequence2 = SequencesKt.emptySequence();
                } else {
                    Collection collection = this.$set;
                    CallableDescriptor callableDescriptor = $receiver2.getOriginal();
                    if (callableDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type D");
                    }
                    CallableDescriptor callableDescriptor2 = callableDescriptor;
                    collection.add(callableDescriptor2);
                    Collection<? extends CallableDescriptor> collection2 = $receiver2.getOverriddenDescriptors();
                    if (collection2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Collection<D>");
                    }
                    sequence2 = SequencesKt.plus(SequencesKt.sequenceOf($receiver2), SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)collection2), (Function1)new Function1<D, Sequence<? extends D>>(this){
                        final /* synthetic */ overriddenTreeUniqueAsSequence.1 this$0;
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }

                        @NotNull
                        public final Sequence<D> invoke(@NotNull D it) {
                            return this.this$0.invoke(it);
                        }
                    }));
                }
                return sequence2;
            }
            {
                this.$useOriginal = bl;
                this.$set = hashSet;
                super(1);
            }
        };
        return doBuildOverriddenTreeAsSequence$.invoke($receiver);
    }

    public static final int varargParameterPosition(@NotNull CallableDescriptor $receiver) {
        int n;
        block2: {
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            List<ValueParameterDescriptor> $receiver$iv = $receiver.getValueParameters();
            int index$iv = 0;
            for (ValueParameterDescriptor item$iv : $receiver$iv) {
                ValueParameterDescriptor it = item$iv;
                if (it.getVarargElementType() != null) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    @Nullable
    public static final List<TypeProjection> findImplicitOuterClassArguments(@NotNull ClassDescriptor scopeOwner, @NotNull ClassDescriptor outerClass2) {
        Intrinsics.checkParameterIsNotNull(scopeOwner, "scopeOwner");
        Intrinsics.checkParameterIsNotNull(outerClass2, "outerClass");
        Iterator<ClassDescriptor> iterator2 = DescriptorUtilsKt.classesFromInnerToOuter(scopeOwner).iterator();
        while (iterator2.hasNext()) {
            ClassDescriptor current = iterator2.next();
            for (KotlinType supertype : DescriptorUtilsKt.getAllSuperClassesTypesIncludeItself(current)) {
                ClassifierDescriptor classifierDescriptor = supertype.getConstructor().getDeclarationDescriptor();
                if (classifierDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                }
                ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
                if (!Intrinsics.areEqual(classDescriptor, outerClass2)) continue;
                return supertype.getArguments();
            }
        }
        return null;
    }

    private static final Sequence<ClassDescriptor> classesFromInnerToOuter(@NotNull ClassDescriptor $receiver) {
        return SequencesKt.generateSequence($receiver, (Function1)classesFromInnerToOuter.1.INSTANCE);
    }

    private static final List<KotlinType> getAllSuperClassesTypesIncludeItself(@NotNull ClassDescriptor $receiver) {
        ArrayList<KotlinType> result2 = new ArrayList<KotlinType>();
        SimpleType simpleType2 = $receiver.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "defaultType");
        KotlinType current = simpleType2;
        while (!TypeUtilsKt.isAnyOrNullableAny(current)) {
            result2.add(current);
            ClassifierDescriptor classifierDescriptor = current.getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            KotlinType next = DescriptorUtils.getSuperClassType((ClassDescriptor)classifierDescriptor);
            if (TypeSubstitutor.create(current).substitute(next, Variance.INVARIANT) != null) continue;
            break;
        }
        return result2;
    }

    public static final boolean isEnumValueOfMethod(@NotNull FunctionDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        List<ValueParameterDescriptor> methodTypeParameters = $receiver.getValueParameters();
        KotlinType nullableString = TypeUtilsKt.makeNullable(DescriptorUtilsKt.getBuiltIns($receiver).getStringType());
        return Intrinsics.areEqual(DescriptorUtils.ENUM_VALUE_OF, $receiver.getName()) && methodTypeParameters.size() == 1 && KotlinTypeChecker.DEFAULT.isSubtypeOf(methodTypeParameters.get(0).getType(), nullableString);
    }

    public static final boolean isExtensionProperty(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver instanceof PropertyDescriptor && ((PropertyDescriptor)$receiver).getExtensionReceiverParameter() != null;
    }

    @NotNull
    public static final SmartList<ClassDescriptor> getAllSuperclassesWithoutAny(@NotNull ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return (SmartList)SequencesKt.toCollection(SequencesKt.generateSequence(DescriptorUtilsKt.getSuperClassNotAny($receiver), (Function1)getAllSuperclassesWithoutAny.1.INSTANCE), (Collection)new SmartList());
    }

    @NotNull
    public static final Sequence<ClassifierDescriptor> getAllSuperClassifiers(@NotNull ClassifierDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        HashSet set = new HashSet();
        Function1<ClassifierDescriptor, Sequence<? extends ClassifierDescriptor>> doGetAllSuperClassesAndInterfaces$ = new Function1<ClassifierDescriptor, Sequence<? extends ClassifierDescriptor>>(set){
            final /* synthetic */ HashSet $set;

            @NotNull
            public final Sequence<ClassifierDescriptor> invoke(@NotNull ClassifierDescriptor $receiver) {
                Sequence<ClassifierDescriptor> sequence2;
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                if (this.$set.contains($receiver.getOriginal())) {
                    sequence2 = SequencesKt.emptySequence();
                } else {
                    Collection collection = this.$set;
                    ClassifierDescriptor classifierDescriptor = $receiver.getOriginal();
                    collection.add(classifierDescriptor);
                    sequence2 = SequencesKt.plus(SequencesKt.sequenceOf($receiver.getOriginal()), SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)$receiver.getTypeConstructor().getSupertypes()), (Function1)new Function1<KotlinType, Sequence<? extends ClassifierDescriptor>>(this){
                        final /* synthetic */ getAllSuperClassifiers.1 this$0;

                        @NotNull
                        public final Sequence<ClassifierDescriptor> invoke(KotlinType it) {
                            Object object = it.getConstructor().getDeclarationDescriptor();
                            if (object == null || (object = this.this$0.invoke((ClassifierDescriptor)object)) == null) {
                                object = SequencesKt.sequenceOf(new ClassifierDescriptor[0]);
                            }
                            return object;
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }));
                }
                return sequence2;
            }
            {
                this.$set = hashSet;
                super(1);
            }
        };
        return doGetAllSuperClassesAndInterfaces$.invoke($receiver);
    }

    @NotNull
    public static final Collection<ClassDescriptor> computeSealedSubclasses(@NotNull ClassDescriptor sealedClass) {
        Intrinsics.checkParameterIsNotNull(sealedClass, "sealedClass");
        if (Intrinsics.areEqual((Object)sealedClass.getModality(), (Object)Modality.SEALED) ^ true) {
            return CollectionsKt.emptyList();
        }
        LinkedHashSet result2 = new LinkedHashSet();
        Function2<MemberScope, Boolean, Unit> collectSubclasses$ = new Function2<MemberScope, Boolean, Unit>(sealedClass, result2){
            final /* synthetic */ ClassDescriptor $sealedClass;
            final /* synthetic */ LinkedHashSet $result;

            public final void invoke(@NotNull MemberScope scope, boolean collectNested) {
                Intrinsics.checkParameterIsNotNull(scope, "scope");
                for (DeclarationDescriptor descriptor2 : ResolutionScope.DefaultImpls.getContributedDescriptors$default(scope, DescriptorKindFilter.CLASSIFIERS, null, 2, null)) {
                    if (!(descriptor2 instanceof ClassDescriptor)) continue;
                    if (DescriptorUtils.isDirectSubclass((ClassDescriptor)descriptor2, this.$sealedClass)) {
                        this.$result.add(descriptor2);
                    }
                    if (!collectNested) continue;
                    MemberScope memberScope2 = ((ClassDescriptor)descriptor2).getUnsubstitutedInnerClassesScope();
                    Intrinsics.checkExpressionValueIsNotNull(memberScope2, "descriptor.unsubstitutedInnerClassesScope");
                    this.invoke(memberScope2, collectNested);
                }
            }
            {
                this.$sealedClass = classDescriptor;
                this.$result = linkedHashSet;
                super(2);
            }
        };
        DeclarationDescriptor container2 = sealedClass.getContainingDeclaration();
        if (container2 instanceof PackageFragmentDescriptor) {
            collectSubclasses$.invoke(((PackageFragmentDescriptor)container2).getMemberScope(), false);
        }
        MemberScope memberScope2 = sealedClass.getUnsubstitutedInnerClassesScope();
        Intrinsics.checkExpressionValueIsNotNull(memberScope2, "sealedClass.unsubstitutedInnerClassesScope");
        collectSubclasses$.invoke(memberScope2, true);
        return result2;
    }

    @Nullable
    public static final ClassConstructorDescriptor getNoArgsConstructor(@NotNull ClassDescriptor $receiver) {
        Object v0;
        block1: {
            Iterable iterable;
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Iterable iterable2 = iterable = (Iterable)$receiver.getConstructors();
            for (Object t : iterable2) {
                ClassConstructorDescriptor it = (ClassConstructorDescriptor)t;
                if (!it.getValueParameters().isEmpty()) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ClassConstructorDescriptor> getConstructorForEmptyArgumentsList(@NotNull ClassDescriptor $receiver) {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Iterable iterable = $receiver$iv = (Iterable)$receiver.getConstructors();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            boolean bl;
            block4: {
                ClassConstructorDescriptor it = (ClassConstructorDescriptor)element$iv$iv;
                Iterable $receiver$iv2 = it.getValueParameters();
                if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv2) {
                        ValueParameterDescriptor it2 = (ValueParameterDescriptor)element$iv;
                        if (DescriptorUtilsKt.hasDefaultValue(it2) || it2.getVarargElementType() != null) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    public static final boolean isPublishedApi(@NotNull DeclarationDescriptor $receiver) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver instanceof CallableMemberDescriptor) {
            CallableMemberDescriptor callableMemberDescriptor = DescriptorUtils.getDirectMember((CallableMemberDescriptor)$receiver);
            Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "DescriptorUtils.getDirectMember(this)");
            declarationDescriptor = callableMemberDescriptor;
        } else {
            declarationDescriptor = $receiver;
        }
        DeclarationDescriptor descriptor2 = declarationDescriptor;
        Annotations annotations2 = descriptor2.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.publishedApi;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.FQ_NAMES.publishedApi");
        return annotations2.hasAnnotation(fqName2);
    }

    public static final boolean isAncestorOf(@NotNull DeclarationDescriptor $receiver, @NotNull DeclarationDescriptor descriptor2, boolean strict) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        return DescriptorUtils.isAncestor($receiver, descriptor2, strict);
    }

    public static final boolean isCompanionObject(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return DescriptorUtils.isCompanionObject($receiver);
    }

    public static final boolean isSubclassOf(@NotNull ClassDescriptor $receiver, @NotNull ClassDescriptor superclass) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(superclass, "superclass");
        return DescriptorUtils.isSubclass($receiver, superclass);
    }

    @Nullable
    public static final ClassDescriptor getAnnotationClass(@NotNull AnnotationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassifierDescriptor classifierDescriptor = $receiver.getType().getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        return (ClassDescriptor)classifierDescriptor;
    }

    @Nullable
    public static final Object firstArgumentValue(@NotNull AnnotationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ConstantValue constantValue = (ConstantValue)CollectionsKt.firstOrNull((Iterable)$receiver.getAllValueArguments().values());
        return constantValue != null ? constantValue.getValue() : null;
    }

    public static final boolean isEffectivelyExternal(@NotNull MemberDescriptor $receiver) {
        ClassDescriptor containingClass;
        block3: {
            block4: {
                PropertyDescriptor variableDescriptor;
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                if ($receiver.isExternal()) {
                    return true;
                }
                if ($receiver instanceof PropertyAccessorDescriptor && DescriptorUtilsKt.isEffectivelyExternal(variableDescriptor = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty())) {
                    return true;
                }
                if (!($receiver instanceof PropertyDescriptor)) break block3;
                PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)$receiver).getGetter();
                if (propertyGetterDescriptor == null) break block3;
                if (!propertyGetterDescriptor.isExternal()) break block3;
                if (!((PropertyDescriptor)$receiver).isVar()) break block4;
                PropertySetterDescriptor propertySetterDescriptor = ((PropertyDescriptor)$receiver).getSetter();
                if (propertySetterDescriptor == null) break block3;
                if (!propertySetterDescriptor.isExternal()) break block3;
            }
            return true;
        }
        return (containingClass = DescriptorUtils.getContainingClass($receiver)) != null && DescriptorUtilsKt.isEffectivelyExternal(containingClass);
    }
}

