/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFileReference
extends FileReference
implements JSModuleBaseReference {
    public static final String[] IMPLICIT_EXTENSIONS = new String[]{".coffee", ".d.ts", ".d.tsx", ".ts", ".tsx", ".jsx", ".es6", ".js.flow", ".js", ".json", ".node", ".vue"};
    private final String[] myImplicitExtensions;

    public JSFileReference(String text, int offset, TextRange textRange, @NotNull FileReferenceSet fileReferenceSet) {
        if (fileReferenceSet == null) {
            JSFileReference.$$$reportNull$$$0(0);
        }
        this(text, offset, textRange, fileReferenceSet, IMPLICIT_EXTENSIONS);
    }

    public JSFileReference(String text, int offset, TextRange textRange, @NotNull FileReferenceSet fileReferenceSet, String[] implicitExtensions) {
        if (fileReferenceSet == null) {
            JSFileReference.$$$reportNull$$$0(1);
        }
        super(fileReferenceSet, textRange, offset, text);
        this.myImplicitExtensions = JSFileReference.withCurrentFileExtension(implicitExtensions, fileReferenceSet.getElement());
    }

    protected void innerResolveInContext(@NotNull String referenceText, @NotNull PsiFileSystemItem context, Collection<ResolveResult> results, boolean caseSensitive) {
        if (referenceText == null) {
            JSFileReference.$$$reportNull$$$0(2);
        }
        if (context == null) {
            JSFileReference.$$$reportNull$$$0(3);
        }
        if (!this.isLast()) {
            this.simpleInnerResolveInContext(referenceText, context, results, caseSensitive);
            return;
        }
        if (this.isAcceptableEmptyReference(referenceText)) {
            if (this.isAllowFolders()) {
                this.simpleInnerResolveInContext(referenceText, context, results, caseSensitive);
            }
            return;
        }
        int size = results.size();
        for (String extension : this.getImplicitExtensions()) {
            if (referenceText.endsWith(extension)) continue;
            this.simpleInnerResolveInContext(referenceText + extension, context, results, caseSensitive);
            if (size != results.size()) {
                this.filterImplicitElementsResolveInContext(referenceText, context, results, caseSensitive);
            }
            if (size != results.size() && this.shouldStopImplicitExtensionProcessing(extension)) break;
        }
        if (size == results.size()) {
            List candidates = ContainerUtil.newSmartList();
            this.simpleInnerResolveInContext(referenceText, context, candidates, caseSensitive);
            if (!candidates.isEmpty()) {
                this.processDefaultResolveElements(candidates, results);
            }
        }
    }

    protected boolean shouldStopImplicitExtensionProcessing(@NotNull String currentExtension) {
        if (currentExtension == null) {
            JSFileReference.$$$reportNull$$$0(4);
        }
        return true;
    }

    protected boolean isAcceptableEmptyReference(@NotNull String referenceText) {
        if (referenceText == null) {
            JSFileReference.$$$reportNull$$$0(5);
        }
        return referenceText.isEmpty() && !this.getFileReferenceSet().isEndingSlashNotAllowed();
    }

    protected final void simpleInnerResolveInContext(@NotNull String referenceText, @NotNull PsiFileSystemItem context, Collection<ResolveResult> results, boolean caseSensitive) {
        if (referenceText == null) {
            JSFileReference.$$$reportNull$$$0(6);
        }
        if (context == null) {
            JSFileReference.$$$reportNull$$$0(7);
        }
        super.innerResolveInContext(referenceText, context, results, caseSensitive);
    }

    protected void filterImplicitElementsResolveInContext(String text, PsiFileSystemItem context, Collection<ResolveResult> results, boolean sensitive) {
    }

    protected String[] getImplicitExtensions() {
        return this.myImplicitExtensions;
    }

    protected final void processDefaultResolveElements(@NotNull Collection<ResolveResult> candidates, @NotNull Collection<ResolveResult> results) {
        if (candidates == null) {
            JSFileReference.$$$reportNull$$$0(8);
        }
        if (results == null) {
            JSFileReference.$$$reportNull$$$0(9);
        }
        for (ResolveResult candidate : candidates) {
            boolean hasNewElements;
            PsiElement element = candidate.getElement();
            if (!(element instanceof PsiFileSystemItem) || !((PsiFileSystemItem)element).isDirectory()) {
                results.add(candidate);
                continue;
            }
            Collection<ResolveResult> resolvedDirectoryElements = this.resolveDirectory((PsiFileSystemItem)element);
            boolean bl = hasNewElements = !resolvedDirectoryElements.isEmpty();
            if (hasNewElements) {
                results.addAll(resolvedDirectoryElements);
            }
            if (!this.isAllowFolders() || hasNewElements) continue;
            results.add(candidate);
        }
    }

    @NotNull
    protected Collection<ResolveResult> resolveDirectory(@NotNull PsiFileSystemItem directory) {
        if (directory == null) {
            JSFileReference.$$$reportNull$$$0(10);
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            JSFileReference.$$$reportNull$$$0(11);
        }
        return list;
    }

    protected boolean isAllowFolders() {
        return false;
    }

    @NotNull
    public String getFileNameToCreate() {
        VirtualFile vFile;
        PsiFile psiFile;
        String text = this.getText();
        if (!StringUtil.containsChar((String)text, (char)'.') && this.isLast() && (psiFile = this.getElement().getContainingFile()) != null && (vFile = psiFile.getVirtualFile()) != null) {
            String string = text + "." + vFile.getExtension();
            if (string == null) {
                JSFileReference.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = super.getFileNameToCreate();
        if (string == null) {
            JSFileReference.$$$reportNull$$$0(13);
        }
        return string;
    }

    protected PsiElement rename(String newName) throws IncorrectOperationException {
        if (!this.isLast()) {
            newName = this.fixRelativePath(newName);
            return super.rename(newName);
        }
        newName = this.fixExtension(newName);
        newName = this.fixRelativePath(newName);
        return super.rename(newName);
    }

    private String fixRelativePath(String newName) {
        FileReference reference;
        String refText;
        if (!this.getFileReferenceSet().isAbsolutePathReference() && (".".equals(refText = (reference = this.getFileReferenceSet().getReference(0)).getText()) || refText != null && refText.startsWith("..")) && !newName.startsWith("..")) {
            newName = "./" + newName;
        }
        return newName;
    }

    protected String fixExtension(String newName) {
        return this.fixExtension(newName, this.getText());
    }

    protected String fixExtension(String newName, String oldRefText) {
        String[] extensions = this.getSortedByLengthImplicitExtensions();
        String newImplicitExtension = JSFileReference.findExtension(newName, extensions);
        String textImplicitExtension = JSFileReference.findExtension(oldRefText, extensions);
        if (newImplicitExtension != null && textImplicitExtension == null || oldRefText.indexOf(46) == -1) {
            int indexNameWithoutExtension;
            int n = indexNameWithoutExtension = newImplicitExtension != null ? newName.length() - newImplicitExtension.length() : newName.lastIndexOf(46);
            if (indexNameWithoutExtension != -1) {
                int lastIndexOfSeparator = newImplicitExtension != null ? -1 : newName.lastIndexOf(47);
                newName = indexNameWithoutExtension > lastIndexOfSeparator ? newName.substring(0, indexNameWithoutExtension) : newName;
            }
        }
        return newName;
    }

    @NotNull
    protected String[] getSortedByLengthImplicitExtensions() {
        String[] extensions = this.getImplicitExtensions();
        Arrays.sort(extensions, Comparator.comparing(String::length).reversed());
        if (extensions == null) {
            JSFileReference.$$$reportNull$$$0(14);
        }
        return extensions;
    }

    protected PsiElement fixRefText(String name) {
        return super.fixRefText(this.fixExtension(name));
    }

    public PsiElement bindToElement(@NotNull PsiElement element, boolean absolute) throws IncorrectOperationException {
        String path;
        if (element == null) {
            JSFileReference.$$$reportNull$$$0(15);
        }
        if (!this.isRelativeCommonPath() && JSFileReference.checkReferencedFileFromNodeModules(element)) {
            return this.getElement();
        }
        if ((!this.isRelativeCommonPath() || absolute) && (path = JSFileReference.getPathFromDefaultContext(this.getFileReferenceSet(), element, absolute)) != null) {
            return this.rename(path);
        }
        return super.bindToElement(element, absolute);
    }

    protected static String getPathFromDefaultContext(@NotNull FileReferenceSet referenceSet, @NotNull PsiElement element, boolean absolute) {
        Collection filteredContexts;
        VirtualFile dstVFile;
        String path;
        Collection<PsiFileSystemItem> defaultContexts;
        if (referenceSet == null) {
            JSFileReference.$$$reportNull$$$0(16);
        }
        if (element == null) {
            JSFileReference.$$$reportNull$$$0(17);
        }
        if ((defaultContexts = JSFileReference.getDefaultResolveContextsForBind(referenceSet, element)).size() > 0 && (path = JSFileReferencesUtil.getShortestPathInContexts(dstVFile = element instanceof PsiFileSystemItem ? ((PsiFileSystemItem)element).getVirtualFile() : null, filteredContexts = (Collection)defaultContexts.stream().map(el -> el.getVirtualFile()).collect(Collectors.toList()), true)) != null) {
            return absolute && referenceSet.absoluteUrlNeedsStartSlash() && !path.startsWith("/") ? "/" + path : path;
        }
        return null;
    }

    @NotNull
    protected static Collection<PsiFileSystemItem> getDefaultResolveContextsForBind(@NotNull FileReferenceSet referenceSet, @NotNull PsiElement element) {
        if (referenceSet == null) {
            JSFileReference.$$$reportNull$$$0(18);
        }
        if (element == null) {
            JSFileReference.$$$reportNull$$$0(19);
        }
        Collection allDefaultContexts = referenceSet.getDefaultContexts();
        FileReference firstRef = referenceSet.getReference(0);
        PsiFileSystemItem resolvedFirstRef = firstRef.resolve();
        if (resolvedFirstRef != null && resolvedFirstRef != element) {
            PsiFileSystemItem contextDir = resolvedFirstRef.getParent();
            List list = allDefaultContexts.contains(contextDir) ? ContainerUtil.createMaybeSingletonList((Object)contextDir) : ContainerUtil.emptyList();
            if (list == null) {
                JSFileReference.$$$reportNull$$$0(20);
            }
            return list;
        }
        LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet((Iterable)allDefaultContexts);
        if (linkedHashSet == null) {
            JSFileReference.$$$reportNull$$$0(21);
        }
        return linkedHashSet;
    }

    private boolean isRelativeCommonPath() {
        String path = this.getFileReferenceSet().getPathString();
        return path.startsWith(".");
    }

    private static boolean checkReferencedFileFromNodeModules(@NotNull PsiElement element) {
        VirtualFile file;
        if (element == null) {
            JSFileReference.$$$reportNull$$$0(22);
        }
        return (file = PsiUtilCore.getVirtualFile((PsiElement)element)) != null && JSLibraryUtil.hasDirectoryInPath(file, "node_modules", null);
    }

    @Contract(value="null, _ -> null")
    public static String findExtension(@Nullable String fileName, String[] extensions) {
        if (fileName == null) {
            return null;
        }
        for (String extension : extensions) {
            if (!StringUtil.endsWithIgnoreCase((String)fileName, (String)extension)) continue;
            return extension;
        }
        return null;
    }

    @Contract(value="!null,_ -> !null")
    public static String getFileNameWithoutExtension(@Nullable String fileName, String[] extensions) {
        if (fileName == null) {
            return null;
        }
        String extension = JSFileReference.findExtension(fileName, extensions);
        return extension != null ? fileName.substring(0, fileName.length() - extension.length()) : FileUtilRt.getNameWithoutExtension((String)fileName);
    }

    @Contract(value="null -> null")
    public static String findImplicitExtension(@Nullable String fileName) {
        return JSFileReference.findExtension(fileName, IMPLICIT_EXTENSIONS);
    }

    public static String[] withCurrentFileExtension(String[] implicitExtensions, PsiElement element) {
        String extension = FileUtilRt.getExtension((String)element.getContainingFile().getName());
        return !StringUtil.isEmpty((String)extension) && !ArrayUtil.contains((Object)implicitExtensions, (Object[])new Serializable[]{extension}) ? (String[])ArrayUtil.append((Object[])implicitExtensions, (Object)("." + extension)) : implicitExtensions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileReferenceSet";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentExtension";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/JSFileReference";
                break;
            }
            case 15: 
            case 17: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/JSFileReference";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDirectory";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNameToCreate";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedByLengthImplicitExtensions";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultResolveContextsForBind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "innerResolveInContext";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldStopImplicitExtensionProcessing";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableEmptyReference";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "simpleInnerResolveInContext";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processDefaultResolveElements";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveDirectory";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPathFromDefaultContext";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultResolveContextsForBind";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkReferencedFileFromNodeModules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

