/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.testframework.sm.SMCustomMessagesParsing;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.HelperFilesLocator;
import com.intellij.javascript.jest.JestConfig;
import com.intellij.javascript.jest.JestRunConfiguration;
import com.intellij.javascript.jest.JestRunSettings;
import com.intellij.javascript.jest.JestUtil;
import com.intellij.javascript.jest.scope.JestScopeKind;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.debug.NodeLocalDebugRunProfileState;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.testFramework.navigation.JSTestLocationProvider;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JestRunState
implements RunProfileState,
NodeLocalDebugRunProfileState {
    private static final String FRAMEWORK_NAME = "JestJavaScriptTestRunner";
    private static final String INTELLIJ_JEST_JASMINE_REPORTER = "jest-intellij/lib/jest-intellij-jasmine.js";
    private static final String CONFIG_SETUP_TEST_FRAMEWORK_SCRIPT_FILE = "_JEST_SETUP_TEST_FRAMEWORK_SCRIPT_FILE_OVERWRITTEN_BY_INTELLIJ";
    private static final String TEST_RUN_FROM_SINGLE_TEST_FILE = "_INTELLIJ_JEST_TEST_RUN_FROM_SINGLE_TEST_FILE";
    private static final String JEST_CONFIG_ROOT_DIR = "_INTELLIJ_JEST_CONFIG_ROOT_DIR";
    private static volatile File TEMP_INPUT_FILE;
    private final Project myProject;
    private final JestRunConfiguration myRunConfiguration;
    private final ExecutionEnvironment myEnvironment;
    private final NodePackage myJestPackage;
    private final JestRunSettings myRunSettings;

    public JestRunState(@NotNull JestRunConfiguration runConfiguration, @NotNull ExecutionEnvironment environment, @NotNull NodePackage jestPackage) {
        if (runConfiguration == null) {
            JestRunState.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            JestRunState.$$$reportNull$$$0(1);
        }
        if (jestPackage == null) {
            JestRunState.$$$reportNull$$$0(2);
        }
        this.myProject = runConfiguration.getProject();
        this.myRunConfiguration = runConfiguration;
        this.myEnvironment = environment;
        this.myJestPackage = jestPackage;
        this.myRunSettings = runConfiguration.getRunSettings();
    }

    @Override
    @NotNull
    public ExecutionResult execute(int debugPort) throws ExecutionException {
        NodeJsLocalInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolveAsLocal(this.myProject);
        GeneralCommandLine commandLine = this.createCommandLine(interpreter, debugPort);
        OSProcessHandler processHandler = NodeCommandLineUtil.createProcessHandler(commandLine, false);
        ConsoleView consoleView = this.createSmtRunnerConsoleView(commandLine.getWorkDirectory());
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        consoleView.attachToProcess((ProcessHandler)processHandler);
        this.foldCommandLine(consoleView, (ProcessHandler)processHandler);
        DefaultExecutionResult executionResult = new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)processHandler);
        executionResult.setRestartActions(new AnAction[]{new ToggleAutoTestAction()});
        DefaultExecutionResult defaultExecutionResult = executionResult;
        if (defaultExecutionResult == null) {
            JestRunState.$$$reportNull$$$0(3);
        }
        return defaultExecutionResult;
    }

    @NotNull
    private GeneralCommandLine createCommandLine(@NotNull NodeJsLocalInterpreter interpreter, int debugPort) throws ExecutionException {
        if (interpreter == null) {
            JestRunState.$$$reportNull$$$0(4);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(){

            @NotNull
            protected Process startProcess(@NotNull List<String> commands) throws IOException {
                if (commands == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProcessBuilder builder = new ProcessBuilder(commands);
                this.setupEnvironment(builder.environment());
                builder.directory(this.getWorkDirectory());
                builder.redirectErrorStream(this.isRedirectErrorStream());
                if (SystemInfo.isWindows) {
                    File input = TEMP_INPUT_FILE;
                    if (input == null || !input.isFile()) {
                        input = FileUtil.createTempFile((String)"intellij-jest-empty-input", null, (boolean)true);
                        TEMP_INPUT_FILE = input;
                    }
                    builder.redirectInput(ProcessBuilder.Redirect.from(input));
                }
                Process process = builder.start();
                if (process == null) {
                    1.$$$reportNull$$$0(1);
                }
                return process;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "commands";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/jest/JestRunState$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/jest/JestRunState$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "startProcess";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "startProcess";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        commandLine.setRedirectErrorStream(true);
        commandLine.setCharset(StandardCharsets.UTF_8);
        String workingDir = this.myRunSettings.getWorkingDirSystemDependentPath();
        if (!workingDir.isEmpty()) {
            commandLine.setWorkDirectory(workingDir);
        }
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        if (debugPort > -1) {
            boolean preferInspectorProtocol = Registry.is((String)"jest.debugger.use.inspect", (boolean)false);
            if (!preferInspectorProtocol) {
                SemVer version = (SemVer)interpreter.provideCachedVersionOrFetch().blockingGet(1500, TimeUnit.MILLISECONDS);
                preferInspectorProtocol = version != null && version.getMajor() >= 8;
            }
            NodeCommandLineUtil.addNodeOptionsForDebugging(commandLine, Collections.emptyList(), debugPort, true, interpreter, preferInspectorProtocol);
        }
        commandLine.addParameter(JestUtil.getJestMainJsFile(this.myJestPackage).getAbsolutePath());
        JestConfig config2 = JestConfig.create(this.myRunSettings.getConfigFileSystemDependentPath(), this.myRunSettings.getWorkingDirSystemDependentPath());
        this.configureEnvironment(commandLine, config2);
        if (JestUtil.isReactScriptsFamilyPackage(this.myJestPackage)) {
            commandLine.getEnvironment().put("CI", "1");
        } else {
            commandLine.addParameters(new String[]{"--config"});
            commandLine.addParameter(config2.stringifyConfig());
        }
        if (StringUtil.isNotEmpty((String)this.myRunSettings.getJestOptions())) {
            commandLine.addParameters(ParametersList.parse((String)this.myRunSettings.getJestOptions()));
        }
        if (debugPort != -1) {
            commandLine.addParameter("--runInBand");
        }
        commandLine.addParameter("--colors");
        commandLine.addParameter("--setupTestFrameworkScriptFile");
        commandLine.addParameter(HelperFilesLocator.resolvePathForExecution(INTELLIJ_JEST_JASMINE_REPORTER));
        JestScopeKind scopeKind = this.myRunSettings.getScopeKind();
        if (scopeKind == JestScopeKind.TEST_FILE || scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            commandLine.addParameter("--testPathPattern");
            commandLine.addParameter("^" + JestUtil.escapeJavaScriptRegex(this.myRunSettings.getTestFileSystemDependentPath(), "") + "$");
        }
        if (scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            commandLine.addParameter("--testNamePattern");
            if (scopeKind == JestScopeKind.SUITE) {
                commandLine.addParameter("^" + this.formatTestNameEscapedRegex() + " ");
            } else {
                String topLevelSuiteRegex = this.myRunSettings.getTestNames().size() == 1 ? "(test )?" : "";
                commandLine.addParameter("^" + topLevelSuiteRegex + this.formatTestNameEscapedRegex() + "$");
            }
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            JestRunState.$$$reportNull$$$0(5);
        }
        return generalCommandLine;
    }

    @NotNull
    private String formatTestNameEscapedRegex() {
        String string = JestUtil.escapeJavaScriptRegex(StringUtil.join(this.myRunSettings.getTestNames(), (String)" "), "");
        if (string == null) {
            JestRunState.$$$reportNull$$$0(6);
        }
        return string;
    }

    private void configureEnvironment(@NotNull GeneralCommandLine commandLine, @NotNull JestConfig config2) {
        JestScopeKind scopeKind;
        if (commandLine == null) {
            JestRunState.$$$reportNull$$$0(7);
        }
        if (config2 == null) {
            JestRunState.$$$reportNull$$$0(8);
        }
        this.myRunSettings.getEnvData().configureCommandLine(commandLine, true);
        NodeCommandLineUtil.configureUsefulEnvironment(commandLine);
        String configSetupTestFrameworkScriptFile = config2.getSetupTestFrameworkScriptFile();
        if (configSetupTestFrameworkScriptFile != null) {
            commandLine.getEnvironment().put(CONFIG_SETUP_TEST_FRAMEWORK_SCRIPT_FILE, configSetupTestFrameworkScriptFile);
        } else {
            File file;
            String setupFilePath = JestUtil.getPredefinedSetupTestsFilePath(this.myJestPackage);
            if (setupFilePath != null && (file = new File(this.myRunSettings.getWorkingDirSystemDependentPath(), setupFilePath)).isFile()) {
                commandLine.getEnvironment().put(CONFIG_SETUP_TEST_FRAMEWORK_SCRIPT_FILE, file.getAbsolutePath());
            }
        }
        String rootDir = config2.getRootDir();
        if (rootDir != null) {
            commandLine.getEnvironment().put(JEST_CONFIG_ROOT_DIR, rootDir);
        }
        if ((scopeKind = this.myRunSettings.getScopeKind()) == JestScopeKind.TEST_FILE || scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            commandLine.getEnvironment().put(TEST_RUN_FROM_SINGLE_TEST_FILE, Boolean.TRUE.toString());
        }
    }

    @NotNull
    private ConsoleView createSmtRunnerConsoleView(@Nullable File workingDirectory) {
        JestConsoleProperties testConsoleProperties = new JestConsoleProperties(this.myRunConfiguration, this.myEnvironment.getExecutor(), (SMTestLocator)new JSTestLocationProvider(true));
        BaseTestsOutputConsoleView consoleView = SMTestRunnerConnectionUtil.createConsole((String)FRAMEWORK_NAME, (TestConsoleProperties)testConsoleProperties);
        consoleView.addMessageFilter((Filter)new NodeStackTraceFilter(this.myProject, workingDirectory));
        consoleView.addMessageFilter((Filter)new NodeConsoleAdditionalFilter(this.myProject, workingDirectory));
        Disposer.register((Disposable)this.myProject, (Disposable)consoleView);
        BaseTestsOutputConsoleView baseTestsOutputConsoleView = consoleView;
        if (baseTestsOutputConsoleView == null) {
            JestRunState.$$$reportNull$$$0(9);
        }
        return baseTestsOutputConsoleView;
    }

    @Override
    public void foldCommandLine(@NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        if (consoleView == null) {
            JestRunState.$$$reportNull$$$0(10);
        }
        if (processHandler == null) {
            JestRunState.$$$reportNull$$$0(11);
        }
        ArrayList commands = ContainerUtil.newArrayList((Object[])new String[]{"jest"});
        String configFileName = PathUtil.getFileName((String)this.myRunSettings.getConfigFileSystemDependentPath());
        if (!configFileName.isEmpty()) {
            commands.add("--config");
            commands.add(configFileName);
        }
        JsbtUtil.foldCommandLine(consoleView, processHandler, ParametersListUtil.join((List)commands));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jestPackage";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/jest/JestRunState";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/jest/JestRunState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTestNameEscapedRegex";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createSmtRunnerConsoleView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configureEnvironment";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "foldCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class JestOutputToGeneralTestEventsConverter
    extends OutputToGeneralTestEventsConverter {
        public JestOutputToGeneralTestEventsConverter(@NotNull String testFrameworkName, boolean stdinEnabled) {
            if (testFrameworkName == null) {
                JestOutputToGeneralTestEventsConverter.$$$reportNull$$$0(0);
            }
            super(testFrameworkName, stdinEnabled);
        }

        protected void processConsistentText(String text, Key outputType, boolean tcLikeFakeOutput) {
            int ind = text.indexOf("##teamcity[");
            if (ind > 0) {
                super.processConsistentText(text.substring(0, ind), outputType, false);
                super.processConsistentText(text.substring(ind), outputType, false);
            } else {
                super.processConsistentText(text, outputType, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "com/intellij/javascript/jest/JestRunState$JestOutputToGeneralTestEventsConverter", "<init>"));
        }
    }

    private static class JestConsoleProperties
    extends SMTRunnerConsoleProperties
    implements SMCustomMessagesParsing {
        private final SMTestLocator myLocator;

        public JestConsoleProperties(@NotNull JestRunConfiguration configuration, @NotNull Executor executor, @NotNull SMTestLocator locator) {
            if (configuration == null) {
                JestConsoleProperties.$$$reportNull$$$0(0);
            }
            if (executor == null) {
                JestConsoleProperties.$$$reportNull$$$0(1);
            }
            if (locator == null) {
                JestConsoleProperties.$$$reportNull$$$0(2);
            }
            super((RunConfiguration)configuration, JestRunState.FRAMEWORK_NAME, executor);
            this.myLocator = locator;
            this.setUsePredefinedMessageFilter(false);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.HIDE_PASSED_TESTS, false);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.HIDE_IGNORED_TEST, true);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.SCROLL_TO_SOURCE, true);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.SELECT_FIRST_DEFECT, true);
            this.setIdBasedTestTree(true);
            this.setPrintTestingStartedTime(false);
        }

        public SMTestLocator getTestLocator() {
            return this.myLocator;
        }

        public JestOutputToGeneralTestEventsConverter createTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
            if (testFrameworkName == null) {
                JestConsoleProperties.$$$reportNull$$$0(3);
            }
            if (consoleProperties == null) {
                JestConsoleProperties.$$$reportNull$$$0(4);
            }
            return new JestOutputToGeneralTestEventsConverter(testFrameworkName, consoleProperties.isEditable());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "locator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testFrameworkName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consoleProperties";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/jest/JestRunState$JestConsoleProperties";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createTestEventsConverter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

