/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.jest.JestPkgInfo;
import com.intellij.javascript.jest.JestRunConfiguration;
import com.intellij.javascript.jest.JestRunSettings;
import com.intellij.javascript.jest.scope.JestScopeKind;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JestUtil {
    private static final String PACKAGE_NAME = "jest";
    private static Map<String, JestPkgInfo> PKG_INFO_MAP = ContainerUtil.newLinkedHashMap((Pair)Pair.create((Object)"react-scripts-ts", (Object)new JestPkgInfo("scripts/test.js", "src/setupTests.ts", true)), (Pair[])new Pair[]{Pair.create((Object)"react-super-scripts", (Object)new JestPkgInfo("scripts/test.js", "src/setupTests.js", true)), Pair.create((Object)"react-awesome-scripts", (Object)new JestPkgInfo("scripts/test.js", "src/setupTests.js", true)), Pair.create((Object)"react-scripts", (Object)new JestPkgInfo("./bin/react-scripts.js", "src/setupTests.js", true)), Pair.create((Object)"jest", (Object)new JestPkgInfo("./bin/jest.js", null, false)), Pair.create((Object)"jest-cli", (Object)new JestPkgInfo("./bin/jest.js", null, false))});
    public static final NodePackageDescriptor PKG_DESCRIPTOR = new NodePackageDescriptor(new ArrayList<String>(PKG_INFO_MAP.keySet()));
    private static final String KEY__JEST_PACKAGE_DIR = "nodejs.jest.jest_package";
    private static final String TAG__CONFIG_FILE = "config-file";
    private static final String TAG__NODE_INTERPRETER = "node-interpreter";
    private static final String TAG__WORKING_DIR = "working-dir";
    private static final String TAG__JEST_OPTIONS = "jest-options";
    private static final String TAG__SCOPE_KIND = "scope-kind";
    private static final String TAG__TEST_FILE = "test-file";
    private static final String TAG__TEST_NAMES = "test-names";
    private static final String TAG__TEST_NAME = "test-name";

    private JestUtil() {
    }

    @NotNull
    public static JestRunSettings readXml(@NotNull Element element) {
        if (element == null) {
            JestUtil.$$$reportNull$$$0(0);
        }
        JestRunSettings.Builder builder = JestRunSettings.builder();
        builder.setConfigFilePath(JestUtil.readValue(element, TAG__CONFIG_FILE));
        String interpreterRefName = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)element, (String)TAG__NODE_INTERPRETER);
        builder.setInterpreterRef(interpreterRefName == null ? NodeJsInterpreterRef.createProjectRef() : NodeJsInterpreterRef.create(interpreterRefName));
        builder.setWorkingDir(JestUtil.readValue(element, TAG__WORKING_DIR));
        builder.setJestOptions(JestUtil.readValue(element, TAG__JEST_OPTIONS));
        builder.setEnvData(EnvironmentVariablesData.readExternal((Element)element));
        JestScopeKind scopeKind = JestUtil.readScopeKind(element);
        builder.setScopeKind(scopeKind);
        if (scopeKind == JestScopeKind.TEST_FILE || scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            builder.setTestFilePath(JestUtil.readValue(element, TAG__TEST_FILE));
        }
        if (scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            builder.setTestNames(JestUtil.readTestNames(element));
        }
        JestRunSettings jestRunSettings = builder.build();
        if (jestRunSettings == null) {
            JestUtil.$$$reportNull$$$0(1);
        }
        return jestRunSettings;
    }

    @NotNull
    private static JestScopeKind readScopeKind(@NotNull Element element) {
        JestScopeKind jestScopeKind;
        if (element == null) {
            JestUtil.$$$reportNull$$$0(2);
        }
        String scopeKindStr = JestUtil.readValue(element, TAG__SCOPE_KIND);
        try {
            jestScopeKind = JestScopeKind.valueOf(scopeKindStr);
        }
        catch (Exception ignored) {
            JestScopeKind jestScopeKind2 = JestScopeKind.ALL;
            if (jestScopeKind2 == null) {
                JestUtil.$$$reportNull$$$0(4);
            }
            return jestScopeKind2;
        }
        if (jestScopeKind == null) {
            JestUtil.$$$reportNull$$$0(3);
        }
        return jestScopeKind;
    }

    @NotNull
    private static String readValue(@NotNull Element element, @NotNull String key) {
        if (element == null) {
            JestUtil.$$$reportNull$$$0(5);
        }
        if (key == null) {
            JestUtil.$$$reportNull$$$0(6);
        }
        String string = StringUtil.notNullize((String)JDOMExternalizerUtil.getFirstChildValueAttribute((Element)element, (String)key));
        if (string == null) {
            JestUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static List<String> readTestNames(@NotNull Element parent) {
        Element testNamesElement;
        if (parent == null) {
            JestUtil.$$$reportNull$$$0(8);
        }
        if ((testNamesElement = parent.getChild(TAG__TEST_NAMES)) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                JestUtil.$$$reportNull$$$0(9);
            }
            return list;
        }
        List list = JDOMExternalizerUtil.getChildrenValueAttributes((Element)testNamesElement, (String)TAG__TEST_NAME);
        if (list == null) {
            JestUtil.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static void writeValue(@NotNull Element element, @NotNull String tagName, @Nullable String value) {
        if (element == null) {
            JestUtil.$$$reportNull$$$0(11);
        }
        if (tagName == null) {
            JestUtil.$$$reportNull$$$0(12);
        }
        if (value != null) {
            JDOMExternalizerUtil.addElementWithValueAttribute((Element)element, (String)tagName, (String)value);
        }
    }

    public static void writeXml(@NotNull Element element, @NotNull JestRunSettings settings) {
        if (element == null) {
            JestUtil.$$$reportNull$$$0(13);
        }
        if (settings == null) {
            JestUtil.$$$reportNull$$$0(14);
        }
        if (!StringUtil.isEmptyOrSpaces((String)settings.getConfigFileSystemDependentPath())) {
            JestUtil.writeValue(element, TAG__CONFIG_FILE, FileUtil.toSystemIndependentName((String)settings.getConfigFileSystemDependentPath()));
        }
        JestUtil.writeValue(element, TAG__NODE_INTERPRETER, settings.getInterpreterRef().getReferenceName());
        JestUtil.writeValue(element, TAG__WORKING_DIR, FileUtil.toSystemIndependentName((String)settings.getWorkingDirSystemDependentPath()));
        if (StringUtil.isNotEmpty((String)settings.getJestOptions())) {
            JestUtil.writeValue(element, TAG__JEST_OPTIONS, settings.getJestOptions());
        }
        settings.getEnvData().writeExternal(element);
        JestScopeKind scopeKind = settings.getScopeKind();
        JestUtil.writeValue(element, TAG__SCOPE_KIND, scopeKind.name());
        if (scopeKind == JestScopeKind.TEST_FILE || scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            JestUtil.writeValue(element, TAG__TEST_FILE, FileUtil.toSystemIndependentName((String)settings.getTestFileSystemDependentPath()));
        }
        if (scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            Element testNamesElement = new Element(TAG__TEST_NAMES);
            if (!settings.getTestNames().isEmpty()) {
                JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)testNamesElement, (String)TAG__TEST_NAME, settings.getTestNames());
            }
            element.addContent(testNamesElement);
        }
    }

    @NotNull
    public static List<VirtualFile> listPossibleConfigFilesInProject(@NotNull Project project) {
        if (project == null) {
            JestUtil.$$$reportNull$$$0(15);
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            JestUtil.$$$reportNull$$$0(16);
        }
        return list;
    }

    public static boolean isJestConfigFile(@NotNull CharSequence sequence) {
        if (sequence == null) {
            JestUtil.$$$reportNull$$$0(17);
        }
        return StringUtil.equals((CharSequence)"jest.conf.json", (CharSequence)sequence) || StringUtil.equals((CharSequence)"jest.config", (CharSequence)sequence);
    }

    @NotNull
    public static NodePackage getJestPackage(@NotNull Project project, @Nullable NodeJsInterpreter interpreter) {
        NodePackage pkg;
        String packagePath;
        if (project == null) {
            JestUtil.$$$reportNull$$$0(18);
        }
        if ((packagePath = JestUtil.getPackagePath(project)) == null && !(pkg = PKG_DESCRIPTOR.findFirstDirectDependencyPackage(project, interpreter, null)).getSystemIndependentPath().isEmpty()) {
            JestUtil.setPackagePath(project, pkg.getSystemIndependentPath());
            NodePackage nodePackage = pkg;
            if (nodePackage == null) {
                JestUtil.$$$reportNull$$$0(19);
            }
            return nodePackage;
        }
        NodePackage nodePackage = new NodePackage(StringUtil.notNullize((String)packagePath));
        if (nodePackage == null) {
            JestUtil.$$$reportNull$$$0(20);
        }
        return nodePackage;
    }

    public static void setJestPackage(@NotNull Project project, @NotNull NodePackage jestPackage) {
        if (project == null) {
            JestUtil.$$$reportNull$$$0(21);
        }
        if (jestPackage == null) {
            JestUtil.$$$reportNull$$$0(22);
        }
        JestUtil.setPackagePath(project, jestPackage.getSystemIndependentPath());
    }

    private static void setPackagePath(@NotNull Project project, @NotNull String value) {
        if (project == null) {
            JestUtil.$$$reportNull$$$0(23);
        }
        if (value == null) {
            JestUtil.$$$reportNull$$$0(24);
        }
        PropertiesComponent.getInstance((Project)project).setValue(KEY__JEST_PACKAGE_DIR, value);
    }

    @Nullable
    private static String getPackagePath(@NotNull Project project) {
        if (project == null) {
            JestUtil.$$$reportNull$$$0(25);
        }
        return PropertiesComponent.getInstance((Project)project).getValue(KEY__JEST_PACKAGE_DIR);
    }

    @NotNull
    public static File getJestMainJsFile(@NotNull NodePackage pkg) throws ExecutionException {
        PackageJsonData data;
        VirtualFile packageJson;
        File bin;
        JestPkgInfo info;
        if (pkg == null) {
            JestUtil.$$$reportNull$$$0(26);
        }
        if ((info = PKG_INFO_MAP.get(pkg.getName())) != null && (bin = new File(pkg.getSystemDependentPath(), info.getBinFilePath())).isFile()) {
            File file = bin;
            if (file == null) {
                JestUtil.$$$reportNull$$$0(27);
            }
            return file;
        }
        VirtualFile pkgDir = LocalFileSystem.getInstance().findFileByPath(pkg.getSystemIndependentPath());
        if (pkgDir != null && pkgDir.isValid() && (packageJson = PackageJsonUtil.findChildPackageJsonFile(pkgDir)) != null && (data = PackageJsonData.getOrCreate(packageJson)).getBinPath() != null) {
            File file = new File(pkg.getSystemDependentPath(), data.getBinPath());
            if (file == null) {
                JestUtil.$$$reportNull$$$0(28);
            }
            return file;
        }
        throw new ExecutionException("Cannot find bin file for '" + pkg.getName() + "' package");
    }

    @NotNull
    public static String escapeJavaScriptRegex(@NotNull String str, @NotNull String escapeIgnoreChars) {
        if (str == null) {
            JestUtil.$$$reportNull$$$0(29);
        }
        if (escapeIgnoreChars == null) {
            JestUtil.$$$reportNull$$$0(30);
        }
        String charsToEscape = "\\.?*+^$[](){}|-";
        for (int i = 0; i < charsToEscape.length(); ++i) {
            char ch = charsToEscape.charAt(i);
            if (StringUtil.containsChar((String)escapeIgnoreChars, (char)ch)) continue;
            str = str.replace(String.valueOf(ch), "\\" + ch);
        }
        String string = str;
        if (string == null) {
            JestUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    public static void checkRunConfiguration(@NotNull JestRunConfiguration configuration) throws RuntimeConfigurationException {
        JestRunSettings settings;
        if (configuration == null) {
            JestUtil.$$$reportNull$$$0(32);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(settings = configuration.getRunSettings()).getConfigFileSystemDependentPath())) {
            JestUtil.validatePath(false, "configuration file", settings.getConfigFileSystemDependentPath());
        }
        JestUtil.validatePath(true, "working directory", settings.getWorkingDirSystemDependentPath());
        NodeJsInterpreter interpreter = settings.getInterpreterRef().resolve(configuration.getProject());
        NodeJsLocalInterpreter.checkForRunConfiguration(interpreter);
        configuration.getJestPackage().validateForRunConfiguration(PACKAGE_NAME);
        JestUtil.validatePath(true, "working directory", settings.getWorkingDirSystemDependentPath());
        JestScopeKind scopeKind = settings.getScopeKind();
        if (scopeKind == JestScopeKind.TEST_FILE || scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            JestUtil.validatePath(false, "test file", settings.getTestFileSystemDependentPath());
            if (scopeKind == JestScopeKind.SUITE && settings.getTestNames().isEmpty()) {
                throw new RuntimeConfigurationError("Unspecified suite name");
            }
            if (scopeKind == JestScopeKind.TEST && settings.getTestNames().isEmpty()) {
                throw new RuntimeConfigurationError("Unspecified test name");
            }
        }
    }

    private static void validatePath(boolean shouldBeDirectory, @NotNull String pathLabelName, @Nullable String path) throws RuntimeConfigurationException {
        boolean exists;
        if (pathLabelName == null) {
            JestUtil.$$$reportNull$$$0(33);
        }
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            throw new RuntimeConfigurationError("Unspecified " + pathLabelName);
        }
        File file = new File(path);
        if (!file.isAbsolute()) {
            throw new RuntimeConfigurationError("No such " + pathLabelName);
        }
        boolean bl = exists = shouldBeDirectory ? file.isDirectory() : file.isFile();
        if (!exists) {
            throw new RuntimeConfigurationError("No such " + pathLabelName);
        }
    }

    public static boolean isReactScriptsFamilyPackage(@NotNull NodePackage pkg) {
        JestPkgInfo info;
        if (pkg == null) {
            JestUtil.$$$reportNull$$$0(34);
        }
        return (info = PKG_INFO_MAP.get(pkg.getName())) != null && info.isReactScriptsFamily();
    }

    @Nullable
    public static String getPredefinedSetupTestsFilePath(@NotNull NodePackage pkg) {
        JestPkgInfo info;
        if (pkg == null) {
            JestUtil.$$$reportNull$$$0(35);
        }
        return (info = PKG_INFO_MAP.get(pkg.getName())) != null ? info.getSetupFilePath() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/jest/JestUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 15: 
            case 18: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jestPackage";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 26: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapeIgnoreChars";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathLabelName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/jest/JestUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readXml";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readScopeKind";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readValue";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "readTestNames";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "listPossibleConfigFilesInProject";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getJestPackage";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getJestMainJsFile";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeJavaScriptRegex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readXml";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 31: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readScopeKind";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readTestNames";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "writeValue";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writeXml";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "listPossibleConfigFilesInProject";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isJestConfigFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getJestPackage";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setJestPackage";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setPackagePath";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPackagePath";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getJestMainJsFile";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "escapeJavaScriptRegex";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkRunConfiguration";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "validatePath";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isReactScriptsFamilyPackage";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedSetupTestsFilePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

