/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.javascript.nodejs.PackageJsonField;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonData {
    private static final Logger LOG = Logger.getInstance(PackageJsonData.class);
    private static final String DESCRIPTION = "description";
    private static final String JSNEXT_MAIN = "jsnext:main";
    private static final String MODULE = "module";
    private static final String ES2015 = "es2015";
    private static final String MAIN = "main";
    private static final Map<String, PairConsumer<Holder, String>> ourParsers = ContainerUtil.newHashMap((List)ContainerUtil.list((Object[])new String[]{"name", "main", "description", "version", "types", "typings", "jsnext:main", "module", "es2015"}), (List)ContainerUtil.list((Object[])new PairConsumer[]{(holder, value) -> Holder.access$002(holder, value), (holder, value) -> Holder.access$102(holder, value), (holder, value) -> Holder.access$302(holder, value), (holder, value) -> Holder.access$602(holder, value), (holder, value) -> Holder.access$402(holder, value), (holder, value) -> Holder.access$402(holder, value), (holder, value) -> ((Holder)holder).myAdditionalMainProperties.put(JSNEXT_MAIN, value), (holder, value) -> ((Holder)holder).myAdditionalMainProperties.put(MODULE, value), (holder, value) -> ((Holder)holder).myAdditionalMainProperties.put(ES2015, value)}));
    private static final Map<String, PairConsumer<Holder, JsonReader>> ourCustomParsers = ContainerUtil.newHashMap((Pair)Pair.create((Object)"bin", (holder, reader) -> {
        try {
            if (reader.peek() == JsonToken.BEGIN_OBJECT) {
                reader.beginObject();
                while (reader.hasNext()) {
                    reader.nextName();
                    ((Holder)holder).myBin = JsonUtil.nextStringOrSkip((JsonReader)reader);
                }
                reader.endObject();
            } else {
                ((Holder)holder).myBin = JsonUtil.nextStringOrSkip((JsonReader)reader);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }), (Pair[])new Pair[0]);
    private final String myName;
    private final String myMain;
    private final String myTypings;
    private final String myDescription;
    private final String myBin;
    private final SemVer myVersion;
    private final Map<String, PackageJsonField> myTypeByDependencyNameMap;
    private final Map<String, String> myAdditionalMainProperties;
    private final Set<String> myScopes;
    private final Set<String> myTopLevelProperties;

    private PackageJsonData(@NotNull Holder holder) {
        if (holder == null) {
            PackageJsonData.$$$reportNull$$$0(0);
        }
        this.myName = holder.myName;
        this.myMain = holder.myMain;
        this.myAdditionalMainProperties = holder.myAdditionalMainProperties;
        this.myDescription = holder.myDescription;
        this.myTypings = holder.myTypings;
        this.myTopLevelProperties = holder.myTopLevelProperties;
        this.myBin = holder.myBin;
        this.myVersion = SemVer.parseFromText((String)StringUtil.notNullize((String)holder.myVersion));
        HashMap typeByDependencyNameMap = ContainerUtil.newHashMap();
        HashSet scopes = ContainerUtil.newHashSet();
        for (Map.Entry entry : holder.myDependenciesByType.entrySet()) {
            for (String dependencyName : (List)entry.getValue()) {
                typeByDependencyNameMap.put(dependencyName, entry.getKey());
                PackageJsonData.addScope(dependencyName, scopes);
            }
        }
        this.myScopes = ImmutableSet.copyOf((Collection)scopes);
        this.myTypeByDependencyNameMap = ImmutableMap.copyOf((Map)typeByDependencyNameMap);
    }

    private static void addScope(@NotNull String dependencyName, @NotNull Set<String> scopes) {
        int slashInd;
        if (dependencyName == null) {
            PackageJsonData.$$$reportNull$$$0(1);
        }
        if (scopes == null) {
            PackageJsonData.$$$reportNull$$$0(2);
        }
        if (dependencyName.startsWith("@") && (slashInd = dependencyName.indexOf(47, 1)) > 0) {
            scopes.add(dependencyName.substring(0, slashInd));
        }
    }

    public boolean containsDependencyWithScope(@NotNull String scope) {
        if (scope == null) {
            PackageJsonData.$$$reportNull$$$0(3);
        }
        return this.myScopes.contains(scope);
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    @Nullable
    public String getMain() {
        return this.myMain;
    }

    @Nullable
    public String getJsNextMain() {
        String es2015 = this.myAdditionalMainProperties.get(ES2015);
        if (!StringUtil.isEmptyOrSpaces((String)es2015)) {
            return es2015;
        }
        String jsNext = this.myAdditionalMainProperties.get(JSNEXT_MAIN);
        if (!StringUtil.isEmptyOrSpaces((String)jsNext)) {
            return jsNext;
        }
        return null;
    }

    public Set<String> getTopLevelProperties() {
        return this.myTopLevelProperties;
    }

    @NotNull
    public Collection<String> getAdditionalMains() {
        Collection<String> collection = this.myAdditionalMainProperties.values();
        if (collection == null) {
            PackageJsonData.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Nullable
    public String getDefaultMain() {
        if (!StringUtil.isEmptyOrSpaces((String)this.myTypings)) {
            return this.myTypings;
        }
        String additionalMain = this.getJsNextMain();
        if (!StringUtil.isEmptyOrSpaces((String)additionalMain)) {
            return additionalMain;
        }
        return this.myMain;
    }

    @Nullable
    public String getBinPath() {
        return this.myBin;
    }

    @Nullable
    public SemVer getVersion() {
        return this.myVersion;
    }

    public boolean isMainEmpty() {
        return StringUtil.isEmptyOrSpaces((String)this.myMain) && StringUtil.isEmptyOrSpaces((String)this.getJsNextMain());
    }

    public boolean isDependencyOfAnyType(@NotNull String name) {
        if (name == null) {
            PackageJsonData.$$$reportNull$$$0(5);
        }
        return this.myTypeByDependencyNameMap.containsKey(name);
    }

    public boolean isDependencyOfAnyTypeExcludeDev(@NotNull String name) {
        PackageJsonField field;
        if (name == null) {
            PackageJsonData.$$$reportNull$$$0(6);
        }
        return (field = this.myTypeByDependencyNameMap.get(name)) != null && field != PackageJsonField.devDependencies;
    }

    @NotNull
    public Set<String> getAllDependencies() {
        Set<String> set = this.myTypeByDependencyNameMap.keySet();
        if (set == null) {
            PackageJsonData.$$$reportNull$$$0(7);
        }
        return set;
    }

    public String toString() {
        return this.myTypeByDependencyNameMap.keySet().toString();
    }

    @NotNull
    public static PackageJsonData getOrCreate(@NotNull VirtualFile packageJsonFile) {
        if (packageJsonFile == null) {
            PackageJsonData.$$$reportNull$$$0(8);
        }
        PackageJsonData packageJsonData = PackageJsonUtil.getOrCreateData(packageJsonFile);
        if (packageJsonData == null) {
            PackageJsonData.$$$reportNull$$$0(9);
        }
        return packageJsonData;
    }

    @NotNull
    public static PackageJsonData parse(@NotNull VirtualFile packageJsonFile, @Nullable Document packageJsonDocument) {
        CharSequence text;
        if (packageJsonFile == null) {
            PackageJsonData.$$$reportNull$$$0(10);
        }
        if (!StringUtil.isEmpty((CharSequence)(text = PackageJsonData.loadText(packageJsonFile, packageJsonDocument)))) {
            PackageJsonData packageJsonData;
            block5: {
                try {
                    Holder holder = PackageJsonData.doParse(packageJsonFile, text);
                    packageJsonData = new PackageJsonData(holder);
                    if (packageJsonData != null) break block5;
                }
                catch (Exception e) {
                    LOG.info("Failed to parse " + packageJsonFile.getPath() + ": " + e.getMessage());
                }
                PackageJsonData.$$$reportNull$$$0(11);
            }
            return packageJsonData;
        }
        PackageJsonData packageJsonData = new PackageJsonData(new Holder());
        if (packageJsonData == null) {
            PackageJsonData.$$$reportNull$$$0(12);
        }
        return packageJsonData;
    }

    @Nullable
    private static CharSequence loadText(@NotNull VirtualFile packageJsonFile, @Nullable Document packageJsonDocument) {
        if (packageJsonFile == null) {
            PackageJsonData.$$$reportNull$$$0(13);
        }
        if (packageJsonDocument != null) {
            return packageJsonDocument.getCharsSequence();
        }
        try {
            return VfsUtilCore.loadText((VirtualFile)packageJsonFile);
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    private static Holder doParse(@NotNull VirtualFile packageJson, @NotNull CharSequence text) throws IOException {
        if (packageJson == null) {
            PackageJsonData.$$$reportNull$$$0(14);
        }
        if (text == null) {
            PackageJsonData.$$$reportNull$$$0(15);
        }
        JsonReader reader = new JsonReader((Reader)new CharSequenceReader(text));
        reader.setLenient(true);
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            throw new IOException("Top level element should be object");
        }
        reader.beginObject();
        Holder holder = new Holder();
        EnumMap dependenciesByType = ContainerUtil.newEnumMap(PackageJsonField.class);
        while (reader.hasNext()) {
            String key = reader.nextName();
            holder.myTopLevelProperties.add(key);
            if (ourCustomParsers.containsKey(key)) {
                ourCustomParsers.get(key).consume((Object)holder, (Object)reader);
                continue;
            }
            if (ourParsers.containsKey(key)) {
                String value = JsonUtil.nextStringOrSkip((JsonReader)reader);
                ourParsers.get(key).consume((Object)holder, (Object)value);
                continue;
            }
            PackageJsonField dependencyType = PackageJsonField.findDependencyByName(key);
            if (dependencyType != null) {
                List<String> dependencies = PackageJsonData.readPackages(reader, packageJson, dependencyType);
                dependenciesByType.put(dependencyType, dependencies);
                continue;
            }
            reader.skipValue();
        }
        holder.myDependenciesByType = dependenciesByType;
        reader.endObject();
        Holder holder2 = holder;
        if (holder2 == null) {
            PackageJsonData.$$$reportNull$$$0(16);
        }
        return holder2;
    }

    @NotNull
    private static List<String> readPackages(@NotNull JsonReader reader, @NotNull VirtualFile packageJson, @NotNull PackageJsonField dependencyType) throws IOException {
        if (reader == null) {
            PackageJsonData.$$$reportNull$$$0(17);
        }
        if (packageJson == null) {
            PackageJsonData.$$$reportNull$$$0(18);
        }
        if (dependencyType == null) {
            PackageJsonData.$$$reportNull$$$0(19);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            LOG.info("Failed to parse '" + (Object)((Object)dependencyType) + "' of " + packageJson.getPath() + ": expected " + JsonToken.BEGIN_OBJECT + ", actual " + reader.peek());
            reader.skipValue();
            List<String> list = Collections.emptyList();
            if (list == null) {
                PackageJsonData.$$$reportNull$$$0(20);
            }
            return list;
        }
        reader.beginObject();
        ArrayList packages = ContainerUtil.newArrayList();
        while (reader.hasNext()) {
            String key = reader.nextName();
            packages.add(key);
            reader.skipValue();
        }
        reader.endObject();
        ArrayList arrayList = packages;
        if (arrayList == null) {
            PackageJsonData.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/PackageJsonData";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFile";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/PackageJsonData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalMains";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependencies";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "doParse";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "readPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addScope";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsDependencyWithScope";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 20: 
            case 21: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDependencyOfAnyType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDependencyOfAnyTypeExcludeDev";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doParse";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readPackages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Holder {
        private String myName;
        private Map<String, String> myAdditionalMainProperties = ContainerUtil.newHashMap();
        private String myMain;
        private String myTypings;
        private String myDescription;
        private String myBin;
        private String myVersion;
        private Map<PackageJsonField, List<String>> myDependenciesByType = Collections.emptyMap();
        public Set<String> myTopLevelProperties = new HashSet<String>();

        private Holder() {
        }
    }
}

